package schedulerx2

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateJob invokes the schedulerx2.CreateJob API synchronously
func (client *Client) CreateJob(request *CreateJobRequest) (response *CreateJobResponse, err error) {
	response = CreateCreateJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateJobWithChan invokes the schedulerx2.CreateJob API asynchronously
func (client *Client) CreateJobWithChan(request *CreateJobRequest) (<-chan *CreateJobResponse, <-chan error) {
	responseChan := make(chan *CreateJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateJobWithCallback invokes the schedulerx2.CreateJob API asynchronously
func (client *Client) CreateJobWithCallback(request *CreateJobRequest, callback func(response *CreateJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateJobResponse
		var err error
		defer close(result)
		response, err = client.CreateJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateJobRequest is the request struct for api CreateJob
type CreateJobRequest struct {
	*requests.RpcRequest
	AttemptInterval     requests.Integer        `position:"Body" name:"AttemptInterval"`
	FailTimes           requests.Integer        `position:"Body" name:"FailTimes"`
	ConsumerSize        requests.Integer        `position:"Body" name:"ConsumerSize"`
	JarUrl              string                  `position:"Body" name:"JarUrl"`
	GroupId             string                  `position:"Body" name:"GroupId"`
	DataOffset          requests.Integer        `position:"Body" name:"DataOffset"`
	TaskMaxAttempt      requests.Integer        `position:"Body" name:"TaskMaxAttempt"`
	DispatcherSize      requests.Integer        `position:"Body" name:"DispatcherSize"`
	JobType             string                  `position:"Body" name:"JobType"`
	TaskAttemptInterval requests.Integer        `position:"Body" name:"TaskAttemptInterval"`
	ExecuteMode         string                  `position:"Body" name:"ExecuteMode"`
	TimeExpression      string                  `position:"Body" name:"TimeExpression"`
	TimeoutEnable       requests.Boolean        `position:"Body" name:"TimeoutEnable"`
	ContactInfo         *[]CreateJobContactInfo `position:"Body" name:"ContactInfo"  type:"Repeated"`
	Name                string                  `position:"Body" name:"Name"`
	TimeType            requests.Integer        `position:"Body" name:"TimeType"`
	Parameters          string                  `position:"Body" name:"Parameters"`
	Status              requests.Integer        `position:"Body" name:"Status"`
	NamespaceSource     string                  `position:"Body" name:"NamespaceSource"`
	Timezone            string                  `position:"Body" name:"Timezone"`
	Description         string                  `position:"Body" name:"Description"`
	Content             string                  `position:"Body" name:"Content"`
	Timeout             requests.Integer        `position:"Body" name:"Timeout"`
	TimeoutKillEnable   requests.Boolean        `position:"Body" name:"TimeoutKillEnable"`
	PageSize            requests.Integer        `position:"Body" name:"PageSize"`
	Calendar            string                  `position:"Body" name:"Calendar"`
	FailEnable          requests.Boolean        `position:"Body" name:"FailEnable"`
	SendChannel         string                  `position:"Body" name:"SendChannel"`
	MaxAttempt          requests.Integer        `position:"Body" name:"MaxAttempt"`
	MissWorkerEnable    requests.Boolean        `position:"Body" name:"MissWorkerEnable"`
	SuccessNoticeEnable requests.Boolean        `position:"Body" name:"SuccessNoticeEnable"`
	QueueSize           requests.Integer        `position:"Body" name:"QueueSize"`
	ClassName           string                  `position:"Body" name:"ClassName"`
	Namespace           string                  `position:"Body" name:"Namespace"`
	XAttrs              string                  `position:"Body" name:"XAttrs"`
	MaxConcurrency      requests.Integer        `position:"Body" name:"MaxConcurrency"`
}

// CreateJobContactInfo is a repeated param struct in CreateJobRequest
type CreateJobContactInfo struct {
	Ding      string `name:"Ding"`
	UserPhone string `name:"UserPhone"`
	UserMail  string `name:"UserMail"`
	UserName  string `name:"UserName"`
}

// CreateJobResponse is the response struct for api CreateJob
type CreateJobResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateJobRequest creates a request to invoke CreateJob API
func CreateCreateJobRequest() (request *CreateJobRequest) {
	request = &CreateJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("schedulerx2", "2019-04-30", "CreateJob", "schedulerx2", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateJobResponse creates a response to parse from CreateJob response
func CreateCreateJobResponse() (response *CreateJobResponse) {
	response = &CreateJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
