package selectdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCreateBEClusterInquiry invokes the selectdb.GetCreateBEClusterInquiry API synchronously
func (client *Client) GetCreateBEClusterInquiry(request *GetCreateBEClusterInquiryRequest) (response *GetCreateBEClusterInquiryResponse, err error) {
	response = CreateGetCreateBEClusterInquiryResponse()
	err = client.DoAction(request, response)
	return
}

// GetCreateBEClusterInquiryWithChan invokes the selectdb.GetCreateBEClusterInquiry API asynchronously
func (client *Client) GetCreateBEClusterInquiryWithChan(request *GetCreateBEClusterInquiryRequest) (<-chan *GetCreateBEClusterInquiryResponse, <-chan error) {
	responseChan := make(chan *GetCreateBEClusterInquiryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCreateBEClusterInquiry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCreateBEClusterInquiryWithCallback invokes the selectdb.GetCreateBEClusterInquiry API asynchronously
func (client *Client) GetCreateBEClusterInquiryWithCallback(request *GetCreateBEClusterInquiryRequest, callback func(response *GetCreateBEClusterInquiryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCreateBEClusterInquiryResponse
		var err error
		defer close(result)
		response, err = client.GetCreateBEClusterInquiry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCreateBEClusterInquiryRequest is the request struct for api GetCreateBEClusterInquiry
type GetCreateBEClusterInquiryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CacheSize       requests.Integer `position:"Query" name:"CacheSize"`
	PreCacheSize    requests.Integer `position:"Query" name:"PreCacheSize"`
	ComputeSize     requests.Integer `position:"Query" name:"ComputeSize"`
	DbInstanceId    string           `position:"Query" name:"DbInstanceId"`
	PreComputeSize  requests.Integer `position:"Query" name:"PreComputeSize"`
	Quantity        requests.Integer `position:"Query" name:"Quantity"`
	CommodityCode   string           `position:"Query" name:"CommodityCode"`
	ChargeType      string           `position:"Query" name:"ChargeType"`
	PricingCycle    string           `position:"Query" name:"PricingCycle"`
}

// GetCreateBEClusterInquiryResponse is the response struct for api GetCreateBEClusterInquiry
type GetCreateBEClusterInquiryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetCreateBEClusterInquiryRequest creates a request to invoke GetCreateBEClusterInquiry API
func CreateGetCreateBEClusterInquiryRequest() (request *GetCreateBEClusterInquiryRequest) {
	request = &GetCreateBEClusterInquiryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("selectdb", "2023-05-22", "GetCreateBEClusterInquiry", "", "")
	request.Method = requests.GET
	return
}

// CreateGetCreateBEClusterInquiryResponse creates a response to parse from GetCreateBEClusterInquiry response
func CreateGetCreateBEClusterInquiryResponse() (response *GetCreateBEClusterInquiryResponse) {
	response = &GetCreateBEClusterInquiryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
