package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishPlaybook invokes the sophonsoar.PublishPlaybook API synchronously
func (client *Client) PublishPlaybook(request *PublishPlaybookRequest) (response *PublishPlaybookResponse, err error) {
	response = CreatePublishPlaybookResponse()
	err = client.DoAction(request, response)
	return
}

// PublishPlaybookWithChan invokes the sophonsoar.PublishPlaybook API asynchronously
func (client *Client) PublishPlaybookWithChan(request *PublishPlaybookRequest) (<-chan *PublishPlaybookResponse, <-chan error) {
	responseChan := make(chan *PublishPlaybookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishPlaybook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishPlaybookWithCallback invokes the sophonsoar.PublishPlaybook API asynchronously
func (client *Client) PublishPlaybookWithCallback(request *PublishPlaybookRequest, callback func(response *PublishPlaybookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishPlaybookResponse
		var err error
		defer close(result)
		response, err = client.PublishPlaybook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishPlaybookRequest is the request struct for api PublishPlaybook
type PublishPlaybookRequest struct {
	*requests.RpcRequest
	RoleFor      string `position:"Query" name:"RoleFor"`
	Description  string `position:"Body" name:"Description"`
	PlaybookUuid string `position:"Body" name:"PlaybookUuid"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Body" name:"Lang"`
}

// PublishPlaybookResponse is the response struct for api PublishPlaybook
type PublishPlaybookResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePublishPlaybookRequest creates a request to invoke PublishPlaybook API
func CreatePublishPlaybookRequest() (request *PublishPlaybookRequest) {
	request = &PublishPlaybookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "PublishPlaybook", "", "")
	request.Method = requests.POST
	return
}

// CreatePublishPlaybookResponse creates a response to parse from PublishPlaybook response
func CreatePublishPlaybookResponse() (response *PublishPlaybookResponse) {
	response = &PublishPlaybookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
