package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceKeyPair invokes the swas_open.DescribeInstanceKeyPair API synchronously
func (client *Client) DescribeInstanceKeyPair(request *DescribeInstanceKeyPairRequest) (response *DescribeInstanceKeyPairResponse, err error) {
	response = CreateDescribeInstanceKeyPairResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceKeyPairWithChan invokes the swas_open.DescribeInstanceKeyPair API asynchronously
func (client *Client) DescribeInstanceKeyPairWithChan(request *DescribeInstanceKeyPairRequest) (<-chan *DescribeInstanceKeyPairResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceKeyPairResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceKeyPair(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceKeyPairWithCallback invokes the swas_open.DescribeInstanceKeyPair API asynchronously
func (client *Client) DescribeInstanceKeyPairWithCallback(request *DescribeInstanceKeyPairRequest, callback func(response *DescribeInstanceKeyPairResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceKeyPairResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceKeyPair(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceKeyPairRequest is the request struct for api DescribeInstanceKeyPair
type DescribeInstanceKeyPairRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	InstanceId  string `position:"Query" name:"InstanceId"`
}

// DescribeInstanceKeyPairResponse is the response struct for api DescribeInstanceKeyPair
type DescribeInstanceKeyPairResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	KeyPairName string `json:"KeyPairName" xml:"KeyPairName"`
	Fingerprint string `json:"Fingerprint" xml:"Fingerprint"`
}

// CreateDescribeInstanceKeyPairRequest creates a request to invoke DescribeInstanceKeyPair API
func CreateDescribeInstanceKeyPairRequest() (request *DescribeInstanceKeyPairRequest) {
	request = &DescribeInstanceKeyPairRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DescribeInstanceKeyPair", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceKeyPairResponse creates a response to parse from DescribeInstanceKeyPair response
func CreateDescribeInstanceKeyPairResponse() (response *DescribeInstanceKeyPairResponse) {
	response = &DescribeInstanceKeyPairResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
