package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMonitorData invokes the swas_open.DescribeMonitorData API synchronously
func (client *Client) DescribeMonitorData(request *DescribeMonitorDataRequest) (response *DescribeMonitorDataResponse, err error) {
	response = CreateDescribeMonitorDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMonitorDataWithChan invokes the swas_open.DescribeMonitorData API asynchronously
func (client *Client) DescribeMonitorDataWithChan(request *DescribeMonitorDataRequest) (<-chan *DescribeMonitorDataResponse, <-chan error) {
	responseChan := make(chan *DescribeMonitorDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMonitorData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMonitorDataWithCallback invokes the swas_open.DescribeMonitorData API asynchronously
func (client *Client) DescribeMonitorDataWithCallback(request *DescribeMonitorDataRequest, callback func(response *DescribeMonitorDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMonitorDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeMonitorData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMonitorDataRequest is the request struct for api DescribeMonitorData
type DescribeMonitorDataRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	StartTime   string `position:"Query" name:"StartTime"`
	NextToken   string `position:"Query" name:"NextToken"`
	MetricName  string `position:"Query" name:"MetricName"`
	Period      string `position:"Query" name:"Period"`
	Length      string `position:"Query" name:"Length"`
	EndTime     string `position:"Query" name:"EndTime"`
	InstanceId  string `position:"Query" name:"InstanceId"`
}

// DescribeMonitorDataResponse is the response struct for api DescribeMonitorData
type DescribeMonitorDataResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Datapoints string `json:"Datapoints" xml:"Datapoints"`
	Period     string `json:"Period" xml:"Period"`
	NextToken  string `json:"NextToken" xml:"NextToken"`
}

// CreateDescribeMonitorDataRequest creates a request to invoke DescribeMonitorData API
func CreateDescribeMonitorDataRequest() (request *DescribeMonitorDataRequest) {
	request = &DescribeMonitorDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DescribeMonitorData", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMonitorDataResponse creates a response to parse from DescribeMonitorData response
func CreateDescribeMonitorDataResponse() (response *DescribeMonitorDataResponse) {
	response = &DescribeMonitorDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
