package threedvision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EstimateStereoImageDepth invokes the threedvision.EstimateStereoImageDepth API synchronously
func (client *Client) EstimateStereoImageDepth(request *EstimateStereoImageDepthRequest) (response *EstimateStereoImageDepthResponse, err error) {
	response = CreateEstimateStereoImageDepthResponse()
	err = client.DoAction(request, response)
	return
}

// EstimateStereoImageDepthWithChan invokes the threedvision.EstimateStereoImageDepth API asynchronously
func (client *Client) EstimateStereoImageDepthWithChan(request *EstimateStereoImageDepthRequest) (<-chan *EstimateStereoImageDepthResponse, <-chan error) {
	responseChan := make(chan *EstimateStereoImageDepthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EstimateStereoImageDepth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EstimateStereoImageDepthWithCallback invokes the threedvision.EstimateStereoImageDepth API asynchronously
func (client *Client) EstimateStereoImageDepthWithCallback(request *EstimateStereoImageDepthRequest, callback func(response *EstimateStereoImageDepthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EstimateStereoImageDepthResponse
		var err error
		defer close(result)
		response, err = client.EstimateStereoImageDepth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EstimateStereoImageDepthRequest is the request struct for api EstimateStereoImageDepth
type EstimateStereoImageDepthRequest struct {
	*requests.RpcRequest
	RightImageURL string `position:"Body" name:"RightImageURL"`
	LeftImageURL  string `position:"Body" name:"LeftImageURL"`
}

// EstimateStereoImageDepthResponse is the response struct for api EstimateStereoImageDepth
type EstimateStereoImageDepthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateEstimateStereoImageDepthRequest creates a request to invoke EstimateStereoImageDepth API
func CreateEstimateStereoImageDepthRequest() (request *EstimateStereoImageDepthRequest) {
	request = &EstimateStereoImageDepthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("threedvision", "2021-01-31", "EstimateStereoImageDepth", "threedvision", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEstimateStereoImageDepthResponse creates a response to parse from EstimateStereoImageDepth response
func CreateEstimateStereoImageDepthResponse() (response *EstimateStereoImageDepthResponse) {
	response = &EstimateStereoImageDepthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
