package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateUdfArtifact invokes the ververica.UpdateUdfArtifact API synchronously
func (client *Client) UpdateUdfArtifact(request *UpdateUdfArtifactRequest) (response *UpdateUdfArtifactResponse, err error) {
	response = CreateUpdateUdfArtifactResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateUdfArtifactWithChan invokes the ververica.UpdateUdfArtifact API asynchronously
func (client *Client) UpdateUdfArtifactWithChan(request *UpdateUdfArtifactRequest) (<-chan *UpdateUdfArtifactResponse, <-chan error) {
	responseChan := make(chan *UpdateUdfArtifactResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateUdfArtifact(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateUdfArtifactWithCallback invokes the ververica.UpdateUdfArtifact API asynchronously
func (client *Client) UpdateUdfArtifactWithCallback(request *UpdateUdfArtifactRequest, callback func(response *UpdateUdfArtifactResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateUdfArtifactResponse
		var err error
		defer close(result)
		response, err = client.UpdateUdfArtifact(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateUdfArtifactRequest is the request struct for api UpdateUdfArtifact
type UpdateUdfArtifactRequest struct {
	*requests.RoaRequest
	Workspace       string `position:"Path" name:"workspace"`
	ParamsJson      string `position:"Body" name:"paramsJson"`
	Namespace       string `position:"Path" name:"namespace"`
	UdfArtifactName string `position:"Path" name:"udfArtifactName"`
}

// UpdateUdfArtifactResponse is the response struct for api UpdateUdfArtifact
type UpdateUdfArtifactResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateUpdateUdfArtifactRequest creates a request to invoke UpdateUdfArtifact API
func CreateUpdateUdfArtifactRequest() (request *UpdateUdfArtifactRequest) {
	request = &UpdateUdfArtifactRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "UpdateUdfArtifact", "/pop/workspaces/[workspace]/sql/v1beta1/namespaces/[namespace]/udfartifacts/[udfArtifactName]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateUdfArtifactResponse creates a response to parse from UpdateUdfArtifact response
func CreateUpdateUdfArtifactResponse() (response *UpdateUdfArtifactResponse) {
	response = &UpdateUdfArtifactResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
