package videoenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AdjustVideoColor invokes the videoenhan.AdjustVideoColor API synchronously
func (client *Client) AdjustVideoColor(request *AdjustVideoColorRequest) (response *AdjustVideoColorResponse, err error) {
	response = CreateAdjustVideoColorResponse()
	err = client.DoAction(request, response)
	return
}

// AdjustVideoColorWithChan invokes the videoenhan.AdjustVideoColor API asynchronously
func (client *Client) AdjustVideoColorWithChan(request *AdjustVideoColorRequest) (<-chan *AdjustVideoColorResponse, <-chan error) {
	responseChan := make(chan *AdjustVideoColorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AdjustVideoColor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AdjustVideoColorWithCallback invokes the videoenhan.AdjustVideoColor API asynchronously
func (client *Client) AdjustVideoColorWithCallback(request *AdjustVideoColorRequest, callback func(response *AdjustVideoColorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AdjustVideoColorResponse
		var err error
		defer close(result)
		response, err = client.AdjustVideoColor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AdjustVideoColorRequest is the request struct for api AdjustVideoColor
type AdjustVideoColorRequest struct {
	*requests.RpcRequest
	Mode         string           `position:"Body" name:"Mode"`
	Async        requests.Boolean `position:"Body" name:"Async"`
	VideoUrl     string           `position:"Body" name:"VideoUrl"`
	VideoBitrate requests.Integer `position:"Body" name:"VideoBitrate"`
	VideoCodec   string           `position:"Body" name:"VideoCodec"`
	VideoFormat  string           `position:"Body" name:"VideoFormat"`
}

// AdjustVideoColorResponse is the response struct for api AdjustVideoColor
type AdjustVideoColorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAdjustVideoColorRequest creates a request to invoke AdjustVideoColor API
func CreateAdjustVideoColorRequest() (request *AdjustVideoColorRequest) {
	request = &AdjustVideoColorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoenhan", "2020-03-20", "AdjustVideoColor", "videoenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAdjustVideoColorResponse creates a response to parse from AdjustVideoColor response
func CreateAdjustVideoColorResponse() (response *AdjustVideoColorResponse) {
	response = &AdjustVideoColorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
