package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVSwitchCidrReservations invokes the vpc.ListVSwitchCidrReservations API synchronously
func (client *Client) ListVSwitchCidrReservations(request *ListVSwitchCidrReservationsRequest) (response *ListVSwitchCidrReservationsResponse, err error) {
	response = CreateListVSwitchCidrReservationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListVSwitchCidrReservationsWithChan invokes the vpc.ListVSwitchCidrReservations API asynchronously
func (client *Client) ListVSwitchCidrReservationsWithChan(request *ListVSwitchCidrReservationsRequest) (<-chan *ListVSwitchCidrReservationsResponse, <-chan error) {
	responseChan := make(chan *ListVSwitchCidrReservationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVSwitchCidrReservations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVSwitchCidrReservationsWithCallback invokes the vpc.ListVSwitchCidrReservations API asynchronously
func (client *Client) ListVSwitchCidrReservationsWithCallback(request *ListVSwitchCidrReservationsRequest, callback func(response *ListVSwitchCidrReservationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVSwitchCidrReservationsResponse
		var err error
		defer close(result)
		response, err = client.ListVSwitchCidrReservations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVSwitchCidrReservationsRequest is the request struct for api ListVSwitchCidrReservations
type ListVSwitchCidrReservationsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId            requests.Integer                   `position:"Query" name:"ResourceOwnerId"`
	VSwitchCidrReservationType string                             `position:"Query" name:"VSwitchCidrReservationType"`
	NextToken                  string                             `position:"Query" name:"NextToken"`
	VSwitchCidrReservationIds  *[]string                          `position:"Query" name:"VSwitchCidrReservationIds"  type:"Repeated"`
	IpVersion                  string                             `position:"Query" name:"IpVersion"`
	ResourceOwnerAccount       string                             `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount               string                             `position:"Query" name:"OwnerAccount"`
	OwnerId                    requests.Integer                   `position:"Query" name:"OwnerId"`
	Tags                       *[]ListVSwitchCidrReservationsTags `position:"Query" name:"Tags"  type:"Repeated"`
	VSwitchId                  string                             `position:"Query" name:"VSwitchId"`
	MaxResults                 requests.Integer                   `position:"Query" name:"MaxResults"`
}

// ListVSwitchCidrReservationsTags is a repeated param struct in ListVSwitchCidrReservationsRequest
type ListVSwitchCidrReservationsTags struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListVSwitchCidrReservationsResponse is the response struct for api ListVSwitchCidrReservations
type ListVSwitchCidrReservationsResponse struct {
	*responses.BaseResponse
	RequestId               string                   `json:"RequestId" xml:"RequestId"`
	NextToken               string                   `json:"NextToken" xml:"NextToken"`
	TotalCount              int64                    `json:"TotalCount" xml:"TotalCount"`
	MaxResults              int64                    `json:"MaxResults" xml:"MaxResults"`
	VSwitchCidrReservations []VSwitchCidrReservation `json:"VSwitchCidrReservations" xml:"VSwitchCidrReservations"`
}

// CreateListVSwitchCidrReservationsRequest creates a request to invoke ListVSwitchCidrReservations API
func CreateListVSwitchCidrReservationsRequest() (request *ListVSwitchCidrReservationsRequest) {
	request = &ListVSwitchCidrReservationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListVSwitchCidrReservations", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVSwitchCidrReservationsResponse creates a response to parse from ListVSwitchCidrReservations response
func CreateListVSwitchCidrReservationsResponse() (response *ListVSwitchCidrReservationsResponse) {
	response = &ListVSwitchCidrReservationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
