package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenPublicIpAddressPoolService invokes the vpc.OpenPublicIpAddressPoolService API synchronously
func (client *Client) OpenPublicIpAddressPoolService(request *OpenPublicIpAddressPoolServiceRequest) (response *OpenPublicIpAddressPoolServiceResponse, err error) {
	response = CreateOpenPublicIpAddressPoolServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenPublicIpAddressPoolServiceWithChan invokes the vpc.OpenPublicIpAddressPoolService API asynchronously
func (client *Client) OpenPublicIpAddressPoolServiceWithChan(request *OpenPublicIpAddressPoolServiceRequest) (<-chan *OpenPublicIpAddressPoolServiceResponse, <-chan error) {
	responseChan := make(chan *OpenPublicIpAddressPoolServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenPublicIpAddressPoolService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenPublicIpAddressPoolServiceWithCallback invokes the vpc.OpenPublicIpAddressPoolService API asynchronously
func (client *Client) OpenPublicIpAddressPoolServiceWithCallback(request *OpenPublicIpAddressPoolServiceRequest, callback func(response *OpenPublicIpAddressPoolServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenPublicIpAddressPoolServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenPublicIpAddressPoolService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenPublicIpAddressPoolServiceRequest is the request struct for api OpenPublicIpAddressPoolService
type OpenPublicIpAddressPoolServiceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// OpenPublicIpAddressPoolServiceResponse is the response struct for api OpenPublicIpAddressPoolService
type OpenPublicIpAddressPoolServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateOpenPublicIpAddressPoolServiceRequest creates a request to invoke OpenPublicIpAddressPoolService API
func CreateOpenPublicIpAddressPoolServiceRequest() (request *OpenPublicIpAddressPoolServiceRequest) {
	request = &OpenPublicIpAddressPoolServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "OpenPublicIpAddressPoolService", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOpenPublicIpAddressPoolServiceResponse creates a response to parse from OpenPublicIpAddressPoolService response
func CreateOpenPublicIpAddressPoolServiceResponse() (response *OpenPublicIpAddressPoolServiceResponse) {
	response = &OpenPublicIpAddressPoolServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
