package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePreset invokes the vs.DeletePreset API synchronously
func (client *Client) DeletePreset(request *DeletePresetRequest) (response *DeletePresetResponse, err error) {
	response = CreateDeletePresetResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePresetWithChan invokes the vs.DeletePreset API asynchronously
func (client *Client) DeletePresetWithChan(request *DeletePresetRequest) (<-chan *DeletePresetResponse, <-chan error) {
	responseChan := make(chan *DeletePresetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePreset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePresetWithCallback invokes the vs.DeletePreset API asynchronously
func (client *Client) DeletePresetWithCallback(request *DeletePresetRequest, callback func(response *DeletePresetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePresetResponse
		var err error
		defer close(result)
		response, err = client.DeletePreset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePresetRequest is the request struct for api DeletePreset
type DeletePresetRequest struct {
	*requests.RpcRequest
	SubProtocol string           `position:"Query" name:"SubProtocol"`
	Id          string           `position:"Query" name:"Id"`
	PresetId    string           `position:"Query" name:"PresetId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
}

// DeletePresetResponse is the response struct for api DeletePreset
type DeletePresetResponse struct {
	*responses.BaseResponse
	Id        string `json:"Id" xml:"Id"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletePresetRequest creates a request to invoke DeletePreset API
func CreateDeletePresetRequest() (request *DeletePresetRequest) {
	request = &DeletePresetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DeletePreset", "", "")
	request.Method = requests.POST
	return
}

// CreateDeletePresetResponse creates a response to parse from DeletePreset response
func CreateDeletePresetResponse() (response *DeletePresetResponse) {
	response = &DeletePresetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
