package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeContainerInstanceId invokes the vs.DescribeContainerInstanceId API synchronously
func (client *Client) DescribeContainerInstanceId(request *DescribeContainerInstanceIdRequest) (response *DescribeContainerInstanceIdResponse, err error) {
	response = CreateDescribeContainerInstanceIdResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeContainerInstanceIdWithChan invokes the vs.DescribeContainerInstanceId API asynchronously
func (client *Client) DescribeContainerInstanceIdWithChan(request *DescribeContainerInstanceIdRequest) (<-chan *DescribeContainerInstanceIdResponse, <-chan error) {
	responseChan := make(chan *DescribeContainerInstanceIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeContainerInstanceId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeContainerInstanceIdWithCallback invokes the vs.DescribeContainerInstanceId API asynchronously
func (client *Client) DescribeContainerInstanceIdWithCallback(request *DescribeContainerInstanceIdRequest, callback func(response *DescribeContainerInstanceIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeContainerInstanceIdResponse
		var err error
		defer close(result)
		response, err = client.DescribeContainerInstanceId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeContainerInstanceIdRequest is the request struct for api DescribeContainerInstanceId
type DescribeContainerInstanceIdRequest struct {
	*requests.RpcRequest
	PodIndex requests.Integer `position:"Query" name:"PodIndex"`
	ShowLog  string           `position:"Query" name:"ShowLog"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	NodeName string           `position:"Query" name:"NodeName"`
}

// DescribeContainerInstanceIdResponse is the response struct for api DescribeContainerInstanceId
type DescribeContainerInstanceIdResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	InstanceDetail InstanceDetail `json:"InstanceDetail" xml:"InstanceDetail"`
}

// CreateDescribeContainerInstanceIdRequest creates a request to invoke DescribeContainerInstanceId API
func CreateDescribeContainerInstanceIdRequest() (request *DescribeContainerInstanceIdRequest) {
	request = &DescribeContainerInstanceIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeContainerInstanceId", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeContainerInstanceIdResponse creates a response to parse from DescribeContainerInstanceId response
func CreateDescribeContainerInstanceIdResponse() (response *DescribeContainerInstanceIdResponse) {
	response = &DescribeContainerInstanceIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
