package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePurchasedDevice invokes the vs.DescribePurchasedDevice API synchronously
func (client *Client) DescribePurchasedDevice(request *DescribePurchasedDeviceRequest) (response *DescribePurchasedDeviceResponse, err error) {
	response = CreateDescribePurchasedDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePurchasedDeviceWithChan invokes the vs.DescribePurchasedDevice API asynchronously
func (client *Client) DescribePurchasedDeviceWithChan(request *DescribePurchasedDeviceRequest) (<-chan *DescribePurchasedDeviceResponse, <-chan error) {
	responseChan := make(chan *DescribePurchasedDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePurchasedDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePurchasedDeviceWithCallback invokes the vs.DescribePurchasedDevice API asynchronously
func (client *Client) DescribePurchasedDeviceWithCallback(request *DescribePurchasedDeviceRequest, callback func(response *DescribePurchasedDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePurchasedDeviceResponse
		var err error
		defer close(result)
		response, err = client.DescribePurchasedDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePurchasedDeviceRequest is the request struct for api DescribePurchasedDevice
type DescribePurchasedDeviceRequest struct {
	*requests.RpcRequest
	Id      string           `position:"Query" name:"Id"`
	ShowLog string           `position:"Query" name:"ShowLog"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribePurchasedDeviceResponse is the response struct for api DescribePurchasedDevice
type DescribePurchasedDeviceResponse struct {
	*responses.BaseResponse
	Type         string `json:"Type" xml:"Type"`
	SubType      string `json:"SubType" xml:"SubType"`
	Vendor       string `json:"Vendor" xml:"Vendor"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Description  string `json:"Description" xml:"Description"`
	RegisterCode string `json:"RegisterCode" xml:"RegisterCode"`
	GroupId      string `json:"GroupId" xml:"GroupId"`
	GroupName    string `json:"GroupName" xml:"GroupName"`
	Region       string `json:"Region" xml:"Region"`
	Name         string `json:"Name" xml:"Name"`
	CreatedTime  string `json:"CreatedTime" xml:"CreatedTime"`
	Id           string `json:"Id" xml:"Id"`
	OrderId      string `json:"OrderId" xml:"OrderId"`
}

// CreateDescribePurchasedDeviceRequest creates a request to invoke DescribePurchasedDevice API
func CreateDescribePurchasedDeviceRequest() (request *DescribePurchasedDeviceRequest) {
	request = &DescribePurchasedDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribePurchasedDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribePurchasedDeviceResponse creates a response to parse from DescribePurchasedDevice response
func CreateDescribePurchasedDeviceResponse() (response *DescribePurchasedDeviceResponse) {
	response = &DescribePurchasedDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
