package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyProtectionModuleStatus invokes the waf_openapi.ModifyProtectionModuleStatus API synchronously
func (client *Client) ModifyProtectionModuleStatus(request *ModifyProtectionModuleStatusRequest) (response *ModifyProtectionModuleStatusResponse, err error) {
	response = CreateModifyProtectionModuleStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyProtectionModuleStatusWithChan invokes the waf_openapi.ModifyProtectionModuleStatus API asynchronously
func (client *Client) ModifyProtectionModuleStatusWithChan(request *ModifyProtectionModuleStatusRequest) (<-chan *ModifyProtectionModuleStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyProtectionModuleStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyProtectionModuleStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyProtectionModuleStatusWithCallback invokes the waf_openapi.ModifyProtectionModuleStatus API asynchronously
func (client *Client) ModifyProtectionModuleStatusWithCallback(request *ModifyProtectionModuleStatusRequest, callback func(response *ModifyProtectionModuleStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyProtectionModuleStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyProtectionModuleStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyProtectionModuleStatusRequest is the request struct for api ModifyProtectionModuleStatus
type ModifyProtectionModuleStatusRequest struct {
	*requests.RpcRequest
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Lang            string           `position:"Query" name:"Lang"`
	DefenseType     string           `position:"Query" name:"DefenseType"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	Domain          string           `position:"Query" name:"Domain"`
	ModuleStatus    requests.Integer `position:"Query" name:"ModuleStatus"`
}

// ModifyProtectionModuleStatusResponse is the response struct for api ModifyProtectionModuleStatus
type ModifyProtectionModuleStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyProtectionModuleStatusRequest creates a request to invoke ModifyProtectionModuleStatus API
func CreateModifyProtectionModuleStatusRequest() (request *ModifyProtectionModuleStatusRequest) {
	request = &ModifyProtectionModuleStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2019-09-10", "ModifyProtectionModuleStatus", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyProtectionModuleStatusResponse creates a response to parse from ModifyProtectionModuleStatus response
func CreateModifyProtectionModuleStatusResponse() (response *ModifyProtectionModuleStatusResponse) {
	response = &ModifyProtectionModuleStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
