// Copyright 2019-2021 go-gtp authors. All rights reserved.
// Use of this source code is governed by a MIT-style license that can be
// found in the LICENSE file.

// Package gtp provides simple and painless handling of GTP(GPRS Tunneling Protocol),
// implemented in the Go Programming Language.
//
// This package is the wrapper of all versions of GTP that is available.
// Please see the godocs of each version instead.
//
// GTPv0: https://pkg.go.dev/github.com/wmnsk/go-gtp/v0
//
// GTPv1: https://pkg.go.dev/github.com/wmnsk/go-gtp/v1
//
// GTPv2: https://pkg.go.dev/github.com/wmnsk/go-gtp/v2
//
// Please also see README.md for detailed usage of the APIs provided by this package,
// as well as how to run the examples.
//
// https://github.com/wmnsk/go-gtp/blob/master/README.md
//
// https://github.com/wmnsk/go-gtp/tree/master/examples/gw-tester
package gtp
