// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package bedrock

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateModelCustomizationJob = "CreateModelCustomizationJob"

// CreateModelCustomizationJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateModelCustomizationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModelCustomizationJob for more information on using the CreateModelCustomizationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateModelCustomizationJobRequest method.
//	req, resp := client.CreateModelCustomizationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateModelCustomizationJob
func (c *Bedrock) CreateModelCustomizationJobRequest(input *CreateModelCustomizationJobInput) (req *request.Request, output *CreateModelCustomizationJobOutput) {
	op := &request.Operation{
		Name:       opCreateModelCustomizationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/model-customization-jobs",
	}

	if input == nil {
		input = &CreateModelCustomizationJobInput{}
	}

	output = &CreateModelCustomizationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModelCustomizationJob API operation for Amazon Bedrock.
//
// Creates a fine-tuning job to customize a base model.
//
// You specify the base foundation model and the location of the training data.
// After the model-customization job completes successfully, your custom model
// resource will be ready to use. Training data contains input and output text
// for each record in a JSONL format. Optionally, you can specify validation
// data in the same format as the training data. Bedrock returns validation
// loss metrics and output generations after the job completes.
//
// Model-customization jobs are asynchronous and the completion time depends
// on the base model and the training/validation data size. To monitor a job,
// use the GetModelCustomizationJob operation to retrieve the job status.
//
// For more information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation CreateModelCustomizationJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateModelCustomizationJob
func (c *Bedrock) CreateModelCustomizationJob(input *CreateModelCustomizationJobInput) (*CreateModelCustomizationJobOutput, error) {
	req, out := c.CreateModelCustomizationJobRequest(input)
	return out, req.Send()
}

// CreateModelCustomizationJobWithContext is the same as CreateModelCustomizationJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelCustomizationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) CreateModelCustomizationJobWithContext(ctx aws.Context, input *CreateModelCustomizationJobInput, opts ...request.Option) (*CreateModelCustomizationJobOutput, error) {
	req, out := c.CreateModelCustomizationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProvisionedModelThroughput = "CreateProvisionedModelThroughput"

// CreateProvisionedModelThroughputRequest generates a "aws/request.Request" representing the
// client's request for the CreateProvisionedModelThroughput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProvisionedModelThroughput for more information on using the CreateProvisionedModelThroughput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProvisionedModelThroughputRequest method.
//	req, resp := client.CreateProvisionedModelThroughputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateProvisionedModelThroughput
func (c *Bedrock) CreateProvisionedModelThroughputRequest(input *CreateProvisionedModelThroughputInput) (req *request.Request, output *CreateProvisionedModelThroughputOutput) {
	op := &request.Operation{
		Name:       opCreateProvisionedModelThroughput,
		HTTPMethod: "POST",
		HTTPPath:   "/provisioned-model-throughput",
	}

	if input == nil {
		input = &CreateProvisionedModelThroughputInput{}
	}

	output = &CreateProvisionedModelThroughputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProvisionedModelThroughput API operation for Amazon Bedrock.
//
// Creates a provisioned throughput with dedicated capacity for a foundation
// model or a fine-tuned model.
//
// For more information, see Provisioned throughput (https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation CreateProvisionedModelThroughput for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/CreateProvisionedModelThroughput
func (c *Bedrock) CreateProvisionedModelThroughput(input *CreateProvisionedModelThroughputInput) (*CreateProvisionedModelThroughputOutput, error) {
	req, out := c.CreateProvisionedModelThroughputRequest(input)
	return out, req.Send()
}

// CreateProvisionedModelThroughputWithContext is the same as CreateProvisionedModelThroughput with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProvisionedModelThroughput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) CreateProvisionedModelThroughputWithContext(ctx aws.Context, input *CreateProvisionedModelThroughputInput, opts ...request.Option) (*CreateProvisionedModelThroughputOutput, error) {
	req, out := c.CreateProvisionedModelThroughputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomModel = "DeleteCustomModel"

// DeleteCustomModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomModel for more information on using the DeleteCustomModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomModelRequest method.
//	req, resp := client.DeleteCustomModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteCustomModel
func (c *Bedrock) DeleteCustomModelRequest(input *DeleteCustomModelInput) (req *request.Request, output *DeleteCustomModelOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomModel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/custom-models/{modelIdentifier}",
	}

	if input == nil {
		input = &DeleteCustomModelInput{}
	}

	output = &DeleteCustomModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomModel API operation for Amazon Bedrock.
//
// Deletes a custom model that you created earlier. For more information, see
// Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation DeleteCustomModel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteCustomModel
func (c *Bedrock) DeleteCustomModel(input *DeleteCustomModelInput) (*DeleteCustomModelOutput, error) {
	req, out := c.DeleteCustomModelRequest(input)
	return out, req.Send()
}

// DeleteCustomModelWithContext is the same as DeleteCustomModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) DeleteCustomModelWithContext(ctx aws.Context, input *DeleteCustomModelInput, opts ...request.Option) (*DeleteCustomModelOutput, error) {
	req, out := c.DeleteCustomModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModelInvocationLoggingConfiguration = "DeleteModelInvocationLoggingConfiguration"

// DeleteModelInvocationLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModelInvocationLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModelInvocationLoggingConfiguration for more information on using the DeleteModelInvocationLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteModelInvocationLoggingConfigurationRequest method.
//	req, resp := client.DeleteModelInvocationLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteModelInvocationLoggingConfiguration
func (c *Bedrock) DeleteModelInvocationLoggingConfigurationRequest(input *DeleteModelInvocationLoggingConfigurationInput) (req *request.Request, output *DeleteModelInvocationLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteModelInvocationLoggingConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/logging/modelinvocations",
	}

	if input == nil {
		input = &DeleteModelInvocationLoggingConfigurationInput{}
	}

	output = &DeleteModelInvocationLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModelInvocationLoggingConfiguration API operation for Amazon Bedrock.
//
// Delete the invocation logging.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation DeleteModelInvocationLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteModelInvocationLoggingConfiguration
func (c *Bedrock) DeleteModelInvocationLoggingConfiguration(input *DeleteModelInvocationLoggingConfigurationInput) (*DeleteModelInvocationLoggingConfigurationOutput, error) {
	req, out := c.DeleteModelInvocationLoggingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteModelInvocationLoggingConfigurationWithContext is the same as DeleteModelInvocationLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModelInvocationLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) DeleteModelInvocationLoggingConfigurationWithContext(ctx aws.Context, input *DeleteModelInvocationLoggingConfigurationInput, opts ...request.Option) (*DeleteModelInvocationLoggingConfigurationOutput, error) {
	req, out := c.DeleteModelInvocationLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProvisionedModelThroughput = "DeleteProvisionedModelThroughput"

// DeleteProvisionedModelThroughputRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProvisionedModelThroughput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProvisionedModelThroughput for more information on using the DeleteProvisionedModelThroughput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProvisionedModelThroughputRequest method.
//	req, resp := client.DeleteProvisionedModelThroughputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteProvisionedModelThroughput
func (c *Bedrock) DeleteProvisionedModelThroughputRequest(input *DeleteProvisionedModelThroughputInput) (req *request.Request, output *DeleteProvisionedModelThroughputOutput) {
	op := &request.Operation{
		Name:       opDeleteProvisionedModelThroughput,
		HTTPMethod: "DELETE",
		HTTPPath:   "/provisioned-model-throughput/{provisionedModelId}",
	}

	if input == nil {
		input = &DeleteProvisionedModelThroughputInput{}
	}

	output = &DeleteProvisionedModelThroughputOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProvisionedModelThroughput API operation for Amazon Bedrock.
//
// Deletes a provisioned throughput. For more information, see Provisioned throughput
// (https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation DeleteProvisionedModelThroughput for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/DeleteProvisionedModelThroughput
func (c *Bedrock) DeleteProvisionedModelThroughput(input *DeleteProvisionedModelThroughputInput) (*DeleteProvisionedModelThroughputOutput, error) {
	req, out := c.DeleteProvisionedModelThroughputRequest(input)
	return out, req.Send()
}

// DeleteProvisionedModelThroughputWithContext is the same as DeleteProvisionedModelThroughput with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProvisionedModelThroughput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) DeleteProvisionedModelThroughputWithContext(ctx aws.Context, input *DeleteProvisionedModelThroughputInput, opts ...request.Option) (*DeleteProvisionedModelThroughputOutput, error) {
	req, out := c.DeleteProvisionedModelThroughputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCustomModel = "GetCustomModel"

// GetCustomModelRequest generates a "aws/request.Request" representing the
// client's request for the GetCustomModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCustomModel for more information on using the GetCustomModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCustomModelRequest method.
//	req, resp := client.GetCustomModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetCustomModel
func (c *Bedrock) GetCustomModelRequest(input *GetCustomModelInput) (req *request.Request, output *GetCustomModelOutput) {
	op := &request.Operation{
		Name:       opGetCustomModel,
		HTTPMethod: "GET",
		HTTPPath:   "/custom-models/{modelIdentifier}",
	}

	if input == nil {
		input = &GetCustomModelInput{}
	}

	output = &GetCustomModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCustomModel API operation for Amazon Bedrock.
//
// Get the properties associated with a Bedrock custom model that you have created.For
// more information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation GetCustomModel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetCustomModel
func (c *Bedrock) GetCustomModel(input *GetCustomModelInput) (*GetCustomModelOutput, error) {
	req, out := c.GetCustomModelRequest(input)
	return out, req.Send()
}

// GetCustomModelWithContext is the same as GetCustomModel with the addition of
// the ability to pass a context and additional request options.
//
// See GetCustomModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) GetCustomModelWithContext(ctx aws.Context, input *GetCustomModelInput, opts ...request.Option) (*GetCustomModelOutput, error) {
	req, out := c.GetCustomModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFoundationModel = "GetFoundationModel"

// GetFoundationModelRequest generates a "aws/request.Request" representing the
// client's request for the GetFoundationModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFoundationModel for more information on using the GetFoundationModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFoundationModelRequest method.
//	req, resp := client.GetFoundationModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetFoundationModel
func (c *Bedrock) GetFoundationModelRequest(input *GetFoundationModelInput) (req *request.Request, output *GetFoundationModelOutput) {
	op := &request.Operation{
		Name:       opGetFoundationModel,
		HTTPMethod: "GET",
		HTTPPath:   "/foundation-models/{modelIdentifier}",
	}

	if input == nil {
		input = &GetFoundationModelInput{}
	}

	output = &GetFoundationModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFoundationModel API operation for Amazon Bedrock.
//
// Get details about a Bedrock foundation model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation GetFoundationModel for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetFoundationModel
func (c *Bedrock) GetFoundationModel(input *GetFoundationModelInput) (*GetFoundationModelOutput, error) {
	req, out := c.GetFoundationModelRequest(input)
	return out, req.Send()
}

// GetFoundationModelWithContext is the same as GetFoundationModel with the addition of
// the ability to pass a context and additional request options.
//
// See GetFoundationModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) GetFoundationModelWithContext(ctx aws.Context, input *GetFoundationModelInput, opts ...request.Option) (*GetFoundationModelOutput, error) {
	req, out := c.GetFoundationModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModelCustomizationJob = "GetModelCustomizationJob"

// GetModelCustomizationJobRequest generates a "aws/request.Request" representing the
// client's request for the GetModelCustomizationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModelCustomizationJob for more information on using the GetModelCustomizationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetModelCustomizationJobRequest method.
//	req, resp := client.GetModelCustomizationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelCustomizationJob
func (c *Bedrock) GetModelCustomizationJobRequest(input *GetModelCustomizationJobInput) (req *request.Request, output *GetModelCustomizationJobOutput) {
	op := &request.Operation{
		Name:       opGetModelCustomizationJob,
		HTTPMethod: "GET",
		HTTPPath:   "/model-customization-jobs/{jobIdentifier}",
	}

	if input == nil {
		input = &GetModelCustomizationJobInput{}
	}

	output = &GetModelCustomizationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModelCustomizationJob API operation for Amazon Bedrock.
//
// Retrieves the properties associated with a model-customization job, including
// the status of the job. For more information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation GetModelCustomizationJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelCustomizationJob
func (c *Bedrock) GetModelCustomizationJob(input *GetModelCustomizationJobInput) (*GetModelCustomizationJobOutput, error) {
	req, out := c.GetModelCustomizationJobRequest(input)
	return out, req.Send()
}

// GetModelCustomizationJobWithContext is the same as GetModelCustomizationJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetModelCustomizationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) GetModelCustomizationJobWithContext(ctx aws.Context, input *GetModelCustomizationJobInput, opts ...request.Option) (*GetModelCustomizationJobOutput, error) {
	req, out := c.GetModelCustomizationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModelInvocationLoggingConfiguration = "GetModelInvocationLoggingConfiguration"

// GetModelInvocationLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetModelInvocationLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModelInvocationLoggingConfiguration for more information on using the GetModelInvocationLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetModelInvocationLoggingConfigurationRequest method.
//	req, resp := client.GetModelInvocationLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelInvocationLoggingConfiguration
func (c *Bedrock) GetModelInvocationLoggingConfigurationRequest(input *GetModelInvocationLoggingConfigurationInput) (req *request.Request, output *GetModelInvocationLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetModelInvocationLoggingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/logging/modelinvocations",
	}

	if input == nil {
		input = &GetModelInvocationLoggingConfigurationInput{}
	}

	output = &GetModelInvocationLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModelInvocationLoggingConfiguration API operation for Amazon Bedrock.
//
// Get the current configuration values for model invocation logging.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation GetModelInvocationLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetModelInvocationLoggingConfiguration
func (c *Bedrock) GetModelInvocationLoggingConfiguration(input *GetModelInvocationLoggingConfigurationInput) (*GetModelInvocationLoggingConfigurationOutput, error) {
	req, out := c.GetModelInvocationLoggingConfigurationRequest(input)
	return out, req.Send()
}

// GetModelInvocationLoggingConfigurationWithContext is the same as GetModelInvocationLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetModelInvocationLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) GetModelInvocationLoggingConfigurationWithContext(ctx aws.Context, input *GetModelInvocationLoggingConfigurationInput, opts ...request.Option) (*GetModelInvocationLoggingConfigurationOutput, error) {
	req, out := c.GetModelInvocationLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProvisionedModelThroughput = "GetProvisionedModelThroughput"

// GetProvisionedModelThroughputRequest generates a "aws/request.Request" representing the
// client's request for the GetProvisionedModelThroughput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProvisionedModelThroughput for more information on using the GetProvisionedModelThroughput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProvisionedModelThroughputRequest method.
//	req, resp := client.GetProvisionedModelThroughputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetProvisionedModelThroughput
func (c *Bedrock) GetProvisionedModelThroughputRequest(input *GetProvisionedModelThroughputInput) (req *request.Request, output *GetProvisionedModelThroughputOutput) {
	op := &request.Operation{
		Name:       opGetProvisionedModelThroughput,
		HTTPMethod: "GET",
		HTTPPath:   "/provisioned-model-throughput/{provisionedModelId}",
	}

	if input == nil {
		input = &GetProvisionedModelThroughputInput{}
	}

	output = &GetProvisionedModelThroughputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProvisionedModelThroughput API operation for Amazon Bedrock.
//
// Get details for a provisioned throughput. For more information, see Provisioned
// throughput (https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation GetProvisionedModelThroughput for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/GetProvisionedModelThroughput
func (c *Bedrock) GetProvisionedModelThroughput(input *GetProvisionedModelThroughputInput) (*GetProvisionedModelThroughputOutput, error) {
	req, out := c.GetProvisionedModelThroughputRequest(input)
	return out, req.Send()
}

// GetProvisionedModelThroughputWithContext is the same as GetProvisionedModelThroughput with the addition of
// the ability to pass a context and additional request options.
//
// See GetProvisionedModelThroughput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) GetProvisionedModelThroughputWithContext(ctx aws.Context, input *GetProvisionedModelThroughputInput, opts ...request.Option) (*GetProvisionedModelThroughputOutput, error) {
	req, out := c.GetProvisionedModelThroughputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCustomModels = "ListCustomModels"

// ListCustomModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomModels for more information on using the ListCustomModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomModelsRequest method.
//	req, resp := client.ListCustomModelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListCustomModels
func (c *Bedrock) ListCustomModelsRequest(input *ListCustomModelsInput) (req *request.Request, output *ListCustomModelsOutput) {
	op := &request.Operation{
		Name:       opListCustomModels,
		HTTPMethod: "GET",
		HTTPPath:   "/custom-models",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomModelsInput{}
	}

	output = &ListCustomModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomModels API operation for Amazon Bedrock.
//
// Returns a list of the custom models that you have created with the CreateModelCustomizationJob
// operation.
//
// For more information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation ListCustomModels for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListCustomModels
func (c *Bedrock) ListCustomModels(input *ListCustomModelsInput) (*ListCustomModelsOutput, error) {
	req, out := c.ListCustomModelsRequest(input)
	return out, req.Send()
}

// ListCustomModelsWithContext is the same as ListCustomModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListCustomModelsWithContext(ctx aws.Context, input *ListCustomModelsInput, opts ...request.Option) (*ListCustomModelsOutput, error) {
	req, out := c.ListCustomModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomModelsPages iterates over the pages of a ListCustomModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomModels operation.
//	pageNum := 0
//	err := client.ListCustomModelsPages(params,
//	    func(page *bedrock.ListCustomModelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Bedrock) ListCustomModelsPages(input *ListCustomModelsInput, fn func(*ListCustomModelsOutput, bool) bool) error {
	return c.ListCustomModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomModelsPagesWithContext same as ListCustomModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListCustomModelsPagesWithContext(ctx aws.Context, input *ListCustomModelsInput, fn func(*ListCustomModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFoundationModels = "ListFoundationModels"

// ListFoundationModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListFoundationModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFoundationModels for more information on using the ListFoundationModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFoundationModelsRequest method.
//	req, resp := client.ListFoundationModelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListFoundationModels
func (c *Bedrock) ListFoundationModelsRequest(input *ListFoundationModelsInput) (req *request.Request, output *ListFoundationModelsOutput) {
	op := &request.Operation{
		Name:       opListFoundationModels,
		HTTPMethod: "GET",
		HTTPPath:   "/foundation-models",
	}

	if input == nil {
		input = &ListFoundationModelsInput{}
	}

	output = &ListFoundationModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFoundationModels API operation for Amazon Bedrock.
//
// List of Bedrock foundation models that you can use. For more information,
// see Foundation models (https://docs.aws.amazon.com/bedrock/latest/userguide/foundation-models.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation ListFoundationModels for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListFoundationModels
func (c *Bedrock) ListFoundationModels(input *ListFoundationModelsInput) (*ListFoundationModelsOutput, error) {
	req, out := c.ListFoundationModelsRequest(input)
	return out, req.Send()
}

// ListFoundationModelsWithContext is the same as ListFoundationModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListFoundationModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListFoundationModelsWithContext(ctx aws.Context, input *ListFoundationModelsInput, opts ...request.Option) (*ListFoundationModelsOutput, error) {
	req, out := c.ListFoundationModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListModelCustomizationJobs = "ListModelCustomizationJobs"

// ListModelCustomizationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListModelCustomizationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModelCustomizationJobs for more information on using the ListModelCustomizationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListModelCustomizationJobsRequest method.
//	req, resp := client.ListModelCustomizationJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelCustomizationJobs
func (c *Bedrock) ListModelCustomizationJobsRequest(input *ListModelCustomizationJobsInput) (req *request.Request, output *ListModelCustomizationJobsOutput) {
	op := &request.Operation{
		Name:       opListModelCustomizationJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/model-customization-jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelCustomizationJobsInput{}
	}

	output = &ListModelCustomizationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModelCustomizationJobs API operation for Amazon Bedrock.
//
// Returns a list of model customization jobs that you have submitted. You can
// filter the jobs to return based on one or more criteria.
//
// For more information, see Custom models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation ListModelCustomizationJobs for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListModelCustomizationJobs
func (c *Bedrock) ListModelCustomizationJobs(input *ListModelCustomizationJobsInput) (*ListModelCustomizationJobsOutput, error) {
	req, out := c.ListModelCustomizationJobsRequest(input)
	return out, req.Send()
}

// ListModelCustomizationJobsWithContext is the same as ListModelCustomizationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListModelCustomizationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListModelCustomizationJobsWithContext(ctx aws.Context, input *ListModelCustomizationJobsInput, opts ...request.Option) (*ListModelCustomizationJobsOutput, error) {
	req, out := c.ListModelCustomizationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelCustomizationJobsPages iterates over the pages of a ListModelCustomizationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModelCustomizationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListModelCustomizationJobs operation.
//	pageNum := 0
//	err := client.ListModelCustomizationJobsPages(params,
//	    func(page *bedrock.ListModelCustomizationJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Bedrock) ListModelCustomizationJobsPages(input *ListModelCustomizationJobsInput, fn func(*ListModelCustomizationJobsOutput, bool) bool) error {
	return c.ListModelCustomizationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelCustomizationJobsPagesWithContext same as ListModelCustomizationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListModelCustomizationJobsPagesWithContext(ctx aws.Context, input *ListModelCustomizationJobsInput, fn func(*ListModelCustomizationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelCustomizationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelCustomizationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelCustomizationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProvisionedModelThroughputs = "ListProvisionedModelThroughputs"

// ListProvisionedModelThroughputsRequest generates a "aws/request.Request" representing the
// client's request for the ListProvisionedModelThroughputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProvisionedModelThroughputs for more information on using the ListProvisionedModelThroughputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProvisionedModelThroughputsRequest method.
//	req, resp := client.ListProvisionedModelThroughputsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListProvisionedModelThroughputs
func (c *Bedrock) ListProvisionedModelThroughputsRequest(input *ListProvisionedModelThroughputsInput) (req *request.Request, output *ListProvisionedModelThroughputsOutput) {
	op := &request.Operation{
		Name:       opListProvisionedModelThroughputs,
		HTTPMethod: "GET",
		HTTPPath:   "/provisioned-model-throughputs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProvisionedModelThroughputsInput{}
	}

	output = &ListProvisionedModelThroughputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProvisionedModelThroughputs API operation for Amazon Bedrock.
//
// List the provisioned capacities. For more information, see Provisioned throughput
// (https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation ListProvisionedModelThroughputs for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListProvisionedModelThroughputs
func (c *Bedrock) ListProvisionedModelThroughputs(input *ListProvisionedModelThroughputsInput) (*ListProvisionedModelThroughputsOutput, error) {
	req, out := c.ListProvisionedModelThroughputsRequest(input)
	return out, req.Send()
}

// ListProvisionedModelThroughputsWithContext is the same as ListProvisionedModelThroughputs with the addition of
// the ability to pass a context and additional request options.
//
// See ListProvisionedModelThroughputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListProvisionedModelThroughputsWithContext(ctx aws.Context, input *ListProvisionedModelThroughputsInput, opts ...request.Option) (*ListProvisionedModelThroughputsOutput, error) {
	req, out := c.ListProvisionedModelThroughputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProvisionedModelThroughputsPages iterates over the pages of a ListProvisionedModelThroughputs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProvisionedModelThroughputs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProvisionedModelThroughputs operation.
//	pageNum := 0
//	err := client.ListProvisionedModelThroughputsPages(params,
//	    func(page *bedrock.ListProvisionedModelThroughputsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Bedrock) ListProvisionedModelThroughputsPages(input *ListProvisionedModelThroughputsInput, fn func(*ListProvisionedModelThroughputsOutput, bool) bool) error {
	return c.ListProvisionedModelThroughputsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProvisionedModelThroughputsPagesWithContext same as ListProvisionedModelThroughputsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListProvisionedModelThroughputsPagesWithContext(ctx aws.Context, input *ListProvisionedModelThroughputsInput, fn func(*ListProvisionedModelThroughputsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProvisionedModelThroughputsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProvisionedModelThroughputsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProvisionedModelThroughputsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListTagsForResource
func (c *Bedrock) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/listTagsForResource",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Bedrock.
//
// List the tags associated with the specified resource.
//
// For more information, see Tagging resources (https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/ListTagsForResource
func (c *Bedrock) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutModelInvocationLoggingConfiguration = "PutModelInvocationLoggingConfiguration"

// PutModelInvocationLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutModelInvocationLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutModelInvocationLoggingConfiguration for more information on using the PutModelInvocationLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutModelInvocationLoggingConfigurationRequest method.
//	req, resp := client.PutModelInvocationLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/PutModelInvocationLoggingConfiguration
func (c *Bedrock) PutModelInvocationLoggingConfigurationRequest(input *PutModelInvocationLoggingConfigurationInput) (req *request.Request, output *PutModelInvocationLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutModelInvocationLoggingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/logging/modelinvocations",
	}

	if input == nil {
		input = &PutModelInvocationLoggingConfigurationInput{}
	}

	output = &PutModelInvocationLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutModelInvocationLoggingConfiguration API operation for Amazon Bedrock.
//
// Set the configuration values for model invocation logging.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation PutModelInvocationLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/PutModelInvocationLoggingConfiguration
func (c *Bedrock) PutModelInvocationLoggingConfiguration(input *PutModelInvocationLoggingConfigurationInput) (*PutModelInvocationLoggingConfigurationOutput, error) {
	req, out := c.PutModelInvocationLoggingConfigurationRequest(input)
	return out, req.Send()
}

// PutModelInvocationLoggingConfigurationWithContext is the same as PutModelInvocationLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutModelInvocationLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) PutModelInvocationLoggingConfigurationWithContext(ctx aws.Context, input *PutModelInvocationLoggingConfigurationInput, opts ...request.Option) (*PutModelInvocationLoggingConfigurationOutput, error) {
	req, out := c.PutModelInvocationLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopModelCustomizationJob = "StopModelCustomizationJob"

// StopModelCustomizationJobRequest generates a "aws/request.Request" representing the
// client's request for the StopModelCustomizationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopModelCustomizationJob for more information on using the StopModelCustomizationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopModelCustomizationJobRequest method.
//	req, resp := client.StopModelCustomizationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StopModelCustomizationJob
func (c *Bedrock) StopModelCustomizationJobRequest(input *StopModelCustomizationJobInput) (req *request.Request, output *StopModelCustomizationJobOutput) {
	op := &request.Operation{
		Name:       opStopModelCustomizationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/model-customization-jobs/{jobIdentifier}/stop",
	}

	if input == nil {
		input = &StopModelCustomizationJobInput{}
	}

	output = &StopModelCustomizationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopModelCustomizationJob API operation for Amazon Bedrock.
//
// Stops an active model customization job. For more information, see Custom
// models (https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation StopModelCustomizationJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - ConflictException
//     Error occurred because of a conflict while performing an operation.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/StopModelCustomizationJob
func (c *Bedrock) StopModelCustomizationJob(input *StopModelCustomizationJobInput) (*StopModelCustomizationJobOutput, error) {
	req, out := c.StopModelCustomizationJobRequest(input)
	return out, req.Send()
}

// StopModelCustomizationJobWithContext is the same as StopModelCustomizationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopModelCustomizationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) StopModelCustomizationJobWithContext(ctx aws.Context, input *StopModelCustomizationJobInput, opts ...request.Option) (*StopModelCustomizationJobOutput, error) {
	req, out := c.StopModelCustomizationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/TagResource
func (c *Bedrock) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tagResource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Bedrock.
//
// Associate tags with a resource. For more information, see Tagging resources
// (https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - TooManyTagsException
//     The request contains more tags than can be associated with a resource (50
//     tags per resource). The maximum number of tags includes both existing tags
//     and those included in your current request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/TagResource
func (c *Bedrock) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UntagResource
func (c *Bedrock) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/untagResource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Bedrock.
//
// Remove one or more tags from a resource. For more information, see Tagging
// resources (https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UntagResource
func (c *Bedrock) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProvisionedModelThroughput = "UpdateProvisionedModelThroughput"

// UpdateProvisionedModelThroughputRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProvisionedModelThroughput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProvisionedModelThroughput for more information on using the UpdateProvisionedModelThroughput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProvisionedModelThroughputRequest method.
//	req, resp := client.UpdateProvisionedModelThroughputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateProvisionedModelThroughput
func (c *Bedrock) UpdateProvisionedModelThroughputRequest(input *UpdateProvisionedModelThroughputInput) (req *request.Request, output *UpdateProvisionedModelThroughputOutput) {
	op := &request.Operation{
		Name:       opUpdateProvisionedModelThroughput,
		HTTPMethod: "PATCH",
		HTTPPath:   "/provisioned-model-throughput/{provisionedModelId}",
	}

	if input == nil {
		input = &UpdateProvisionedModelThroughputInput{}
	}

	output = &UpdateProvisionedModelThroughputOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateProvisionedModelThroughput API operation for Amazon Bedrock.
//
// Update a provisioned throughput. For more information, see Provisioned throughput
// (https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html)
// in the Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Bedrock's
// API operation UpdateProvisionedModelThroughput for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource ARN was not found. Check the ARN and try your request
//     again.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/UpdateProvisionedModelThroughput
func (c *Bedrock) UpdateProvisionedModelThroughput(input *UpdateProvisionedModelThroughputInput) (*UpdateProvisionedModelThroughputOutput, error) {
	req, out := c.UpdateProvisionedModelThroughputRequest(input)
	return out, req.Send()
}

// UpdateProvisionedModelThroughputWithContext is the same as UpdateProvisionedModelThroughput with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProvisionedModelThroughput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Bedrock) UpdateProvisionedModelThroughputWithContext(ctx aws.Context, input *UpdateProvisionedModelThroughputInput, opts ...request.Option) (*UpdateProvisionedModelThroughputOutput, error) {
	req, out := c.UpdateProvisionedModelThroughputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The request is denied because of missing access permissions.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// CloudWatch logging configuration.
type CloudWatchConfig struct {
	_ struct{} `type:"structure"`

	// S3 configuration for delivering a large amount of data.
	LargeDataDeliveryS3Config *S3Config `locationName:"largeDataDeliveryS3Config" type:"structure"`

	// The log group name.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchConfig"}
	if s.LogGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogGroupName", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.LargeDataDeliveryS3Config != nil {
		if err := s.LargeDataDeliveryS3Config.Validate(); err != nil {
			invalidParams.AddNested("LargeDataDeliveryS3Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLargeDataDeliveryS3Config sets the LargeDataDeliveryS3Config field's value.
func (s *CloudWatchConfig) SetLargeDataDeliveryS3Config(v *S3Config) *CloudWatchConfig {
	s.LargeDataDeliveryS3Config = v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *CloudWatchConfig) SetLogGroupName(v string) *CloudWatchConfig {
	s.LogGroupName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CloudWatchConfig) SetRoleArn(v string) *CloudWatchConfig {
	s.RoleArn = &v
	return s
}

// Error occurred because of a conflict while performing an operation.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateModelCustomizationJobInput struct {
	_ struct{} `type:"structure"`

	// Name of the base model.
	//
	// BaseModelIdentifier is a required field
	BaseModelIdentifier *string `locationName:"baseModelIdentifier" min:"1" type:"string" required:"true"`

	// Unique token value that you can provide. The GetModelCustomizationJob response
	// includes the same token value.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The custom model is encrypted at rest using this key.
	CustomModelKmsKeyId *string `locationName:"customModelKmsKeyId" min:"1" type:"string"`

	// Enter a name for the custom model.
	//
	// CustomModelName is a required field
	CustomModelName *string `locationName:"customModelName" min:"1" type:"string" required:"true"`

	// Assign tags to the custom model.
	CustomModelTags []*Tag `locationName:"customModelTags" type:"list"`

	// Parameters related to tuning the model.
	//
	// HyperParameters is a required field
	HyperParameters map[string]*string `locationName:"hyperParameters" type:"map" required:"true"`

	// Enter a unique name for the fine-tuning job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// Assign tags to the job.
	JobTags []*Tag `locationName:"jobTags" type:"list"`

	// S3 location for the output data.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `locationName:"outputDataConfig" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role that Bedrock can assume to
	// perform tasks on your behalf. For example, during model training, Bedrock
	// needs your permission to read input data from an S3 bucket, write model artifacts
	// to an S3 bucket. To pass this role to Bedrock, the caller of this API must
	// have the iam:PassRole permission.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Information about the training dataset.
	//
	// TrainingDataConfig is a required field
	TrainingDataConfig *TrainingDataConfig `locationName:"trainingDataConfig" type:"structure" required:"true"`

	// Information about the validation dataset.
	ValidationDataConfig *ValidationDataConfig `locationName:"validationDataConfig" type:"structure"`

	// VPC configuration (optional). Configuration parameters for the private Virtual
	// Private Cloud (VPC) that contains the resources you are using for this job.
	VpcConfig *VpcConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelCustomizationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelCustomizationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelCustomizationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelCustomizationJobInput"}
	if s.BaseModelIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("BaseModelIdentifier"))
	}
	if s.BaseModelIdentifier != nil && len(*s.BaseModelIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BaseModelIdentifier", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.CustomModelKmsKeyId != nil && len(*s.CustomModelKmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomModelKmsKeyId", 1))
	}
	if s.CustomModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomModelName"))
	}
	if s.CustomModelName != nil && len(*s.CustomModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomModelName", 1))
	}
	if s.HyperParameters == nil {
		invalidParams.Add(request.NewErrParamRequired("HyperParameters"))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.TrainingDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingDataConfig"))
	}
	if s.CustomModelTags != nil {
		for i, v := range s.CustomModelTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomModelTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.JobTags != nil {
		for i, v := range s.JobTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "JobTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.TrainingDataConfig != nil {
		if err := s.TrainingDataConfig.Validate(); err != nil {
			invalidParams.AddNested("TrainingDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ValidationDataConfig != nil {
		if err := s.ValidationDataConfig.Validate(); err != nil {
			invalidParams.AddNested("ValidationDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseModelIdentifier sets the BaseModelIdentifier field's value.
func (s *CreateModelCustomizationJobInput) SetBaseModelIdentifier(v string) *CreateModelCustomizationJobInput {
	s.BaseModelIdentifier = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateModelCustomizationJobInput) SetClientRequestToken(v string) *CreateModelCustomizationJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetCustomModelKmsKeyId sets the CustomModelKmsKeyId field's value.
func (s *CreateModelCustomizationJobInput) SetCustomModelKmsKeyId(v string) *CreateModelCustomizationJobInput {
	s.CustomModelKmsKeyId = &v
	return s
}

// SetCustomModelName sets the CustomModelName field's value.
func (s *CreateModelCustomizationJobInput) SetCustomModelName(v string) *CreateModelCustomizationJobInput {
	s.CustomModelName = &v
	return s
}

// SetCustomModelTags sets the CustomModelTags field's value.
func (s *CreateModelCustomizationJobInput) SetCustomModelTags(v []*Tag) *CreateModelCustomizationJobInput {
	s.CustomModelTags = v
	return s
}

// SetHyperParameters sets the HyperParameters field's value.
func (s *CreateModelCustomizationJobInput) SetHyperParameters(v map[string]*string) *CreateModelCustomizationJobInput {
	s.HyperParameters = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *CreateModelCustomizationJobInput) SetJobName(v string) *CreateModelCustomizationJobInput {
	s.JobName = &v
	return s
}

// SetJobTags sets the JobTags field's value.
func (s *CreateModelCustomizationJobInput) SetJobTags(v []*Tag) *CreateModelCustomizationJobInput {
	s.JobTags = v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *CreateModelCustomizationJobInput) SetOutputDataConfig(v *OutputDataConfig) *CreateModelCustomizationJobInput {
	s.OutputDataConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateModelCustomizationJobInput) SetRoleArn(v string) *CreateModelCustomizationJobInput {
	s.RoleArn = &v
	return s
}

// SetTrainingDataConfig sets the TrainingDataConfig field's value.
func (s *CreateModelCustomizationJobInput) SetTrainingDataConfig(v *TrainingDataConfig) *CreateModelCustomizationJobInput {
	s.TrainingDataConfig = v
	return s
}

// SetValidationDataConfig sets the ValidationDataConfig field's value.
func (s *CreateModelCustomizationJobInput) SetValidationDataConfig(v *ValidationDataConfig) *CreateModelCustomizationJobInput {
	s.ValidationDataConfig = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateModelCustomizationJobInput) SetVpcConfig(v *VpcConfig) *CreateModelCustomizationJobInput {
	s.VpcConfig = v
	return s
}

type CreateModelCustomizationJobOutput struct {
	_ struct{} `type:"structure"`

	// ARN of the fine tuning job
	//
	// JobArn is a required field
	JobArn *string `locationName:"jobArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelCustomizationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelCustomizationJobOutput) GoString() string {
	return s.String()
}

// SetJobArn sets the JobArn field's value.
func (s *CreateModelCustomizationJobOutput) SetJobArn(v string) *CreateModelCustomizationJobOutput {
	s.JobArn = &v
	return s
}

type CreateProvisionedModelThroughputInput struct {
	_ struct{} `type:"structure"`

	// Unique token value that you can provide. If this token matches a previous
	// request, Bedrock ignores the request, but does not return an error.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// Commitment duration requested for the provisioned throughput.
	CommitmentDuration *string `locationName:"commitmentDuration" type:"string" enum:"CommitmentDuration"`

	// Name or ARN of the model to associate with this provisioned throughput.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// Number of model units to allocate.
	//
	// ModelUnits is a required field
	ModelUnits *int64 `locationName:"modelUnits" min:"1" type:"integer" required:"true"`

	// Unique name for this provisioned throughput.
	//
	// ProvisionedModelName is a required field
	ProvisionedModelName *string `locationName:"provisionedModelName" min:"1" type:"string" required:"true"`

	// Tags to associate with this provisioned throughput.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProvisionedModelThroughputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProvisionedModelThroughputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProvisionedModelThroughputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProvisionedModelThroughputInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelUnits"))
	}
	if s.ModelUnits != nil && *s.ModelUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ModelUnits", 1))
	}
	if s.ProvisionedModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedModelName"))
	}
	if s.ProvisionedModelName != nil && len(*s.ProvisionedModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedModelName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateProvisionedModelThroughputInput) SetClientRequestToken(v string) *CreateProvisionedModelThroughputInput {
	s.ClientRequestToken = &v
	return s
}

// SetCommitmentDuration sets the CommitmentDuration field's value.
func (s *CreateProvisionedModelThroughputInput) SetCommitmentDuration(v string) *CreateProvisionedModelThroughputInput {
	s.CommitmentDuration = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *CreateProvisionedModelThroughputInput) SetModelId(v string) *CreateProvisionedModelThroughputInput {
	s.ModelId = &v
	return s
}

// SetModelUnits sets the ModelUnits field's value.
func (s *CreateProvisionedModelThroughputInput) SetModelUnits(v int64) *CreateProvisionedModelThroughputInput {
	s.ModelUnits = &v
	return s
}

// SetProvisionedModelName sets the ProvisionedModelName field's value.
func (s *CreateProvisionedModelThroughputInput) SetProvisionedModelName(v string) *CreateProvisionedModelThroughputInput {
	s.ProvisionedModelName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProvisionedModelThroughputInput) SetTags(v []*Tag) *CreateProvisionedModelThroughputInput {
	s.Tags = v
	return s
}

type CreateProvisionedModelThroughputOutput struct {
	_ struct{} `type:"structure"`

	// The ARN for this provisioned throughput.
	//
	// ProvisionedModelArn is a required field
	ProvisionedModelArn *string `locationName:"provisionedModelArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProvisionedModelThroughputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProvisionedModelThroughputOutput) GoString() string {
	return s.String()
}

// SetProvisionedModelArn sets the ProvisionedModelArn field's value.
func (s *CreateProvisionedModelThroughputOutput) SetProvisionedModelArn(v string) *CreateProvisionedModelThroughputOutput {
	s.ProvisionedModelArn = &v
	return s
}

// Summary information for a custom model.
type CustomModelSummary struct {
	_ struct{} `type:"structure"`

	// The base model ARN.
	//
	// BaseModelArn is a required field
	BaseModelArn *string `locationName:"baseModelArn" min:"20" type:"string" required:"true"`

	// The base model name.
	//
	// BaseModelName is a required field
	BaseModelName *string `locationName:"baseModelName" min:"1" type:"string" required:"true"`

	// Creation time of the model.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ARN of the custom model.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" min:"20" type:"string" required:"true"`

	// The name of the custom model.
	//
	// ModelName is a required field
	ModelName *string `locationName:"modelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomModelSummary) GoString() string {
	return s.String()
}

// SetBaseModelArn sets the BaseModelArn field's value.
func (s *CustomModelSummary) SetBaseModelArn(v string) *CustomModelSummary {
	s.BaseModelArn = &v
	return s
}

// SetBaseModelName sets the BaseModelName field's value.
func (s *CustomModelSummary) SetBaseModelName(v string) *CustomModelSummary {
	s.BaseModelName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CustomModelSummary) SetCreationTime(v time.Time) *CustomModelSummary {
	s.CreationTime = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *CustomModelSummary) SetModelArn(v string) *CustomModelSummary {
	s.ModelArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CustomModelSummary) SetModelName(v string) *CustomModelSummary {
	s.ModelName = &v
	return s
}

type DeleteCustomModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Name of the model to delete.
	//
	// ModelIdentifier is a required field
	ModelIdentifier *string `location:"uri" locationName:"modelIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomModelInput"}
	if s.ModelIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelIdentifier"))
	}
	if s.ModelIdentifier != nil && len(*s.ModelIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelIdentifier sets the ModelIdentifier field's value.
func (s *DeleteCustomModelInput) SetModelIdentifier(v string) *DeleteCustomModelInput {
	s.ModelIdentifier = &v
	return s
}

type DeleteCustomModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomModelOutput) GoString() string {
	return s.String()
}

type DeleteModelInvocationLoggingConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInvocationLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInvocationLoggingConfigurationInput) GoString() string {
	return s.String()
}

type DeleteModelInvocationLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInvocationLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInvocationLoggingConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteProvisionedModelThroughputInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN or name of the provisioned throughput.
	//
	// ProvisionedModelId is a required field
	ProvisionedModelId *string `location:"uri" locationName:"provisionedModelId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProvisionedModelThroughputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProvisionedModelThroughputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProvisionedModelThroughputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProvisionedModelThroughputInput"}
	if s.ProvisionedModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedModelId"))
	}
	if s.ProvisionedModelId != nil && len(*s.ProvisionedModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProvisionedModelId sets the ProvisionedModelId field's value.
func (s *DeleteProvisionedModelThroughputInput) SetProvisionedModelId(v string) *DeleteProvisionedModelThroughputInput {
	s.ProvisionedModelId = &v
	return s
}

type DeleteProvisionedModelThroughputOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProvisionedModelThroughputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProvisionedModelThroughputOutput) GoString() string {
	return s.String()
}

// Information about a foundation model.
type FoundationModelDetails struct {
	_ struct{} `type:"structure"`

	// The customization that the model supports.
	CustomizationsSupported []*string `locationName:"customizationsSupported" type:"list" enum:"ModelCustomization"`

	// The inference types that the model supports.
	InferenceTypesSupported []*string `locationName:"inferenceTypesSupported" type:"list" enum:"InferenceType"`

	// The input modalities that the model supports.
	InputModalities []*string `locationName:"inputModalities" type:"list" enum:"ModelModality"`

	// The model ARN.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" type:"string" required:"true"`

	// The model identifier.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" type:"string" required:"true"`

	// The model name.
	ModelName *string `locationName:"modelName" min:"1" type:"string"`

	// The output modalities that the model supports.
	OutputModalities []*string `locationName:"outputModalities" type:"list" enum:"ModelModality"`

	// he model's provider name.
	ProviderName *string `locationName:"providerName" min:"1" type:"string"`

	// Indicates whether the model supports streaming.
	ResponseStreamingSupported *bool `locationName:"responseStreamingSupported" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FoundationModelDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FoundationModelDetails) GoString() string {
	return s.String()
}

// SetCustomizationsSupported sets the CustomizationsSupported field's value.
func (s *FoundationModelDetails) SetCustomizationsSupported(v []*string) *FoundationModelDetails {
	s.CustomizationsSupported = v
	return s
}

// SetInferenceTypesSupported sets the InferenceTypesSupported field's value.
func (s *FoundationModelDetails) SetInferenceTypesSupported(v []*string) *FoundationModelDetails {
	s.InferenceTypesSupported = v
	return s
}

// SetInputModalities sets the InputModalities field's value.
func (s *FoundationModelDetails) SetInputModalities(v []*string) *FoundationModelDetails {
	s.InputModalities = v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *FoundationModelDetails) SetModelArn(v string) *FoundationModelDetails {
	s.ModelArn = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *FoundationModelDetails) SetModelId(v string) *FoundationModelDetails {
	s.ModelId = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *FoundationModelDetails) SetModelName(v string) *FoundationModelDetails {
	s.ModelName = &v
	return s
}

// SetOutputModalities sets the OutputModalities field's value.
func (s *FoundationModelDetails) SetOutputModalities(v []*string) *FoundationModelDetails {
	s.OutputModalities = v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *FoundationModelDetails) SetProviderName(v string) *FoundationModelDetails {
	s.ProviderName = &v
	return s
}

// SetResponseStreamingSupported sets the ResponseStreamingSupported field's value.
func (s *FoundationModelDetails) SetResponseStreamingSupported(v bool) *FoundationModelDetails {
	s.ResponseStreamingSupported = &v
	return s
}

// Summary information for a foundation model.
type FoundationModelSummary struct {
	_ struct{} `type:"structure"`

	// Whether the model supports fine-tuning or continual pre-training.
	CustomizationsSupported []*string `locationName:"customizationsSupported" type:"list" enum:"ModelCustomization"`

	// The inference types that the model supports.
	InferenceTypesSupported []*string `locationName:"inferenceTypesSupported" type:"list" enum:"InferenceType"`

	// The input modalities that the model supports.
	InputModalities []*string `locationName:"inputModalities" type:"list" enum:"ModelModality"`

	// The ARN of the foundation model.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" type:"string" required:"true"`

	// The model Id of the foundation model.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" type:"string" required:"true"`

	// The name of the model.
	ModelName *string `locationName:"modelName" min:"1" type:"string"`

	// The output modalities that the model supports.
	OutputModalities []*string `locationName:"outputModalities" type:"list" enum:"ModelModality"`

	// The model's provider name.
	ProviderName *string `locationName:"providerName" min:"1" type:"string"`

	// Indicates whether the model supports streaming.
	ResponseStreamingSupported *bool `locationName:"responseStreamingSupported" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FoundationModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FoundationModelSummary) GoString() string {
	return s.String()
}

// SetCustomizationsSupported sets the CustomizationsSupported field's value.
func (s *FoundationModelSummary) SetCustomizationsSupported(v []*string) *FoundationModelSummary {
	s.CustomizationsSupported = v
	return s
}

// SetInferenceTypesSupported sets the InferenceTypesSupported field's value.
func (s *FoundationModelSummary) SetInferenceTypesSupported(v []*string) *FoundationModelSummary {
	s.InferenceTypesSupported = v
	return s
}

// SetInputModalities sets the InputModalities field's value.
func (s *FoundationModelSummary) SetInputModalities(v []*string) *FoundationModelSummary {
	s.InputModalities = v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *FoundationModelSummary) SetModelArn(v string) *FoundationModelSummary {
	s.ModelArn = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *FoundationModelSummary) SetModelId(v string) *FoundationModelSummary {
	s.ModelId = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *FoundationModelSummary) SetModelName(v string) *FoundationModelSummary {
	s.ModelName = &v
	return s
}

// SetOutputModalities sets the OutputModalities field's value.
func (s *FoundationModelSummary) SetOutputModalities(v []*string) *FoundationModelSummary {
	s.OutputModalities = v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *FoundationModelSummary) SetProviderName(v string) *FoundationModelSummary {
	s.ProviderName = &v
	return s
}

// SetResponseStreamingSupported sets the ResponseStreamingSupported field's value.
func (s *FoundationModelSummary) SetResponseStreamingSupported(v bool) *FoundationModelSummary {
	s.ResponseStreamingSupported = &v
	return s
}

type GetCustomModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Name or ARN of the custom model.
	//
	// ModelIdentifier is a required field
	ModelIdentifier *string `location:"uri" locationName:"modelIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCustomModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCustomModelInput"}
	if s.ModelIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelIdentifier"))
	}
	if s.ModelIdentifier != nil && len(*s.ModelIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelIdentifier sets the ModelIdentifier field's value.
func (s *GetCustomModelInput) SetModelIdentifier(v string) *GetCustomModelInput {
	s.ModelIdentifier = &v
	return s
}

type GetCustomModelOutput struct {
	_ struct{} `type:"structure"`

	// ARN of the base model.
	//
	// BaseModelArn is a required field
	BaseModelArn *string `locationName:"baseModelArn" min:"20" type:"string" required:"true"`

	// Creation time of the model.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Hyperparameter values associated with this model.
	HyperParameters map[string]*string `locationName:"hyperParameters" type:"map"`

	// Job ARN associated with this model.
	//
	// JobArn is a required field
	JobArn *string `locationName:"jobArn" type:"string" required:"true"`

	// Job name associated with this model.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// ARN associated with this model.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" min:"20" type:"string" required:"true"`

	// The custom model is encrypted at rest using this key.
	ModelKmsKeyArn *string `locationName:"modelKmsKeyArn" min:"1" type:"string"`

	// Model name associated with this model.
	//
	// ModelName is a required field
	ModelName *string `locationName:"modelName" min:"1" type:"string" required:"true"`

	// Output data configuration associated with this custom model.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `locationName:"outputDataConfig" type:"structure" required:"true"`

	// Information about the training dataset.
	//
	// TrainingDataConfig is a required field
	TrainingDataConfig *TrainingDataConfig `locationName:"trainingDataConfig" type:"structure" required:"true"`

	// The training metrics from the job creation.
	TrainingMetrics *TrainingMetrics `locationName:"trainingMetrics" type:"structure"`

	// Array of up to 10 validators.
	ValidationDataConfig *ValidationDataConfig `locationName:"validationDataConfig" type:"structure"`

	// The validation metrics from the job creation.
	ValidationMetrics []*ValidatorMetric `locationName:"validationMetrics" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomModelOutput) GoString() string {
	return s.String()
}

// SetBaseModelArn sets the BaseModelArn field's value.
func (s *GetCustomModelOutput) SetBaseModelArn(v string) *GetCustomModelOutput {
	s.BaseModelArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetCustomModelOutput) SetCreationTime(v time.Time) *GetCustomModelOutput {
	s.CreationTime = &v
	return s
}

// SetHyperParameters sets the HyperParameters field's value.
func (s *GetCustomModelOutput) SetHyperParameters(v map[string]*string) *GetCustomModelOutput {
	s.HyperParameters = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *GetCustomModelOutput) SetJobArn(v string) *GetCustomModelOutput {
	s.JobArn = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *GetCustomModelOutput) SetJobName(v string) *GetCustomModelOutput {
	s.JobName = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *GetCustomModelOutput) SetModelArn(v string) *GetCustomModelOutput {
	s.ModelArn = &v
	return s
}

// SetModelKmsKeyArn sets the ModelKmsKeyArn field's value.
func (s *GetCustomModelOutput) SetModelKmsKeyArn(v string) *GetCustomModelOutput {
	s.ModelKmsKeyArn = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *GetCustomModelOutput) SetModelName(v string) *GetCustomModelOutput {
	s.ModelName = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *GetCustomModelOutput) SetOutputDataConfig(v *OutputDataConfig) *GetCustomModelOutput {
	s.OutputDataConfig = v
	return s
}

// SetTrainingDataConfig sets the TrainingDataConfig field's value.
func (s *GetCustomModelOutput) SetTrainingDataConfig(v *TrainingDataConfig) *GetCustomModelOutput {
	s.TrainingDataConfig = v
	return s
}

// SetTrainingMetrics sets the TrainingMetrics field's value.
func (s *GetCustomModelOutput) SetTrainingMetrics(v *TrainingMetrics) *GetCustomModelOutput {
	s.TrainingMetrics = v
	return s
}

// SetValidationDataConfig sets the ValidationDataConfig field's value.
func (s *GetCustomModelOutput) SetValidationDataConfig(v *ValidationDataConfig) *GetCustomModelOutput {
	s.ValidationDataConfig = v
	return s
}

// SetValidationMetrics sets the ValidationMetrics field's value.
func (s *GetCustomModelOutput) SetValidationMetrics(v []*ValidatorMetric) *GetCustomModelOutput {
	s.ValidationMetrics = v
	return s
}

type GetFoundationModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The model identifier.
	//
	// ModelIdentifier is a required field
	ModelIdentifier *string `location:"uri" locationName:"modelIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFoundationModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFoundationModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFoundationModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFoundationModelInput"}
	if s.ModelIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelIdentifier"))
	}
	if s.ModelIdentifier != nil && len(*s.ModelIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelIdentifier sets the ModelIdentifier field's value.
func (s *GetFoundationModelInput) SetModelIdentifier(v string) *GetFoundationModelInput {
	s.ModelIdentifier = &v
	return s
}

type GetFoundationModelOutput struct {
	_ struct{} `type:"structure"`

	// Information about the foundation model.
	ModelDetails *FoundationModelDetails `locationName:"modelDetails" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFoundationModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFoundationModelOutput) GoString() string {
	return s.String()
}

// SetModelDetails sets the ModelDetails field's value.
func (s *GetFoundationModelOutput) SetModelDetails(v *FoundationModelDetails) *GetFoundationModelOutput {
	s.ModelDetails = v
	return s
}

type GetModelCustomizationJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier for the customization job.
	//
	// JobIdentifier is a required field
	JobIdentifier *string `location:"uri" locationName:"jobIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelCustomizationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelCustomizationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelCustomizationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelCustomizationJobInput"}
	if s.JobIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("JobIdentifier"))
	}
	if s.JobIdentifier != nil && len(*s.JobIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobIdentifier sets the JobIdentifier field's value.
func (s *GetModelCustomizationJobInput) SetJobIdentifier(v string) *GetModelCustomizationJobInput {
	s.JobIdentifier = &v
	return s
}

type GetModelCustomizationJobOutput struct {
	_ struct{} `type:"structure"`

	// ARN of the base model.
	//
	// BaseModelArn is a required field
	BaseModelArn *string `locationName:"baseModelArn" type:"string" required:"true"`

	// The token that you specified in the CreateCustomizationJob request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// Time that the resource was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Time that the resource transitioned to terminal state.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// Information about why the job failed.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The hyperparameter values for the job.
	//
	// HyperParameters is a required field
	HyperParameters map[string]*string `locationName:"hyperParameters" type:"map" required:"true"`

	// The ARN of the customization job.
	//
	// JobArn is a required field
	JobArn *string `locationName:"jobArn" type:"string" required:"true"`

	// The name of the customization job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// Time that the resource was last modified.
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp" timestampFormat:"iso8601"`

	// Output data configuration
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `locationName:"outputDataConfig" type:"structure" required:"true"`

	// The ARN of the output model.
	OutputModelArn *string `locationName:"outputModelArn" min:"20" type:"string"`

	// The custom model is encrypted at rest using this key.
	OutputModelKmsKeyArn *string `locationName:"outputModelKmsKeyArn" min:"1" type:"string"`

	// The name of the output model.
	//
	// OutputModelName is a required field
	OutputModelName *string `locationName:"outputModelName" min:"1" type:"string" required:"true"`

	// The ARN of the IAM role.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The status of the job. A successful job transitions from in-progress to completed
	// when the output model is ready to use. If the job failed, the failure message
	// contains information about why the job failed.
	Status *string `locationName:"status" type:"string" enum:"ModelCustomizationJobStatus"`

	// S3 Location of the training data.
	//
	// TrainingDataConfig is a required field
	TrainingDataConfig *TrainingDataConfig `locationName:"trainingDataConfig" type:"structure" required:"true"`

	// Metrics associated with the custom job.
	TrainingMetrics *TrainingMetrics `locationName:"trainingMetrics" type:"structure"`

	// Array of up to 10 validators.
	//
	// ValidationDataConfig is a required field
	ValidationDataConfig *ValidationDataConfig `locationName:"validationDataConfig" type:"structure" required:"true"`

	// The loss metric for each validator that you provided in the createjob request.
	ValidationMetrics []*ValidatorMetric `locationName:"validationMetrics" type:"list"`

	// VPC configuration for the custom model job.
	VpcConfig *VpcConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelCustomizationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelCustomizationJobOutput) GoString() string {
	return s.String()
}

// SetBaseModelArn sets the BaseModelArn field's value.
func (s *GetModelCustomizationJobOutput) SetBaseModelArn(v string) *GetModelCustomizationJobOutput {
	s.BaseModelArn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *GetModelCustomizationJobOutput) SetClientRequestToken(v string) *GetModelCustomizationJobOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetModelCustomizationJobOutput) SetCreationTime(v time.Time) *GetModelCustomizationJobOutput {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GetModelCustomizationJobOutput) SetEndTime(v time.Time) *GetModelCustomizationJobOutput {
	s.EndTime = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *GetModelCustomizationJobOutput) SetFailureMessage(v string) *GetModelCustomizationJobOutput {
	s.FailureMessage = &v
	return s
}

// SetHyperParameters sets the HyperParameters field's value.
func (s *GetModelCustomizationJobOutput) SetHyperParameters(v map[string]*string) *GetModelCustomizationJobOutput {
	s.HyperParameters = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *GetModelCustomizationJobOutput) SetJobArn(v string) *GetModelCustomizationJobOutput {
	s.JobArn = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *GetModelCustomizationJobOutput) SetJobName(v string) *GetModelCustomizationJobOutput {
	s.JobName = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetModelCustomizationJobOutput) SetLastModifiedTime(v time.Time) *GetModelCustomizationJobOutput {
	s.LastModifiedTime = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *GetModelCustomizationJobOutput) SetOutputDataConfig(v *OutputDataConfig) *GetModelCustomizationJobOutput {
	s.OutputDataConfig = v
	return s
}

// SetOutputModelArn sets the OutputModelArn field's value.
func (s *GetModelCustomizationJobOutput) SetOutputModelArn(v string) *GetModelCustomizationJobOutput {
	s.OutputModelArn = &v
	return s
}

// SetOutputModelKmsKeyArn sets the OutputModelKmsKeyArn field's value.
func (s *GetModelCustomizationJobOutput) SetOutputModelKmsKeyArn(v string) *GetModelCustomizationJobOutput {
	s.OutputModelKmsKeyArn = &v
	return s
}

// SetOutputModelName sets the OutputModelName field's value.
func (s *GetModelCustomizationJobOutput) SetOutputModelName(v string) *GetModelCustomizationJobOutput {
	s.OutputModelName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetModelCustomizationJobOutput) SetRoleArn(v string) *GetModelCustomizationJobOutput {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetModelCustomizationJobOutput) SetStatus(v string) *GetModelCustomizationJobOutput {
	s.Status = &v
	return s
}

// SetTrainingDataConfig sets the TrainingDataConfig field's value.
func (s *GetModelCustomizationJobOutput) SetTrainingDataConfig(v *TrainingDataConfig) *GetModelCustomizationJobOutput {
	s.TrainingDataConfig = v
	return s
}

// SetTrainingMetrics sets the TrainingMetrics field's value.
func (s *GetModelCustomizationJobOutput) SetTrainingMetrics(v *TrainingMetrics) *GetModelCustomizationJobOutput {
	s.TrainingMetrics = v
	return s
}

// SetValidationDataConfig sets the ValidationDataConfig field's value.
func (s *GetModelCustomizationJobOutput) SetValidationDataConfig(v *ValidationDataConfig) *GetModelCustomizationJobOutput {
	s.ValidationDataConfig = v
	return s
}

// SetValidationMetrics sets the ValidationMetrics field's value.
func (s *GetModelCustomizationJobOutput) SetValidationMetrics(v []*ValidatorMetric) *GetModelCustomizationJobOutput {
	s.ValidationMetrics = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *GetModelCustomizationJobOutput) SetVpcConfig(v *VpcConfig) *GetModelCustomizationJobOutput {
	s.VpcConfig = v
	return s
}

type GetModelInvocationLoggingConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelInvocationLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelInvocationLoggingConfigurationInput) GoString() string {
	return s.String()
}

type GetModelInvocationLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The current configuration values.
	LoggingConfig *LoggingConfig `locationName:"loggingConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelInvocationLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelInvocationLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetLoggingConfig sets the LoggingConfig field's value.
func (s *GetModelInvocationLoggingConfigurationOutput) SetLoggingConfig(v *LoggingConfig) *GetModelInvocationLoggingConfigurationOutput {
	s.LoggingConfig = v
	return s
}

type GetProvisionedModelThroughputInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN or name of the provisioned throughput.
	//
	// ProvisionedModelId is a required field
	ProvisionedModelId *string `location:"uri" locationName:"provisionedModelId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProvisionedModelThroughputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProvisionedModelThroughputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProvisionedModelThroughputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProvisionedModelThroughputInput"}
	if s.ProvisionedModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedModelId"))
	}
	if s.ProvisionedModelId != nil && len(*s.ProvisionedModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProvisionedModelId sets the ProvisionedModelId field's value.
func (s *GetProvisionedModelThroughputInput) SetProvisionedModelId(v string) *GetProvisionedModelThroughputInput {
	s.ProvisionedModelId = &v
	return s
}

type GetProvisionedModelThroughputOutput struct {
	_ struct{} `type:"structure"`

	// Commitment duration of the provisioned throughput.
	CommitmentDuration *string `locationName:"commitmentDuration" type:"string" enum:"CommitmentDuration"`

	// Commitment expiration time for the provisioned throughput.
	CommitmentExpirationTime *time.Time `locationName:"commitmentExpirationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The timestamp of the creation time for this provisioned throughput.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ARN of the new model to asssociate with this provisioned throughput.
	//
	// DesiredModelArn is a required field
	DesiredModelArn *string `locationName:"desiredModelArn" min:"20" type:"string" required:"true"`

	// The desired number of model units that was requested to be available for
	// this provisioned throughput.
	//
	// DesiredModelUnits is a required field
	DesiredModelUnits *int64 `locationName:"desiredModelUnits" min:"1" type:"integer" required:"true"`

	// Failure message for any issues that the create operation encounters.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// ARN of the foundation model.
	//
	// FoundationModelArn is a required field
	FoundationModelArn *string `locationName:"foundationModelArn" type:"string" required:"true"`

	// The timestamp of the last modified time of this provisioned throughput.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ARN or name of the model associated with this provisioned throughput.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" min:"20" type:"string" required:"true"`

	// The current number of model units requested to be available for this provisioned
	// throughput.
	//
	// ModelUnits is a required field
	ModelUnits *int64 `locationName:"modelUnits" min:"1" type:"integer" required:"true"`

	// The ARN of the provisioned throughput.
	//
	// ProvisionedModelArn is a required field
	ProvisionedModelArn *string `locationName:"provisionedModelArn" type:"string" required:"true"`

	// The name of the provisioned throughput.
	//
	// ProvisionedModelName is a required field
	ProvisionedModelName *string `locationName:"provisionedModelName" min:"1" type:"string" required:"true"`

	// Status of the provisioned throughput.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ProvisionedModelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProvisionedModelThroughputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProvisionedModelThroughputOutput) GoString() string {
	return s.String()
}

// SetCommitmentDuration sets the CommitmentDuration field's value.
func (s *GetProvisionedModelThroughputOutput) SetCommitmentDuration(v string) *GetProvisionedModelThroughputOutput {
	s.CommitmentDuration = &v
	return s
}

// SetCommitmentExpirationTime sets the CommitmentExpirationTime field's value.
func (s *GetProvisionedModelThroughputOutput) SetCommitmentExpirationTime(v time.Time) *GetProvisionedModelThroughputOutput {
	s.CommitmentExpirationTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetProvisionedModelThroughputOutput) SetCreationTime(v time.Time) *GetProvisionedModelThroughputOutput {
	s.CreationTime = &v
	return s
}

// SetDesiredModelArn sets the DesiredModelArn field's value.
func (s *GetProvisionedModelThroughputOutput) SetDesiredModelArn(v string) *GetProvisionedModelThroughputOutput {
	s.DesiredModelArn = &v
	return s
}

// SetDesiredModelUnits sets the DesiredModelUnits field's value.
func (s *GetProvisionedModelThroughputOutput) SetDesiredModelUnits(v int64) *GetProvisionedModelThroughputOutput {
	s.DesiredModelUnits = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *GetProvisionedModelThroughputOutput) SetFailureMessage(v string) *GetProvisionedModelThroughputOutput {
	s.FailureMessage = &v
	return s
}

// SetFoundationModelArn sets the FoundationModelArn field's value.
func (s *GetProvisionedModelThroughputOutput) SetFoundationModelArn(v string) *GetProvisionedModelThroughputOutput {
	s.FoundationModelArn = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetProvisionedModelThroughputOutput) SetLastModifiedTime(v time.Time) *GetProvisionedModelThroughputOutput {
	s.LastModifiedTime = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *GetProvisionedModelThroughputOutput) SetModelArn(v string) *GetProvisionedModelThroughputOutput {
	s.ModelArn = &v
	return s
}

// SetModelUnits sets the ModelUnits field's value.
func (s *GetProvisionedModelThroughputOutput) SetModelUnits(v int64) *GetProvisionedModelThroughputOutput {
	s.ModelUnits = &v
	return s
}

// SetProvisionedModelArn sets the ProvisionedModelArn field's value.
func (s *GetProvisionedModelThroughputOutput) SetProvisionedModelArn(v string) *GetProvisionedModelThroughputOutput {
	s.ProvisionedModelArn = &v
	return s
}

// SetProvisionedModelName sets the ProvisionedModelName field's value.
func (s *GetProvisionedModelThroughputOutput) SetProvisionedModelName(v string) *GetProvisionedModelThroughputOutput {
	s.ProvisionedModelName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetProvisionedModelThroughputOutput) SetStatus(v string) *GetProvisionedModelThroughputOutput {
	s.Status = &v
	return s
}

// An internal server error occurred. Retry your request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCustomModelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Return custom models only if the base model ARN matches this parameter.
	BaseModelArnEquals *string `location:"querystring" locationName:"baseModelArnEquals" min:"20" type:"string"`

	// Return custom models created after the specified time.
	CreationTimeAfter *time.Time `location:"querystring" locationName:"creationTimeAfter" type:"timestamp" timestampFormat:"iso8601"`

	// Return custom models created before the specified time.
	CreationTimeBefore *time.Time `location:"querystring" locationName:"creationTimeBefore" type:"timestamp" timestampFormat:"iso8601"`

	// Return custom models only if the foundation model ARN matches this parameter.
	FoundationModelArnEquals *string `location:"querystring" locationName:"foundationModelArnEquals" type:"string"`

	// Maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Return custom models only if the job name contains these characters.
	NameContains *string `location:"querystring" locationName:"nameContains" min:"1" type:"string"`

	// Continuation token from the previous response, for Bedrock to list the next
	// set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The field to sort by in the returned list of models.
	SortBy *string `location:"querystring" locationName:"sortBy" type:"string" enum:"SortModelsBy"`

	// The sort order of the results.
	SortOrder *string `location:"querystring" locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomModelsInput"}
	if s.BaseModelArnEquals != nil && len(*s.BaseModelArnEquals) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BaseModelArnEquals", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseModelArnEquals sets the BaseModelArnEquals field's value.
func (s *ListCustomModelsInput) SetBaseModelArnEquals(v string) *ListCustomModelsInput {
	s.BaseModelArnEquals = &v
	return s
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListCustomModelsInput) SetCreationTimeAfter(v time.Time) *ListCustomModelsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListCustomModelsInput) SetCreationTimeBefore(v time.Time) *ListCustomModelsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetFoundationModelArnEquals sets the FoundationModelArnEquals field's value.
func (s *ListCustomModelsInput) SetFoundationModelArnEquals(v string) *ListCustomModelsInput {
	s.FoundationModelArnEquals = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomModelsInput) SetMaxResults(v int64) *ListCustomModelsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListCustomModelsInput) SetNameContains(v string) *ListCustomModelsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomModelsInput) SetNextToken(v string) *ListCustomModelsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListCustomModelsInput) SetSortBy(v string) *ListCustomModelsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListCustomModelsInput) SetSortOrder(v string) *ListCustomModelsInput {
	s.SortOrder = &v
	return s
}

type ListCustomModelsOutput struct {
	_ struct{} `type:"structure"`

	// Model summaries.
	ModelSummaries []*CustomModelSummary `locationName:"modelSummaries" type:"list"`

	// Continuation token for the next request to list the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomModelsOutput) GoString() string {
	return s.String()
}

// SetModelSummaries sets the ModelSummaries field's value.
func (s *ListCustomModelsOutput) SetModelSummaries(v []*CustomModelSummary) *ListCustomModelsOutput {
	s.ModelSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomModelsOutput) SetNextToken(v string) *ListCustomModelsOutput {
	s.NextToken = &v
	return s
}

type ListFoundationModelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// List by customization type.
	ByCustomizationType *string `location:"querystring" locationName:"byCustomizationType" type:"string" enum:"ModelCustomization"`

	// List by inference type.
	ByInferenceType *string `location:"querystring" locationName:"byInferenceType" type:"string" enum:"InferenceType"`

	// List by output modality type.
	ByOutputModality *string `location:"querystring" locationName:"byOutputModality" type:"string" enum:"ModelModality"`

	// A Bedrock model provider.
	ByProvider *string `location:"querystring" locationName:"byProvider" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFoundationModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFoundationModelsInput) GoString() string {
	return s.String()
}

// SetByCustomizationType sets the ByCustomizationType field's value.
func (s *ListFoundationModelsInput) SetByCustomizationType(v string) *ListFoundationModelsInput {
	s.ByCustomizationType = &v
	return s
}

// SetByInferenceType sets the ByInferenceType field's value.
func (s *ListFoundationModelsInput) SetByInferenceType(v string) *ListFoundationModelsInput {
	s.ByInferenceType = &v
	return s
}

// SetByOutputModality sets the ByOutputModality field's value.
func (s *ListFoundationModelsInput) SetByOutputModality(v string) *ListFoundationModelsInput {
	s.ByOutputModality = &v
	return s
}

// SetByProvider sets the ByProvider field's value.
func (s *ListFoundationModelsInput) SetByProvider(v string) *ListFoundationModelsInput {
	s.ByProvider = &v
	return s
}

type ListFoundationModelsOutput struct {
	_ struct{} `type:"structure"`

	// A list of bedrock foundation models.
	ModelSummaries []*FoundationModelSummary `locationName:"modelSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFoundationModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFoundationModelsOutput) GoString() string {
	return s.String()
}

// SetModelSummaries sets the ModelSummaries field's value.
func (s *ListFoundationModelsOutput) SetModelSummaries(v []*FoundationModelSummary) *ListFoundationModelsOutput {
	s.ModelSummaries = v
	return s
}

type ListModelCustomizationJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Return customization jobs created after the specified time.
	CreationTimeAfter *time.Time `location:"querystring" locationName:"creationTimeAfter" type:"timestamp" timestampFormat:"iso8601"`

	// Return customization jobs created before the specified time.
	CreationTimeBefore *time.Time `location:"querystring" locationName:"creationTimeBefore" type:"timestamp" timestampFormat:"iso8601"`

	// Maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Return customization jobs only if the job name contains these characters.
	NameContains *string `location:"querystring" locationName:"nameContains" min:"1" type:"string"`

	// Continuation token from the previous response, for Bedrock to list the next
	// set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The field to sort by in the returned list of jobs.
	SortBy *string `location:"querystring" locationName:"sortBy" type:"string" enum:"SortJobsBy"`

	// The sort order of the results.
	SortOrder *string `location:"querystring" locationName:"sortOrder" type:"string" enum:"SortOrder"`

	// Return customization jobs with the specified status.
	StatusEquals *string `location:"querystring" locationName:"statusEquals" type:"string" enum:"FineTuningJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelCustomizationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelCustomizationJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListModelCustomizationJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListModelCustomizationJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListModelCustomizationJobsInput) SetCreationTimeAfter(v time.Time) *ListModelCustomizationJobsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListModelCustomizationJobsInput) SetCreationTimeBefore(v time.Time) *ListModelCustomizationJobsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListModelCustomizationJobsInput) SetMaxResults(v int64) *ListModelCustomizationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListModelCustomizationJobsInput) SetNameContains(v string) *ListModelCustomizationJobsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelCustomizationJobsInput) SetNextToken(v string) *ListModelCustomizationJobsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListModelCustomizationJobsInput) SetSortBy(v string) *ListModelCustomizationJobsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListModelCustomizationJobsInput) SetSortOrder(v string) *ListModelCustomizationJobsInput {
	s.SortOrder = &v
	return s
}

// SetStatusEquals sets the StatusEquals field's value.
func (s *ListModelCustomizationJobsInput) SetStatusEquals(v string) *ListModelCustomizationJobsInput {
	s.StatusEquals = &v
	return s
}

type ListModelCustomizationJobsOutput struct {
	_ struct{} `type:"structure"`

	// Job summaries.
	ModelCustomizationJobSummaries []*ModelCustomizationJobSummary `locationName:"modelCustomizationJobSummaries" type:"list"`

	// Page continuation token to use in the next request.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelCustomizationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelCustomizationJobsOutput) GoString() string {
	return s.String()
}

// SetModelCustomizationJobSummaries sets the ModelCustomizationJobSummaries field's value.
func (s *ListModelCustomizationJobsOutput) SetModelCustomizationJobSummaries(v []*ModelCustomizationJobSummary) *ListModelCustomizationJobsOutput {
	s.ModelCustomizationJobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelCustomizationJobsOutput) SetNextToken(v string) *ListModelCustomizationJobsOutput {
	s.NextToken = &v
	return s
}

type ListProvisionedModelThroughputsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Return provisioned capacities created after the specified time.
	CreationTimeAfter *time.Time `location:"querystring" locationName:"creationTimeAfter" type:"timestamp" timestampFormat:"iso8601"`

	// Return provisioned capacities created before the specified time.
	CreationTimeBefore *time.Time `location:"querystring" locationName:"creationTimeBefore" type:"timestamp" timestampFormat:"iso8601"`

	// THe maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Return the list of provisioned capacities where their model ARN is equal
	// to this parameter.
	ModelArnEquals *string `location:"querystring" locationName:"modelArnEquals" min:"20" type:"string"`

	// Return the list of provisioned capacities if their name contains these characters.
	NameContains *string `location:"querystring" locationName:"nameContains" min:"1" type:"string"`

	// Continuation token from the previous response, for Bedrock to list the next
	// set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The field to sort by in the returned list of provisioned capacities.
	SortBy *string `location:"querystring" locationName:"sortBy" type:"string" enum:"SortByProvisionedModels"`

	// The sort order of the results.
	SortOrder *string `location:"querystring" locationName:"sortOrder" type:"string" enum:"SortOrder"`

	// Return the list of provisioned capacities that match the specified status.
	StatusEquals *string `location:"querystring" locationName:"statusEquals" type:"string" enum:"ProvisionedModelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProvisionedModelThroughputsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProvisionedModelThroughputsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProvisionedModelThroughputsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProvisionedModelThroughputsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ModelArnEquals != nil && len(*s.ModelArnEquals) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ModelArnEquals", 20))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListProvisionedModelThroughputsInput) SetCreationTimeAfter(v time.Time) *ListProvisionedModelThroughputsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListProvisionedModelThroughputsInput) SetCreationTimeBefore(v time.Time) *ListProvisionedModelThroughputsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProvisionedModelThroughputsInput) SetMaxResults(v int64) *ListProvisionedModelThroughputsInput {
	s.MaxResults = &v
	return s
}

// SetModelArnEquals sets the ModelArnEquals field's value.
func (s *ListProvisionedModelThroughputsInput) SetModelArnEquals(v string) *ListProvisionedModelThroughputsInput {
	s.ModelArnEquals = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListProvisionedModelThroughputsInput) SetNameContains(v string) *ListProvisionedModelThroughputsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProvisionedModelThroughputsInput) SetNextToken(v string) *ListProvisionedModelThroughputsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListProvisionedModelThroughputsInput) SetSortBy(v string) *ListProvisionedModelThroughputsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListProvisionedModelThroughputsInput) SetSortOrder(v string) *ListProvisionedModelThroughputsInput {
	s.SortOrder = &v
	return s
}

// SetStatusEquals sets the StatusEquals field's value.
func (s *ListProvisionedModelThroughputsInput) SetStatusEquals(v string) *ListProvisionedModelThroughputsInput {
	s.StatusEquals = &v
	return s
}

type ListProvisionedModelThroughputsOutput struct {
	_ struct{} `type:"structure"`

	// Continuation token for the next request to list the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// List of summaries, one for each provisioned throughput in the response.
	ProvisionedModelSummaries []*ProvisionedModelSummary `locationName:"provisionedModelSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProvisionedModelThroughputsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProvisionedModelThroughputsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProvisionedModelThroughputsOutput) SetNextToken(v string) *ListProvisionedModelThroughputsOutput {
	s.NextToken = &v
	return s
}

// SetProvisionedModelSummaries sets the ProvisionedModelSummaries field's value.
func (s *ListProvisionedModelThroughputsOutput) SetProvisionedModelSummaries(v []*ProvisionedModelSummary) *ListProvisionedModelThroughputsOutput {
	s.ProvisionedModelSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An array of the tags associated with this resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Configuration fields for invokation logging.
type LoggingConfig struct {
	_ struct{} `type:"structure"`

	// CloudWatch logging configuration.
	CloudWatchConfig *CloudWatchConfig `locationName:"cloudWatchConfig" type:"structure"`

	// Set to include embeddings data in the log delivery.
	EmbeddingDataDeliveryEnabled *bool `locationName:"embeddingDataDeliveryEnabled" type:"boolean"`

	// Set to include image data in the log delivery.
	ImageDataDeliveryEnabled *bool `locationName:"imageDataDeliveryEnabled" type:"boolean"`

	// S3 configuration for storing log data.
	S3Config *S3Config `locationName:"s3Config" type:"structure"`

	// Set to include text data in the log delivery.
	TextDataDeliveryEnabled *bool `locationName:"textDataDeliveryEnabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoggingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingConfig"}
	if s.CloudWatchConfig != nil {
		if err := s.CloudWatchConfig.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Config != nil {
		if err := s.S3Config.Validate(); err != nil {
			invalidParams.AddNested("S3Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchConfig sets the CloudWatchConfig field's value.
func (s *LoggingConfig) SetCloudWatchConfig(v *CloudWatchConfig) *LoggingConfig {
	s.CloudWatchConfig = v
	return s
}

// SetEmbeddingDataDeliveryEnabled sets the EmbeddingDataDeliveryEnabled field's value.
func (s *LoggingConfig) SetEmbeddingDataDeliveryEnabled(v bool) *LoggingConfig {
	s.EmbeddingDataDeliveryEnabled = &v
	return s
}

// SetImageDataDeliveryEnabled sets the ImageDataDeliveryEnabled field's value.
func (s *LoggingConfig) SetImageDataDeliveryEnabled(v bool) *LoggingConfig {
	s.ImageDataDeliveryEnabled = &v
	return s
}

// SetS3Config sets the S3Config field's value.
func (s *LoggingConfig) SetS3Config(v *S3Config) *LoggingConfig {
	s.S3Config = v
	return s
}

// SetTextDataDeliveryEnabled sets the TextDataDeliveryEnabled field's value.
func (s *LoggingConfig) SetTextDataDeliveryEnabled(v bool) *LoggingConfig {
	s.TextDataDeliveryEnabled = &v
	return s
}

// Information about one customization job
type ModelCustomizationJobSummary struct {
	_ struct{} `type:"structure"`

	// ARN of the base model.
	//
	// BaseModelArn is a required field
	BaseModelArn *string `locationName:"baseModelArn" min:"20" type:"string" required:"true"`

	// Creation time of the custom model.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// ARN of the custom model.
	CustomModelArn *string `locationName:"customModelArn" min:"20" type:"string"`

	// Name of the custom model.
	CustomModelName *string `locationName:"customModelName" min:"1" type:"string"`

	// Time that the customization job ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601"`

	// ARN of the customization job.
	//
	// JobArn is a required field
	JobArn *string `locationName:"jobArn" type:"string" required:"true"`

	// Name of the customization job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// Time that the customization job was last modified.
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp" timestampFormat:"iso8601"`

	// Status of the customization job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ModelCustomizationJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelCustomizationJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelCustomizationJobSummary) GoString() string {
	return s.String()
}

// SetBaseModelArn sets the BaseModelArn field's value.
func (s *ModelCustomizationJobSummary) SetBaseModelArn(v string) *ModelCustomizationJobSummary {
	s.BaseModelArn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ModelCustomizationJobSummary) SetCreationTime(v time.Time) *ModelCustomizationJobSummary {
	s.CreationTime = &v
	return s
}

// SetCustomModelArn sets the CustomModelArn field's value.
func (s *ModelCustomizationJobSummary) SetCustomModelArn(v string) *ModelCustomizationJobSummary {
	s.CustomModelArn = &v
	return s
}

// SetCustomModelName sets the CustomModelName field's value.
func (s *ModelCustomizationJobSummary) SetCustomModelName(v string) *ModelCustomizationJobSummary {
	s.CustomModelName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ModelCustomizationJobSummary) SetEndTime(v time.Time) *ModelCustomizationJobSummary {
	s.EndTime = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *ModelCustomizationJobSummary) SetJobArn(v string) *ModelCustomizationJobSummary {
	s.JobArn = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *ModelCustomizationJobSummary) SetJobName(v string) *ModelCustomizationJobSummary {
	s.JobName = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *ModelCustomizationJobSummary) SetLastModifiedTime(v time.Time) *ModelCustomizationJobSummary {
	s.LastModifiedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ModelCustomizationJobSummary) SetStatus(v string) *ModelCustomizationJobSummary {
	s.Status = &v
	return s
}

// S3 Location of the output data.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The S3 URI where the output data is stored.
	//
	// S3Uri is a required field
	S3Uri *string `locationName:"s3Uri" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}
	if s.S3Uri != nil && len(*s.S3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *OutputDataConfig) SetS3Uri(v string) *OutputDataConfig {
	s.S3Uri = &v
	return s
}

// Set of fields associated with a provisioned throughput.
type ProvisionedModelSummary struct {
	_ struct{} `type:"structure"`

	// Commitment duration for the provisioned throughput.
	CommitmentDuration *string `locationName:"commitmentDuration" type:"string" enum:"CommitmentDuration"`

	// Commitment expiration time for the provisioned throughput.
	CommitmentExpirationTime *time.Time `locationName:"commitmentExpirationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The time that this provisioned throughput was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Desired model ARN.
	//
	// DesiredModelArn is a required field
	DesiredModelArn *string `locationName:"desiredModelArn" min:"20" type:"string" required:"true"`

	// Desired model units.
	//
	// DesiredModelUnits is a required field
	DesiredModelUnits *int64 `locationName:"desiredModelUnits" min:"1" type:"integer" required:"true"`

	// Foundation model ARN.
	//
	// FoundationModelArn is a required field
	FoundationModelArn *string `locationName:"foundationModelArn" type:"string" required:"true"`

	// The time that this provisioned throughput was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `locationName:"lastModifiedTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ARN of the model associated with this provisioned throughput.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" min:"20" type:"string" required:"true"`

	// The number of model units allocated.
	//
	// ModelUnits is a required field
	ModelUnits *int64 `locationName:"modelUnits" min:"1" type:"integer" required:"true"`

	// The ARN of the provisioned throughput.
	//
	// ProvisionedModelArn is a required field
	ProvisionedModelArn *string `locationName:"provisionedModelArn" type:"string" required:"true"`

	// The name of the provisioned throughput.
	//
	// ProvisionedModelName is a required field
	ProvisionedModelName *string `locationName:"provisionedModelName" min:"1" type:"string" required:"true"`

	// Status of the provisioned throughput.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ProvisionedModelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedModelSummary) GoString() string {
	return s.String()
}

// SetCommitmentDuration sets the CommitmentDuration field's value.
func (s *ProvisionedModelSummary) SetCommitmentDuration(v string) *ProvisionedModelSummary {
	s.CommitmentDuration = &v
	return s
}

// SetCommitmentExpirationTime sets the CommitmentExpirationTime field's value.
func (s *ProvisionedModelSummary) SetCommitmentExpirationTime(v time.Time) *ProvisionedModelSummary {
	s.CommitmentExpirationTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ProvisionedModelSummary) SetCreationTime(v time.Time) *ProvisionedModelSummary {
	s.CreationTime = &v
	return s
}

// SetDesiredModelArn sets the DesiredModelArn field's value.
func (s *ProvisionedModelSummary) SetDesiredModelArn(v string) *ProvisionedModelSummary {
	s.DesiredModelArn = &v
	return s
}

// SetDesiredModelUnits sets the DesiredModelUnits field's value.
func (s *ProvisionedModelSummary) SetDesiredModelUnits(v int64) *ProvisionedModelSummary {
	s.DesiredModelUnits = &v
	return s
}

// SetFoundationModelArn sets the FoundationModelArn field's value.
func (s *ProvisionedModelSummary) SetFoundationModelArn(v string) *ProvisionedModelSummary {
	s.FoundationModelArn = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *ProvisionedModelSummary) SetLastModifiedTime(v time.Time) *ProvisionedModelSummary {
	s.LastModifiedTime = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *ProvisionedModelSummary) SetModelArn(v string) *ProvisionedModelSummary {
	s.ModelArn = &v
	return s
}

// SetModelUnits sets the ModelUnits field's value.
func (s *ProvisionedModelSummary) SetModelUnits(v int64) *ProvisionedModelSummary {
	s.ModelUnits = &v
	return s
}

// SetProvisionedModelArn sets the ProvisionedModelArn field's value.
func (s *ProvisionedModelSummary) SetProvisionedModelArn(v string) *ProvisionedModelSummary {
	s.ProvisionedModelArn = &v
	return s
}

// SetProvisionedModelName sets the ProvisionedModelName field's value.
func (s *ProvisionedModelSummary) SetProvisionedModelName(v string) *ProvisionedModelSummary {
	s.ProvisionedModelName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProvisionedModelSummary) SetStatus(v string) *ProvisionedModelSummary {
	s.Status = &v
	return s
}

type PutModelInvocationLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The logging configuration values to set.
	//
	// LoggingConfig is a required field
	LoggingConfig *LoggingConfig `locationName:"loggingConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutModelInvocationLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutModelInvocationLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutModelInvocationLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutModelInvocationLoggingConfigurationInput"}
	if s.LoggingConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggingConfig"))
	}
	if s.LoggingConfig != nil {
		if err := s.LoggingConfig.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingConfig sets the LoggingConfig field's value.
func (s *PutModelInvocationLoggingConfigurationInput) SetLoggingConfig(v *LoggingConfig) *PutModelInvocationLoggingConfigurationInput {
	s.LoggingConfig = v
	return s
}

type PutModelInvocationLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutModelInvocationLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutModelInvocationLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// The specified resource ARN was not found. Check the ARN and try your request
// again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// S3 configuration for storing log data.
type S3Config struct {
	_ struct{} `type:"structure"`

	// S3 bucket name.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`

	// S3 prefix.
	KeyPrefix *string `locationName:"keyPrefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Config) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Config) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Config) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Config"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Config) SetBucketName(v string) *S3Config {
	s.BucketName = &v
	return s
}

// SetKeyPrefix sets the KeyPrefix field's value.
func (s *S3Config) SetKeyPrefix(v string) *S3Config {
	s.KeyPrefix = &v
	return s
}

// The number of requests exceeds the service quota. Resubmit your request later.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StopModelCustomizationJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Job identifier of the job to stop.
	//
	// JobIdentifier is a required field
	JobIdentifier *string `location:"uri" locationName:"jobIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopModelCustomizationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopModelCustomizationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopModelCustomizationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopModelCustomizationJobInput"}
	if s.JobIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("JobIdentifier"))
	}
	if s.JobIdentifier != nil && len(*s.JobIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobIdentifier sets the JobIdentifier field's value.
func (s *StopModelCustomizationJobInput) SetJobIdentifier(v string) *StopModelCustomizationJobInput {
	s.JobIdentifier = &v
	return s
}

type StopModelCustomizationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopModelCustomizationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopModelCustomizationJobOutput) GoString() string {
	return s.String()
}

// Definition of the key/value pair for a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// Key for the tag.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// Value for the tag.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to tag.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"20" type:"string" required:"true"`

	// Tags to associate with the resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The number of requests exceeds the limit. Resubmit your request later.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request contains more tags than can be associated with a resource (50
// tags per resource). The maximum number of tags includes both existing tags
// and those included in your current request.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The name of the resource with too many tags.
	ResourceName *string `locationName:"resourceName" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// S3 Location of the training data.
type TrainingDataConfig struct {
	_ struct{} `type:"structure"`

	// The S3 URI where the training data is stored.
	//
	// S3Uri is a required field
	S3Uri *string `locationName:"s3Uri" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrainingDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrainingDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}
	if s.S3Uri != nil && len(*s.S3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *TrainingDataConfig) SetS3Uri(v string) *TrainingDataConfig {
	s.S3Uri = &v
	return s
}

// Metrics associated with the custom job.
type TrainingMetrics struct {
	_ struct{} `type:"structure"`

	// Loss metric associated with the custom job.
	TrainingLoss *float64 `locationName:"trainingLoss" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingMetrics) GoString() string {
	return s.String()
}

// SetTrainingLoss sets the TrainingLoss field's value.
func (s *TrainingMetrics) SetTrainingLoss(v float64) *TrainingMetrics {
	s.TrainingLoss = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to untag.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"20" type:"string" required:"true"`

	// Tag keys of the tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateProvisionedModelThroughputInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new model to associate with this provisioned throughput.
	DesiredModelId *string `locationName:"desiredModelId" min:"1" type:"string"`

	// The new name for this provisioned throughput.
	DesiredProvisionedModelName *string `locationName:"desiredProvisionedModelName" min:"1" type:"string"`

	// The ARN or name of the provisioned throughput to update.
	//
	// ProvisionedModelId is a required field
	ProvisionedModelId *string `location:"uri" locationName:"provisionedModelId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProvisionedModelThroughputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProvisionedModelThroughputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProvisionedModelThroughputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProvisionedModelThroughputInput"}
	if s.DesiredModelId != nil && len(*s.DesiredModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DesiredModelId", 1))
	}
	if s.DesiredProvisionedModelName != nil && len(*s.DesiredProvisionedModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DesiredProvisionedModelName", 1))
	}
	if s.ProvisionedModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedModelId"))
	}
	if s.ProvisionedModelId != nil && len(*s.ProvisionedModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredModelId sets the DesiredModelId field's value.
func (s *UpdateProvisionedModelThroughputInput) SetDesiredModelId(v string) *UpdateProvisionedModelThroughputInput {
	s.DesiredModelId = &v
	return s
}

// SetDesiredProvisionedModelName sets the DesiredProvisionedModelName field's value.
func (s *UpdateProvisionedModelThroughputInput) SetDesiredProvisionedModelName(v string) *UpdateProvisionedModelThroughputInput {
	s.DesiredProvisionedModelName = &v
	return s
}

// SetProvisionedModelId sets the ProvisionedModelId field's value.
func (s *UpdateProvisionedModelThroughputInput) SetProvisionedModelId(v string) *UpdateProvisionedModelThroughputInput {
	s.ProvisionedModelId = &v
	return s
}

type UpdateProvisionedModelThroughputOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProvisionedModelThroughputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProvisionedModelThroughputOutput) GoString() string {
	return s.String()
}

// Array of up to 10 validators.
type ValidationDataConfig struct {
	_ struct{} `type:"structure"`

	// Information about the validators.
	//
	// Validators is a required field
	Validators []*Validator `locationName:"validators" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidationDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidationDataConfig"}
	if s.Validators == nil {
		invalidParams.Add(request.NewErrParamRequired("Validators"))
	}
	if s.Validators != nil {
		for i, v := range s.Validators {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Validators", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValidators sets the Validators field's value.
func (s *ValidationDataConfig) SetValidators(v []*Validator) *ValidationDataConfig {
	s.Validators = v
	return s
}

// Input validation failed. Check your request parameters and retry the request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a validator.
type Validator struct {
	_ struct{} `type:"structure"`

	// The S3 URI where the validation data is stored.
	//
	// S3Uri is a required field
	S3Uri *string `locationName:"s3Uri" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Validator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Validator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Validator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Validator"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}
	if s.S3Uri != nil && len(*s.S3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *Validator) SetS3Uri(v string) *Validator {
	s.S3Uri = &v
	return s
}

// The metric for the validator.
type ValidatorMetric struct {
	_ struct{} `type:"structure"`

	// The validation loss associated with this validator.
	ValidationLoss *float64 `locationName:"validationLoss" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatorMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidatorMetric) GoString() string {
	return s.String()
}

// SetValidationLoss sets the ValidationLoss field's value.
func (s *ValidatorMetric) SetValidationLoss(v float64) *ValidatorMetric {
	s.ValidationLoss = &v
	return s
}

// VPC configuration.
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// VPC configuration security group Ids.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list" required:"true"`

	// VPC configuration subnets.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfig"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfig) SetSecurityGroupIds(v []*string) *VpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfig) SetSubnetIds(v []*string) *VpcConfig {
	s.SubnetIds = v
	return s
}

const (
	// CommitmentDurationOneMonth is a CommitmentDuration enum value
	CommitmentDurationOneMonth = "OneMonth"

	// CommitmentDurationSixMonths is a CommitmentDuration enum value
	CommitmentDurationSixMonths = "SixMonths"
)

// CommitmentDuration_Values returns all elements of the CommitmentDuration enum
func CommitmentDuration_Values() []string {
	return []string{
		CommitmentDurationOneMonth,
		CommitmentDurationSixMonths,
	}
}

const (
	// FineTuningJobStatusInProgress is a FineTuningJobStatus enum value
	FineTuningJobStatusInProgress = "InProgress"

	// FineTuningJobStatusCompleted is a FineTuningJobStatus enum value
	FineTuningJobStatusCompleted = "Completed"

	// FineTuningJobStatusFailed is a FineTuningJobStatus enum value
	FineTuningJobStatusFailed = "Failed"

	// FineTuningJobStatusStopping is a FineTuningJobStatus enum value
	FineTuningJobStatusStopping = "Stopping"

	// FineTuningJobStatusStopped is a FineTuningJobStatus enum value
	FineTuningJobStatusStopped = "Stopped"
)

// FineTuningJobStatus_Values returns all elements of the FineTuningJobStatus enum
func FineTuningJobStatus_Values() []string {
	return []string{
		FineTuningJobStatusInProgress,
		FineTuningJobStatusCompleted,
		FineTuningJobStatusFailed,
		FineTuningJobStatusStopping,
		FineTuningJobStatusStopped,
	}
}

const (
	// InferenceTypeOnDemand is a InferenceType enum value
	InferenceTypeOnDemand = "ON_DEMAND"

	// InferenceTypeProvisioned is a InferenceType enum value
	InferenceTypeProvisioned = "PROVISIONED"
)

// InferenceType_Values returns all elements of the InferenceType enum
func InferenceType_Values() []string {
	return []string{
		InferenceTypeOnDemand,
		InferenceTypeProvisioned,
	}
}

const (
	// ModelCustomizationFineTuning is a ModelCustomization enum value
	ModelCustomizationFineTuning = "FINE_TUNING"
)

// ModelCustomization_Values returns all elements of the ModelCustomization enum
func ModelCustomization_Values() []string {
	return []string{
		ModelCustomizationFineTuning,
	}
}

const (
	// ModelCustomizationJobStatusInProgress is a ModelCustomizationJobStatus enum value
	ModelCustomizationJobStatusInProgress = "InProgress"

	// ModelCustomizationJobStatusCompleted is a ModelCustomizationJobStatus enum value
	ModelCustomizationJobStatusCompleted = "Completed"

	// ModelCustomizationJobStatusFailed is a ModelCustomizationJobStatus enum value
	ModelCustomizationJobStatusFailed = "Failed"

	// ModelCustomizationJobStatusStopping is a ModelCustomizationJobStatus enum value
	ModelCustomizationJobStatusStopping = "Stopping"

	// ModelCustomizationJobStatusStopped is a ModelCustomizationJobStatus enum value
	ModelCustomizationJobStatusStopped = "Stopped"
)

// ModelCustomizationJobStatus_Values returns all elements of the ModelCustomizationJobStatus enum
func ModelCustomizationJobStatus_Values() []string {
	return []string{
		ModelCustomizationJobStatusInProgress,
		ModelCustomizationJobStatusCompleted,
		ModelCustomizationJobStatusFailed,
		ModelCustomizationJobStatusStopping,
		ModelCustomizationJobStatusStopped,
	}
}

const (
	// ModelModalityText is a ModelModality enum value
	ModelModalityText = "TEXT"

	// ModelModalityImage is a ModelModality enum value
	ModelModalityImage = "IMAGE"

	// ModelModalityEmbedding is a ModelModality enum value
	ModelModalityEmbedding = "EMBEDDING"
)

// ModelModality_Values returns all elements of the ModelModality enum
func ModelModality_Values() []string {
	return []string{
		ModelModalityText,
		ModelModalityImage,
		ModelModalityEmbedding,
	}
}

const (
	// ProvisionedModelStatusCreating is a ProvisionedModelStatus enum value
	ProvisionedModelStatusCreating = "Creating"

	// ProvisionedModelStatusInService is a ProvisionedModelStatus enum value
	ProvisionedModelStatusInService = "InService"

	// ProvisionedModelStatusUpdating is a ProvisionedModelStatus enum value
	ProvisionedModelStatusUpdating = "Updating"

	// ProvisionedModelStatusFailed is a ProvisionedModelStatus enum value
	ProvisionedModelStatusFailed = "Failed"
)

// ProvisionedModelStatus_Values returns all elements of the ProvisionedModelStatus enum
func ProvisionedModelStatus_Values() []string {
	return []string{
		ProvisionedModelStatusCreating,
		ProvisionedModelStatusInService,
		ProvisionedModelStatusUpdating,
		ProvisionedModelStatusFailed,
	}
}

const (
	// SortByProvisionedModelsCreationTime is a SortByProvisionedModels enum value
	SortByProvisionedModelsCreationTime = "CreationTime"
)

// SortByProvisionedModels_Values returns all elements of the SortByProvisionedModels enum
func SortByProvisionedModels_Values() []string {
	return []string{
		SortByProvisionedModelsCreationTime,
	}
}

const (
	// SortJobsByCreationTime is a SortJobsBy enum value
	SortJobsByCreationTime = "CreationTime"
)

// SortJobsBy_Values returns all elements of the SortJobsBy enum
func SortJobsBy_Values() []string {
	return []string{
		SortJobsByCreationTime,
	}
}

const (
	// SortModelsByCreationTime is a SortModelsBy enum value
	SortModelsByCreationTime = "CreationTime"
)

// SortModelsBy_Values returns all elements of the SortModelsBy enum
func SortModelsBy_Values() []string {
	return []string{
		SortModelsByCreationTime,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "Ascending"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "Descending"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}
