// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/securitycenter/v2/data_access_event.proto

package securitycenterpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The operation of a data access event.
type DataAccessEvent_Operation int32

const (
	// The operation is unspecified.
	DataAccessEvent_OPERATION_UNSPECIFIED DataAccessEvent_Operation = 0
	// Represents a read operation.
	DataAccessEvent_READ DataAccessEvent_Operation = 1
	// Represents a move operation.
	DataAccessEvent_MOVE DataAccessEvent_Operation = 2
	// Represents a copy operation.
	DataAccessEvent_COPY DataAccessEvent_Operation = 3
)

// Enum value maps for DataAccessEvent_Operation.
var (
	DataAccessEvent_Operation_name = map[int32]string{
		0: "OPERATION_UNSPECIFIED",
		1: "READ",
		2: "MOVE",
		3: "COPY",
	}
	DataAccessEvent_Operation_value = map[string]int32{
		"OPERATION_UNSPECIFIED": 0,
		"READ":                  1,
		"MOVE":                  2,
		"COPY":                  3,
	}
)

func (x DataAccessEvent_Operation) Enum() *DataAccessEvent_Operation {
	p := new(DataAccessEvent_Operation)
	*p = x
	return p
}

func (x DataAccessEvent_Operation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataAccessEvent_Operation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_data_access_event_proto_enumTypes[0].Descriptor()
}

func (DataAccessEvent_Operation) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_data_access_event_proto_enumTypes[0]
}

func (x DataAccessEvent_Operation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataAccessEvent_Operation.Descriptor instead.
func (DataAccessEvent_Operation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_data_access_event_proto_rawDescGZIP(), []int{0, 0}
}

// Details about a data access attempt made by a principal not authorized under
// applicable data security policy.
type DataAccessEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique identifier for data access event.
	EventId string `protobuf:"bytes,1,opt,name=event_id,json=eventId,proto3" json:"event_id,omitempty"`
	// The email address of the principal that accessed the data. The principal
	// could be a user account, service account, Google group, or other.
	PrincipalEmail string `protobuf:"bytes,2,opt,name=principal_email,json=principalEmail,proto3" json:"principal_email,omitempty"`
	// The operation performed by the principal to access the data.
	Operation DataAccessEvent_Operation `protobuf:"varint,3,opt,name=operation,proto3,enum=google.cloud.securitycenter.v2.DataAccessEvent_Operation" json:"operation,omitempty"`
	// Timestamp of data access event.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
}

func (x *DataAccessEvent) Reset() {
	*x = DataAccessEvent{}
	mi := &file_google_cloud_securitycenter_v2_data_access_event_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataAccessEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataAccessEvent) ProtoMessage() {}

func (x *DataAccessEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_data_access_event_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataAccessEvent.ProtoReflect.Descriptor instead.
func (*DataAccessEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_data_access_event_proto_rawDescGZIP(), []int{0}
}

func (x *DataAccessEvent) GetEventId() string {
	if x != nil {
		return x.EventId
	}
	return ""
}

func (x *DataAccessEvent) GetPrincipalEmail() string {
	if x != nil {
		return x.PrincipalEmail
	}
	return ""
}

func (x *DataAccessEvent) GetOperation() DataAccessEvent_Operation {
	if x != nil {
		return x.Operation
	}
	return DataAccessEvent_OPERATION_UNSPECIFIED
}

func (x *DataAccessEvent) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

var File_google_cloud_securitycenter_v2_data_access_event_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_data_access_event_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaf, 0x02, 0x0a, 0x0f, 0x44, 0x61,
	0x74, 0x61, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a,
	0x08, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72, 0x69, 0x6e,
	0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x45, 0x6d, 0x61, 0x69,
	0x6c, 0x12, 0x57, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x44, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x52, 0x45, 0x41, 0x44, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4d, 0x4f, 0x56, 0x45, 0x10,
	0x02, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x4f, 0x50, 0x59, 0x10, 0x03, 0x42, 0xee, 0x01, 0x0a, 0x22,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x42, 0x14, 0x44, 0x61, 0x74, 0x61, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_data_access_event_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_data_access_event_proto_rawDescData = file_google_cloud_securitycenter_v2_data_access_event_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_data_access_event_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_data_access_event_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_data_access_event_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_data_access_event_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_data_access_event_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_data_access_event_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_securitycenter_v2_data_access_event_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_securitycenter_v2_data_access_event_proto_goTypes = []any{
	(DataAccessEvent_Operation)(0), // 0: google.cloud.securitycenter.v2.DataAccessEvent.Operation
	(*DataAccessEvent)(nil),        // 1: google.cloud.securitycenter.v2.DataAccessEvent
	(*timestamppb.Timestamp)(nil),  // 2: google.protobuf.Timestamp
}
var file_google_cloud_securitycenter_v2_data_access_event_proto_depIdxs = []int32{
	0, // 0: google.cloud.securitycenter.v2.DataAccessEvent.operation:type_name -> google.cloud.securitycenter.v2.DataAccessEvent.Operation
	2, // 1: google.cloud.securitycenter.v2.DataAccessEvent.event_time:type_name -> google.protobuf.Timestamp
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_data_access_event_proto_init() }
func file_google_cloud_securitycenter_v2_data_access_event_proto_init() {
	if File_google_cloud_securitycenter_v2_data_access_event_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_data_access_event_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_data_access_event_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_data_access_event_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v2_data_access_event_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v2_data_access_event_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_data_access_event_proto = out.File
	file_google_cloud_securitycenter_v2_data_access_event_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_data_access_event_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_data_access_event_proto_depIdxs = nil
}
