// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/securitycenter/v2/resource.proto

package securitycenterpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The cloud provider the finding pertains to.
type CloudProvider int32

const (
	// The cloud provider is unspecified.
	CloudProvider_CLOUD_PROVIDER_UNSPECIFIED CloudProvider = 0
	// The cloud provider is Google Cloud Platform.
	CloudProvider_GOOGLE_CLOUD_PLATFORM CloudProvider = 1
	// The cloud provider is Amazon Web Services.
	CloudProvider_AMAZON_WEB_SERVICES CloudProvider = 2
	// The cloud provider is Microsoft Azure.
	CloudProvider_MICROSOFT_AZURE CloudProvider = 3
)

// Enum value maps for CloudProvider.
var (
	CloudProvider_name = map[int32]string{
		0: "CLOUD_PROVIDER_UNSPECIFIED",
		1: "GOOGLE_CLOUD_PLATFORM",
		2: "AMAZON_WEB_SERVICES",
		3: "MICROSOFT_AZURE",
	}
	CloudProvider_value = map[string]int32{
		"CLOUD_PROVIDER_UNSPECIFIED": 0,
		"GOOGLE_CLOUD_PLATFORM":      1,
		"AMAZON_WEB_SERVICES":        2,
		"MICROSOFT_AZURE":            3,
	}
)

func (x CloudProvider) Enum() *CloudProvider {
	p := new(CloudProvider)
	*p = x
	return p
}

func (x CloudProvider) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudProvider) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_resource_proto_enumTypes[0].Descriptor()
}

func (CloudProvider) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_resource_proto_enumTypes[0]
}

func (x CloudProvider) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudProvider.Descriptor instead.
func (CloudProvider) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{0}
}

// The type of resource the node represents.
type ResourcePath_ResourcePathNodeType int32

const (
	// Node type is unspecified.
	ResourcePath_RESOURCE_PATH_NODE_TYPE_UNSPECIFIED ResourcePath_ResourcePathNodeType = 0
	// The node represents a Google Cloud organization.
	ResourcePath_GCP_ORGANIZATION ResourcePath_ResourcePathNodeType = 1
	// The node represents a Google Cloud folder.
	ResourcePath_GCP_FOLDER ResourcePath_ResourcePathNodeType = 2
	// The node represents a Google Cloud project.
	ResourcePath_GCP_PROJECT ResourcePath_ResourcePathNodeType = 3
	// The node represents an AWS organization.
	ResourcePath_AWS_ORGANIZATION ResourcePath_ResourcePathNodeType = 4
	// The node represents an AWS organizational unit.
	ResourcePath_AWS_ORGANIZATIONAL_UNIT ResourcePath_ResourcePathNodeType = 5
	// The node represents an AWS account.
	ResourcePath_AWS_ACCOUNT ResourcePath_ResourcePathNodeType = 6
	// The node represents an Azure management group.
	ResourcePath_AZURE_MANAGEMENT_GROUP ResourcePath_ResourcePathNodeType = 7
	// The node represents an Azure subscription.
	ResourcePath_AZURE_SUBSCRIPTION ResourcePath_ResourcePathNodeType = 8
	// The node represents an Azure resource group.
	ResourcePath_AZURE_RESOURCE_GROUP ResourcePath_ResourcePathNodeType = 9
)

// Enum value maps for ResourcePath_ResourcePathNodeType.
var (
	ResourcePath_ResourcePathNodeType_name = map[int32]string{
		0: "RESOURCE_PATH_NODE_TYPE_UNSPECIFIED",
		1: "GCP_ORGANIZATION",
		2: "GCP_FOLDER",
		3: "GCP_PROJECT",
		4: "AWS_ORGANIZATION",
		5: "AWS_ORGANIZATIONAL_UNIT",
		6: "AWS_ACCOUNT",
		7: "AZURE_MANAGEMENT_GROUP",
		8: "AZURE_SUBSCRIPTION",
		9: "AZURE_RESOURCE_GROUP",
	}
	ResourcePath_ResourcePathNodeType_value = map[string]int32{
		"RESOURCE_PATH_NODE_TYPE_UNSPECIFIED": 0,
		"GCP_ORGANIZATION":                    1,
		"GCP_FOLDER":                          2,
		"GCP_PROJECT":                         3,
		"AWS_ORGANIZATION":                    4,
		"AWS_ORGANIZATIONAL_UNIT":             5,
		"AWS_ACCOUNT":                         6,
		"AZURE_MANAGEMENT_GROUP":              7,
		"AZURE_SUBSCRIPTION":                  8,
		"AZURE_RESOURCE_GROUP":                9,
	}
)

func (x ResourcePath_ResourcePathNodeType) Enum() *ResourcePath_ResourcePathNodeType {
	p := new(ResourcePath_ResourcePathNodeType)
	*p = x
	return p
}

func (x ResourcePath_ResourcePathNodeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePath_ResourcePathNodeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_resource_proto_enumTypes[1].Descriptor()
}

func (ResourcePath_ResourcePathNodeType) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_resource_proto_enumTypes[1]
}

func (x ResourcePath_ResourcePathNodeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePath_ResourcePathNodeType.Descriptor instead.
func (ResourcePath_ResourcePathNodeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{4, 0}
}

// Information related to the Google Cloud resource.
type Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name of the resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The human readable name of the resource.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The full resource type of the resource.
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// Indicates which cloud provider the finding is from.
	CloudProvider CloudProvider `protobuf:"varint,4,opt,name=cloud_provider,json=cloudProvider,proto3,enum=google.cloud.securitycenter.v2.CloudProvider" json:"cloud_provider,omitempty"`
	// The service or resource provider associated with the resource.
	Service string `protobuf:"bytes,5,opt,name=service,proto3" json:"service,omitempty"`
	// The region or location of the service (if applicable).
	Location string `protobuf:"bytes,6,opt,name=location,proto3" json:"location,omitempty"`
	// Types that are assignable to CloudProviderMetadata:
	//
	//	*Resource_GcpMetadata
	//	*Resource_AwsMetadata
	//	*Resource_AzureMetadata
	CloudProviderMetadata isResource_CloudProviderMetadata `protobuf_oneof:"cloud_provider_metadata"`
	// Provides the path to the resource within the resource hierarchy.
	ResourcePath *ResourcePath `protobuf:"bytes,10,opt,name=resource_path,json=resourcePath,proto3" json:"resource_path,omitempty"`
	// A string representation of the resource path.
	// For Google Cloud, it has the format of
	// `organizations/{organization_id}/folders/{folder_id}/folders/{folder_id}/projects/{project_id}`
	// where there can be any number of folders.
	// For AWS, it has the format of
	// `org/{organization_id}/ou/{organizational_unit_id}/ou/{organizational_unit_id}/account/{account_id}`
	// where there can be any number of organizational units.
	// For Azure, it has the format of
	// `mg/{management_group_id}/mg/{management_group_id}/subscription/{subscription_id}/rg/{resource_group_name}`
	// where there can be any number of management groups.
	ResourcePathString string `protobuf:"bytes,11,opt,name=resource_path_string,json=resourcePathString,proto3" json:"resource_path_string,omitempty"`
}

func (x *Resource) Reset() {
	*x = Resource{}
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resource.ProtoReflect.Descriptor instead.
func (*Resource) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{0}
}

func (x *Resource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Resource) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Resource) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Resource) GetCloudProvider() CloudProvider {
	if x != nil {
		return x.CloudProvider
	}
	return CloudProvider_CLOUD_PROVIDER_UNSPECIFIED
}

func (x *Resource) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *Resource) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (m *Resource) GetCloudProviderMetadata() isResource_CloudProviderMetadata {
	if m != nil {
		return m.CloudProviderMetadata
	}
	return nil
}

func (x *Resource) GetGcpMetadata() *GcpMetadata {
	if x, ok := x.GetCloudProviderMetadata().(*Resource_GcpMetadata); ok {
		return x.GcpMetadata
	}
	return nil
}

func (x *Resource) GetAwsMetadata() *AwsMetadata {
	if x, ok := x.GetCloudProviderMetadata().(*Resource_AwsMetadata); ok {
		return x.AwsMetadata
	}
	return nil
}

func (x *Resource) GetAzureMetadata() *AzureMetadata {
	if x, ok := x.GetCloudProviderMetadata().(*Resource_AzureMetadata); ok {
		return x.AzureMetadata
	}
	return nil
}

func (x *Resource) GetResourcePath() *ResourcePath {
	if x != nil {
		return x.ResourcePath
	}
	return nil
}

func (x *Resource) GetResourcePathString() string {
	if x != nil {
		return x.ResourcePathString
	}
	return ""
}

type isResource_CloudProviderMetadata interface {
	isResource_CloudProviderMetadata()
}

type Resource_GcpMetadata struct {
	// The GCP metadata associated with the finding.
	GcpMetadata *GcpMetadata `protobuf:"bytes,7,opt,name=gcp_metadata,json=gcpMetadata,proto3,oneof"`
}

type Resource_AwsMetadata struct {
	// The AWS metadata associated with the finding.
	AwsMetadata *AwsMetadata `protobuf:"bytes,8,opt,name=aws_metadata,json=awsMetadata,proto3,oneof"`
}

type Resource_AzureMetadata struct {
	// The Azure metadata associated with the finding.
	AzureMetadata *AzureMetadata `protobuf:"bytes,9,opt,name=azure_metadata,json=azureMetadata,proto3,oneof"`
}

func (*Resource_GcpMetadata) isResource_CloudProviderMetadata() {}

func (*Resource_AwsMetadata) isResource_CloudProviderMetadata() {}

func (*Resource_AzureMetadata) isResource_CloudProviderMetadata() {}

// GCP metadata associated with the resource, only applicable if the finding's
// cloud provider is Google Cloud Platform.
type GcpMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name of project that the resource belongs to.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// The project ID that the resource belongs to.
	ProjectDisplayName string `protobuf:"bytes,2,opt,name=project_display_name,json=projectDisplayName,proto3" json:"project_display_name,omitempty"`
	// The full resource name of resource's parent.
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	// The human readable name of resource's parent.
	ParentDisplayName string `protobuf:"bytes,4,opt,name=parent_display_name,json=parentDisplayName,proto3" json:"parent_display_name,omitempty"`
	// Output only. Contains a Folder message for each folder in the assets
	// ancestry. The first folder is the deepest nested folder, and the last
	// folder is the folder directly under the Organization.
	Folders []*Folder `protobuf:"bytes,5,rep,name=folders,proto3" json:"folders,omitempty"`
	// The name of the organization that the resource belongs to.
	Organization string `protobuf:"bytes,6,opt,name=organization,proto3" json:"organization,omitempty"`
}

func (x *GcpMetadata) Reset() {
	*x = GcpMetadata{}
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcpMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcpMetadata) ProtoMessage() {}

func (x *GcpMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcpMetadata.ProtoReflect.Descriptor instead.
func (*GcpMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{1}
}

func (x *GcpMetadata) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *GcpMetadata) GetProjectDisplayName() string {
	if x != nil {
		return x.ProjectDisplayName
	}
	return ""
}

func (x *GcpMetadata) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GcpMetadata) GetParentDisplayName() string {
	if x != nil {
		return x.ParentDisplayName
	}
	return ""
}

func (x *GcpMetadata) GetFolders() []*Folder {
	if x != nil {
		return x.Folders
	}
	return nil
}

func (x *GcpMetadata) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

// AWS metadata associated with the resource, only applicable if the finding's
// cloud provider is Amazon Web Services.
type AwsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The AWS organization associated with the resource.
	Organization *AwsMetadata_AwsOrganization `protobuf:"bytes,1,opt,name=organization,proto3" json:"organization,omitempty"`
	// A list of AWS organizational units associated with the resource, ordered
	// from lowest level (closest to the account) to highest level.
	OrganizationalUnits []*AwsMetadata_AwsOrganizationalUnit `protobuf:"bytes,2,rep,name=organizational_units,json=organizationalUnits,proto3" json:"organizational_units,omitempty"`
	// The AWS account associated with the resource.
	Account *AwsMetadata_AwsAccount `protobuf:"bytes,3,opt,name=account,proto3" json:"account,omitempty"`
}

func (x *AwsMetadata) Reset() {
	*x = AwsMetadata{}
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsMetadata) ProtoMessage() {}

func (x *AwsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsMetadata.ProtoReflect.Descriptor instead.
func (*AwsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{2}
}

func (x *AwsMetadata) GetOrganization() *AwsMetadata_AwsOrganization {
	if x != nil {
		return x.Organization
	}
	return nil
}

func (x *AwsMetadata) GetOrganizationalUnits() []*AwsMetadata_AwsOrganizationalUnit {
	if x != nil {
		return x.OrganizationalUnits
	}
	return nil
}

func (x *AwsMetadata) GetAccount() *AwsMetadata_AwsAccount {
	if x != nil {
		return x.Account
	}
	return nil
}

// Azure metadata associated with the resource, only applicable if the finding's
// cloud provider is Microsoft Azure.
type AzureMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Azure management groups associated with the resource, ordered
	// from lowest level (closest to the subscription) to highest level.
	ManagementGroups []*AzureMetadata_AzureManagementGroup `protobuf:"bytes,1,rep,name=management_groups,json=managementGroups,proto3" json:"management_groups,omitempty"`
	// The Azure subscription associated with the resource.
	Subscription *AzureMetadata_AzureSubscription `protobuf:"bytes,2,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// The Azure resource group associated with the resource.
	ResourceGroup *AzureMetadata_AzureResourceGroup `protobuf:"bytes,3,opt,name=resource_group,json=resourceGroup,proto3" json:"resource_group,omitempty"`
	// The Azure Entra tenant associated with the resource.
	Tenant *AzureMetadata_AzureTenant `protobuf:"bytes,7,opt,name=tenant,proto3" json:"tenant,omitempty"`
}

func (x *AzureMetadata) Reset() {
	*x = AzureMetadata{}
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureMetadata) ProtoMessage() {}

func (x *AzureMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureMetadata.ProtoReflect.Descriptor instead.
func (*AzureMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{3}
}

func (x *AzureMetadata) GetManagementGroups() []*AzureMetadata_AzureManagementGroup {
	if x != nil {
		return x.ManagementGroups
	}
	return nil
}

func (x *AzureMetadata) GetSubscription() *AzureMetadata_AzureSubscription {
	if x != nil {
		return x.Subscription
	}
	return nil
}

func (x *AzureMetadata) GetResourceGroup() *AzureMetadata_AzureResourceGroup {
	if x != nil {
		return x.ResourceGroup
	}
	return nil
}

func (x *AzureMetadata) GetTenant() *AzureMetadata_AzureTenant {
	if x != nil {
		return x.Tenant
	}
	return nil
}

// Represents the path of resources leading up to the resource this finding is
// about.
type ResourcePath struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of nodes that make the up resource path, ordered from lowest
	// level to highest level.
	Nodes []*ResourcePath_ResourcePathNode `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
}

func (x *ResourcePath) Reset() {
	*x = ResourcePath{}
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourcePath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcePath) ProtoMessage() {}

func (x *ResourcePath) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcePath.ProtoReflect.Descriptor instead.
func (*ResourcePath) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{4}
}

func (x *ResourcePath) GetNodes() []*ResourcePath_ResourcePathNode {
	if x != nil {
		return x.Nodes
	}
	return nil
}

// An organization is a collection of accounts that are centrally managed
// together using consolidated billing, organized hierarchically with
// organizational units (OUs), and controlled with policies.
type AwsMetadata_AwsOrganization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier (ID) for the organization. The regex pattern for an
	// organization ID string requires "o-" followed by from 10 to 32 lowercase
	// letters or digits.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *AwsMetadata_AwsOrganization) Reset() {
	*x = AwsMetadata_AwsOrganization{}
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsMetadata_AwsOrganization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsMetadata_AwsOrganization) ProtoMessage() {}

func (x *AwsMetadata_AwsOrganization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsMetadata_AwsOrganization.ProtoReflect.Descriptor instead.
func (*AwsMetadata_AwsOrganization) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{2, 0}
}

func (x *AwsMetadata_AwsOrganization) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// An Organizational Unit (OU) is a container of AWS accounts within a root of
// an organization. Policies that are attached to an OU apply to all accounts
// contained in that OU and in any child OUs.
type AwsMetadata_AwsOrganizationalUnit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier (ID) associated with this OU. The regex pattern for
	// an organizational unit ID string requires "ou-" followed by from 4 to 32
	// lowercase letters or digits (the ID of the root that contains the OU).
	// This string is followed by a second "-" dash and from 8 to 32 additional
	// lowercase letters or digits. For example, "ou-ab12-cd34ef56".
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The friendly name of the OU.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *AwsMetadata_AwsOrganizationalUnit) Reset() {
	*x = AwsMetadata_AwsOrganizationalUnit{}
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsMetadata_AwsOrganizationalUnit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsMetadata_AwsOrganizationalUnit) ProtoMessage() {}

func (x *AwsMetadata_AwsOrganizationalUnit) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsMetadata_AwsOrganizationalUnit.ProtoReflect.Descriptor instead.
func (*AwsMetadata_AwsOrganizationalUnit) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{2, 1}
}

func (x *AwsMetadata_AwsOrganizationalUnit) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AwsMetadata_AwsOrganizationalUnit) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// An AWS account that is a member of an organization.
type AwsMetadata_AwsAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier (ID) of the account, containing exactly 12 digits.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The friendly name of this account.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *AwsMetadata_AwsAccount) Reset() {
	*x = AwsMetadata_AwsAccount{}
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsMetadata_AwsAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsMetadata_AwsAccount) ProtoMessage() {}

func (x *AwsMetadata_AwsAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsMetadata_AwsAccount.ProtoReflect.Descriptor instead.
func (*AwsMetadata_AwsAccount) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{2, 2}
}

func (x *AwsMetadata_AwsAccount) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AwsMetadata_AwsAccount) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents an Azure management group.
type AzureMetadata_AzureManagementGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The UUID of the Azure management group, for example,
	// `20000000-0001-0000-0000-000000000000`.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the Azure management group.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *AzureMetadata_AzureManagementGroup) Reset() {
	*x = AzureMetadata_AzureManagementGroup{}
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureMetadata_AzureManagementGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureMetadata_AzureManagementGroup) ProtoMessage() {}

func (x *AzureMetadata_AzureManagementGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureMetadata_AzureManagementGroup.ProtoReflect.Descriptor instead.
func (*AzureMetadata_AzureManagementGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{3, 0}
}

func (x *AzureMetadata_AzureManagementGroup) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AzureMetadata_AzureManagementGroup) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Represents an Azure subscription.
type AzureMetadata_AzureSubscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The UUID of the Azure subscription, for example,
	// `291bba3f-e0a5-47bc-a099-3bdcb2a50a05`.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the Azure subscription.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *AzureMetadata_AzureSubscription) Reset() {
	*x = AzureMetadata_AzureSubscription{}
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureMetadata_AzureSubscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureMetadata_AzureSubscription) ProtoMessage() {}

func (x *AzureMetadata_AzureSubscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureMetadata_AzureSubscription.ProtoReflect.Descriptor instead.
func (*AzureMetadata_AzureSubscription) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{3, 1}
}

func (x *AzureMetadata_AzureSubscription) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AzureMetadata_AzureSubscription) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Represents an Azure resource group.
type AzureMetadata_AzureResourceGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Azure resource group.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the Azure resource group. This is not a UUID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *AzureMetadata_AzureResourceGroup) Reset() {
	*x = AzureMetadata_AzureResourceGroup{}
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureMetadata_AzureResourceGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureMetadata_AzureResourceGroup) ProtoMessage() {}

func (x *AzureMetadata_AzureResourceGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureMetadata_AzureResourceGroup.ProtoReflect.Descriptor instead.
func (*AzureMetadata_AzureResourceGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{3, 2}
}

func (x *AzureMetadata_AzureResourceGroup) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AzureMetadata_AzureResourceGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents a Microsoft Entra tenant.
type AzureMetadata_AzureTenant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Microsoft Entra tenant, for example,
	// "a11aaa11-aa11-1aa1-11aa-1aaa11a".
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the Azure tenant.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *AzureMetadata_AzureTenant) Reset() {
	*x = AzureMetadata_AzureTenant{}
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureMetadata_AzureTenant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureMetadata_AzureTenant) ProtoMessage() {}

func (x *AzureMetadata_AzureTenant) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureMetadata_AzureTenant.ProtoReflect.Descriptor instead.
func (*AzureMetadata_AzureTenant) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{3, 3}
}

func (x *AzureMetadata_AzureTenant) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AzureMetadata_AzureTenant) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// A node within the resource path. Each node represents a resource within the
// resource hierarchy.
type ResourcePath_ResourcePathNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of resource this node represents.
	NodeType ResourcePath_ResourcePathNodeType `protobuf:"varint,1,opt,name=node_type,json=nodeType,proto3,enum=google.cloud.securitycenter.v2.ResourcePath_ResourcePathNodeType" json:"node_type,omitempty"`
	// The ID of the resource this node represents.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the resource this node represents.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *ResourcePath_ResourcePathNode) Reset() {
	*x = ResourcePath_ResourcePathNode{}
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourcePath_ResourcePathNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcePath_ResourcePathNode) ProtoMessage() {}

func (x *ResourcePath_ResourcePathNode) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_resource_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcePath_ResourcePathNode.ProtoReflect.Descriptor instead.
func (*ResourcePath_ResourcePathNode) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP(), []int{4, 0}
}

func (x *ResourcePath_ResourcePathNode) GetNodeType() ResourcePath_ResourcePathNodeType {
	if x != nil {
		return x.NodeType
	}
	return ResourcePath_RESOURCE_PATH_NODE_TYPE_UNSPECIFIED
}

func (x *ResourcePath_ResourcePathNode) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ResourcePath_ResourcePathNode) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

var File_google_cloud_securitycenter_v2_resource_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_resource_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfd, 0x04,
	0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x54, 0x0a, 0x0e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x0d, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x50, 0x0a, 0x0c, 0x67, 0x63, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x63, 0x70, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0b, 0x67, 0x63, 0x70, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x50, 0x0a, 0x0c, 0x61, 0x77, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x77, 0x73, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x77, 0x73, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x56, 0x0a, 0x0e, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0d,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x51, 0x0a,
	0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61,
	0x74, 0x68, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68,
	0x12, 0x30, 0x0a, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x42, 0x19, 0x0a, 0x17, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x8c, 0x02,
	0x0a, 0x0b, 0x47, 0x63, 0x70, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x18, 0x0a,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x45, 0x0a, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc8, 0x03, 0x0a,
	0x0b, 0x41, 0x77, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a, 0x0c,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x41, 0x77, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x41, 0x77, 0x73, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x74, 0x0a,
	0x14, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f,
	0x75, 0x6e, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x77, 0x73,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x41, 0x77, 0x73, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x55, 0x6e, 0x69, 0x74, 0x52, 0x13,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x55, 0x6e,
	0x69, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x77, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x07, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x21, 0x0a, 0x0f, 0x41, 0x77, 0x73, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x1a, 0x3b, 0x0a, 0x15, 0x41, 0x77, 0x73, 0x4f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x55, 0x6e, 0x69,
	0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x30, 0x0a, 0x0a, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb0, 0x05, 0x0a, 0x0d, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x6f, 0x0a, 0x11, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x10, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x63, 0x0a, 0x0c, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x67, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x51, 0x0a, 0x06, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x52, 0x06, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x1a, 0x49, 0x0a, 0x14, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x46, 0x0a, 0x11, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x38,
	0x0a, 0x12, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x40, 0x0a, 0x0b, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x96, 0x04, 0x0a, 0x0c, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x53, 0x0a, 0x05, 0x6e,
	0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x50, 0x61, 0x74, 0x68, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73,
	0x1a, 0xa5, 0x01, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x74,
	0x68, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x5e, 0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50,
	0x61, 0x74, 0x68, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x6e, 0x6f, 0x64,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x88, 0x02, 0x0a, 0x14, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x27, 0x0a, 0x23, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x50, 0x41,
	0x54, 0x48, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x43,
	0x50, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01,
	0x12, 0x0e, 0x0a, 0x0a, 0x47, 0x43, 0x50, 0x5f, 0x46, 0x4f, 0x4c, 0x44, 0x45, 0x52, 0x10, 0x02,
	0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x43, 0x50, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x10,
	0x03, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x57, 0x53, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x57, 0x53, 0x5f, 0x4f,
	0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x55, 0x4e,
	0x49, 0x54, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x57, 0x53, 0x5f, 0x41, 0x43, 0x43, 0x4f,
	0x55, 0x4e, 0x54, 0x10, 0x06, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x5a, 0x55, 0x52, 0x45, 0x5f, 0x4d,
	0x41, 0x4e, 0x41, 0x47, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x10,
	0x07, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x5a, 0x55, 0x52, 0x45, 0x5f, 0x53, 0x55, 0x42, 0x53, 0x43,
	0x52, 0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08, 0x12, 0x18, 0x0a, 0x14, 0x41, 0x5a, 0x55,
	0x52, 0x45, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x47, 0x52, 0x4f, 0x55,
	0x50, 0x10, 0x09, 0x2a, 0x78, 0x0a, 0x0d, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x50, 0x52,
	0x4f, 0x56, 0x49, 0x44, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x43,
	0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x50, 0x4c, 0x41, 0x54, 0x46, 0x4f, 0x52, 0x4d, 0x10, 0x01, 0x12,
	0x17, 0x0a, 0x13, 0x41, 0x4d, 0x41, 0x5a, 0x4f, 0x4e, 0x5f, 0x57, 0x45, 0x42, 0x5f, 0x53, 0x45,
	0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x4d, 0x49, 0x43, 0x52,
	0x4f, 0x53, 0x4f, 0x46, 0x54, 0x5f, 0x41, 0x5a, 0x55, 0x52, 0x45, 0x10, 0x03, 0x42, 0xe7, 0x01,
	0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x42, 0x0d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62,
	0x3b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x56, 0x32, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x5c, 0x56, 0x32, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_resource_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_resource_proto_rawDescData = file_google_cloud_securitycenter_v2_resource_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_resource_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_resource_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_resource_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_resource_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_resource_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_resource_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_securitycenter_v2_resource_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_securitycenter_v2_resource_proto_goTypes = []any{
	(CloudProvider)(0),                         // 0: google.cloud.securitycenter.v2.CloudProvider
	(ResourcePath_ResourcePathNodeType)(0),     // 1: google.cloud.securitycenter.v2.ResourcePath.ResourcePathNodeType
	(*Resource)(nil),                           // 2: google.cloud.securitycenter.v2.Resource
	(*GcpMetadata)(nil),                        // 3: google.cloud.securitycenter.v2.GcpMetadata
	(*AwsMetadata)(nil),                        // 4: google.cloud.securitycenter.v2.AwsMetadata
	(*AzureMetadata)(nil),                      // 5: google.cloud.securitycenter.v2.AzureMetadata
	(*ResourcePath)(nil),                       // 6: google.cloud.securitycenter.v2.ResourcePath
	(*AwsMetadata_AwsOrganization)(nil),        // 7: google.cloud.securitycenter.v2.AwsMetadata.AwsOrganization
	(*AwsMetadata_AwsOrganizationalUnit)(nil),  // 8: google.cloud.securitycenter.v2.AwsMetadata.AwsOrganizationalUnit
	(*AwsMetadata_AwsAccount)(nil),             // 9: google.cloud.securitycenter.v2.AwsMetadata.AwsAccount
	(*AzureMetadata_AzureManagementGroup)(nil), // 10: google.cloud.securitycenter.v2.AzureMetadata.AzureManagementGroup
	(*AzureMetadata_AzureSubscription)(nil),    // 11: google.cloud.securitycenter.v2.AzureMetadata.AzureSubscription
	(*AzureMetadata_AzureResourceGroup)(nil),   // 12: google.cloud.securitycenter.v2.AzureMetadata.AzureResourceGroup
	(*AzureMetadata_AzureTenant)(nil),          // 13: google.cloud.securitycenter.v2.AzureMetadata.AzureTenant
	(*ResourcePath_ResourcePathNode)(nil),      // 14: google.cloud.securitycenter.v2.ResourcePath.ResourcePathNode
	(*Folder)(nil),                             // 15: google.cloud.securitycenter.v2.Folder
}
var file_google_cloud_securitycenter_v2_resource_proto_depIdxs = []int32{
	0,  // 0: google.cloud.securitycenter.v2.Resource.cloud_provider:type_name -> google.cloud.securitycenter.v2.CloudProvider
	3,  // 1: google.cloud.securitycenter.v2.Resource.gcp_metadata:type_name -> google.cloud.securitycenter.v2.GcpMetadata
	4,  // 2: google.cloud.securitycenter.v2.Resource.aws_metadata:type_name -> google.cloud.securitycenter.v2.AwsMetadata
	5,  // 3: google.cloud.securitycenter.v2.Resource.azure_metadata:type_name -> google.cloud.securitycenter.v2.AzureMetadata
	6,  // 4: google.cloud.securitycenter.v2.Resource.resource_path:type_name -> google.cloud.securitycenter.v2.ResourcePath
	15, // 5: google.cloud.securitycenter.v2.GcpMetadata.folders:type_name -> google.cloud.securitycenter.v2.Folder
	7,  // 6: google.cloud.securitycenter.v2.AwsMetadata.organization:type_name -> google.cloud.securitycenter.v2.AwsMetadata.AwsOrganization
	8,  // 7: google.cloud.securitycenter.v2.AwsMetadata.organizational_units:type_name -> google.cloud.securitycenter.v2.AwsMetadata.AwsOrganizationalUnit
	9,  // 8: google.cloud.securitycenter.v2.AwsMetadata.account:type_name -> google.cloud.securitycenter.v2.AwsMetadata.AwsAccount
	10, // 9: google.cloud.securitycenter.v2.AzureMetadata.management_groups:type_name -> google.cloud.securitycenter.v2.AzureMetadata.AzureManagementGroup
	11, // 10: google.cloud.securitycenter.v2.AzureMetadata.subscription:type_name -> google.cloud.securitycenter.v2.AzureMetadata.AzureSubscription
	12, // 11: google.cloud.securitycenter.v2.AzureMetadata.resource_group:type_name -> google.cloud.securitycenter.v2.AzureMetadata.AzureResourceGroup
	13, // 12: google.cloud.securitycenter.v2.AzureMetadata.tenant:type_name -> google.cloud.securitycenter.v2.AzureMetadata.AzureTenant
	14, // 13: google.cloud.securitycenter.v2.ResourcePath.nodes:type_name -> google.cloud.securitycenter.v2.ResourcePath.ResourcePathNode
	1,  // 14: google.cloud.securitycenter.v2.ResourcePath.ResourcePathNode.node_type:type_name -> google.cloud.securitycenter.v2.ResourcePath.ResourcePathNodeType
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_resource_proto_init() }
func file_google_cloud_securitycenter_v2_resource_proto_init() {
	if File_google_cloud_securitycenter_v2_resource_proto != nil {
		return
	}
	file_google_cloud_securitycenter_v2_folder_proto_init()
	file_google_cloud_securitycenter_v2_resource_proto_msgTypes[0].OneofWrappers = []any{
		(*Resource_GcpMetadata)(nil),
		(*Resource_AwsMetadata)(nil),
		(*Resource_AzureMetadata)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_resource_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_resource_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_resource_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v2_resource_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v2_resource_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_resource_proto = out.File
	file_google_cloud_securitycenter_v2_resource_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_resource_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_resource_proto_depIdxs = nil
}
