<?php

declare(strict_types=1);

/*
 * Copyright (c) 2023-2024 François Kooman <fkooman@tuxed.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

namespace fkooman\Radius\Tests;

use fkooman\Radius\Password;
use PHPUnit\Framework\TestCase;

/**
 * @covers \fkooman\Radius\Password
 *
 * @uses \fkooman\Radius\Utils
 */
class PasswordTest extends TestCase
{
    public function testShortPassword(): void
    {
        $this->assertSame(
            'cdcd3c59edf2ff52c19b3ce87fecedb8',
            bin2hex(
                Password::encrypt(
                    'bar',
                    hex2bin('028e2f05b8e438da0da15ab2196626eb'),
                    's3cr3t'
                )
            )
        );

        $this->assertSame(
            'bar',
            Password::decrypt(
                hex2bin('cdcd3c59edf2ff52c19b3ce87fecedb8'),
                hex2bin('028e2f05b8e438da0da15ab2196626eb'),
                's3cr3t'
            )
        );
    }

    public function testSixteenCharPassword(): void
    {
        $this->assertSame(
            '9f93eba5893164c6548dd07d9c555ce9',
            bin2hex(
                Password::encrypt(
                    'passwordpassword',
                    hex2bin('3fffc1ae5d84f56c528a6dc3c3e53730'),
                    's3cr3t'
                )
            )
        );

        $this->assertSame(
            'passwordpassword',
            Password::decrypt(
                hex2bin('9f93eba5893164c6548dd07d9c555ce9'),
                hex2bin('3fffc1ae5d84f56c528a6dc3c3e53730'),
                's3cr3t'
            )
        );
    }

    public function testLongPassword(): void
    {
        $this->assertSame(
            'e074b22820a2a967814d019ff131de051cd5494f6fde9a0d675a5d1bf26e42cc',
            bin2hex(
                Password::encrypt(
                    'very-long-password',
                    hex2bin('e1caf13c73006558f1e9725806b2e495'),
                    's3cr3t'
                )
            )
        );

        $this->assertSame(
            'very-long-password',
            Password::decrypt(
                hex2bin('e074b22820a2a967814d019ff131de051cd5494f6fde9a0d675a5d1bf26e42cc'),
                hex2bin('e1caf13c73006558f1e9725806b2e495'),
                's3cr3t'
            )
        );
    }
}
