<?php

declare(strict_types=1);

/*
 * Copyright (c) 2023-2024 François Kooman <fkooman@tuxed.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

// @codeCoverageIgnoreStart
// this is an autogenerated file - do not edit
spl_autoload_register(
    function ($class): void {
        static $classes = null;
        if ($classes === null) {
            $classes = [
                'fkooman\\radius\\attributecollection' => '/../src/AttributeCollection.php',
                'fkooman\\radius\\clientconfig' => '/../src/ClientConfig.php',
                'fkooman\\radius\\exception\\accesschallengeexception' => '/../src/Exception/AccessChallengeException.php',
                'fkooman\\radius\\exception\\accessrejectexception' => '/../src/Exception/AccessRejectException.php',
                'fkooman\\radius\\exception\\attributecollectionexception' => '/../src/Exception/AttributeCollectionException.php',
                'fkooman\\radius\\exception\\passwordexception' => '/../src/Exception/PasswordException.php',
                'fkooman\\radius\\exception\\radiusexception' => '/../src/Exception/RadiusException.php',
                'fkooman\\radius\\exception\\socketexception' => '/../src/Exception/SocketException.php',
                'fkooman\\radius\\loggerinterface' => '/../src/LoggerInterface.php',
                'fkooman\\radius\\messageauthenticator' => '/../src/MessageAuthenticator.php',
                'fkooman\\radius\\nulllogger' => '/../src/NullLogger.php',
                'fkooman\\radius\\password' => '/../src/Password.php',
                'fkooman\\radius\\phpsocket' => '/../src/PhpSocket.php',
                'fkooman\\radius\\radiusclient' => '/../src/RadiusClient.php',
                'fkooman\\radius\\radiuspacket' => '/../src/RadiusPacket.php',
                'fkooman\\radius\\responseauthenticator' => '/../src/ResponseAuthenticator.php',
                'fkooman\\radius\\serverinfo' => '/../src/ServerInfo.php',
                'fkooman\\radius\\socketinterface' => '/../src/SocketInterface.php',
                'fkooman\\radius\\utils' => '/../src/Utils.php',
            ];
        }
        $cn = strtolower($class);
        if (isset($classes[$cn])) {
            require __DIR__ . $classes[$cn];
        }
    },
    true,
    false
);
// @codeCoverageIgnoreEnd
