// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/dataflow/v1beta3/messages.proto

package dataflowpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates the importance of the message.
type JobMessageImportance int32

const (
	// The message importance isn't specified, or is unknown.
	JobMessageImportance_JOB_MESSAGE_IMPORTANCE_UNKNOWN JobMessageImportance = 0
	// The message is at the 'debug' level: typically only useful for
	// software engineers working on the code the job is running.
	// Typically, Dataflow pipeline runners do not display log messages
	// at this level by default.
	JobMessageImportance_JOB_MESSAGE_DEBUG JobMessageImportance = 1
	// The message is at the 'detailed' level: somewhat verbose, but
	// potentially useful to users.  Typically, Dataflow pipeline
	// runners do not display log messages at this level by default.
	// These messages are displayed by default in the Dataflow
	// monitoring UI.
	JobMessageImportance_JOB_MESSAGE_DETAILED JobMessageImportance = 2
	// The message is at the 'basic' level: useful for keeping
	// track of the execution of a Dataflow pipeline.  Typically,
	// Dataflow pipeline runners display log messages at this level by
	// default, and these messages are displayed by default in the
	// Dataflow monitoring UI.
	JobMessageImportance_JOB_MESSAGE_BASIC JobMessageImportance = 5
	// The message is at the 'warning' level: indicating a condition
	// pertaining to a job which may require human intervention.
	// Typically, Dataflow pipeline runners display log messages at this
	// level by default, and these messages are displayed by default in
	// the Dataflow monitoring UI.
	JobMessageImportance_JOB_MESSAGE_WARNING JobMessageImportance = 3
	// The message is at the 'error' level: indicating a condition
	// preventing a job from succeeding.  Typically, Dataflow pipeline
	// runners display log messages at this level by default, and these
	// messages are displayed by default in the Dataflow monitoring UI.
	JobMessageImportance_JOB_MESSAGE_ERROR JobMessageImportance = 4
)

// Enum value maps for JobMessageImportance.
var (
	JobMessageImportance_name = map[int32]string{
		0: "JOB_MESSAGE_IMPORTANCE_UNKNOWN",
		1: "JOB_MESSAGE_DEBUG",
		2: "JOB_MESSAGE_DETAILED",
		5: "JOB_MESSAGE_BASIC",
		3: "JOB_MESSAGE_WARNING",
		4: "JOB_MESSAGE_ERROR",
	}
	JobMessageImportance_value = map[string]int32{
		"JOB_MESSAGE_IMPORTANCE_UNKNOWN": 0,
		"JOB_MESSAGE_DEBUG":              1,
		"JOB_MESSAGE_DETAILED":           2,
		"JOB_MESSAGE_BASIC":              5,
		"JOB_MESSAGE_WARNING":            3,
		"JOB_MESSAGE_ERROR":              4,
	}
)

func (x JobMessageImportance) Enum() *JobMessageImportance {
	p := new(JobMessageImportance)
	*p = x
	return p
}

func (x JobMessageImportance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobMessageImportance) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_messages_proto_enumTypes[0].Descriptor()
}

func (JobMessageImportance) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_messages_proto_enumTypes[0]
}

func (x JobMessageImportance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobMessageImportance.Descriptor instead.
func (JobMessageImportance) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_messages_proto_rawDescGZIP(), []int{0}
}

// Indicates the type of autoscaling event.
type AutoscalingEvent_AutoscalingEventType int32

const (
	// Default type for the enum.  Value should never be returned.
	AutoscalingEvent_TYPE_UNKNOWN AutoscalingEvent_AutoscalingEventType = 0
	// The TARGET_NUM_WORKERS_CHANGED type should be used when the target
	// worker pool size has changed at the start of an actuation. An event
	// should always be specified as TARGET_NUM_WORKERS_CHANGED if it reflects
	// a change in the target_num_workers.
	AutoscalingEvent_TARGET_NUM_WORKERS_CHANGED AutoscalingEvent_AutoscalingEventType = 1
	// The CURRENT_NUM_WORKERS_CHANGED type should be used when actual worker
	// pool size has been changed, but the target_num_workers has not changed.
	AutoscalingEvent_CURRENT_NUM_WORKERS_CHANGED AutoscalingEvent_AutoscalingEventType = 2
	// The ACTUATION_FAILURE type should be used when we want to report
	// an error to the user indicating why the current number of workers
	// in the pool could not be changed.
	// Displayed in the current status and history widgets.
	AutoscalingEvent_ACTUATION_FAILURE AutoscalingEvent_AutoscalingEventType = 3
	// Used when we want to report to the user a reason why we are
	// not currently adjusting the number of workers.
	// Should specify both target_num_workers, current_num_workers and a
	// decision_message.
	AutoscalingEvent_NO_CHANGE AutoscalingEvent_AutoscalingEventType = 4
)

// Enum value maps for AutoscalingEvent_AutoscalingEventType.
var (
	AutoscalingEvent_AutoscalingEventType_name = map[int32]string{
		0: "TYPE_UNKNOWN",
		1: "TARGET_NUM_WORKERS_CHANGED",
		2: "CURRENT_NUM_WORKERS_CHANGED",
		3: "ACTUATION_FAILURE",
		4: "NO_CHANGE",
	}
	AutoscalingEvent_AutoscalingEventType_value = map[string]int32{
		"TYPE_UNKNOWN":                0,
		"TARGET_NUM_WORKERS_CHANGED":  1,
		"CURRENT_NUM_WORKERS_CHANGED": 2,
		"ACTUATION_FAILURE":           3,
		"NO_CHANGE":                   4,
	}
)

func (x AutoscalingEvent_AutoscalingEventType) Enum() *AutoscalingEvent_AutoscalingEventType {
	p := new(AutoscalingEvent_AutoscalingEventType)
	*p = x
	return p
}

func (x AutoscalingEvent_AutoscalingEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalingEvent_AutoscalingEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_messages_proto_enumTypes[1].Descriptor()
}

func (AutoscalingEvent_AutoscalingEventType) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_messages_proto_enumTypes[1]
}

func (x AutoscalingEvent_AutoscalingEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalingEvent_AutoscalingEventType.Descriptor instead.
func (AutoscalingEvent_AutoscalingEventType) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_messages_proto_rawDescGZIP(), []int{2, 0}
}

// A particular message pertaining to a Dataflow job.
type JobMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The timestamp of the message.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// The text of the message.
	MessageText string `protobuf:"bytes,3,opt,name=message_text,json=messageText,proto3" json:"message_text,omitempty"`
	// Importance level of the message.
	MessageImportance JobMessageImportance `protobuf:"varint,4,opt,name=message_importance,json=messageImportance,proto3,enum=google.dataflow.v1beta3.JobMessageImportance" json:"message_importance,omitempty"`
}

func (x *JobMessage) Reset() {
	*x = JobMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_messages_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobMessage) ProtoMessage() {}

func (x *JobMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_messages_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobMessage.ProtoReflect.Descriptor instead.
func (*JobMessage) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_messages_proto_rawDescGZIP(), []int{0}
}

func (x *JobMessage) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *JobMessage) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *JobMessage) GetMessageText() string {
	if x != nil {
		return x.MessageText
	}
	return ""
}

func (x *JobMessage) GetMessageImportance() JobMessageImportance {
	if x != nil {
		return x.MessageImportance
	}
	return JobMessageImportance_JOB_MESSAGE_IMPORTANCE_UNKNOWN
}

// A rich message format, including a human readable string, a key for
// identifying the message, and structured data associated with the message for
// programmatic consumption.
type StructuredMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Human-readable version of message.
	MessageText string `protobuf:"bytes,1,opt,name=message_text,json=messageText,proto3" json:"message_text,omitempty"`
	// Identifier for this message type.  Used by external systems to
	// internationalize or personalize message.
	MessageKey string `protobuf:"bytes,2,opt,name=message_key,json=messageKey,proto3" json:"message_key,omitempty"`
	// The structured data associated with this message.
	Parameters []*StructuredMessage_Parameter `protobuf:"bytes,3,rep,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *StructuredMessage) Reset() {
	*x = StructuredMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_messages_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredMessage) ProtoMessage() {}

func (x *StructuredMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_messages_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredMessage.ProtoReflect.Descriptor instead.
func (*StructuredMessage) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_messages_proto_rawDescGZIP(), []int{1}
}

func (x *StructuredMessage) GetMessageText() string {
	if x != nil {
		return x.MessageText
	}
	return ""
}

func (x *StructuredMessage) GetMessageKey() string {
	if x != nil {
		return x.MessageKey
	}
	return ""
}

func (x *StructuredMessage) GetParameters() []*StructuredMessage_Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// A structured message reporting an autoscaling decision made by the Dataflow
// service.
type AutoscalingEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current number of workers the job has.
	CurrentNumWorkers int64 `protobuf:"varint,1,opt,name=current_num_workers,json=currentNumWorkers,proto3" json:"current_num_workers,omitempty"`
	// The target number of workers the worker pool wants to resize to use.
	TargetNumWorkers int64 `protobuf:"varint,2,opt,name=target_num_workers,json=targetNumWorkers,proto3" json:"target_num_workers,omitempty"`
	// The type of autoscaling event to report.
	EventType AutoscalingEvent_AutoscalingEventType `protobuf:"varint,3,opt,name=event_type,json=eventType,proto3,enum=google.dataflow.v1beta3.AutoscalingEvent_AutoscalingEventType" json:"event_type,omitempty"`
	// A message describing why the system decided to adjust the current
	// number of workers, why it failed, or why the system decided to
	// not make any changes to the number of workers.
	Description *StructuredMessage `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// The time this event was emitted to indicate a new target or current
	// num_workers value.
	Time *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=time,proto3" json:"time,omitempty"`
	// A short and friendly name for the worker pool this event refers to.
	WorkerPool string `protobuf:"bytes,7,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
}

func (x *AutoscalingEvent) Reset() {
	*x = AutoscalingEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_messages_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalingEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingEvent) ProtoMessage() {}

func (x *AutoscalingEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_messages_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingEvent.ProtoReflect.Descriptor instead.
func (*AutoscalingEvent) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_messages_proto_rawDescGZIP(), []int{2}
}

func (x *AutoscalingEvent) GetCurrentNumWorkers() int64 {
	if x != nil {
		return x.CurrentNumWorkers
	}
	return 0
}

func (x *AutoscalingEvent) GetTargetNumWorkers() int64 {
	if x != nil {
		return x.TargetNumWorkers
	}
	return 0
}

func (x *AutoscalingEvent) GetEventType() AutoscalingEvent_AutoscalingEventType {
	if x != nil {
		return x.EventType
	}
	return AutoscalingEvent_TYPE_UNKNOWN
}

func (x *AutoscalingEvent) GetDescription() *StructuredMessage {
	if x != nil {
		return x.Description
	}
	return nil
}

func (x *AutoscalingEvent) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *AutoscalingEvent) GetWorkerPool() string {
	if x != nil {
		return x.WorkerPool
	}
	return ""
}

// Request to list job messages.
// Up to max_results messages will be returned in the time range specified
// starting with the oldest messages first. If no time range is specified
// the results with start with the oldest message.
type ListJobMessagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A project id.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The job to get messages about.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Filter to only get messages with importance >= level
	MinimumImportance JobMessageImportance `protobuf:"varint,3,opt,name=minimum_importance,json=minimumImportance,proto3,enum=google.dataflow.v1beta3.JobMessageImportance" json:"minimum_importance,omitempty"`
	// If specified, determines the maximum number of messages to
	// return.  If unspecified, the service may choose an appropriate
	// default, or may return an arbitrarily large number of results.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If supplied, this should be the value of next_page_token returned
	// by an earlier call. This will cause the next page of results to
	// be returned.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// If specified, return only messages with timestamps >= start_time.
	// The default is the job creation time (i.e. beginning of messages).
	StartTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Return only messages with timestamps < end_time. The default is now
	// (i.e. return up to the latest messages available).
	EndTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
	// contains the job specified by job_id.
	Location string `protobuf:"bytes,8,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *ListJobMessagesRequest) Reset() {
	*x = ListJobMessagesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_messages_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobMessagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobMessagesRequest) ProtoMessage() {}

func (x *ListJobMessagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_messages_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobMessagesRequest.ProtoReflect.Descriptor instead.
func (*ListJobMessagesRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_messages_proto_rawDescGZIP(), []int{3}
}

func (x *ListJobMessagesRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListJobMessagesRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *ListJobMessagesRequest) GetMinimumImportance() JobMessageImportance {
	if x != nil {
		return x.MinimumImportance
	}
	return JobMessageImportance_JOB_MESSAGE_IMPORTANCE_UNKNOWN
}

func (x *ListJobMessagesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListJobMessagesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListJobMessagesRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ListJobMessagesRequest) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ListJobMessagesRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Response to a request to list job messages.
type ListJobMessagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Messages in ascending timestamp order.
	JobMessages []*JobMessage `protobuf:"bytes,1,rep,name=job_messages,json=jobMessages,proto3" json:"job_messages,omitempty"`
	// The token to obtain the next page of results if there are more.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Autoscaling events in ascending timestamp order.
	AutoscalingEvents []*AutoscalingEvent `protobuf:"bytes,3,rep,name=autoscaling_events,json=autoscalingEvents,proto3" json:"autoscaling_events,omitempty"`
}

func (x *ListJobMessagesResponse) Reset() {
	*x = ListJobMessagesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_messages_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListJobMessagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListJobMessagesResponse) ProtoMessage() {}

func (x *ListJobMessagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_messages_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListJobMessagesResponse.ProtoReflect.Descriptor instead.
func (*ListJobMessagesResponse) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_messages_proto_rawDescGZIP(), []int{4}
}

func (x *ListJobMessagesResponse) GetJobMessages() []*JobMessage {
	if x != nil {
		return x.JobMessages
	}
	return nil
}

func (x *ListJobMessagesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListJobMessagesResponse) GetAutoscalingEvents() []*AutoscalingEvent {
	if x != nil {
		return x.AutoscalingEvents
	}
	return nil
}

// Structured data associated with this message.
type StructuredMessage_Parameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key or name for this parameter.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value for this parameter.
	Value *structpb.Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *StructuredMessage_Parameter) Reset() {
	*x = StructuredMessage_Parameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_dataflow_v1beta3_messages_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredMessage_Parameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredMessage_Parameter) ProtoMessage() {}

func (x *StructuredMessage_Parameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_messages_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredMessage_Parameter.ProtoReflect.Descriptor instead.
func (*StructuredMessage_Parameter) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_messages_proto_rawDescGZIP(), []int{1, 0}
}

func (x *StructuredMessage_Parameter) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *StructuredMessage_Parameter) GetValue() *structpb.Value {
	if x != nil {
		return x.Value
	}
	return nil
}

var File_google_dataflow_v1beta3_messages_proto protoreflect.FileDescriptor

var file_google_dataflow_v1beta3_messages_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcd, 0x01, 0x0a, 0x0a, 0x4a, 0x6f, 0x62, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x65, 0x78, 0x74, 0x12, 0x5c, 0x0a, 0x12, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x11, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xfa, 0x01, 0x0a, 0x11, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x65, 0x78, 0x74,
	0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4b, 0x65,
	0x79, 0x12, 0x54, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x0a, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x4b, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x80, 0x04, 0x0a, 0x10, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4e,
	0x75, 0x6d, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4e, 0x75, 0x6d,
	0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x12, 0x5d, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04,
	0x74, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70,
	0x6f, 0x6f, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x8f, 0x01, 0x0a, 0x14, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10,
	0x0a, 0x0c, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00,
	0x12, 0x1e, 0x0a, 0x1a, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x4e, 0x55, 0x4d, 0x5f, 0x57,
	0x4f, 0x52, 0x4b, 0x45, 0x52, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x54, 0x5f, 0x4e, 0x55, 0x4d, 0x5f,
	0x57, 0x4f, 0x52, 0x4b, 0x45, 0x52, 0x53, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10,
	0x02, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x43, 0x54, 0x55, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46,
	0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x5f, 0x43,
	0x48, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x04, 0x22, 0xf6, 0x02, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74,
	0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x64, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x5c, 0x0a, 0x12, 0x6d, 0x69, 0x6e, 0x69,
	0x6d, 0x75, 0x6d, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a,
	0x6f, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x11, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xe3, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x0c,
	0x6a, 0x6f, 0x62, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0b, 0x6a, 0x6f, 0x62, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x58, 0x0a, 0x12,
	0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2a, 0xb2, 0x01, 0x0a, 0x14, 0x4a, 0x6f, 0x62, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x22, 0x0a, 0x1e, 0x4a, 0x4f, 0x42, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x49,
	0x4d, 0x50, 0x4f, 0x52, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4a, 0x4f, 0x42, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41,
	0x47, 0x45, 0x5f, 0x44, 0x45, 0x42, 0x55, 0x47, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x4a, 0x4f,
	0x42, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x44, 0x45, 0x54, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x4a, 0x4f, 0x42, 0x5f, 0x4d, 0x45, 0x53, 0x53,
	0x41, 0x47, 0x45, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x05, 0x12, 0x17, 0x0a, 0x13, 0x4a,
	0x4f, 0x42, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x57, 0x41, 0x52, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x4a, 0x4f, 0x42, 0x5f, 0x4d, 0x45, 0x53, 0x53,
	0x41, 0x47, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x32, 0xe7, 0x03, 0x0a, 0x0f,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x33, 0x12,
	0xfc, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x85, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7f, 0x5a,
	0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6a,
	0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f,
	0x62, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x1a, 0xd4,
	0x01, 0xca, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0xb6, 0x01, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x72, 0x65,
	0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x69, 0x6e, 0x66, 0x6f, 0x2e,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x42, 0xd0, 0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x42, 0x0d, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6c, 0x6f, 0x77, 0x70, 0x62, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x56, 0x31,
	0x42, 0x65, 0x74, 0x61, 0x33, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x5c, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_dataflow_v1beta3_messages_proto_rawDescOnce sync.Once
	file_google_dataflow_v1beta3_messages_proto_rawDescData = file_google_dataflow_v1beta3_messages_proto_rawDesc
)

func file_google_dataflow_v1beta3_messages_proto_rawDescGZIP() []byte {
	file_google_dataflow_v1beta3_messages_proto_rawDescOnce.Do(func() {
		file_google_dataflow_v1beta3_messages_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_dataflow_v1beta3_messages_proto_rawDescData)
	})
	return file_google_dataflow_v1beta3_messages_proto_rawDescData
}

var file_google_dataflow_v1beta3_messages_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_dataflow_v1beta3_messages_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_dataflow_v1beta3_messages_proto_goTypes = []interface{}{
	(JobMessageImportance)(0),                  // 0: google.dataflow.v1beta3.JobMessageImportance
	(AutoscalingEvent_AutoscalingEventType)(0), // 1: google.dataflow.v1beta3.AutoscalingEvent.AutoscalingEventType
	(*JobMessage)(nil),                         // 2: google.dataflow.v1beta3.JobMessage
	(*StructuredMessage)(nil),                  // 3: google.dataflow.v1beta3.StructuredMessage
	(*AutoscalingEvent)(nil),                   // 4: google.dataflow.v1beta3.AutoscalingEvent
	(*ListJobMessagesRequest)(nil),             // 5: google.dataflow.v1beta3.ListJobMessagesRequest
	(*ListJobMessagesResponse)(nil),            // 6: google.dataflow.v1beta3.ListJobMessagesResponse
	(*StructuredMessage_Parameter)(nil),        // 7: google.dataflow.v1beta3.StructuredMessage.Parameter
	(*timestamppb.Timestamp)(nil),              // 8: google.protobuf.Timestamp
	(*structpb.Value)(nil),                     // 9: google.protobuf.Value
}
var file_google_dataflow_v1beta3_messages_proto_depIdxs = []int32{
	8,  // 0: google.dataflow.v1beta3.JobMessage.time:type_name -> google.protobuf.Timestamp
	0,  // 1: google.dataflow.v1beta3.JobMessage.message_importance:type_name -> google.dataflow.v1beta3.JobMessageImportance
	7,  // 2: google.dataflow.v1beta3.StructuredMessage.parameters:type_name -> google.dataflow.v1beta3.StructuredMessage.Parameter
	1,  // 3: google.dataflow.v1beta3.AutoscalingEvent.event_type:type_name -> google.dataflow.v1beta3.AutoscalingEvent.AutoscalingEventType
	3,  // 4: google.dataflow.v1beta3.AutoscalingEvent.description:type_name -> google.dataflow.v1beta3.StructuredMessage
	8,  // 5: google.dataflow.v1beta3.AutoscalingEvent.time:type_name -> google.protobuf.Timestamp
	0,  // 6: google.dataflow.v1beta3.ListJobMessagesRequest.minimum_importance:type_name -> google.dataflow.v1beta3.JobMessageImportance
	8,  // 7: google.dataflow.v1beta3.ListJobMessagesRequest.start_time:type_name -> google.protobuf.Timestamp
	8,  // 8: google.dataflow.v1beta3.ListJobMessagesRequest.end_time:type_name -> google.protobuf.Timestamp
	2,  // 9: google.dataflow.v1beta3.ListJobMessagesResponse.job_messages:type_name -> google.dataflow.v1beta3.JobMessage
	4,  // 10: google.dataflow.v1beta3.ListJobMessagesResponse.autoscaling_events:type_name -> google.dataflow.v1beta3.AutoscalingEvent
	9,  // 11: google.dataflow.v1beta3.StructuredMessage.Parameter.value:type_name -> google.protobuf.Value
	5,  // 12: google.dataflow.v1beta3.MessagesV1Beta3.ListJobMessages:input_type -> google.dataflow.v1beta3.ListJobMessagesRequest
	6,  // 13: google.dataflow.v1beta3.MessagesV1Beta3.ListJobMessages:output_type -> google.dataflow.v1beta3.ListJobMessagesResponse
	13, // [13:14] is the sub-list for method output_type
	12, // [12:13] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_dataflow_v1beta3_messages_proto_init() }
func file_google_dataflow_v1beta3_messages_proto_init() {
	if File_google_dataflow_v1beta3_messages_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_dataflow_v1beta3_messages_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_messages_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_messages_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoscalingEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_messages_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobMessagesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_messages_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListJobMessagesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_dataflow_v1beta3_messages_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredMessage_Parameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_dataflow_v1beta3_messages_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_dataflow_v1beta3_messages_proto_goTypes,
		DependencyIndexes: file_google_dataflow_v1beta3_messages_proto_depIdxs,
		EnumInfos:         file_google_dataflow_v1beta3_messages_proto_enumTypes,
		MessageInfos:      file_google_dataflow_v1beta3_messages_proto_msgTypes,
	}.Build()
	File_google_dataflow_v1beta3_messages_proto = out.File
	file_google_dataflow_v1beta3_messages_proto_rawDesc = nil
	file_google_dataflow_v1beta3_messages_proto_goTypes = nil
	file_google_dataflow_v1beta3_messages_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MessagesV1Beta3Client is the client API for MessagesV1Beta3 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MessagesV1Beta3Client interface {
	// Request the job status.
	//
	// To request the status of a job, we recommend using
	// `projects.locations.jobs.messages.list` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.messages.list` is not recommended, as you can only request
	// the status of jobs that are running in `us-central1`.
	ListJobMessages(ctx context.Context, in *ListJobMessagesRequest, opts ...grpc.CallOption) (*ListJobMessagesResponse, error)
}

type messagesV1Beta3Client struct {
	cc grpc.ClientConnInterface
}

func NewMessagesV1Beta3Client(cc grpc.ClientConnInterface) MessagesV1Beta3Client {
	return &messagesV1Beta3Client{cc}
}

func (c *messagesV1Beta3Client) ListJobMessages(ctx context.Context, in *ListJobMessagesRequest, opts ...grpc.CallOption) (*ListJobMessagesResponse, error) {
	out := new(ListJobMessagesResponse)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.MessagesV1Beta3/ListJobMessages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MessagesV1Beta3Server is the server API for MessagesV1Beta3 service.
type MessagesV1Beta3Server interface {
	// Request the job status.
	//
	// To request the status of a job, we recommend using
	// `projects.locations.jobs.messages.list` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.messages.list` is not recommended, as you can only request
	// the status of jobs that are running in `us-central1`.
	ListJobMessages(context.Context, *ListJobMessagesRequest) (*ListJobMessagesResponse, error)
}

// UnimplementedMessagesV1Beta3Server can be embedded to have forward compatible implementations.
type UnimplementedMessagesV1Beta3Server struct {
}

func (*UnimplementedMessagesV1Beta3Server) ListJobMessages(context.Context, *ListJobMessagesRequest) (*ListJobMessagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobMessages not implemented")
}

func RegisterMessagesV1Beta3Server(s *grpc.Server, srv MessagesV1Beta3Server) {
	s.RegisterService(&_MessagesV1Beta3_serviceDesc, srv)
}

func _MessagesV1Beta3_ListJobMessages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobMessagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagesV1Beta3Server).ListJobMessages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.MessagesV1Beta3/ListJobMessages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagesV1Beta3Server).ListJobMessages(ctx, req.(*ListJobMessagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MessagesV1Beta3_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.dataflow.v1beta3.MessagesV1Beta3",
	HandlerType: (*MessagesV1Beta3Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListJobMessages",
			Handler:    _MessagesV1Beta3_ListJobMessages_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/dataflow/v1beta3/messages.proto",
}
