// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotfleethub

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationRequest method.
//    req, resp := client.CreateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/CreateApplication
func (c *IoTFleetHub) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for AWS IoT Fleet Hub.
//
// Creates a Fleet Hub for AWS IoT Device Management web application.
//
// Fleet Hub for AWS IoT Device Management is in public preview and is subject
// to change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Fleet Hub's
// API operation CreateApplication for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
//   * LimitExceededException
//   A limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/CreateApplication
func (c *IoTFleetHub) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetHub) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationRequest method.
//    req, resp := client.DeleteApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/DeleteApplication
func (c *IoTFleetHub) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplication API operation for AWS IoT Fleet Hub.
//
// Deletes a Fleet Hub for AWS IoT Device Management web application.
//
// Fleet Hub for AWS IoT Device Management is in public preview and is subject
// to change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Fleet Hub's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/DeleteApplication
func (c *IoTFleetHub) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetHub) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplication = "DescribeApplication"

// DescribeApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplication for more information on using the DescribeApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeApplicationRequest method.
//    req, resp := client.DescribeApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/DescribeApplication
func (c *IoTFleetHub) DescribeApplicationRequest(input *DescribeApplicationInput) (req *request.Request, output *DescribeApplicationOutput) {
	op := &request.Operation{
		Name:       opDescribeApplication,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &DescribeApplicationInput{}
	}

	output = &DescribeApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplication API operation for AWS IoT Fleet Hub.
//
// Gets information about a Fleet Hub for AWS IoT Device Management web application.
//
// Fleet Hub for AWS IoT Device Management is in public preview and is subject
// to change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Fleet Hub's
// API operation DescribeApplication for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/DescribeApplication
func (c *IoTFleetHub) DescribeApplication(input *DescribeApplicationInput) (*DescribeApplicationOutput, error) {
	req, out := c.DescribeApplicationRequest(input)
	return out, req.Send()
}

// DescribeApplicationWithContext is the same as DescribeApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetHub) DescribeApplicationWithContext(ctx aws.Context, input *DescribeApplicationInput, opts ...request.Option) (*DescribeApplicationOutput, error) {
	req, out := c.DescribeApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationsRequest method.
//    req, resp := client.ListApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/ListApplications
func (c *IoTFleetHub) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "GET",
		HTTPPath:   "/applications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for AWS IoT Fleet Hub.
//
// Gets a list of Fleet Hub for AWS IoT Device Management web applications for
// the current account.
//
// Fleet Hub for AWS IoT Device Management is in public preview and is subject
// to change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Fleet Hub's
// API operation ListApplications for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/ListApplications
func (c *IoTFleetHub) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetHub) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplications operation.
//    pageNum := 0
//    err := client.ListApplicationsPages(params,
//        func(page *iotfleethub.ListApplicationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTFleetHub) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetHub) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/ListTagsForResource
func (c *IoTFleetHub) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT Fleet Hub.
//
// Lists the tags for the specified resource.
//
// Fleet Hub for AWS IoT Device Management is in public preview and is subject
// to change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Fleet Hub's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/ListTagsForResource
func (c *IoTFleetHub) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetHub) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/TagResource
func (c *IoTFleetHub) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS IoT Fleet Hub.
//
// Adds to or modifies the tags of the specified resource. Tags are metadata
// which can be used to manage a resource.
//
// Fleet Hub for AWS IoT Device Management is in public preview and is subject
// to change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Fleet Hub's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/TagResource
func (c *IoTFleetHub) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetHub) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/UntagResource
func (c *IoTFleetHub) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS IoT Fleet Hub.
//
// Removes the specified tags (metadata) from the resource.
//
// Fleet Hub for AWS IoT Device Management is in public preview and is subject
// to change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Fleet Hub's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/UntagResource
func (c *IoTFleetHub) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetHub) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationRequest method.
//    req, resp := client.UpdateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/UpdateApplication
func (c *IoTFleetHub) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "PATCH",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateApplication API operation for AWS IoT Fleet Hub.
//
// Updates information about a Fleet Hub for a AWS IoT Device Management web
// application.
//
// Fleet Hub for AWS IoT Device Management is in public preview and is subject
// to change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Fleet Hub's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InternalFailureException
//   An unexpected error has occurred.
//
//   * ConflictException
//   The request conflicts with the current state of the resource.
//
//   * ThrottlingException
//   The rate exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotfleethub-2020-11-03/UpdateApplication
func (c *IoTFleetHub) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTFleetHub) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A summary of information about a AWS IoT Device Management web application.
//
// Fleet Hub for AWS IoT Device Management is in public preview and is subject
// to change.
type ApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The date (in Unix epoch time) when the web application was created.
	ApplicationCreationDate *int64 `locationName:"applicationCreationDate" type:"long"`

	// An optional description of the web application.
	ApplicationDescription *string `locationName:"applicationDescription" min:"1" type:"string"`

	// The unique Id of the web application.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The date (in Unix epoch time) when the web application was last updated.
	ApplicationLastUpdateDate *int64 `locationName:"applicationLastUpdateDate" type:"long"`

	// The name of the web application.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// The current state of the web application.
	ApplicationState *string `locationName:"applicationState" type:"string" enum:"ApplicationState"`

	// The URL of the web application.
	//
	// ApplicationUrl is a required field
	ApplicationUrl *string `locationName:"applicationUrl" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) GoString() string {
	return s.String()
}

// SetApplicationCreationDate sets the ApplicationCreationDate field's value.
func (s *ApplicationSummary) SetApplicationCreationDate(v int64) *ApplicationSummary {
	s.ApplicationCreationDate = &v
	return s
}

// SetApplicationDescription sets the ApplicationDescription field's value.
func (s *ApplicationSummary) SetApplicationDescription(v string) *ApplicationSummary {
	s.ApplicationDescription = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ApplicationSummary) SetApplicationId(v string) *ApplicationSummary {
	s.ApplicationId = &v
	return s
}

// SetApplicationLastUpdateDate sets the ApplicationLastUpdateDate field's value.
func (s *ApplicationSummary) SetApplicationLastUpdateDate(v int64) *ApplicationSummary {
	s.ApplicationLastUpdateDate = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ApplicationSummary) SetApplicationName(v string) *ApplicationSummary {
	s.ApplicationName = &v
	return s
}

// SetApplicationState sets the ApplicationState field's value.
func (s *ApplicationSummary) SetApplicationState(v string) *ApplicationSummary {
	s.ApplicationState = &v
	return s
}

// SetApplicationUrl sets the ApplicationUrl field's value.
func (s *ApplicationSummary) SetApplicationUrl(v string) *ApplicationSummary {
	s.ApplicationUrl = &v
	return s
}

// The request conflicts with the current state of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// An optional description of the web application.
	ApplicationDescription *string `locationName:"applicationDescription" min:"1" type:"string"`

	// The name of the web application.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ARN of the role that the web application assumes when it interacts with
	// AWS IoT Core.
	//
	// The name of the role must be in the form AWSIotFleetHub_random_string .
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// A set of key/value pairs that you can use to manage the web application resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.ApplicationDescription != nil && len(*s.ApplicationDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationDescription", 1))
	}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationDescription sets the ApplicationDescription field's value.
func (s *CreateApplicationInput) SetApplicationDescription(v string) *CreateApplicationInput {
	s.ApplicationDescription = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *CreateApplicationInput) SetApplicationName(v string) *CreateApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateApplicationInput) SetClientToken(v string) *CreateApplicationInput {
	s.ClientToken = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateApplicationInput) SetRoleArn(v string) *CreateApplicationInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInput) SetTags(v map[string]*string) *CreateApplicationInput {
	s.Tags = v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the web application.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `locationName:"applicationArn" min:"1" type:"string" required:"true"`

	// The unique Id of the web application.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *CreateApplicationOutput) SetApplicationArn(v string) *CreateApplicationOutput {
	s.ApplicationArn = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateApplicationOutput) SetApplicationId(v string) *CreateApplicationOutput {
	s.ApplicationId = &v
	return s
}

type DeleteApplicationInput struct {
	_ struct{} `type:"structure"`

	// The unique Id of the web application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApplicationInput) SetApplicationId(v string) *DeleteApplicationInput {
	s.ApplicationId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteApplicationInput) SetClientToken(v string) *DeleteApplicationInput {
	s.ClientToken = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

type DescribeApplicationInput struct {
	_ struct{} `type:"structure"`

	// The unique Id of the web application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DescribeApplicationInput) SetApplicationId(v string) *DescribeApplicationInput {
	s.ApplicationId = &v
	return s
}

type DescribeApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the web application.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `locationName:"applicationArn" min:"1" type:"string" required:"true"`

	// The date (in Unix epoch time) when the application was created.
	//
	// ApplicationCreationDate is a required field
	ApplicationCreationDate *int64 `locationName:"applicationCreationDate" type:"long" required:"true"`

	// An optional description of the web application.
	ApplicationDescription *string `locationName:"applicationDescription" min:"1" type:"string"`

	// The unique Id of the web application.
	//
	// ApplicationId is a required field
	ApplicationId *string `locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The date (in Unix epoch time) when the application was last updated.
	//
	// ApplicationLastUpdateDate is a required field
	ApplicationLastUpdateDate *int64 `locationName:"applicationLastUpdateDate" type:"long" required:"true"`

	// The name of the web application.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// The current state of the web application.
	//
	// ApplicationState is a required field
	ApplicationState *string `locationName:"applicationState" type:"string" required:"true" enum:"ApplicationState"`

	// The URL of the web application.
	//
	// ApplicationUrl is a required field
	ApplicationUrl *string `locationName:"applicationUrl" min:"1" type:"string" required:"true"`

	// A message indicating why the DescribeApplication API failed.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The ARN of the role that the web application assumes when it interacts with
	// AWS IoT Core.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// The Id of the single sign-on client that you use to authenticate and authorize
	// users on the web application.
	SsoClientId *string `locationName:"ssoClientId" type:"string"`

	// A set of key/value pairs that you can use to manage the web application resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *DescribeApplicationOutput) SetApplicationArn(v string) *DescribeApplicationOutput {
	s.ApplicationArn = &v
	return s
}

// SetApplicationCreationDate sets the ApplicationCreationDate field's value.
func (s *DescribeApplicationOutput) SetApplicationCreationDate(v int64) *DescribeApplicationOutput {
	s.ApplicationCreationDate = &v
	return s
}

// SetApplicationDescription sets the ApplicationDescription field's value.
func (s *DescribeApplicationOutput) SetApplicationDescription(v string) *DescribeApplicationOutput {
	s.ApplicationDescription = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DescribeApplicationOutput) SetApplicationId(v string) *DescribeApplicationOutput {
	s.ApplicationId = &v
	return s
}

// SetApplicationLastUpdateDate sets the ApplicationLastUpdateDate field's value.
func (s *DescribeApplicationOutput) SetApplicationLastUpdateDate(v int64) *DescribeApplicationOutput {
	s.ApplicationLastUpdateDate = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DescribeApplicationOutput) SetApplicationName(v string) *DescribeApplicationOutput {
	s.ApplicationName = &v
	return s
}

// SetApplicationState sets the ApplicationState field's value.
func (s *DescribeApplicationOutput) SetApplicationState(v string) *DescribeApplicationOutput {
	s.ApplicationState = &v
	return s
}

// SetApplicationUrl sets the ApplicationUrl field's value.
func (s *DescribeApplicationOutput) SetApplicationUrl(v string) *DescribeApplicationOutput {
	s.ApplicationUrl = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeApplicationOutput) SetErrorMessage(v string) *DescribeApplicationOutput {
	s.ErrorMessage = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeApplicationOutput) SetRoleArn(v string) *DescribeApplicationOutput {
	s.RoleArn = &v
	return s
}

// SetSsoClientId sets the SsoClientId field's value.
func (s *DescribeApplicationOutput) SetSsoClientId(v string) *DescribeApplicationOutput {
	s.SsoClientId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeApplicationOutput) SetTags(v map[string]*string) *DescribeApplicationOutput {
	s.Tags = v
	return s
}

// An unexpected error has occurred.
type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is not valid.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A limit has been exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure"`

	// A token used to get the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that provide summaries of information about the web applications
	// in the list.
	ApplicationSummaries []*ApplicationSummary `locationName:"applicationSummaries" type:"list"`

	// A token used to get the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplicationSummaries sets the ApplicationSummaries field's value.
func (s *ListApplicationsOutput) SetApplicationSummaries(v []*ApplicationSummary) *ListApplicationsOutput {
	s.ApplicationSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags assigned to the resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The specified resource does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The new or modified tags for the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The rate exceeds the limit.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A list of the keys of the tags to be removed from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// An optional description of the web application.
	ApplicationDescription *string `locationName:"applicationDescription" min:"1" type:"string"`

	// The unique Id of the web application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The name of the web application.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.ApplicationDescription != nil && len(*s.ApplicationDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationDescription", 1))
	}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationDescription sets the ApplicationDescription field's value.
func (s *UpdateApplicationInput) SetApplicationDescription(v string) *UpdateApplicationInput {
	s.ApplicationDescription = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApplicationInput) SetApplicationId(v string) *UpdateApplicationInput {
	s.ApplicationId = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *UpdateApplicationInput) SetApplicationName(v string) *UpdateApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateApplicationInput) SetClientToken(v string) *UpdateApplicationInput {
	s.ClientToken = &v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

const (
	// ApplicationStateCreating is a ApplicationState enum value
	ApplicationStateCreating = "CREATING"

	// ApplicationStateDeleting is a ApplicationState enum value
	ApplicationStateDeleting = "DELETING"

	// ApplicationStateActive is a ApplicationState enum value
	ApplicationStateActive = "ACTIVE"

	// ApplicationStateCreateFailed is a ApplicationState enum value
	ApplicationStateCreateFailed = "CREATE_FAILED"

	// ApplicationStateDeleteFailed is a ApplicationState enum value
	ApplicationStateDeleteFailed = "DELETE_FAILED"
)

// ApplicationState_Values returns all elements of the ApplicationState enum
func ApplicationState_Values() []string {
	return []string{
		ApplicationStateCreating,
		ApplicationStateDeleting,
		ApplicationStateActive,
		ApplicationStateCreateFailed,
		ApplicationStateDeleteFailed,
	}
}
