// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/datalabeling/v1beta1/data_labeling_service.proto

package datalabelingpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataLabelingService_CreateDataset_FullMethodName            = "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateDataset"
	DataLabelingService_GetDataset_FullMethodName               = "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetDataset"
	DataLabelingService_ListDatasets_FullMethodName             = "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListDatasets"
	DataLabelingService_DeleteDataset_FullMethodName            = "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteDataset"
	DataLabelingService_ImportData_FullMethodName               = "/google.cloud.datalabeling.v1beta1.DataLabelingService/ImportData"
	DataLabelingService_ExportData_FullMethodName               = "/google.cloud.datalabeling.v1beta1.DataLabelingService/ExportData"
	DataLabelingService_GetDataItem_FullMethodName              = "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetDataItem"
	DataLabelingService_ListDataItems_FullMethodName            = "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListDataItems"
	DataLabelingService_GetAnnotatedDataset_FullMethodName      = "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetAnnotatedDataset"
	DataLabelingService_ListAnnotatedDatasets_FullMethodName    = "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListAnnotatedDatasets"
	DataLabelingService_DeleteAnnotatedDataset_FullMethodName   = "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteAnnotatedDataset"
	DataLabelingService_LabelImage_FullMethodName               = "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelImage"
	DataLabelingService_LabelVideo_FullMethodName               = "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelVideo"
	DataLabelingService_LabelText_FullMethodName                = "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelText"
	DataLabelingService_GetExample_FullMethodName               = "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetExample"
	DataLabelingService_ListExamples_FullMethodName             = "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListExamples"
	DataLabelingService_CreateAnnotationSpecSet_FullMethodName  = "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateAnnotationSpecSet"
	DataLabelingService_GetAnnotationSpecSet_FullMethodName     = "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetAnnotationSpecSet"
	DataLabelingService_ListAnnotationSpecSets_FullMethodName   = "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListAnnotationSpecSets"
	DataLabelingService_DeleteAnnotationSpecSet_FullMethodName  = "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteAnnotationSpecSet"
	DataLabelingService_CreateInstruction_FullMethodName        = "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateInstruction"
	DataLabelingService_GetInstruction_FullMethodName           = "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetInstruction"
	DataLabelingService_ListInstructions_FullMethodName         = "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListInstructions"
	DataLabelingService_DeleteInstruction_FullMethodName        = "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteInstruction"
	DataLabelingService_GetEvaluation_FullMethodName            = "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetEvaluation"
	DataLabelingService_SearchEvaluations_FullMethodName        = "/google.cloud.datalabeling.v1beta1.DataLabelingService/SearchEvaluations"
	DataLabelingService_SearchExampleComparisons_FullMethodName = "/google.cloud.datalabeling.v1beta1.DataLabelingService/SearchExampleComparisons"
	DataLabelingService_CreateEvaluationJob_FullMethodName      = "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateEvaluationJob"
	DataLabelingService_UpdateEvaluationJob_FullMethodName      = "/google.cloud.datalabeling.v1beta1.DataLabelingService/UpdateEvaluationJob"
	DataLabelingService_GetEvaluationJob_FullMethodName         = "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetEvaluationJob"
	DataLabelingService_PauseEvaluationJob_FullMethodName       = "/google.cloud.datalabeling.v1beta1.DataLabelingService/PauseEvaluationJob"
	DataLabelingService_ResumeEvaluationJob_FullMethodName      = "/google.cloud.datalabeling.v1beta1.DataLabelingService/ResumeEvaluationJob"
	DataLabelingService_DeleteEvaluationJob_FullMethodName      = "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteEvaluationJob"
	DataLabelingService_ListEvaluationJobs_FullMethodName       = "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListEvaluationJobs"
)

// DataLabelingServiceClient is the client API for DataLabelingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DataLabelingServiceClient interface {
	// Creates dataset. If success return a Dataset resource.
	CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Gets dataset by resource name.
	GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Lists datasets under a project. Pagination is supported.
	ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error)
	// Deletes a dataset by resource name.
	DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Imports data into dataset based on source locations defined in request.
	// It can be called multiple times for the same dataset. Each dataset can
	// only have one long running operation running on it. For example, no
	// labeling task (also long running operation) can be started while
	// importing is still ongoing. Vice versa.
	ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports data and annotations from dataset.
	ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a data item in a dataset by resource name. This API can be
	// called after data are imported into dataset.
	GetDataItem(ctx context.Context, in *GetDataItemRequest, opts ...grpc.CallOption) (*DataItem, error)
	// Lists data items in a dataset. This API can be called after data
	// are imported into dataset. Pagination is supported.
	ListDataItems(ctx context.Context, in *ListDataItemsRequest, opts ...grpc.CallOption) (*ListDataItemsResponse, error)
	// Gets an annotated dataset by resource name.
	GetAnnotatedDataset(ctx context.Context, in *GetAnnotatedDatasetRequest, opts ...grpc.CallOption) (*AnnotatedDataset, error)
	// Lists annotated datasets for a dataset. Pagination is supported.
	ListAnnotatedDatasets(ctx context.Context, in *ListAnnotatedDatasetsRequest, opts ...grpc.CallOption) (*ListAnnotatedDatasetsResponse, error)
	// Deletes an annotated dataset by resource name.
	DeleteAnnotatedDataset(ctx context.Context, in *DeleteAnnotatedDatasetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Starts a labeling task for image. The type of image labeling task is
	// configured by feature in the request.
	LabelImage(ctx context.Context, in *LabelImageRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts a labeling task for video. The type of video labeling task is
	// configured by feature in the request.
	LabelVideo(ctx context.Context, in *LabelVideoRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts a labeling task for text. The type of text labeling task is
	// configured by feature in the request.
	LabelText(ctx context.Context, in *LabelTextRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an example by resource name, including both data and annotation.
	GetExample(ctx context.Context, in *GetExampleRequest, opts ...grpc.CallOption) (*Example, error)
	// Lists examples in an annotated dataset. Pagination is supported.
	ListExamples(ctx context.Context, in *ListExamplesRequest, opts ...grpc.CallOption) (*ListExamplesResponse, error)
	// Creates an annotation spec set by providing a set of labels.
	CreateAnnotationSpecSet(ctx context.Context, in *CreateAnnotationSpecSetRequest, opts ...grpc.CallOption) (*AnnotationSpecSet, error)
	// Gets an annotation spec set by resource name.
	GetAnnotationSpecSet(ctx context.Context, in *GetAnnotationSpecSetRequest, opts ...grpc.CallOption) (*AnnotationSpecSet, error)
	// Lists annotation spec sets for a project. Pagination is supported.
	ListAnnotationSpecSets(ctx context.Context, in *ListAnnotationSpecSetsRequest, opts ...grpc.CallOption) (*ListAnnotationSpecSetsResponse, error)
	// Deletes an annotation spec set by resource name.
	DeleteAnnotationSpecSet(ctx context.Context, in *DeleteAnnotationSpecSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates an instruction for how data should be labeled.
	CreateInstruction(ctx context.Context, in *CreateInstructionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an instruction by resource name.
	GetInstruction(ctx context.Context, in *GetInstructionRequest, opts ...grpc.CallOption) (*Instruction, error)
	// Lists instructions for a project. Pagination is supported.
	ListInstructions(ctx context.Context, in *ListInstructionsRequest, opts ...grpc.CallOption) (*ListInstructionsResponse, error)
	// Deletes an instruction object by resource name.
	DeleteInstruction(ctx context.Context, in *DeleteInstructionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets an evaluation by resource name (to search, use
	// [projects.evaluations.search][google.cloud.datalabeling.v1beta1.DataLabelingService.SearchEvaluations]).
	GetEvaluation(ctx context.Context, in *GetEvaluationRequest, opts ...grpc.CallOption) (*Evaluation, error)
	// Searches [evaluations][google.cloud.datalabeling.v1beta1.Evaluation] within a project.
	SearchEvaluations(ctx context.Context, in *SearchEvaluationsRequest, opts ...grpc.CallOption) (*SearchEvaluationsResponse, error)
	// Searches example comparisons from an evaluation. The return format is a
	// list of example comparisons that show ground truth and prediction(s) for
	// a single input. Search by providing an evaluation ID.
	SearchExampleComparisons(ctx context.Context, in *SearchExampleComparisonsRequest, opts ...grpc.CallOption) (*SearchExampleComparisonsResponse, error)
	// Creates an evaluation job.
	CreateEvaluationJob(ctx context.Context, in *CreateEvaluationJobRequest, opts ...grpc.CallOption) (*EvaluationJob, error)
	// Updates an evaluation job. You can only update certain fields of the job's
	// [EvaluationJobConfig][google.cloud.datalabeling.v1beta1.EvaluationJobConfig]: `humanAnnotationConfig.instruction`,
	// `exampleCount`, and `exampleSamplePercentage`.
	//
	// If you want to change any other aspect of the evaluation job, you must
	// delete the job and create a new one.
	UpdateEvaluationJob(ctx context.Context, in *UpdateEvaluationJobRequest, opts ...grpc.CallOption) (*EvaluationJob, error)
	// Gets an evaluation job by resource name.
	GetEvaluationJob(ctx context.Context, in *GetEvaluationJobRequest, opts ...grpc.CallOption) (*EvaluationJob, error)
	// Pauses an evaluation job. Pausing an evaluation job that is already in a
	// `PAUSED` state is a no-op.
	PauseEvaluationJob(ctx context.Context, in *PauseEvaluationJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Resumes a paused evaluation job. A deleted evaluation job can't be resumed.
	// Resuming a running or scheduled evaluation job is a no-op.
	ResumeEvaluationJob(ctx context.Context, in *ResumeEvaluationJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Stops and deletes an evaluation job.
	DeleteEvaluationJob(ctx context.Context, in *DeleteEvaluationJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all evaluation jobs within a project with possible filters.
	// Pagination is supported.
	ListEvaluationJobs(ctx context.Context, in *ListEvaluationJobsRequest, opts ...grpc.CallOption) (*ListEvaluationJobsResponse, error)
}

type dataLabelingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDataLabelingServiceClient(cc grpc.ClientConnInterface) DataLabelingServiceClient {
	return &dataLabelingServiceClient{cc}
}

func (c *dataLabelingServiceClient) CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, DataLabelingService_CreateDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, DataLabelingService_GetDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error) {
	out := new(ListDatasetsResponse)
	err := c.cc.Invoke(ctx, DataLabelingService_ListDatasets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataLabelingService_DeleteDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataLabelingService_ImportData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataLabelingService_ExportData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetDataItem(ctx context.Context, in *GetDataItemRequest, opts ...grpc.CallOption) (*DataItem, error) {
	out := new(DataItem)
	err := c.cc.Invoke(ctx, DataLabelingService_GetDataItem_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListDataItems(ctx context.Context, in *ListDataItemsRequest, opts ...grpc.CallOption) (*ListDataItemsResponse, error) {
	out := new(ListDataItemsResponse)
	err := c.cc.Invoke(ctx, DataLabelingService_ListDataItems_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetAnnotatedDataset(ctx context.Context, in *GetAnnotatedDatasetRequest, opts ...grpc.CallOption) (*AnnotatedDataset, error) {
	out := new(AnnotatedDataset)
	err := c.cc.Invoke(ctx, DataLabelingService_GetAnnotatedDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListAnnotatedDatasets(ctx context.Context, in *ListAnnotatedDatasetsRequest, opts ...grpc.CallOption) (*ListAnnotatedDatasetsResponse, error) {
	out := new(ListAnnotatedDatasetsResponse)
	err := c.cc.Invoke(ctx, DataLabelingService_ListAnnotatedDatasets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteAnnotatedDataset(ctx context.Context, in *DeleteAnnotatedDatasetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataLabelingService_DeleteAnnotatedDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) LabelImage(ctx context.Context, in *LabelImageRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataLabelingService_LabelImage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) LabelVideo(ctx context.Context, in *LabelVideoRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataLabelingService_LabelVideo_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) LabelText(ctx context.Context, in *LabelTextRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataLabelingService_LabelText_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetExample(ctx context.Context, in *GetExampleRequest, opts ...grpc.CallOption) (*Example, error) {
	out := new(Example)
	err := c.cc.Invoke(ctx, DataLabelingService_GetExample_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListExamples(ctx context.Context, in *ListExamplesRequest, opts ...grpc.CallOption) (*ListExamplesResponse, error) {
	out := new(ListExamplesResponse)
	err := c.cc.Invoke(ctx, DataLabelingService_ListExamples_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) CreateAnnotationSpecSet(ctx context.Context, in *CreateAnnotationSpecSetRequest, opts ...grpc.CallOption) (*AnnotationSpecSet, error) {
	out := new(AnnotationSpecSet)
	err := c.cc.Invoke(ctx, DataLabelingService_CreateAnnotationSpecSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetAnnotationSpecSet(ctx context.Context, in *GetAnnotationSpecSetRequest, opts ...grpc.CallOption) (*AnnotationSpecSet, error) {
	out := new(AnnotationSpecSet)
	err := c.cc.Invoke(ctx, DataLabelingService_GetAnnotationSpecSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListAnnotationSpecSets(ctx context.Context, in *ListAnnotationSpecSetsRequest, opts ...grpc.CallOption) (*ListAnnotationSpecSetsResponse, error) {
	out := new(ListAnnotationSpecSetsResponse)
	err := c.cc.Invoke(ctx, DataLabelingService_ListAnnotationSpecSets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteAnnotationSpecSet(ctx context.Context, in *DeleteAnnotationSpecSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataLabelingService_DeleteAnnotationSpecSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) CreateInstruction(ctx context.Context, in *CreateInstructionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataLabelingService_CreateInstruction_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetInstruction(ctx context.Context, in *GetInstructionRequest, opts ...grpc.CallOption) (*Instruction, error) {
	out := new(Instruction)
	err := c.cc.Invoke(ctx, DataLabelingService_GetInstruction_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListInstructions(ctx context.Context, in *ListInstructionsRequest, opts ...grpc.CallOption) (*ListInstructionsResponse, error) {
	out := new(ListInstructionsResponse)
	err := c.cc.Invoke(ctx, DataLabelingService_ListInstructions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteInstruction(ctx context.Context, in *DeleteInstructionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataLabelingService_DeleteInstruction_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetEvaluation(ctx context.Context, in *GetEvaluationRequest, opts ...grpc.CallOption) (*Evaluation, error) {
	out := new(Evaluation)
	err := c.cc.Invoke(ctx, DataLabelingService_GetEvaluation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) SearchEvaluations(ctx context.Context, in *SearchEvaluationsRequest, opts ...grpc.CallOption) (*SearchEvaluationsResponse, error) {
	out := new(SearchEvaluationsResponse)
	err := c.cc.Invoke(ctx, DataLabelingService_SearchEvaluations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) SearchExampleComparisons(ctx context.Context, in *SearchExampleComparisonsRequest, opts ...grpc.CallOption) (*SearchExampleComparisonsResponse, error) {
	out := new(SearchExampleComparisonsResponse)
	err := c.cc.Invoke(ctx, DataLabelingService_SearchExampleComparisons_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) CreateEvaluationJob(ctx context.Context, in *CreateEvaluationJobRequest, opts ...grpc.CallOption) (*EvaluationJob, error) {
	out := new(EvaluationJob)
	err := c.cc.Invoke(ctx, DataLabelingService_CreateEvaluationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) UpdateEvaluationJob(ctx context.Context, in *UpdateEvaluationJobRequest, opts ...grpc.CallOption) (*EvaluationJob, error) {
	out := new(EvaluationJob)
	err := c.cc.Invoke(ctx, DataLabelingService_UpdateEvaluationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetEvaluationJob(ctx context.Context, in *GetEvaluationJobRequest, opts ...grpc.CallOption) (*EvaluationJob, error) {
	out := new(EvaluationJob)
	err := c.cc.Invoke(ctx, DataLabelingService_GetEvaluationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) PauseEvaluationJob(ctx context.Context, in *PauseEvaluationJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataLabelingService_PauseEvaluationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ResumeEvaluationJob(ctx context.Context, in *ResumeEvaluationJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataLabelingService_ResumeEvaluationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteEvaluationJob(ctx context.Context, in *DeleteEvaluationJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, DataLabelingService_DeleteEvaluationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListEvaluationJobs(ctx context.Context, in *ListEvaluationJobsRequest, opts ...grpc.CallOption) (*ListEvaluationJobsResponse, error) {
	out := new(ListEvaluationJobsResponse)
	err := c.cc.Invoke(ctx, DataLabelingService_ListEvaluationJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataLabelingServiceServer is the server API for DataLabelingService service.
// All implementations should embed UnimplementedDataLabelingServiceServer
// for forward compatibility
type DataLabelingServiceServer interface {
	// Creates dataset. If success return a Dataset resource.
	CreateDataset(context.Context, *CreateDatasetRequest) (*Dataset, error)
	// Gets dataset by resource name.
	GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error)
	// Lists datasets under a project. Pagination is supported.
	ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error)
	// Deletes a dataset by resource name.
	DeleteDataset(context.Context, *DeleteDatasetRequest) (*emptypb.Empty, error)
	// Imports data into dataset based on source locations defined in request.
	// It can be called multiple times for the same dataset. Each dataset can
	// only have one long running operation running on it. For example, no
	// labeling task (also long running operation) can be started while
	// importing is still ongoing. Vice versa.
	ImportData(context.Context, *ImportDataRequest) (*longrunningpb.Operation, error)
	// Exports data and annotations from dataset.
	ExportData(context.Context, *ExportDataRequest) (*longrunningpb.Operation, error)
	// Gets a data item in a dataset by resource name. This API can be
	// called after data are imported into dataset.
	GetDataItem(context.Context, *GetDataItemRequest) (*DataItem, error)
	// Lists data items in a dataset. This API can be called after data
	// are imported into dataset. Pagination is supported.
	ListDataItems(context.Context, *ListDataItemsRequest) (*ListDataItemsResponse, error)
	// Gets an annotated dataset by resource name.
	GetAnnotatedDataset(context.Context, *GetAnnotatedDatasetRequest) (*AnnotatedDataset, error)
	// Lists annotated datasets for a dataset. Pagination is supported.
	ListAnnotatedDatasets(context.Context, *ListAnnotatedDatasetsRequest) (*ListAnnotatedDatasetsResponse, error)
	// Deletes an annotated dataset by resource name.
	DeleteAnnotatedDataset(context.Context, *DeleteAnnotatedDatasetRequest) (*emptypb.Empty, error)
	// Starts a labeling task for image. The type of image labeling task is
	// configured by feature in the request.
	LabelImage(context.Context, *LabelImageRequest) (*longrunningpb.Operation, error)
	// Starts a labeling task for video. The type of video labeling task is
	// configured by feature in the request.
	LabelVideo(context.Context, *LabelVideoRequest) (*longrunningpb.Operation, error)
	// Starts a labeling task for text. The type of text labeling task is
	// configured by feature in the request.
	LabelText(context.Context, *LabelTextRequest) (*longrunningpb.Operation, error)
	// Gets an example by resource name, including both data and annotation.
	GetExample(context.Context, *GetExampleRequest) (*Example, error)
	// Lists examples in an annotated dataset. Pagination is supported.
	ListExamples(context.Context, *ListExamplesRequest) (*ListExamplesResponse, error)
	// Creates an annotation spec set by providing a set of labels.
	CreateAnnotationSpecSet(context.Context, *CreateAnnotationSpecSetRequest) (*AnnotationSpecSet, error)
	// Gets an annotation spec set by resource name.
	GetAnnotationSpecSet(context.Context, *GetAnnotationSpecSetRequest) (*AnnotationSpecSet, error)
	// Lists annotation spec sets for a project. Pagination is supported.
	ListAnnotationSpecSets(context.Context, *ListAnnotationSpecSetsRequest) (*ListAnnotationSpecSetsResponse, error)
	// Deletes an annotation spec set by resource name.
	DeleteAnnotationSpecSet(context.Context, *DeleteAnnotationSpecSetRequest) (*emptypb.Empty, error)
	// Creates an instruction for how data should be labeled.
	CreateInstruction(context.Context, *CreateInstructionRequest) (*longrunningpb.Operation, error)
	// Gets an instruction by resource name.
	GetInstruction(context.Context, *GetInstructionRequest) (*Instruction, error)
	// Lists instructions for a project. Pagination is supported.
	ListInstructions(context.Context, *ListInstructionsRequest) (*ListInstructionsResponse, error)
	// Deletes an instruction object by resource name.
	DeleteInstruction(context.Context, *DeleteInstructionRequest) (*emptypb.Empty, error)
	// Gets an evaluation by resource name (to search, use
	// [projects.evaluations.search][google.cloud.datalabeling.v1beta1.DataLabelingService.SearchEvaluations]).
	GetEvaluation(context.Context, *GetEvaluationRequest) (*Evaluation, error)
	// Searches [evaluations][google.cloud.datalabeling.v1beta1.Evaluation] within a project.
	SearchEvaluations(context.Context, *SearchEvaluationsRequest) (*SearchEvaluationsResponse, error)
	// Searches example comparisons from an evaluation. The return format is a
	// list of example comparisons that show ground truth and prediction(s) for
	// a single input. Search by providing an evaluation ID.
	SearchExampleComparisons(context.Context, *SearchExampleComparisonsRequest) (*SearchExampleComparisonsResponse, error)
	// Creates an evaluation job.
	CreateEvaluationJob(context.Context, *CreateEvaluationJobRequest) (*EvaluationJob, error)
	// Updates an evaluation job. You can only update certain fields of the job's
	// [EvaluationJobConfig][google.cloud.datalabeling.v1beta1.EvaluationJobConfig]: `humanAnnotationConfig.instruction`,
	// `exampleCount`, and `exampleSamplePercentage`.
	//
	// If you want to change any other aspect of the evaluation job, you must
	// delete the job and create a new one.
	UpdateEvaluationJob(context.Context, *UpdateEvaluationJobRequest) (*EvaluationJob, error)
	// Gets an evaluation job by resource name.
	GetEvaluationJob(context.Context, *GetEvaluationJobRequest) (*EvaluationJob, error)
	// Pauses an evaluation job. Pausing an evaluation job that is already in a
	// `PAUSED` state is a no-op.
	PauseEvaluationJob(context.Context, *PauseEvaluationJobRequest) (*emptypb.Empty, error)
	// Resumes a paused evaluation job. A deleted evaluation job can't be resumed.
	// Resuming a running or scheduled evaluation job is a no-op.
	ResumeEvaluationJob(context.Context, *ResumeEvaluationJobRequest) (*emptypb.Empty, error)
	// Stops and deletes an evaluation job.
	DeleteEvaluationJob(context.Context, *DeleteEvaluationJobRequest) (*emptypb.Empty, error)
	// Lists all evaluation jobs within a project with possible filters.
	// Pagination is supported.
	ListEvaluationJobs(context.Context, *ListEvaluationJobsRequest) (*ListEvaluationJobsResponse, error)
}

// UnimplementedDataLabelingServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDataLabelingServiceServer struct {
}

func (UnimplementedDataLabelingServiceServer) CreateDataset(context.Context, *CreateDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataset not implemented")
}
func (UnimplementedDataLabelingServiceServer) GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataset not implemented")
}
func (UnimplementedDataLabelingServiceServer) ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatasets not implemented")
}
func (UnimplementedDataLabelingServiceServer) DeleteDataset(context.Context, *DeleteDatasetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataset not implemented")
}
func (UnimplementedDataLabelingServiceServer) ImportData(context.Context, *ImportDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportData not implemented")
}
func (UnimplementedDataLabelingServiceServer) ExportData(context.Context, *ExportDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportData not implemented")
}
func (UnimplementedDataLabelingServiceServer) GetDataItem(context.Context, *GetDataItemRequest) (*DataItem, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataItem not implemented")
}
func (UnimplementedDataLabelingServiceServer) ListDataItems(context.Context, *ListDataItemsRequest) (*ListDataItemsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataItems not implemented")
}
func (UnimplementedDataLabelingServiceServer) GetAnnotatedDataset(context.Context, *GetAnnotatedDatasetRequest) (*AnnotatedDataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAnnotatedDataset not implemented")
}
func (UnimplementedDataLabelingServiceServer) ListAnnotatedDatasets(context.Context, *ListAnnotatedDatasetsRequest) (*ListAnnotatedDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnnotatedDatasets not implemented")
}
func (UnimplementedDataLabelingServiceServer) DeleteAnnotatedDataset(context.Context, *DeleteAnnotatedDatasetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAnnotatedDataset not implemented")
}
func (UnimplementedDataLabelingServiceServer) LabelImage(context.Context, *LabelImageRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LabelImage not implemented")
}
func (UnimplementedDataLabelingServiceServer) LabelVideo(context.Context, *LabelVideoRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LabelVideo not implemented")
}
func (UnimplementedDataLabelingServiceServer) LabelText(context.Context, *LabelTextRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LabelText not implemented")
}
func (UnimplementedDataLabelingServiceServer) GetExample(context.Context, *GetExampleRequest) (*Example, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExample not implemented")
}
func (UnimplementedDataLabelingServiceServer) ListExamples(context.Context, *ListExamplesRequest) (*ListExamplesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExamples not implemented")
}
func (UnimplementedDataLabelingServiceServer) CreateAnnotationSpecSet(context.Context, *CreateAnnotationSpecSetRequest) (*AnnotationSpecSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAnnotationSpecSet not implemented")
}
func (UnimplementedDataLabelingServiceServer) GetAnnotationSpecSet(context.Context, *GetAnnotationSpecSetRequest) (*AnnotationSpecSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAnnotationSpecSet not implemented")
}
func (UnimplementedDataLabelingServiceServer) ListAnnotationSpecSets(context.Context, *ListAnnotationSpecSetsRequest) (*ListAnnotationSpecSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnnotationSpecSets not implemented")
}
func (UnimplementedDataLabelingServiceServer) DeleteAnnotationSpecSet(context.Context, *DeleteAnnotationSpecSetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAnnotationSpecSet not implemented")
}
func (UnimplementedDataLabelingServiceServer) CreateInstruction(context.Context, *CreateInstructionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstruction not implemented")
}
func (UnimplementedDataLabelingServiceServer) GetInstruction(context.Context, *GetInstructionRequest) (*Instruction, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstruction not implemented")
}
func (UnimplementedDataLabelingServiceServer) ListInstructions(context.Context, *ListInstructionsRequest) (*ListInstructionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstructions not implemented")
}
func (UnimplementedDataLabelingServiceServer) DeleteInstruction(context.Context, *DeleteInstructionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstruction not implemented")
}
func (UnimplementedDataLabelingServiceServer) GetEvaluation(context.Context, *GetEvaluationRequest) (*Evaluation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEvaluation not implemented")
}
func (UnimplementedDataLabelingServiceServer) SearchEvaluations(context.Context, *SearchEvaluationsRequest) (*SearchEvaluationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchEvaluations not implemented")
}
func (UnimplementedDataLabelingServiceServer) SearchExampleComparisons(context.Context, *SearchExampleComparisonsRequest) (*SearchExampleComparisonsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchExampleComparisons not implemented")
}
func (UnimplementedDataLabelingServiceServer) CreateEvaluationJob(context.Context, *CreateEvaluationJobRequest) (*EvaluationJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEvaluationJob not implemented")
}
func (UnimplementedDataLabelingServiceServer) UpdateEvaluationJob(context.Context, *UpdateEvaluationJobRequest) (*EvaluationJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEvaluationJob not implemented")
}
func (UnimplementedDataLabelingServiceServer) GetEvaluationJob(context.Context, *GetEvaluationJobRequest) (*EvaluationJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEvaluationJob not implemented")
}
func (UnimplementedDataLabelingServiceServer) PauseEvaluationJob(context.Context, *PauseEvaluationJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseEvaluationJob not implemented")
}
func (UnimplementedDataLabelingServiceServer) ResumeEvaluationJob(context.Context, *ResumeEvaluationJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeEvaluationJob not implemented")
}
func (UnimplementedDataLabelingServiceServer) DeleteEvaluationJob(context.Context, *DeleteEvaluationJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEvaluationJob not implemented")
}
func (UnimplementedDataLabelingServiceServer) ListEvaluationJobs(context.Context, *ListEvaluationJobsRequest) (*ListEvaluationJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEvaluationJobs not implemented")
}

// UnsafeDataLabelingServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataLabelingServiceServer will
// result in compilation errors.
type UnsafeDataLabelingServiceServer interface {
	mustEmbedUnimplementedDataLabelingServiceServer()
}

func RegisterDataLabelingServiceServer(s grpc.ServiceRegistrar, srv DataLabelingServiceServer) {
	s.RegisterService(&DataLabelingService_ServiceDesc, srv)
}

func _DataLabelingService_CreateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).CreateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_CreateDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).CreateDataset(ctx, req.(*CreateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_GetDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetDataset(ctx, req.(*GetDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_ListDatasets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListDatasets(ctx, req.(*ListDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_DeleteDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteDataset(ctx, req.(*DeleteDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ImportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ImportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_ImportData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ImportData(ctx, req.(*ImportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ExportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ExportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_ExportData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ExportData(ctx, req.(*ExportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetDataItem_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataItemRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetDataItem(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_GetDataItem_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetDataItem(ctx, req.(*GetDataItemRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListDataItems_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataItemsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListDataItems(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_ListDataItems_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListDataItems(ctx, req.(*ListDataItemsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetAnnotatedDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotatedDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetAnnotatedDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_GetAnnotatedDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetAnnotatedDataset(ctx, req.(*GetAnnotatedDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListAnnotatedDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotatedDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListAnnotatedDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_ListAnnotatedDatasets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListAnnotatedDatasets(ctx, req.(*ListAnnotatedDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteAnnotatedDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnnotatedDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteAnnotatedDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_DeleteAnnotatedDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteAnnotatedDataset(ctx, req.(*DeleteAnnotatedDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_LabelImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).LabelImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_LabelImage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).LabelImage(ctx, req.(*LabelImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_LabelVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).LabelVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_LabelVideo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).LabelVideo(ctx, req.(*LabelVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_LabelText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).LabelText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_LabelText_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).LabelText(ctx, req.(*LabelTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetExample_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExampleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetExample(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_GetExample_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetExample(ctx, req.(*GetExampleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListExamples_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExamplesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListExamples(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_ListExamples_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListExamples(ctx, req.(*ListExamplesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_CreateAnnotationSpecSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnnotationSpecSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).CreateAnnotationSpecSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_CreateAnnotationSpecSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).CreateAnnotationSpecSet(ctx, req.(*CreateAnnotationSpecSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetAnnotationSpecSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationSpecSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetAnnotationSpecSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_GetAnnotationSpecSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetAnnotationSpecSet(ctx, req.(*GetAnnotationSpecSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListAnnotationSpecSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotationSpecSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListAnnotationSpecSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_ListAnnotationSpecSets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListAnnotationSpecSets(ctx, req.(*ListAnnotationSpecSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteAnnotationSpecSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnnotationSpecSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteAnnotationSpecSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_DeleteAnnotationSpecSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteAnnotationSpecSet(ctx, req.(*DeleteAnnotationSpecSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_CreateInstruction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstructionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).CreateInstruction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_CreateInstruction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).CreateInstruction(ctx, req.(*CreateInstructionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetInstruction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstructionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetInstruction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_GetInstruction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetInstruction(ctx, req.(*GetInstructionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListInstructions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstructionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListInstructions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_ListInstructions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListInstructions(ctx, req.(*ListInstructionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteInstruction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstructionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteInstruction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_DeleteInstruction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteInstruction(ctx, req.(*DeleteInstructionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_GetEvaluation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetEvaluation(ctx, req.(*GetEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_SearchEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).SearchEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_SearchEvaluations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).SearchEvaluations(ctx, req.(*SearchEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_SearchExampleComparisons_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchExampleComparisonsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).SearchExampleComparisons(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_SearchExampleComparisons_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).SearchExampleComparisons(ctx, req.(*SearchExampleComparisonsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_CreateEvaluationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEvaluationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).CreateEvaluationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_CreateEvaluationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).CreateEvaluationJob(ctx, req.(*CreateEvaluationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_UpdateEvaluationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEvaluationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).UpdateEvaluationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_UpdateEvaluationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).UpdateEvaluationJob(ctx, req.(*UpdateEvaluationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetEvaluationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEvaluationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetEvaluationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_GetEvaluationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetEvaluationJob(ctx, req.(*GetEvaluationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_PauseEvaluationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseEvaluationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).PauseEvaluationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_PauseEvaluationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).PauseEvaluationJob(ctx, req.(*PauseEvaluationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ResumeEvaluationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeEvaluationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ResumeEvaluationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_ResumeEvaluationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ResumeEvaluationJob(ctx, req.(*ResumeEvaluationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteEvaluationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEvaluationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteEvaluationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_DeleteEvaluationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteEvaluationJob(ctx, req.(*DeleteEvaluationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListEvaluationJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEvaluationJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListEvaluationJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataLabelingService_ListEvaluationJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListEvaluationJobs(ctx, req.(*ListEvaluationJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataLabelingService_ServiceDesc is the grpc.ServiceDesc for DataLabelingService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataLabelingService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datalabeling.v1beta1.DataLabelingService",
	HandlerType: (*DataLabelingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataset",
			Handler:    _DataLabelingService_CreateDataset_Handler,
		},
		{
			MethodName: "GetDataset",
			Handler:    _DataLabelingService_GetDataset_Handler,
		},
		{
			MethodName: "ListDatasets",
			Handler:    _DataLabelingService_ListDatasets_Handler,
		},
		{
			MethodName: "DeleteDataset",
			Handler:    _DataLabelingService_DeleteDataset_Handler,
		},
		{
			MethodName: "ImportData",
			Handler:    _DataLabelingService_ImportData_Handler,
		},
		{
			MethodName: "ExportData",
			Handler:    _DataLabelingService_ExportData_Handler,
		},
		{
			MethodName: "GetDataItem",
			Handler:    _DataLabelingService_GetDataItem_Handler,
		},
		{
			MethodName: "ListDataItems",
			Handler:    _DataLabelingService_ListDataItems_Handler,
		},
		{
			MethodName: "GetAnnotatedDataset",
			Handler:    _DataLabelingService_GetAnnotatedDataset_Handler,
		},
		{
			MethodName: "ListAnnotatedDatasets",
			Handler:    _DataLabelingService_ListAnnotatedDatasets_Handler,
		},
		{
			MethodName: "DeleteAnnotatedDataset",
			Handler:    _DataLabelingService_DeleteAnnotatedDataset_Handler,
		},
		{
			MethodName: "LabelImage",
			Handler:    _DataLabelingService_LabelImage_Handler,
		},
		{
			MethodName: "LabelVideo",
			Handler:    _DataLabelingService_LabelVideo_Handler,
		},
		{
			MethodName: "LabelText",
			Handler:    _DataLabelingService_LabelText_Handler,
		},
		{
			MethodName: "GetExample",
			Handler:    _DataLabelingService_GetExample_Handler,
		},
		{
			MethodName: "ListExamples",
			Handler:    _DataLabelingService_ListExamples_Handler,
		},
		{
			MethodName: "CreateAnnotationSpecSet",
			Handler:    _DataLabelingService_CreateAnnotationSpecSet_Handler,
		},
		{
			MethodName: "GetAnnotationSpecSet",
			Handler:    _DataLabelingService_GetAnnotationSpecSet_Handler,
		},
		{
			MethodName: "ListAnnotationSpecSets",
			Handler:    _DataLabelingService_ListAnnotationSpecSets_Handler,
		},
		{
			MethodName: "DeleteAnnotationSpecSet",
			Handler:    _DataLabelingService_DeleteAnnotationSpecSet_Handler,
		},
		{
			MethodName: "CreateInstruction",
			Handler:    _DataLabelingService_CreateInstruction_Handler,
		},
		{
			MethodName: "GetInstruction",
			Handler:    _DataLabelingService_GetInstruction_Handler,
		},
		{
			MethodName: "ListInstructions",
			Handler:    _DataLabelingService_ListInstructions_Handler,
		},
		{
			MethodName: "DeleteInstruction",
			Handler:    _DataLabelingService_DeleteInstruction_Handler,
		},
		{
			MethodName: "GetEvaluation",
			Handler:    _DataLabelingService_GetEvaluation_Handler,
		},
		{
			MethodName: "SearchEvaluations",
			Handler:    _DataLabelingService_SearchEvaluations_Handler,
		},
		{
			MethodName: "SearchExampleComparisons",
			Handler:    _DataLabelingService_SearchExampleComparisons_Handler,
		},
		{
			MethodName: "CreateEvaluationJob",
			Handler:    _DataLabelingService_CreateEvaluationJob_Handler,
		},
		{
			MethodName: "UpdateEvaluationJob",
			Handler:    _DataLabelingService_UpdateEvaluationJob_Handler,
		},
		{
			MethodName: "GetEvaluationJob",
			Handler:    _DataLabelingService_GetEvaluationJob_Handler,
		},
		{
			MethodName: "PauseEvaluationJob",
			Handler:    _DataLabelingService_PauseEvaluationJob_Handler,
		},
		{
			MethodName: "ResumeEvaluationJob",
			Handler:    _DataLabelingService_ResumeEvaluationJob_Handler,
		},
		{
			MethodName: "DeleteEvaluationJob",
			Handler:    _DataLabelingService_DeleteEvaluationJob_Handler,
		},
		{
			MethodName: "ListEvaluationJobs",
			Handler:    _DataLabelingService_ListEvaluationJobs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datalabeling/v1beta1/data_labeling_service.proto",
}
