//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/filter/http/compressor/v2/compressor.proto

package compressorv2

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Compressor with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Compressor) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Compressor with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in CompressorMultiError, or
// nil if none found.
func (m *Compressor) ValidateAll() error {
	return m.validate(true)
}

func (m *Compressor) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetContentLength()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CompressorValidationError{
					field:  "ContentLength",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CompressorValidationError{
					field:  "ContentLength",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContentLength()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CompressorValidationError{
				field:  "ContentLength",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for DisableOnEtagHeader

	// no validation rules for RemoveAcceptEncodingHeader

	if all {
		switch v := interface{}(m.GetRuntimeEnabled()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CompressorValidationError{
					field:  "RuntimeEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CompressorValidationError{
					field:  "RuntimeEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRuntimeEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CompressorValidationError{
				field:  "RuntimeEnabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return CompressorMultiError(errors)
	}

	return nil
}

// CompressorMultiError is an error wrapping multiple validation errors
// returned by Compressor.ValidateAll() if the designated constraints aren't met.
type CompressorMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CompressorMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CompressorMultiError) AllErrors() []error { return m }

// CompressorValidationError is the validation error returned by
// Compressor.Validate if the designated constraints aren't met.
type CompressorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CompressorValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CompressorValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CompressorValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CompressorValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CompressorValidationError) ErrorName() string { return "CompressorValidationError" }

// Error satisfies the builtin error interface
func (e CompressorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCompressor.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CompressorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CompressorValidationError{}
