// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshiftdataapiservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opBatchExecuteStatement = "BatchExecuteStatement"

// BatchExecuteStatementRequest generates a "aws/request.Request" representing the
// client's request for the BatchExecuteStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchExecuteStatement for more information on using the BatchExecuteStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchExecuteStatementRequest method.
//	req, resp := client.BatchExecuteStatementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/BatchExecuteStatement
func (c *RedshiftDataAPIService) BatchExecuteStatementRequest(input *BatchExecuteStatementInput) (req *request.Request, output *BatchExecuteStatementOutput) {
	op := &request.Operation{
		Name:       opBatchExecuteStatement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchExecuteStatementInput{}
	}

	output = &BatchExecuteStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchExecuteStatement API operation for Redshift Data API Service.
//
// Runs one or more SQL statements, which can be data manipulation language
// (DML) or data definition language (DDL). Depending on the authorization method,
// use one of the following combinations of request parameters:
//
//   - Secrets Manager - when connecting to a cluster, specify the Amazon Resource
//     Name (ARN) of the secret, the database name, and the cluster identifier
//     that matches the cluster in the secret. When connecting to a serverless
//     workgroup, specify the Amazon Resource Name (ARN) of the secret and the
//     database name.
//
//   - Temporary credentials - when connecting to a cluster, specify the cluster
//     identifier, the database name, and the database user name. Also, permission
//     to call the redshift:GetClusterCredentials operation is required. When
//     connecting to a serverless workgroup, specify the workgroup name and database
//     name. Also, permission to call the redshift-serverless:GetCredentials
//     operation is required.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Data API Service's
// API operation BatchExecuteStatement for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - ActiveStatementsExceededException
//     The number of active statements exceeds the limit.
//
//   - BatchExecuteStatementException
//     An SQL statement encountered an environmental error while running.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/BatchExecuteStatement
func (c *RedshiftDataAPIService) BatchExecuteStatement(input *BatchExecuteStatementInput) (*BatchExecuteStatementOutput, error) {
	req, out := c.BatchExecuteStatementRequest(input)
	return out, req.Send()
}

// BatchExecuteStatementWithContext is the same as BatchExecuteStatement with the addition of
// the ability to pass a context and additional request options.
//
// See BatchExecuteStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) BatchExecuteStatementWithContext(ctx aws.Context, input *BatchExecuteStatementInput, opts ...request.Option) (*BatchExecuteStatementOutput, error) {
	req, out := c.BatchExecuteStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelStatement = "CancelStatement"

// CancelStatementRequest generates a "aws/request.Request" representing the
// client's request for the CancelStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelStatement for more information on using the CancelStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelStatementRequest method.
//	req, resp := client.CancelStatementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/CancelStatement
func (c *RedshiftDataAPIService) CancelStatementRequest(input *CancelStatementInput) (req *request.Request, output *CancelStatementOutput) {
	op := &request.Operation{
		Name:       opCancelStatement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelStatementInput{}
	}

	output = &CancelStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelStatement API operation for Redshift Data API Service.
//
// Cancels a running query. To be canceled, a query must be running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Data API Service's
// API operation CancelStatement for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - ResourceNotFoundException
//     The Amazon Redshift Data API operation failed due to a missing resource.
//
//   - InternalServerException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - DatabaseConnectionException
//     Connection to a database failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/CancelStatement
func (c *RedshiftDataAPIService) CancelStatement(input *CancelStatementInput) (*CancelStatementOutput, error) {
	req, out := c.CancelStatementRequest(input)
	return out, req.Send()
}

// CancelStatementWithContext is the same as CancelStatement with the addition of
// the ability to pass a context and additional request options.
//
// See CancelStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) CancelStatementWithContext(ctx aws.Context, input *CancelStatementInput, opts ...request.Option) (*CancelStatementOutput, error) {
	req, out := c.CancelStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStatement = "DescribeStatement"

// DescribeStatementRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStatement for more information on using the DescribeStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeStatementRequest method.
//	req, resp := client.DescribeStatementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeStatement
func (c *RedshiftDataAPIService) DescribeStatementRequest(input *DescribeStatementInput) (req *request.Request, output *DescribeStatementOutput) {
	op := &request.Operation{
		Name:       opDescribeStatement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStatementInput{}
	}

	output = &DescribeStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStatement API operation for Redshift Data API Service.
//
// Describes the details about a specific instance when a query was run by the
// Amazon Redshift Data API. The information includes when the query started,
// when it finished, the query status, the number of rows returned, and the
// SQL statement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Data API Service's
// API operation DescribeStatement for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - ResourceNotFoundException
//     The Amazon Redshift Data API operation failed due to a missing resource.
//
//   - InternalServerException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeStatement
func (c *RedshiftDataAPIService) DescribeStatement(input *DescribeStatementInput) (*DescribeStatementOutput, error) {
	req, out := c.DescribeStatementRequest(input)
	return out, req.Send()
}

// DescribeStatementWithContext is the same as DescribeStatement with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) DescribeStatementWithContext(ctx aws.Context, input *DescribeStatementInput, opts ...request.Option) (*DescribeStatementOutput, error) {
	req, out := c.DescribeStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTable = "DescribeTable"

// DescribeTableRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTable for more information on using the DescribeTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTableRequest method.
//	req, resp := client.DescribeTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeTable
func (c *RedshiftDataAPIService) DescribeTableRequest(input *DescribeTableInput) (req *request.Request, output *DescribeTableOutput) {
	op := &request.Operation{
		Name:       opDescribeTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTableInput{}
	}

	output = &DescribeTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTable API operation for Redshift Data API Service.
//
// Describes the detailed information about a table from metadata in the cluster.
// The information includes its columns. A token is returned to page through
// the column list. Depending on the authorization method, use one of the following
// combinations of request parameters:
//
//   - Secrets Manager - when connecting to a cluster, specify the Amazon Resource
//     Name (ARN) of the secret, the database name, and the cluster identifier
//     that matches the cluster in the secret. When connecting to a serverless
//     workgroup, specify the Amazon Resource Name (ARN) of the secret and the
//     database name.
//
//   - Temporary credentials - when connecting to a cluster, specify the cluster
//     identifier, the database name, and the database user name. Also, permission
//     to call the redshift:GetClusterCredentials operation is required. When
//     connecting to a serverless workgroup, specify the workgroup name and database
//     name. Also, permission to call the redshift-serverless:GetCredentials
//     operation is required.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Data API Service's
// API operation DescribeTable for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - InternalServerException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - DatabaseConnectionException
//     Connection to a database failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeTable
func (c *RedshiftDataAPIService) DescribeTable(input *DescribeTableInput) (*DescribeTableOutput, error) {
	req, out := c.DescribeTableRequest(input)
	return out, req.Send()
}

// DescribeTableWithContext is the same as DescribeTable with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) DescribeTableWithContext(ctx aws.Context, input *DescribeTableInput, opts ...request.Option) (*DescribeTableOutput, error) {
	req, out := c.DescribeTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeTablePages iterates over the pages of a DescribeTable operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTable method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeTable operation.
//	pageNum := 0
//	err := client.DescribeTablePages(params,
//	    func(page *redshiftdataapiservice.DescribeTableOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftDataAPIService) DescribeTablePages(input *DescribeTableInput, fn func(*DescribeTableOutput, bool) bool) error {
	return c.DescribeTablePagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeTablePagesWithContext same as DescribeTablePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) DescribeTablePagesWithContext(ctx aws.Context, input *DescribeTableInput, fn func(*DescribeTableOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeTableInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeTableRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeTableOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opExecuteStatement = "ExecuteStatement"

// ExecuteStatementRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExecuteStatement for more information on using the ExecuteStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExecuteStatementRequest method.
//	req, resp := client.ExecuteStatementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ExecuteStatement
func (c *RedshiftDataAPIService) ExecuteStatementRequest(input *ExecuteStatementInput) (req *request.Request, output *ExecuteStatementOutput) {
	op := &request.Operation{
		Name:       opExecuteStatement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExecuteStatementInput{}
	}

	output = &ExecuteStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExecuteStatement API operation for Redshift Data API Service.
//
// Runs an SQL statement, which can be data manipulation language (DML) or data
// definition language (DDL). This statement must be a single SQL statement.
// Depending on the authorization method, use one of the following combinations
// of request parameters:
//
//   - Secrets Manager - when connecting to a cluster, specify the Amazon Resource
//     Name (ARN) of the secret, the database name, and the cluster identifier
//     that matches the cluster in the secret. When connecting to a serverless
//     workgroup, specify the Amazon Resource Name (ARN) of the secret and the
//     database name.
//
//   - Temporary credentials - when connecting to a cluster, specify the cluster
//     identifier, the database name, and the database user name. Also, permission
//     to call the redshift:GetClusterCredentials operation is required. When
//     connecting to a serverless workgroup, specify the workgroup name and database
//     name. Also, permission to call the redshift-serverless:GetCredentials
//     operation is required.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Data API Service's
// API operation ExecuteStatement for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - ExecuteStatementException
//     The SQL statement encountered an environmental error while running.
//
//   - ActiveStatementsExceededException
//     The number of active statements exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ExecuteStatement
func (c *RedshiftDataAPIService) ExecuteStatement(input *ExecuteStatementInput) (*ExecuteStatementOutput, error) {
	req, out := c.ExecuteStatementRequest(input)
	return out, req.Send()
}

// ExecuteStatementWithContext is the same as ExecuteStatement with the addition of
// the ability to pass a context and additional request options.
//
// See ExecuteStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) ExecuteStatementWithContext(ctx aws.Context, input *ExecuteStatementInput, opts ...request.Option) (*ExecuteStatementOutput, error) {
	req, out := c.ExecuteStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStatementResult = "GetStatementResult"

// GetStatementResultRequest generates a "aws/request.Request" representing the
// client's request for the GetStatementResult operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStatementResult for more information on using the GetStatementResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStatementResultRequest method.
//	req, resp := client.GetStatementResultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/GetStatementResult
func (c *RedshiftDataAPIService) GetStatementResultRequest(input *GetStatementResultInput) (req *request.Request, output *GetStatementResultOutput) {
	op := &request.Operation{
		Name:       opGetStatementResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetStatementResultInput{}
	}

	output = &GetStatementResultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStatementResult API operation for Redshift Data API Service.
//
// Fetches the temporarily cached result of an SQL statement. A token is returned
// to page through the statement results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Data API Service's
// API operation GetStatementResult for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - ResourceNotFoundException
//     The Amazon Redshift Data API operation failed due to a missing resource.
//
//   - InternalServerException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/GetStatementResult
func (c *RedshiftDataAPIService) GetStatementResult(input *GetStatementResultInput) (*GetStatementResultOutput, error) {
	req, out := c.GetStatementResultRequest(input)
	return out, req.Send()
}

// GetStatementResultWithContext is the same as GetStatementResult with the addition of
// the ability to pass a context and additional request options.
//
// See GetStatementResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) GetStatementResultWithContext(ctx aws.Context, input *GetStatementResultInput, opts ...request.Option) (*GetStatementResultOutput, error) {
	req, out := c.GetStatementResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetStatementResultPages iterates over the pages of a GetStatementResult operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetStatementResult method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetStatementResult operation.
//	pageNum := 0
//	err := client.GetStatementResultPages(params,
//	    func(page *redshiftdataapiservice.GetStatementResultOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftDataAPIService) GetStatementResultPages(input *GetStatementResultInput, fn func(*GetStatementResultOutput, bool) bool) error {
	return c.GetStatementResultPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetStatementResultPagesWithContext same as GetStatementResultPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) GetStatementResultPagesWithContext(ctx aws.Context, input *GetStatementResultInput, fn func(*GetStatementResultOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetStatementResultInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetStatementResultRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetStatementResultOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatabases = "ListDatabases"

// ListDatabasesRequest generates a "aws/request.Request" representing the
// client's request for the ListDatabases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatabases for more information on using the ListDatabases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDatabasesRequest method.
//	req, resp := client.ListDatabasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListDatabases
func (c *RedshiftDataAPIService) ListDatabasesRequest(input *ListDatabasesInput) (req *request.Request, output *ListDatabasesOutput) {
	op := &request.Operation{
		Name:       opListDatabases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatabasesInput{}
	}

	output = &ListDatabasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatabases API operation for Redshift Data API Service.
//
// List the databases in a cluster. A token is returned to page through the
// database list. Depending on the authorization method, use one of the following
// combinations of request parameters:
//
//   - Secrets Manager - when connecting to a cluster, specify the Amazon Resource
//     Name (ARN) of the secret, the database name, and the cluster identifier
//     that matches the cluster in the secret. When connecting to a serverless
//     workgroup, specify the Amazon Resource Name (ARN) of the secret and the
//     database name.
//
//   - Temporary credentials - when connecting to a cluster, specify the cluster
//     identifier, the database name, and the database user name. Also, permission
//     to call the redshift:GetClusterCredentials operation is required. When
//     connecting to a serverless workgroup, specify the workgroup name and database
//     name. Also, permission to call the redshift-serverless:GetCredentials
//     operation is required.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Data API Service's
// API operation ListDatabases for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - InternalServerException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - DatabaseConnectionException
//     Connection to a database failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListDatabases
func (c *RedshiftDataAPIService) ListDatabases(input *ListDatabasesInput) (*ListDatabasesOutput, error) {
	req, out := c.ListDatabasesRequest(input)
	return out, req.Send()
}

// ListDatabasesWithContext is the same as ListDatabases with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatabases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) ListDatabasesWithContext(ctx aws.Context, input *ListDatabasesInput, opts ...request.Option) (*ListDatabasesOutput, error) {
	req, out := c.ListDatabasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatabasesPages iterates over the pages of a ListDatabases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatabases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDatabases operation.
//	pageNum := 0
//	err := client.ListDatabasesPages(params,
//	    func(page *redshiftdataapiservice.ListDatabasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftDataAPIService) ListDatabasesPages(input *ListDatabasesInput, fn func(*ListDatabasesOutput, bool) bool) error {
	return c.ListDatabasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatabasesPagesWithContext same as ListDatabasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) ListDatabasesPagesWithContext(ctx aws.Context, input *ListDatabasesInput, fn func(*ListDatabasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatabasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatabasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatabasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSchemas = "ListSchemas"

// ListSchemasRequest generates a "aws/request.Request" representing the
// client's request for the ListSchemas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchemas for more information on using the ListSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSchemasRequest method.
//	req, resp := client.ListSchemasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListSchemas
func (c *RedshiftDataAPIService) ListSchemasRequest(input *ListSchemasInput) (req *request.Request, output *ListSchemasOutput) {
	op := &request.Operation{
		Name:       opListSchemas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSchemasInput{}
	}

	output = &ListSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchemas API operation for Redshift Data API Service.
//
// Lists the schemas in a database. A token is returned to page through the
// schema list. Depending on the authorization method, use one of the following
// combinations of request parameters:
//
//   - Secrets Manager - when connecting to a cluster, specify the Amazon Resource
//     Name (ARN) of the secret, the database name, and the cluster identifier
//     that matches the cluster in the secret. When connecting to a serverless
//     workgroup, specify the Amazon Resource Name (ARN) of the secret and the
//     database name.
//
//   - Temporary credentials - when connecting to a cluster, specify the cluster
//     identifier, the database name, and the database user name. Also, permission
//     to call the redshift:GetClusterCredentials operation is required. When
//     connecting to a serverless workgroup, specify the workgroup name and database
//     name. Also, permission to call the redshift-serverless:GetCredentials
//     operation is required.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Data API Service's
// API operation ListSchemas for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - InternalServerException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - DatabaseConnectionException
//     Connection to a database failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListSchemas
func (c *RedshiftDataAPIService) ListSchemas(input *ListSchemasInput) (*ListSchemasOutput, error) {
	req, out := c.ListSchemasRequest(input)
	return out, req.Send()
}

// ListSchemasWithContext is the same as ListSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) ListSchemasWithContext(ctx aws.Context, input *ListSchemasInput, opts ...request.Option) (*ListSchemasOutput, error) {
	req, out := c.ListSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSchemasPages iterates over the pages of a ListSchemas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSchemas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSchemas operation.
//	pageNum := 0
//	err := client.ListSchemasPages(params,
//	    func(page *redshiftdataapiservice.ListSchemasOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftDataAPIService) ListSchemasPages(input *ListSchemasInput, fn func(*ListSchemasOutput, bool) bool) error {
	return c.ListSchemasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSchemasPagesWithContext same as ListSchemasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) ListSchemasPagesWithContext(ctx aws.Context, input *ListSchemasInput, fn func(*ListSchemasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSchemasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSchemasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSchemasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStatements = "ListStatements"

// ListStatementsRequest generates a "aws/request.Request" representing the
// client's request for the ListStatements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStatements for more information on using the ListStatements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStatementsRequest method.
//	req, resp := client.ListStatementsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListStatements
func (c *RedshiftDataAPIService) ListStatementsRequest(input *ListStatementsInput) (req *request.Request, output *ListStatementsOutput) {
	op := &request.Operation{
		Name:       opListStatements,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStatementsInput{}
	}

	output = &ListStatementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStatements API operation for Redshift Data API Service.
//
// List of SQL statements. By default, only finished statements are shown. A
// token is returned to page through the statement list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Data API Service's
// API operation ListStatements for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - InternalServerException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListStatements
func (c *RedshiftDataAPIService) ListStatements(input *ListStatementsInput) (*ListStatementsOutput, error) {
	req, out := c.ListStatementsRequest(input)
	return out, req.Send()
}

// ListStatementsWithContext is the same as ListStatements with the addition of
// the ability to pass a context and additional request options.
//
// See ListStatements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) ListStatementsWithContext(ctx aws.Context, input *ListStatementsInput, opts ...request.Option) (*ListStatementsOutput, error) {
	req, out := c.ListStatementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStatementsPages iterates over the pages of a ListStatements operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStatements method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStatements operation.
//	pageNum := 0
//	err := client.ListStatementsPages(params,
//	    func(page *redshiftdataapiservice.ListStatementsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftDataAPIService) ListStatementsPages(input *ListStatementsInput, fn func(*ListStatementsOutput, bool) bool) error {
	return c.ListStatementsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStatementsPagesWithContext same as ListStatementsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) ListStatementsPagesWithContext(ctx aws.Context, input *ListStatementsInput, fn func(*ListStatementsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStatementsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStatementsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStatementsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTables = "ListTables"

// ListTablesRequest generates a "aws/request.Request" representing the
// client's request for the ListTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTables for more information on using the ListTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTablesRequest method.
//	req, resp := client.ListTablesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListTables
func (c *RedshiftDataAPIService) ListTablesRequest(input *ListTablesInput) (req *request.Request, output *ListTablesOutput) {
	op := &request.Operation{
		Name:       opListTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTablesInput{}
	}

	output = &ListTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTables API operation for Redshift Data API Service.
//
// List the tables in a database. If neither SchemaPattern nor TablePattern
// are specified, then all tables in the database are returned. A token is returned
// to page through the table list. Depending on the authorization method, use
// one of the following combinations of request parameters:
//
//   - Secrets Manager - when connecting to a cluster, specify the Amazon Resource
//     Name (ARN) of the secret, the database name, and the cluster identifier
//     that matches the cluster in the secret. When connecting to a serverless
//     workgroup, specify the Amazon Resource Name (ARN) of the secret and the
//     database name.
//
//   - Temporary credentials - when connecting to a cluster, specify the cluster
//     identifier, the database name, and the database user name. Also, permission
//     to call the redshift:GetClusterCredentials operation is required. When
//     connecting to a serverless workgroup, specify the workgroup name and database
//     name. Also, permission to call the redshift-serverless:GetCredentials
//     operation is required.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Data API Service's
// API operation ListTables for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - InternalServerException
//     The Amazon Redshift Data API operation failed due to invalid input.
//
//   - DatabaseConnectionException
//     Connection to a database failed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListTables
func (c *RedshiftDataAPIService) ListTables(input *ListTablesInput) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	return out, req.Send()
}

// ListTablesWithContext is the same as ListTables with the addition of
// the ability to pass a context and additional request options.
//
// See ListTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) ListTablesWithContext(ctx aws.Context, input *ListTablesInput, opts ...request.Option) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTablesPages iterates over the pages of a ListTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTables operation.
//	pageNum := 0
//	err := client.ListTablesPages(params,
//	    func(page *redshiftdataapiservice.ListTablesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftDataAPIService) ListTablesPages(input *ListTablesInput, fn func(*ListTablesOutput, bool) bool) error {
	return c.ListTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTablesPagesWithContext same as ListTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftDataAPIService) ListTablesPagesWithContext(ctx aws.Context, input *ListTablesInput, fn func(*ListTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

// The number of active statements exceeds the limit.
type ActiveStatementsExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveStatementsExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveStatementsExceededException) GoString() string {
	return s.String()
}

func newErrorActiveStatementsExceededException(v protocol.ResponseMetadata) error {
	return &ActiveStatementsExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ActiveStatementsExceededException) Code() string {
	return "ActiveStatementsExceededException"
}

// Message returns the exception's message.
func (s *ActiveStatementsExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ActiveStatementsExceededException) OrigErr() error {
	return nil
}

func (s *ActiveStatementsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ActiveStatementsExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ActiveStatementsExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An SQL statement encountered an environmental error while running.
type BatchExecuteStatementException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Statement identifier of the exception.
	//
	// StatementId is a required field
	StatementId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchExecuteStatementException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchExecuteStatementException) GoString() string {
	return s.String()
}

func newErrorBatchExecuteStatementException(v protocol.ResponseMetadata) error {
	return &BatchExecuteStatementException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BatchExecuteStatementException) Code() string {
	return "BatchExecuteStatementException"
}

// Message returns the exception's message.
func (s *BatchExecuteStatementException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BatchExecuteStatementException) OrigErr() error {
	return nil
}

func (s *BatchExecuteStatementException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BatchExecuteStatementException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BatchExecuteStatementException) RequestID() string {
	return s.RespMetadata.RequestID
}

type BatchExecuteStatementInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier. This parameter is required when connecting to a cluster
	// and authenticating using either Secrets Manager or temporary credentials.
	ClusterIdentifier *string `type:"string"`

	// The name of the database. This parameter is required when authenticating
	// using either Secrets Manager or temporary credentials.
	//
	// Database is a required field
	Database *string `type:"string" required:"true"`

	// The database user name. This parameter is required when connecting to a cluster
	// and authenticating using temporary credentials.
	DbUser *string `type:"string"`

	// The name or ARN of the secret that enables access to the database. This parameter
	// is required when authenticating using Secrets Manager.
	SecretArn *string `type:"string"`

	// One or more SQL statements to run.
	//
	// Sqls is a required field
	Sqls []*string `min:"1" type:"list" required:"true"`

	// The name of the SQL statements. You can name the SQL statements when you
	// create them to identify the query.
	StatementName *string `type:"string"`

	// A value that indicates whether to send an event to the Amazon EventBridge
	// event bus after the SQL statements run.
	WithEvent *bool `type:"boolean"`

	// The serverless workgroup name. This parameter is required when connecting
	// to a serverless workgroup and authenticating using either Secrets Manager
	// or temporary credentials.
	WorkgroupName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchExecuteStatementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchExecuteStatementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchExecuteStatementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchExecuteStatementInput"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Sqls == nil {
		invalidParams.Add(request.NewErrParamRequired("Sqls"))
	}
	if s.Sqls != nil && len(s.Sqls) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sqls", 1))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *BatchExecuteStatementInput) SetClusterIdentifier(v string) *BatchExecuteStatementInput {
	s.ClusterIdentifier = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *BatchExecuteStatementInput) SetDatabase(v string) *BatchExecuteStatementInput {
	s.Database = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *BatchExecuteStatementInput) SetDbUser(v string) *BatchExecuteStatementInput {
	s.DbUser = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *BatchExecuteStatementInput) SetSecretArn(v string) *BatchExecuteStatementInput {
	s.SecretArn = &v
	return s
}

// SetSqls sets the Sqls field's value.
func (s *BatchExecuteStatementInput) SetSqls(v []*string) *BatchExecuteStatementInput {
	s.Sqls = v
	return s
}

// SetStatementName sets the StatementName field's value.
func (s *BatchExecuteStatementInput) SetStatementName(v string) *BatchExecuteStatementInput {
	s.StatementName = &v
	return s
}

// SetWithEvent sets the WithEvent field's value.
func (s *BatchExecuteStatementInput) SetWithEvent(v bool) *BatchExecuteStatementInput {
	s.WithEvent = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *BatchExecuteStatementInput) SetWorkgroupName(v string) *BatchExecuteStatementInput {
	s.WorkgroupName = &v
	return s
}

type BatchExecuteStatementOutput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier. This element is not returned when connecting to a
	// serverless workgroup.
	ClusterIdentifier *string `type:"string"`

	// The date and time (UTC) the statement was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The name of the database.
	Database *string `type:"string"`

	// The database user name.
	DbUser *string `type:"string"`

	// The identifier of the SQL statement whose results are to be fetched. This
	// value is a universally unique identifier (UUID) generated by Amazon Redshift
	// Data API. This identifier is returned by BatchExecuteStatment.
	Id *string `type:"string"`

	// The name or ARN of the secret that enables access to the database.
	SecretArn *string `type:"string"`

	// The serverless workgroup name. This element is not returned when connecting
	// to a provisioned cluster.
	WorkgroupName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchExecuteStatementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchExecuteStatementOutput) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *BatchExecuteStatementOutput) SetClusterIdentifier(v string) *BatchExecuteStatementOutput {
	s.ClusterIdentifier = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *BatchExecuteStatementOutput) SetCreatedAt(v time.Time) *BatchExecuteStatementOutput {
	s.CreatedAt = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *BatchExecuteStatementOutput) SetDatabase(v string) *BatchExecuteStatementOutput {
	s.Database = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *BatchExecuteStatementOutput) SetDbUser(v string) *BatchExecuteStatementOutput {
	s.DbUser = &v
	return s
}

// SetId sets the Id field's value.
func (s *BatchExecuteStatementOutput) SetId(v string) *BatchExecuteStatementOutput {
	s.Id = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *BatchExecuteStatementOutput) SetSecretArn(v string) *BatchExecuteStatementOutput {
	s.SecretArn = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *BatchExecuteStatementOutput) SetWorkgroupName(v string) *BatchExecuteStatementOutput {
	s.WorkgroupName = &v
	return s
}

type CancelStatementInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the SQL statement to cancel. This value is a universally
	// unique identifier (UUID) generated by Amazon Redshift Data API. This identifier
	// is returned by BatchExecuteStatment, ExecuteStatment, and ListStatements.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelStatementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelStatementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelStatementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelStatementInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *CancelStatementInput) SetId(v string) *CancelStatementInput {
	s.Id = &v
	return s
}

type CancelStatementOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether the cancel statement succeeded (true).
	Status *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelStatementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelStatementOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *CancelStatementOutput) SetStatus(v bool) *CancelStatementOutput {
	s.Status = &v
	return s
}

// The properties (metadata) of a column.
type ColumnMetadata struct {
	_ struct{} `type:"structure"`

	// The default value of the column.
	ColumnDefault *string `locationName:"columnDefault" type:"string"`

	// A value that indicates whether the column is case-sensitive.
	IsCaseSensitive *bool `locationName:"isCaseSensitive" type:"boolean"`

	// A value that indicates whether the column contains currency values.
	IsCurrency *bool `locationName:"isCurrency" type:"boolean"`

	// A value that indicates whether an integer column is signed.
	IsSigned *bool `locationName:"isSigned" type:"boolean"`

	// The label for the column.
	Label *string `locationName:"label" type:"string"`

	// The length of the column.
	Length *int64 `locationName:"length" type:"integer"`

	// The name of the column.
	Name *string `locationName:"name" type:"string"`

	// A value that indicates whether the column is nullable.
	Nullable *int64 `locationName:"nullable" type:"integer"`

	// The precision value of a decimal number column.
	Precision *int64 `locationName:"precision" type:"integer"`

	// The scale value of a decimal number column.
	Scale *int64 `locationName:"scale" type:"integer"`

	// The name of the schema that contains the table that includes the column.
	SchemaName *string `locationName:"schemaName" type:"string"`

	// The name of the table that includes the column.
	TableName *string `locationName:"tableName" type:"string"`

	// The database-specific data type of the column.
	TypeName *string `locationName:"typeName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnMetadata) GoString() string {
	return s.String()
}

// SetColumnDefault sets the ColumnDefault field's value.
func (s *ColumnMetadata) SetColumnDefault(v string) *ColumnMetadata {
	s.ColumnDefault = &v
	return s
}

// SetIsCaseSensitive sets the IsCaseSensitive field's value.
func (s *ColumnMetadata) SetIsCaseSensitive(v bool) *ColumnMetadata {
	s.IsCaseSensitive = &v
	return s
}

// SetIsCurrency sets the IsCurrency field's value.
func (s *ColumnMetadata) SetIsCurrency(v bool) *ColumnMetadata {
	s.IsCurrency = &v
	return s
}

// SetIsSigned sets the IsSigned field's value.
func (s *ColumnMetadata) SetIsSigned(v bool) *ColumnMetadata {
	s.IsSigned = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *ColumnMetadata) SetLabel(v string) *ColumnMetadata {
	s.Label = &v
	return s
}

// SetLength sets the Length field's value.
func (s *ColumnMetadata) SetLength(v int64) *ColumnMetadata {
	s.Length = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnMetadata) SetName(v string) *ColumnMetadata {
	s.Name = &v
	return s
}

// SetNullable sets the Nullable field's value.
func (s *ColumnMetadata) SetNullable(v int64) *ColumnMetadata {
	s.Nullable = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *ColumnMetadata) SetPrecision(v int64) *ColumnMetadata {
	s.Precision = &v
	return s
}

// SetScale sets the Scale field's value.
func (s *ColumnMetadata) SetScale(v int64) *ColumnMetadata {
	s.Scale = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *ColumnMetadata) SetSchemaName(v string) *ColumnMetadata {
	s.SchemaName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ColumnMetadata) SetTableName(v string) *ColumnMetadata {
	s.TableName = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ColumnMetadata) SetTypeName(v string) *ColumnMetadata {
	s.TypeName = &v
	return s
}

// Connection to a database failed.
type DatabaseConnectionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseConnectionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatabaseConnectionException) GoString() string {
	return s.String()
}

func newErrorDatabaseConnectionException(v protocol.ResponseMetadata) error {
	return &DatabaseConnectionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DatabaseConnectionException) Code() string {
	return "DatabaseConnectionException"
}

// Message returns the exception's message.
func (s *DatabaseConnectionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DatabaseConnectionException) OrigErr() error {
	return nil
}

func (s *DatabaseConnectionException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DatabaseConnectionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DatabaseConnectionException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DescribeStatementInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the SQL statement to describe. This value is a universally
	// unique identifier (UUID) generated by Amazon Redshift Data API. A suffix
	// indicates the number of the SQL statement. For example, d9b6c0c9-0747-4bf4-b142-e8883122f766:2
	// has a suffix of :2 that indicates the second SQL statement of a batch query.
	// This identifier is returned by BatchExecuteStatment, ExecuteStatement, and
	// ListStatements.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStatementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStatementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStatementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStatementInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeStatementInput) SetId(v string) *DescribeStatementInput {
	s.Id = &v
	return s
}

type DescribeStatementOutput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier.
	ClusterIdentifier *string `type:"string"`

	// The date and time (UTC) when the SQL statement was submitted to run.
	CreatedAt *time.Time `type:"timestamp"`

	// The name of the database.
	Database *string `type:"string"`

	// The database user name.
	DbUser *string `type:"string"`

	// The amount of time in nanoseconds that the statement ran.
	Duration *int64 `type:"long"`

	// The error message from the cluster if the SQL statement encountered an error
	// while running.
	Error *string `type:"string"`

	// A value that indicates whether the statement has a result set. The result
	// set can be empty. The value is true for an empty result set. The value is
	// true if any substatement returns a result set.
	HasResultSet *bool `type:"boolean"`

	// The identifier of the SQL statement described. This value is a universally
	// unique identifier (UUID) generated by Amazon Redshift Data API.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The parameters for the SQL statement.
	QueryParameters []*SqlParameter `min:"1" type:"list"`

	// The SQL statement text.
	QueryString *string `type:"string"`

	// The process identifier from Amazon Redshift.
	RedshiftPid *int64 `type:"long"`

	// The identifier of the query generated by Amazon Redshift. These identifiers
	// are also available in the query column of the STL_QUERY system view.
	RedshiftQueryId *int64 `type:"long"`

	// Either the number of rows returned from the SQL statement or the number of
	// rows affected. If result size is greater than zero, the result rows can be
	// the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE,
	// COPY, and others. A -1 indicates the value is null.
	ResultRows *int64 `type:"long"`

	// The size in bytes of the returned results. A -1 indicates the value is null.
	ResultSize *int64 `type:"long"`

	// The name or Amazon Resource Name (ARN) of the secret that enables access
	// to the database.
	SecretArn *string `type:"string"`

	// The status of the SQL statement being described. Status values are defined
	// as follows:
	//
	//    * ABORTED - The query run was stopped by the user.
	//
	//    * ALL - A status value that includes all query statuses. This value can
	//    be used to filter results.
	//
	//    * FAILED - The query run failed.
	//
	//    * FINISHED - The query has finished running.
	//
	//    * PICKED - The query has been chosen to be run.
	//
	//    * STARTED - The query run has started.
	//
	//    * SUBMITTED - The query was submitted, but not yet processed.
	Status *string `type:"string" enum:"StatusString"`

	// The SQL statements from a multiple statement run.
	SubStatements []*SubStatementData `type:"list"`

	// The date and time (UTC) that the metadata for the SQL statement was last
	// updated. An example is the time the status last changed.
	UpdatedAt *time.Time `type:"timestamp"`

	// The serverless workgroup name.
	WorkgroupName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStatementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStatementOutput) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeStatementOutput) SetClusterIdentifier(v string) *DescribeStatementOutput {
	s.ClusterIdentifier = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeStatementOutput) SetCreatedAt(v time.Time) *DescribeStatementOutput {
	s.CreatedAt = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *DescribeStatementOutput) SetDatabase(v string) *DescribeStatementOutput {
	s.Database = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *DescribeStatementOutput) SetDbUser(v string) *DescribeStatementOutput {
	s.DbUser = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *DescribeStatementOutput) SetDuration(v int64) *DescribeStatementOutput {
	s.Duration = &v
	return s
}

// SetError sets the Error field's value.
func (s *DescribeStatementOutput) SetError(v string) *DescribeStatementOutput {
	s.Error = &v
	return s
}

// SetHasResultSet sets the HasResultSet field's value.
func (s *DescribeStatementOutput) SetHasResultSet(v bool) *DescribeStatementOutput {
	s.HasResultSet = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeStatementOutput) SetId(v string) *DescribeStatementOutput {
	s.Id = &v
	return s
}

// SetQueryParameters sets the QueryParameters field's value.
func (s *DescribeStatementOutput) SetQueryParameters(v []*SqlParameter) *DescribeStatementOutput {
	s.QueryParameters = v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *DescribeStatementOutput) SetQueryString(v string) *DescribeStatementOutput {
	s.QueryString = &v
	return s
}

// SetRedshiftPid sets the RedshiftPid field's value.
func (s *DescribeStatementOutput) SetRedshiftPid(v int64) *DescribeStatementOutput {
	s.RedshiftPid = &v
	return s
}

// SetRedshiftQueryId sets the RedshiftQueryId field's value.
func (s *DescribeStatementOutput) SetRedshiftQueryId(v int64) *DescribeStatementOutput {
	s.RedshiftQueryId = &v
	return s
}

// SetResultRows sets the ResultRows field's value.
func (s *DescribeStatementOutput) SetResultRows(v int64) *DescribeStatementOutput {
	s.ResultRows = &v
	return s
}

// SetResultSize sets the ResultSize field's value.
func (s *DescribeStatementOutput) SetResultSize(v int64) *DescribeStatementOutput {
	s.ResultSize = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *DescribeStatementOutput) SetSecretArn(v string) *DescribeStatementOutput {
	s.SecretArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeStatementOutput) SetStatus(v string) *DescribeStatementOutput {
	s.Status = &v
	return s
}

// SetSubStatements sets the SubStatements field's value.
func (s *DescribeStatementOutput) SetSubStatements(v []*SubStatementData) *DescribeStatementOutput {
	s.SubStatements = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DescribeStatementOutput) SetUpdatedAt(v time.Time) *DescribeStatementOutput {
	s.UpdatedAt = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *DescribeStatementOutput) SetWorkgroupName(v string) *DescribeStatementOutput {
	s.WorkgroupName = &v
	return s
}

type DescribeTableInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier. This parameter is required when connecting to a cluster
	// and authenticating using either Secrets Manager or temporary credentials.
	ClusterIdentifier *string `type:"string"`

	// A database name. The connected database is specified when you connect with
	// your authentication credentials.
	ConnectedDatabase *string `type:"string"`

	// The name of the database that contains the tables to be described. If ConnectedDatabase
	// is not specified, this is also the database to connect to with your authentication
	// credentials.
	//
	// Database is a required field
	Database *string `type:"string" required:"true"`

	// The database user name. This parameter is required when connecting to a cluster
	// and authenticating using temporary credentials.
	DbUser *string `type:"string"`

	// The maximum number of tables to return in the response. If more tables exist
	// than fit in one response, then NextToken is returned to page through the
	// results.
	MaxResults *int64 `type:"integer"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the
	// next NextToken parameter and retrying the command. If the NextToken field
	// is empty, all response records have been retrieved for the request.
	NextToken *string `type:"string"`

	// The schema that contains the table. If no schema is specified, then matching
	// tables for all schemas are returned.
	Schema *string `type:"string"`

	// The name or ARN of the secret that enables access to the database. This parameter
	// is required when authenticating using Secrets Manager.
	SecretArn *string `type:"string"`

	// The table name. If no table is specified, then all tables for all matching
	// schemas are returned. If no table and no schema is specified, then all tables
	// for all schemas in the database are returned
	Table *string `type:"string"`

	// The serverless workgroup name. This parameter is required when connecting
	// to a serverless workgroup and authenticating using either Secrets Manager
	// or temporary credentials.
	WorkgroupName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTableInput"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeTableInput) SetClusterIdentifier(v string) *DescribeTableInput {
	s.ClusterIdentifier = &v
	return s
}

// SetConnectedDatabase sets the ConnectedDatabase field's value.
func (s *DescribeTableInput) SetConnectedDatabase(v string) *DescribeTableInput {
	s.ConnectedDatabase = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *DescribeTableInput) SetDatabase(v string) *DescribeTableInput {
	s.Database = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *DescribeTableInput) SetDbUser(v string) *DescribeTableInput {
	s.DbUser = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeTableInput) SetMaxResults(v int64) *DescribeTableInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeTableInput) SetNextToken(v string) *DescribeTableInput {
	s.NextToken = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *DescribeTableInput) SetSchema(v string) *DescribeTableInput {
	s.Schema = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *DescribeTableInput) SetSecretArn(v string) *DescribeTableInput {
	s.SecretArn = &v
	return s
}

// SetTable sets the Table field's value.
func (s *DescribeTableInput) SetTable(v string) *DescribeTableInput {
	s.Table = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *DescribeTableInput) SetWorkgroupName(v string) *DescribeTableInput {
	s.WorkgroupName = &v
	return s
}

type DescribeTableOutput struct {
	_ struct{} `type:"structure"`

	// A list of columns in the table.
	ColumnList []*ColumnMetadata `type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the
	// next NextToken parameter and retrying the command. If the NextToken field
	// is empty, all response records have been retrieved for the request.
	NextToken *string `type:"string"`

	// The table name.
	TableName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTableOutput) GoString() string {
	return s.String()
}

// SetColumnList sets the ColumnList field's value.
func (s *DescribeTableOutput) SetColumnList(v []*ColumnMetadata) *DescribeTableOutput {
	s.ColumnList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeTableOutput) SetNextToken(v string) *DescribeTableOutput {
	s.NextToken = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DescribeTableOutput) SetTableName(v string) *DescribeTableOutput {
	s.TableName = &v
	return s
}

// The SQL statement encountered an environmental error while running.
type ExecuteStatementException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception message.
	Message_ *string `locationName:"Message" type:"string"`

	// Statement identifier of the exception.
	//
	// StatementId is a required field
	StatementId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteStatementException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteStatementException) GoString() string {
	return s.String()
}

func newErrorExecuteStatementException(v protocol.ResponseMetadata) error {
	return &ExecuteStatementException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ExecuteStatementException) Code() string {
	return "ExecuteStatementException"
}

// Message returns the exception's message.
func (s *ExecuteStatementException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ExecuteStatementException) OrigErr() error {
	return nil
}

func (s *ExecuteStatementException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ExecuteStatementException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ExecuteStatementException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ExecuteStatementInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier. This parameter is required when connecting to a cluster
	// and authenticating using either Secrets Manager or temporary credentials.
	ClusterIdentifier *string `type:"string"`

	// The name of the database. This parameter is required when authenticating
	// using either Secrets Manager or temporary credentials.
	//
	// Database is a required field
	Database *string `type:"string" required:"true"`

	// The database user name. This parameter is required when connecting to a cluster
	// and authenticating using temporary credentials.
	DbUser *string `type:"string"`

	// The parameters for the SQL statement.
	Parameters []*SqlParameter `min:"1" type:"list"`

	// The name or ARN of the secret that enables access to the database. This parameter
	// is required when authenticating using Secrets Manager.
	SecretArn *string `type:"string"`

	// The SQL statement text to run.
	//
	// Sql is a required field
	Sql *string `type:"string" required:"true"`

	// The name of the SQL statement. You can name the SQL statement when you create
	// it to identify the query.
	StatementName *string `type:"string"`

	// A value that indicates whether to send an event to the Amazon EventBridge
	// event bus after the SQL statement runs.
	WithEvent *bool `type:"boolean"`

	// The serverless workgroup name. This parameter is required when connecting
	// to a serverless workgroup and authenticating using either Secrets Manager
	// or temporary credentials.
	WorkgroupName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteStatementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteStatementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteStatementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteStatementInput"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Parameters != nil && len(s.Parameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Parameters", 1))
	}
	if s.Sql == nil {
		invalidParams.Add(request.NewErrParamRequired("Sql"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}
	if s.Parameters != nil {
		for i, v := range s.Parameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ExecuteStatementInput) SetClusterIdentifier(v string) *ExecuteStatementInput {
	s.ClusterIdentifier = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *ExecuteStatementInput) SetDatabase(v string) *ExecuteStatementInput {
	s.Database = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *ExecuteStatementInput) SetDbUser(v string) *ExecuteStatementInput {
	s.DbUser = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ExecuteStatementInput) SetParameters(v []*SqlParameter) *ExecuteStatementInput {
	s.Parameters = v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *ExecuteStatementInput) SetSecretArn(v string) *ExecuteStatementInput {
	s.SecretArn = &v
	return s
}

// SetSql sets the Sql field's value.
func (s *ExecuteStatementInput) SetSql(v string) *ExecuteStatementInput {
	s.Sql = &v
	return s
}

// SetStatementName sets the StatementName field's value.
func (s *ExecuteStatementInput) SetStatementName(v string) *ExecuteStatementInput {
	s.StatementName = &v
	return s
}

// SetWithEvent sets the WithEvent field's value.
func (s *ExecuteStatementInput) SetWithEvent(v bool) *ExecuteStatementInput {
	s.WithEvent = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *ExecuteStatementInput) SetWorkgroupName(v string) *ExecuteStatementInput {
	s.WorkgroupName = &v
	return s
}

type ExecuteStatementOutput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier. This element is not returned when connecting to a
	// serverless workgroup.
	ClusterIdentifier *string `type:"string"`

	// The date and time (UTC) the statement was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The name of the database.
	Database *string `type:"string"`

	// The database user name.
	DbUser *string `type:"string"`

	// The identifier of the SQL statement whose results are to be fetched. This
	// value is a universally unique identifier (UUID) generated by Amazon Redshift
	// Data API.
	Id *string `type:"string"`

	// The name or ARN of the secret that enables access to the database.
	SecretArn *string `type:"string"`

	// The serverless workgroup name. This element is not returned when connecting
	// to a provisioned cluster.
	WorkgroupName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteStatementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecuteStatementOutput) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ExecuteStatementOutput) SetClusterIdentifier(v string) *ExecuteStatementOutput {
	s.ClusterIdentifier = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ExecuteStatementOutput) SetCreatedAt(v time.Time) *ExecuteStatementOutput {
	s.CreatedAt = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *ExecuteStatementOutput) SetDatabase(v string) *ExecuteStatementOutput {
	s.Database = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *ExecuteStatementOutput) SetDbUser(v string) *ExecuteStatementOutput {
	s.DbUser = &v
	return s
}

// SetId sets the Id field's value.
func (s *ExecuteStatementOutput) SetId(v string) *ExecuteStatementOutput {
	s.Id = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *ExecuteStatementOutput) SetSecretArn(v string) *ExecuteStatementOutput {
	s.SecretArn = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *ExecuteStatementOutput) SetWorkgroupName(v string) *ExecuteStatementOutput {
	s.WorkgroupName = &v
	return s
}

// A data value in a column.
type Field struct {
	_ struct{} `type:"structure"`

	// A value of the BLOB data type.
	// BlobValue is automatically base64 encoded/decoded by the SDK.
	BlobValue []byte `locationName:"blobValue" type:"blob"`

	// A value of the Boolean data type.
	BooleanValue *bool `locationName:"booleanValue" type:"boolean"`

	// A value of the double data type.
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// A value that indicates whether the data is NULL.
	IsNull *bool `locationName:"isNull" type:"boolean"`

	// A value of the long data type.
	LongValue *int64 `locationName:"longValue" type:"long"`

	// A value of the string data type.
	StringValue *string `locationName:"stringValue" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Field) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Field) GoString() string {
	return s.String()
}

// SetBlobValue sets the BlobValue field's value.
func (s *Field) SetBlobValue(v []byte) *Field {
	s.BlobValue = v
	return s
}

// SetBooleanValue sets the BooleanValue field's value.
func (s *Field) SetBooleanValue(v bool) *Field {
	s.BooleanValue = &v
	return s
}

// SetDoubleValue sets the DoubleValue field's value.
func (s *Field) SetDoubleValue(v float64) *Field {
	s.DoubleValue = &v
	return s
}

// SetIsNull sets the IsNull field's value.
func (s *Field) SetIsNull(v bool) *Field {
	s.IsNull = &v
	return s
}

// SetLongValue sets the LongValue field's value.
func (s *Field) SetLongValue(v int64) *Field {
	s.LongValue = &v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *Field) SetStringValue(v string) *Field {
	s.StringValue = &v
	return s
}

type GetStatementResultInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the SQL statement whose results are to be fetched. This
	// value is a universally unique identifier (UUID) generated by Amazon Redshift
	// Data API. A suffix indicates then number of the SQL statement. For example,
	// d9b6c0c9-0747-4bf4-b142-e8883122f766:2 has a suffix of :2 that indicates
	// the second SQL statement of a batch query. This identifier is returned by
	// BatchExecuteStatment, ExecuteStatment, and ListStatements.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the
	// next NextToken parameter and retrying the command. If the NextToken field
	// is empty, all response records have been retrieved for the request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStatementResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStatementResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStatementResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStatementResultInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetStatementResultInput) SetId(v string) *GetStatementResultInput {
	s.Id = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetStatementResultInput) SetNextToken(v string) *GetStatementResultInput {
	s.NextToken = &v
	return s
}

type GetStatementResultOutput struct {
	_ struct{} `type:"structure"`

	// The properties (metadata) of a column.
	ColumnMetadata []*ColumnMetadata `type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the
	// next NextToken parameter and retrying the command. If the NextToken field
	// is empty, all response records have been retrieved for the request.
	NextToken *string `type:"string"`

	// The results of the SQL statement.
	//
	// Records is a required field
	Records [][]*Field `type:"list" required:"true"`

	// The total number of rows in the result set returned from a query. You can
	// use this number to estimate the number of calls to the GetStatementResult
	// operation needed to page through the results.
	TotalNumRows *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStatementResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStatementResultOutput) GoString() string {
	return s.String()
}

// SetColumnMetadata sets the ColumnMetadata field's value.
func (s *GetStatementResultOutput) SetColumnMetadata(v []*ColumnMetadata) *GetStatementResultOutput {
	s.ColumnMetadata = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetStatementResultOutput) SetNextToken(v string) *GetStatementResultOutput {
	s.NextToken = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *GetStatementResultOutput) SetRecords(v [][]*Field) *GetStatementResultOutput {
	s.Records = v
	return s
}

// SetTotalNumRows sets the TotalNumRows field's value.
func (s *GetStatementResultOutput) SetTotalNumRows(v int64) *GetStatementResultOutput {
	s.TotalNumRows = &v
	return s
}

// The Amazon Redshift Data API operation failed due to invalid input.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDatabasesInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier. This parameter is required when connecting to a cluster
	// and authenticating using either Secrets Manager or temporary credentials.
	ClusterIdentifier *string `type:"string"`

	// The name of the database. This parameter is required when authenticating
	// using either Secrets Manager or temporary credentials.
	//
	// Database is a required field
	Database *string `type:"string" required:"true"`

	// The database user name. This parameter is required when connecting to a cluster
	// and authenticating using temporary credentials.
	DbUser *string `type:"string"`

	// The maximum number of databases to return in the response. If more databases
	// exist than fit in one response, then NextToken is returned to page through
	// the results.
	MaxResults *int64 `type:"integer"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the
	// next NextToken parameter and retrying the command. If the NextToken field
	// is empty, all response records have been retrieved for the request.
	NextToken *string `type:"string"`

	// The name or ARN of the secret that enables access to the database. This parameter
	// is required when authenticating using Secrets Manager.
	SecretArn *string `type:"string"`

	// The serverless workgroup name. This parameter is required when connecting
	// to a serverless workgroup and authenticating using either Secrets Manager
	// or temporary credentials.
	WorkgroupName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatabasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatabasesInput"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ListDatabasesInput) SetClusterIdentifier(v string) *ListDatabasesInput {
	s.ClusterIdentifier = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *ListDatabasesInput) SetDatabase(v string) *ListDatabasesInput {
	s.Database = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *ListDatabasesInput) SetDbUser(v string) *ListDatabasesInput {
	s.DbUser = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatabasesInput) SetMaxResults(v int64) *ListDatabasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatabasesInput) SetNextToken(v string) *ListDatabasesInput {
	s.NextToken = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *ListDatabasesInput) SetSecretArn(v string) *ListDatabasesInput {
	s.SecretArn = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *ListDatabasesInput) SetWorkgroupName(v string) *ListDatabasesInput {
	s.WorkgroupName = &v
	return s
}

type ListDatabasesOutput struct {
	_ struct{} `type:"structure"`

	// The names of databases.
	Databases []*string `type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the
	// next NextToken parameter and retrying the command. If the NextToken field
	// is empty, all response records have been retrieved for the request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatabasesOutput) GoString() string {
	return s.String()
}

// SetDatabases sets the Databases field's value.
func (s *ListDatabasesOutput) SetDatabases(v []*string) *ListDatabasesOutput {
	s.Databases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatabasesOutput) SetNextToken(v string) *ListDatabasesOutput {
	s.NextToken = &v
	return s
}

type ListSchemasInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier. This parameter is required when connecting to a cluster
	// and authenticating using either Secrets Manager or temporary credentials.
	ClusterIdentifier *string `type:"string"`

	// A database name. The connected database is specified when you connect with
	// your authentication credentials.
	ConnectedDatabase *string `type:"string"`

	// The name of the database that contains the schemas to list. If ConnectedDatabase
	// is not specified, this is also the database to connect to with your authentication
	// credentials.
	//
	// Database is a required field
	Database *string `type:"string" required:"true"`

	// The database user name. This parameter is required when connecting to a cluster
	// and authenticating using temporary credentials.
	DbUser *string `type:"string"`

	// The maximum number of schemas to return in the response. If more schemas
	// exist than fit in one response, then NextToken is returned to page through
	// the results.
	MaxResults *int64 `type:"integer"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the
	// next NextToken parameter and retrying the command. If the NextToken field
	// is empty, all response records have been retrieved for the request.
	NextToken *string `type:"string"`

	// A pattern to filter results by schema name. Within a schema pattern, "%"
	// means match any substring of 0 or more characters and "_" means match any
	// one character. Only schema name entries matching the search pattern are returned.
	SchemaPattern *string `type:"string"`

	// The name or ARN of the secret that enables access to the database. This parameter
	// is required when authenticating using Secrets Manager.
	SecretArn *string `type:"string"`

	// The serverless workgroup name. This parameter is required when connecting
	// to a serverless workgroup and authenticating using either Secrets Manager
	// or temporary credentials.
	WorkgroupName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSchemasInput"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ListSchemasInput) SetClusterIdentifier(v string) *ListSchemasInput {
	s.ClusterIdentifier = &v
	return s
}

// SetConnectedDatabase sets the ConnectedDatabase field's value.
func (s *ListSchemasInput) SetConnectedDatabase(v string) *ListSchemasInput {
	s.ConnectedDatabase = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *ListSchemasInput) SetDatabase(v string) *ListSchemasInput {
	s.Database = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *ListSchemasInput) SetDbUser(v string) *ListSchemasInput {
	s.DbUser = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSchemasInput) SetMaxResults(v int64) *ListSchemasInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemasInput) SetNextToken(v string) *ListSchemasInput {
	s.NextToken = &v
	return s
}

// SetSchemaPattern sets the SchemaPattern field's value.
func (s *ListSchemasInput) SetSchemaPattern(v string) *ListSchemasInput {
	s.SchemaPattern = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *ListSchemasInput) SetSecretArn(v string) *ListSchemasInput {
	s.SecretArn = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *ListSchemasInput) SetWorkgroupName(v string) *ListSchemasInput {
	s.WorkgroupName = &v
	return s
}

type ListSchemasOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the
	// next NextToken parameter and retrying the command. If the NextToken field
	// is empty, all response records have been retrieved for the request.
	NextToken *string `type:"string"`

	// The schemas that match the request pattern.
	Schemas []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSchemasOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemasOutput) SetNextToken(v string) *ListSchemasOutput {
	s.NextToken = &v
	return s
}

// SetSchemas sets the Schemas field's value.
func (s *ListSchemasOutput) SetSchemas(v []*string) *ListSchemasOutput {
	s.Schemas = v
	return s
}

type ListStatementsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of SQL statements to return in the response. If more SQL
	// statements exist than fit in one response, then NextToken is returned to
	// page through the results.
	MaxResults *int64 `type:"integer"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the
	// next NextToken parameter and retrying the command. If the NextToken field
	// is empty, all response records have been retrieved for the request.
	NextToken *string `type:"string"`

	// A value that filters which statements to return in the response. If true,
	// all statements run by the caller's IAM role are returned. If false, only
	// statements run by the caller's IAM role in the current IAM session are returned.
	// The default is true.
	RoleLevel *bool `type:"boolean"`

	// The name of the SQL statement specified as input to BatchExecuteStatement
	// or ExecuteStatement to identify the query. You can list multiple statements
	// by providing a prefix that matches the beginning of the statement name. For
	// example, to list myStatement1, myStatement2, myStatement3, and so on, then
	// provide the a value of myStatement. Data API does a case-sensitive match
	// of SQL statement names to the prefix value you provide.
	StatementName *string `type:"string"`

	// The status of the SQL statement to list. Status values are defined as follows:
	//
	//    * ABORTED - The query run was stopped by the user.
	//
	//    * ALL - A status value that includes all query statuses. This value can
	//    be used to filter results.
	//
	//    * FAILED - The query run failed.
	//
	//    * FINISHED - The query has finished running.
	//
	//    * PICKED - The query has been chosen to be run.
	//
	//    * STARTED - The query run has started.
	//
	//    * SUBMITTED - The query was submitted, but not yet processed.
	Status *string `type:"string" enum:"StatusString"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStatementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStatementsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStatementsInput) SetMaxResults(v int64) *ListStatementsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStatementsInput) SetNextToken(v string) *ListStatementsInput {
	s.NextToken = &v
	return s
}

// SetRoleLevel sets the RoleLevel field's value.
func (s *ListStatementsInput) SetRoleLevel(v bool) *ListStatementsInput {
	s.RoleLevel = &v
	return s
}

// SetStatementName sets the StatementName field's value.
func (s *ListStatementsInput) SetStatementName(v string) *ListStatementsInput {
	s.StatementName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListStatementsInput) SetStatus(v string) *ListStatementsInput {
	s.Status = &v
	return s
}

type ListStatementsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the
	// next NextToken parameter and retrying the command. If the NextToken field
	// is empty, all response records have been retrieved for the request.
	NextToken *string `type:"string"`

	// The SQL statements.
	//
	// Statements is a required field
	Statements []*StatementData `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStatementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStatementsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStatementsOutput) SetNextToken(v string) *ListStatementsOutput {
	s.NextToken = &v
	return s
}

// SetStatements sets the Statements field's value.
func (s *ListStatementsOutput) SetStatements(v []*StatementData) *ListStatementsOutput {
	s.Statements = v
	return s
}

type ListTablesInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier. This parameter is required when connecting to a cluster
	// and authenticating using either Secrets Manager or temporary credentials.
	ClusterIdentifier *string `type:"string"`

	// A database name. The connected database is specified when you connect with
	// your authentication credentials.
	ConnectedDatabase *string `type:"string"`

	// The name of the database that contains the tables to list. If ConnectedDatabase
	// is not specified, this is also the database to connect to with your authentication
	// credentials.
	//
	// Database is a required field
	Database *string `type:"string" required:"true"`

	// The database user name. This parameter is required when connecting to a cluster
	// and authenticating using temporary credentials.
	DbUser *string `type:"string"`

	// The maximum number of tables to return in the response. If more tables exist
	// than fit in one response, then NextToken is returned to page through the
	// results.
	MaxResults *int64 `type:"integer"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the
	// next NextToken parameter and retrying the command. If the NextToken field
	// is empty, all response records have been retrieved for the request.
	NextToken *string `type:"string"`

	// A pattern to filter results by schema name. Within a schema pattern, "%"
	// means match any substring of 0 or more characters and "_" means match any
	// one character. Only schema name entries matching the search pattern are returned.
	// If SchemaPattern is not specified, then all tables that match TablePattern
	// are returned. If neither SchemaPattern or TablePattern are specified, then
	// all tables are returned.
	SchemaPattern *string `type:"string"`

	// The name or ARN of the secret that enables access to the database. This parameter
	// is required when authenticating using Secrets Manager.
	SecretArn *string `type:"string"`

	// A pattern to filter results by table name. Within a table pattern, "%" means
	// match any substring of 0 or more characters and "_" means match any one character.
	// Only table name entries matching the search pattern are returned. If TablePattern
	// is not specified, then all tables that match SchemaPatternare returned. If
	// neither SchemaPattern or TablePattern are specified, then all tables are
	// returned.
	TablePattern *string `type:"string"`

	// The serverless workgroup name. This parameter is required when connecting
	// to a serverless workgroup and authenticating using either Secrets Manager
	// or temporary credentials.
	WorkgroupName *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTablesInput"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ListTablesInput) SetClusterIdentifier(v string) *ListTablesInput {
	s.ClusterIdentifier = &v
	return s
}

// SetConnectedDatabase sets the ConnectedDatabase field's value.
func (s *ListTablesInput) SetConnectedDatabase(v string) *ListTablesInput {
	s.ConnectedDatabase = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *ListTablesInput) SetDatabase(v string) *ListTablesInput {
	s.Database = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *ListTablesInput) SetDbUser(v string) *ListTablesInput {
	s.DbUser = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTablesInput) SetMaxResults(v int64) *ListTablesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTablesInput) SetNextToken(v string) *ListTablesInput {
	s.NextToken = &v
	return s
}

// SetSchemaPattern sets the SchemaPattern field's value.
func (s *ListTablesInput) SetSchemaPattern(v string) *ListTablesInput {
	s.SchemaPattern = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *ListTablesInput) SetSecretArn(v string) *ListTablesInput {
	s.SecretArn = &v
	return s
}

// SetTablePattern sets the TablePattern field's value.
func (s *ListTablesInput) SetTablePattern(v string) *ListTablesInput {
	s.TablePattern = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *ListTablesInput) SetWorkgroupName(v string) *ListTablesInput {
	s.WorkgroupName = &v
	return s
}

type ListTablesOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the
	// next NextToken parameter and retrying the command. If the NextToken field
	// is empty, all response records have been retrieved for the request.
	NextToken *string `type:"string"`

	// The tables that match the request pattern.
	Tables []*TableMember `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTablesOutput) SetNextToken(v string) *ListTablesOutput {
	s.NextToken = &v
	return s
}

// SetTables sets the Tables field's value.
func (s *ListTablesOutput) SetTables(v []*TableMember) *ListTablesOutput {
	s.Tables = v
	return s
}

// The Amazon Redshift Data API operation failed due to a missing resource.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception message.
	Message_ *string `locationName:"Message" type:"string"`

	// Resource identifier associated with the exception.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A parameter used in a SQL statement.
type SqlParameter struct {
	_ struct{} `type:"structure"`

	// The name of the parameter.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The value of the parameter. Amazon Redshift implicitly converts to the proper
	// data type. For more inforation, see Data types (https://docs.aws.amazon.com/redshift/latest/dg/c_Supported_data_types.html)
	// in the Amazon Redshift Database Developer Guide.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqlParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqlParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqlParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SqlParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SqlParameter) SetName(v string) *SqlParameter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SqlParameter) SetValue(v string) *SqlParameter {
	s.Value = &v
	return s
}

// The SQL statement to run.
type StatementData struct {
	_ struct{} `type:"structure"`

	// The date and time (UTC) the statement was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The SQL statement identifier. This value is a universally unique identifier
	// (UUID) generated by Amazon Redshift Data API.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// A value that indicates whether the statement is a batch query request.
	IsBatchStatement *bool `type:"boolean"`

	// The parameters used in a SQL statement.
	QueryParameters []*SqlParameter `min:"1" type:"list"`

	// The SQL statement.
	QueryString *string `type:"string"`

	// One or more SQL statements. Each query string in the array corresponds to
	// one of the queries in a batch query request.
	QueryStrings []*string `type:"list"`

	// The name or Amazon Resource Name (ARN) of the secret that enables access
	// to the database.
	SecretArn *string `type:"string"`

	// The name of the SQL statement.
	StatementName *string `type:"string"`

	// The status of the SQL statement. An example is the that the SQL statement
	// finished.
	Status *string `type:"string" enum:"StatusString"`

	// The date and time (UTC) that the statement metadata was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatementData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatementData) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *StatementData) SetCreatedAt(v time.Time) *StatementData {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *StatementData) SetId(v string) *StatementData {
	s.Id = &v
	return s
}

// SetIsBatchStatement sets the IsBatchStatement field's value.
func (s *StatementData) SetIsBatchStatement(v bool) *StatementData {
	s.IsBatchStatement = &v
	return s
}

// SetQueryParameters sets the QueryParameters field's value.
func (s *StatementData) SetQueryParameters(v []*SqlParameter) *StatementData {
	s.QueryParameters = v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *StatementData) SetQueryString(v string) *StatementData {
	s.QueryString = &v
	return s
}

// SetQueryStrings sets the QueryStrings field's value.
func (s *StatementData) SetQueryStrings(v []*string) *StatementData {
	s.QueryStrings = v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *StatementData) SetSecretArn(v string) *StatementData {
	s.SecretArn = &v
	return s
}

// SetStatementName sets the StatementName field's value.
func (s *StatementData) SetStatementName(v string) *StatementData {
	s.StatementName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StatementData) SetStatus(v string) *StatementData {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *StatementData) SetUpdatedAt(v time.Time) *StatementData {
	s.UpdatedAt = &v
	return s
}

// Information about an SQL statement.
type SubStatementData struct {
	_ struct{} `type:"structure"`

	// The date and time (UTC) the statement was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The amount of time in nanoseconds that the statement ran.
	Duration *int64 `type:"long"`

	// The error message from the cluster if the SQL statement encountered an error
	// while running.
	Error *string `type:"string"`

	// A value that indicates whether the statement has a result set. The result
	// set can be empty. The value is true for an empty result set.
	HasResultSet *bool `type:"boolean"`

	// The identifier of the SQL statement. This value is a universally unique identifier
	// (UUID) generated by Amazon Redshift Data API. A suffix indicates the number
	// of the SQL statement. For example, d9b6c0c9-0747-4bf4-b142-e8883122f766:2
	// has a suffix of :2 that indicates the second SQL statement of a batch query.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The SQL statement text.
	QueryString *string `type:"string"`

	// The SQL statement identifier. This value is a universally unique identifier
	// (UUID) generated by Amazon Redshift Data API.
	RedshiftQueryId *int64 `type:"long"`

	// Either the number of rows returned from the SQL statement or the number of
	// rows affected. If result size is greater than zero, the result rows can be
	// the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE,
	// COPY, and others. A -1 indicates the value is null.
	ResultRows *int64 `type:"long"`

	// The size in bytes of the returned results. A -1 indicates the value is null.
	ResultSize *int64 `type:"long"`

	// The status of the SQL statement. An example is the that the SQL statement
	// finished.
	Status *string `type:"string" enum:"StatementStatusString"`

	// The date and time (UTC) that the statement metadata was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubStatementData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubStatementData) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SubStatementData) SetCreatedAt(v time.Time) *SubStatementData {
	s.CreatedAt = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *SubStatementData) SetDuration(v int64) *SubStatementData {
	s.Duration = &v
	return s
}

// SetError sets the Error field's value.
func (s *SubStatementData) SetError(v string) *SubStatementData {
	s.Error = &v
	return s
}

// SetHasResultSet sets the HasResultSet field's value.
func (s *SubStatementData) SetHasResultSet(v bool) *SubStatementData {
	s.HasResultSet = &v
	return s
}

// SetId sets the Id field's value.
func (s *SubStatementData) SetId(v string) *SubStatementData {
	s.Id = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *SubStatementData) SetQueryString(v string) *SubStatementData {
	s.QueryString = &v
	return s
}

// SetRedshiftQueryId sets the RedshiftQueryId field's value.
func (s *SubStatementData) SetRedshiftQueryId(v int64) *SubStatementData {
	s.RedshiftQueryId = &v
	return s
}

// SetResultRows sets the ResultRows field's value.
func (s *SubStatementData) SetResultRows(v int64) *SubStatementData {
	s.ResultRows = &v
	return s
}

// SetResultSize sets the ResultSize field's value.
func (s *SubStatementData) SetResultSize(v int64) *SubStatementData {
	s.ResultSize = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SubStatementData) SetStatus(v string) *SubStatementData {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *SubStatementData) SetUpdatedAt(v time.Time) *SubStatementData {
	s.UpdatedAt = &v
	return s
}

// The properties of a table.
type TableMember struct {
	_ struct{} `type:"structure"`

	// The name of the table.
	Name *string `locationName:"name" type:"string"`

	// The schema containing the table.
	Schema *string `locationName:"schema" type:"string"`

	// The type of the table. Possible values include TABLE, VIEW, SYSTEM TABLE,
	// GLOBAL TEMPORARY, LOCAL TEMPORARY, ALIAS, and SYNONYM.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableMember) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *TableMember) SetName(v string) *TableMember {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *TableMember) SetSchema(v string) *TableMember {
	s.Schema = &v
	return s
}

// SetType sets the Type field's value.
func (s *TableMember) SetType(v string) *TableMember {
	s.Type = &v
	return s
}

// The Amazon Redshift Data API operation failed due to invalid input.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// StatementStatusStringSubmitted is a StatementStatusString enum value
	StatementStatusStringSubmitted = "SUBMITTED"

	// StatementStatusStringPicked is a StatementStatusString enum value
	StatementStatusStringPicked = "PICKED"

	// StatementStatusStringStarted is a StatementStatusString enum value
	StatementStatusStringStarted = "STARTED"

	// StatementStatusStringFinished is a StatementStatusString enum value
	StatementStatusStringFinished = "FINISHED"

	// StatementStatusStringAborted is a StatementStatusString enum value
	StatementStatusStringAborted = "ABORTED"

	// StatementStatusStringFailed is a StatementStatusString enum value
	StatementStatusStringFailed = "FAILED"
)

// StatementStatusString_Values returns all elements of the StatementStatusString enum
func StatementStatusString_Values() []string {
	return []string{
		StatementStatusStringSubmitted,
		StatementStatusStringPicked,
		StatementStatusStringStarted,
		StatementStatusStringFinished,
		StatementStatusStringAborted,
		StatementStatusStringFailed,
	}
}

const (
	// StatusStringSubmitted is a StatusString enum value
	StatusStringSubmitted = "SUBMITTED"

	// StatusStringPicked is a StatusString enum value
	StatusStringPicked = "PICKED"

	// StatusStringStarted is a StatusString enum value
	StatusStringStarted = "STARTED"

	// StatusStringFinished is a StatusString enum value
	StatusStringFinished = "FINISHED"

	// StatusStringAborted is a StatusString enum value
	StatusStringAborted = "ABORTED"

	// StatusStringFailed is a StatusString enum value
	StatusStringFailed = "FAILED"

	// StatusStringAll is a StatusString enum value
	StatusStringAll = "ALL"
)

// StatusString_Values returns all elements of the StatusString enum
func StatusString_Values() []string {
	return []string{
		StatusStringSubmitted,
		StatusStringPicked,
		StatusStringStarted,
		StatusStringFinished,
		StatusStringAborted,
		StatusStringFailed,
		StatusStringAll,
	}
}
