// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/cloud/baremetalsolution/v2/provisioning.proto

package baremetalsolutionpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The possible states for this ProvisioningConfig.
type ProvisioningConfig_State int32

const (
	// State wasn't specified.
	ProvisioningConfig_STATE_UNSPECIFIED ProvisioningConfig_State = 0
	// ProvisioningConfig is a draft and can be freely modified.
	ProvisioningConfig_DRAFT ProvisioningConfig_State = 1
	// ProvisioningConfig was already submitted and cannot be modified.
	ProvisioningConfig_SUBMITTED ProvisioningConfig_State = 2
	// ProvisioningConfig was in the provisioning state.  Initially this state
	// comes from the work order table in big query when SNOW is used.  Later
	// this field can be set by the work order API.
	ProvisioningConfig_PROVISIONING ProvisioningConfig_State = 3
	// ProvisioningConfig was provisioned, meaning the resources exist.
	ProvisioningConfig_PROVISIONED ProvisioningConfig_State = 4
	// ProvisioningConfig was validated.  A validation tool will be run to
	// set this state.
	ProvisioningConfig_VALIDATED ProvisioningConfig_State = 5
	// ProvisioningConfig was canceled.
	ProvisioningConfig_CANCELLED ProvisioningConfig_State = 6
	// The request is submitted for provisioning, with error return.
	ProvisioningConfig_FAILED ProvisioningConfig_State = 7
)

// Enum value maps for ProvisioningConfig_State.
var (
	ProvisioningConfig_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "DRAFT",
		2: "SUBMITTED",
		3: "PROVISIONING",
		4: "PROVISIONED",
		5: "VALIDATED",
		6: "CANCELLED",
		7: "FAILED",
	}
	ProvisioningConfig_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"DRAFT":             1,
		"SUBMITTED":         2,
		"PROVISIONING":      3,
		"PROVISIONED":       4,
		"VALIDATED":         5,
		"CANCELLED":         6,
		"FAILED":            7,
	}
)

func (x ProvisioningConfig_State) Enum() *ProvisioningConfig_State {
	p := new(ProvisioningConfig_State)
	*p = x
	return p
}

func (x ProvisioningConfig_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProvisioningConfig_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[0].Descriptor()
}

func (ProvisioningConfig_State) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[0]
}

func (x ProvisioningConfig_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProvisioningConfig_State.Descriptor instead.
func (ProvisioningConfig_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{0, 0}
}

// The available asset types for intake.
type ProvisioningQuota_AssetType int32

const (
	// The unspecified type.
	ProvisioningQuota_ASSET_TYPE_UNSPECIFIED ProvisioningQuota_AssetType = 0
	// The server asset type.
	ProvisioningQuota_ASSET_TYPE_SERVER ProvisioningQuota_AssetType = 1
	// The storage asset type.
	ProvisioningQuota_ASSET_TYPE_STORAGE ProvisioningQuota_AssetType = 2
	// The network asset type.
	ProvisioningQuota_ASSET_TYPE_NETWORK ProvisioningQuota_AssetType = 3
)

// Enum value maps for ProvisioningQuota_AssetType.
var (
	ProvisioningQuota_AssetType_name = map[int32]string{
		0: "ASSET_TYPE_UNSPECIFIED",
		1: "ASSET_TYPE_SERVER",
		2: "ASSET_TYPE_STORAGE",
		3: "ASSET_TYPE_NETWORK",
	}
	ProvisioningQuota_AssetType_value = map[string]int32{
		"ASSET_TYPE_UNSPECIFIED": 0,
		"ASSET_TYPE_SERVER":      1,
		"ASSET_TYPE_STORAGE":     2,
		"ASSET_TYPE_NETWORK":     3,
	}
)

func (x ProvisioningQuota_AssetType) Enum() *ProvisioningQuota_AssetType {
	p := new(ProvisioningQuota_AssetType)
	*p = x
	return p
}

func (x ProvisioningQuota_AssetType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProvisioningQuota_AssetType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[1].Descriptor()
}

func (ProvisioningQuota_AssetType) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[1]
}

func (x ProvisioningQuota_AssetType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProvisioningQuota_AssetType.Descriptor instead.
func (ProvisioningQuota_AssetType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{3, 0}
}

// The network configuration of the instance.
type InstanceConfig_NetworkConfig int32

const (
	// The unspecified network configuration.
	InstanceConfig_NETWORKCONFIG_UNSPECIFIED InstanceConfig_NetworkConfig = 0
	// Instance part of single client network and single private network.
	InstanceConfig_SINGLE_VLAN InstanceConfig_NetworkConfig = 1
	// Instance part of multiple (or single) client networks and private
	// networks.
	InstanceConfig_MULTI_VLAN InstanceConfig_NetworkConfig = 2
)

// Enum value maps for InstanceConfig_NetworkConfig.
var (
	InstanceConfig_NetworkConfig_name = map[int32]string{
		0: "NETWORKCONFIG_UNSPECIFIED",
		1: "SINGLE_VLAN",
		2: "MULTI_VLAN",
	}
	InstanceConfig_NetworkConfig_value = map[string]int32{
		"NETWORKCONFIG_UNSPECIFIED": 0,
		"SINGLE_VLAN":               1,
		"MULTI_VLAN":                2,
	}
)

func (x InstanceConfig_NetworkConfig) Enum() *InstanceConfig_NetworkConfig {
	p := new(InstanceConfig_NetworkConfig)
	*p = x
	return p
}

func (x InstanceConfig_NetworkConfig) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceConfig_NetworkConfig) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[2].Descriptor()
}

func (InstanceConfig_NetworkConfig) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[2]
}

func (x InstanceConfig_NetworkConfig) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceConfig_NetworkConfig.Descriptor instead.
func (InstanceConfig_NetworkConfig) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{6, 0}
}

// The types of Volumes.
type VolumeConfig_Type int32

const (
	// The unspecified type.
	VolumeConfig_TYPE_UNSPECIFIED VolumeConfig_Type = 0
	// This Volume is on flash.
	VolumeConfig_FLASH VolumeConfig_Type = 1
	// This Volume is on disk.
	VolumeConfig_DISK VolumeConfig_Type = 2
)

// Enum value maps for VolumeConfig_Type.
var (
	VolumeConfig_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "FLASH",
		2: "DISK",
	}
	VolumeConfig_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"FLASH":            1,
		"DISK":             2,
	}
)

func (x VolumeConfig_Type) Enum() *VolumeConfig_Type {
	p := new(VolumeConfig_Type)
	*p = x
	return p
}

func (x VolumeConfig_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VolumeConfig_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[3].Descriptor()
}

func (VolumeConfig_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[3]
}

func (x VolumeConfig_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VolumeConfig_Type.Descriptor instead.
func (VolumeConfig_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{7, 0}
}

// The protocol used to access the volume.
type VolumeConfig_Protocol int32

const (
	// Unspecified value.
	VolumeConfig_PROTOCOL_UNSPECIFIED VolumeConfig_Protocol = 0
	// Fibre channel.
	VolumeConfig_PROTOCOL_FC VolumeConfig_Protocol = 1
	// Network file system.
	VolumeConfig_PROTOCOL_NFS VolumeConfig_Protocol = 2
)

// Enum value maps for VolumeConfig_Protocol.
var (
	VolumeConfig_Protocol_name = map[int32]string{
		0: "PROTOCOL_UNSPECIFIED",
		1: "PROTOCOL_FC",
		2: "PROTOCOL_NFS",
	}
	VolumeConfig_Protocol_value = map[string]int32{
		"PROTOCOL_UNSPECIFIED": 0,
		"PROTOCOL_FC":          1,
		"PROTOCOL_NFS":         2,
	}
)

func (x VolumeConfig_Protocol) Enum() *VolumeConfig_Protocol {
	p := new(VolumeConfig_Protocol)
	*p = x
	return p
}

func (x VolumeConfig_Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VolumeConfig_Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[4].Descriptor()
}

func (VolumeConfig_Protocol) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[4]
}

func (x VolumeConfig_Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VolumeConfig_Protocol.Descriptor instead.
func (VolumeConfig_Protocol) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{7, 1}
}

// Permissions that can granted for an export.
type VolumeConfig_NfsExport_Permissions int32

const (
	// Unspecified value.
	VolumeConfig_NfsExport_PERMISSIONS_UNSPECIFIED VolumeConfig_NfsExport_Permissions = 0
	// Read-only permission.
	VolumeConfig_NfsExport_READ_ONLY VolumeConfig_NfsExport_Permissions = 1
	// Read-write permission.
	VolumeConfig_NfsExport_READ_WRITE VolumeConfig_NfsExport_Permissions = 2
)

// Enum value maps for VolumeConfig_NfsExport_Permissions.
var (
	VolumeConfig_NfsExport_Permissions_name = map[int32]string{
		0: "PERMISSIONS_UNSPECIFIED",
		1: "READ_ONLY",
		2: "READ_WRITE",
	}
	VolumeConfig_NfsExport_Permissions_value = map[string]int32{
		"PERMISSIONS_UNSPECIFIED": 0,
		"READ_ONLY":               1,
		"READ_WRITE":              2,
	}
)

func (x VolumeConfig_NfsExport_Permissions) Enum() *VolumeConfig_NfsExport_Permissions {
	p := new(VolumeConfig_NfsExport_Permissions)
	*p = x
	return p
}

func (x VolumeConfig_NfsExport_Permissions) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VolumeConfig_NfsExport_Permissions) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[5].Descriptor()
}

func (VolumeConfig_NfsExport_Permissions) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[5]
}

func (x VolumeConfig_NfsExport_Permissions) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VolumeConfig_NfsExport_Permissions.Descriptor instead.
func (VolumeConfig_NfsExport_Permissions) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{7, 1, 0}
}

// Network type.
type NetworkConfig_Type int32

const (
	// Unspecified value.
	NetworkConfig_TYPE_UNSPECIFIED NetworkConfig_Type = 0
	// Client network, that is a network peered to a GCP VPC.
	NetworkConfig_CLIENT NetworkConfig_Type = 1
	// Private network, that is a network local to the BMS POD.
	NetworkConfig_PRIVATE NetworkConfig_Type = 2
)

// Enum value maps for NetworkConfig_Type.
var (
	NetworkConfig_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "CLIENT",
		2: "PRIVATE",
	}
	NetworkConfig_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"CLIENT":           1,
		"PRIVATE":          2,
	}
)

func (x NetworkConfig_Type) Enum() *NetworkConfig_Type {
	p := new(NetworkConfig_Type)
	*p = x
	return p
}

func (x NetworkConfig_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkConfig_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[6].Descriptor()
}

func (NetworkConfig_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[6]
}

func (x NetworkConfig_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkConfig_Type.Descriptor instead.
func (NetworkConfig_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{8, 0}
}

// Interconnect bandwidth.
type NetworkConfig_Bandwidth int32

const (
	// Unspecified value.
	NetworkConfig_BANDWIDTH_UNSPECIFIED NetworkConfig_Bandwidth = 0
	// 1 Gbps.
	NetworkConfig_BW_1_GBPS NetworkConfig_Bandwidth = 1
	// 2 Gbps.
	NetworkConfig_BW_2_GBPS NetworkConfig_Bandwidth = 2
	// 5 Gbps.
	NetworkConfig_BW_5_GBPS NetworkConfig_Bandwidth = 3
	// 10 Gbps.
	NetworkConfig_BW_10_GBPS NetworkConfig_Bandwidth = 4
)

// Enum value maps for NetworkConfig_Bandwidth.
var (
	NetworkConfig_Bandwidth_name = map[int32]string{
		0: "BANDWIDTH_UNSPECIFIED",
		1: "BW_1_GBPS",
		2: "BW_2_GBPS",
		3: "BW_5_GBPS",
		4: "BW_10_GBPS",
	}
	NetworkConfig_Bandwidth_value = map[string]int32{
		"BANDWIDTH_UNSPECIFIED": 0,
		"BW_1_GBPS":             1,
		"BW_2_GBPS":             2,
		"BW_5_GBPS":             3,
		"BW_10_GBPS":            4,
	}
)

func (x NetworkConfig_Bandwidth) Enum() *NetworkConfig_Bandwidth {
	p := new(NetworkConfig_Bandwidth)
	*p = x
	return p
}

func (x NetworkConfig_Bandwidth) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkConfig_Bandwidth) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[7].Descriptor()
}

func (NetworkConfig_Bandwidth) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[7]
}

func (x NetworkConfig_Bandwidth) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkConfig_Bandwidth.Descriptor instead.
func (NetworkConfig_Bandwidth) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{8, 1}
}

// Service network block.
type NetworkConfig_ServiceCidr int32

const (
	// Unspecified value.
	NetworkConfig_SERVICE_CIDR_UNSPECIFIED NetworkConfig_ServiceCidr = 0
	// Services are disabled for the given network.
	NetworkConfig_DISABLED NetworkConfig_ServiceCidr = 1
	// Use the highest /26 block of the network to host services.
	NetworkConfig_HIGH_26 NetworkConfig_ServiceCidr = 2
	// Use the highest /27 block of the network to host services.
	NetworkConfig_HIGH_27 NetworkConfig_ServiceCidr = 3
	// Use the highest /28 block of the network to host services.
	NetworkConfig_HIGH_28 NetworkConfig_ServiceCidr = 4
)

// Enum value maps for NetworkConfig_ServiceCidr.
var (
	NetworkConfig_ServiceCidr_name = map[int32]string{
		0: "SERVICE_CIDR_UNSPECIFIED",
		1: "DISABLED",
		2: "HIGH_26",
		3: "HIGH_27",
		4: "HIGH_28",
	}
	NetworkConfig_ServiceCidr_value = map[string]int32{
		"SERVICE_CIDR_UNSPECIFIED": 0,
		"DISABLED":                 1,
		"HIGH_26":                  2,
		"HIGH_27":                  3,
		"HIGH_28":                  4,
	}
)

func (x NetworkConfig_ServiceCidr) Enum() *NetworkConfig_ServiceCidr {
	p := new(NetworkConfig_ServiceCidr)
	*p = x
	return p
}

func (x NetworkConfig_ServiceCidr) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkConfig_ServiceCidr) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[8].Descriptor()
}

func (NetworkConfig_ServiceCidr) Type() protoreflect.EnumType {
	return &file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes[8]
}

func (x NetworkConfig_ServiceCidr) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkConfig_ServiceCidr.Descriptor instead.
func (NetworkConfig_ServiceCidr) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{8, 2}
}

// A provisioning configuration.
type ProvisioningConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The system-generated name of the provisioning config. This
	// follows the UUID format.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Instances to be created.
	Instances []*InstanceConfig `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
	// Networks to be created.
	Networks []*NetworkConfig `protobuf:"bytes,3,rep,name=networks,proto3" json:"networks,omitempty"`
	// Volumes to be created.
	Volumes []*VolumeConfig `protobuf:"bytes,4,rep,name=volumes,proto3" json:"volumes,omitempty"`
	// A generated ticket id to track provisioning request.
	TicketId string `protobuf:"bytes,5,opt,name=ticket_id,json=ticketId,proto3" json:"ticket_id,omitempty"`
	// A service account to enable customers to access instance credentials upon
	// handover.
	HandoverServiceAccount string `protobuf:"bytes,6,opt,name=handover_service_account,json=handoverServiceAccount,proto3" json:"handover_service_account,omitempty"`
	// Email provided to send a confirmation with provisioning config to.
	// Deprecated in favour of email field in request messages.
	//
	// Deprecated: Marked as deprecated in google/cloud/baremetalsolution/v2/provisioning.proto.
	Email string `protobuf:"bytes,7,opt,name=email,proto3" json:"email,omitempty"`
	// Output only. State of ProvisioningConfig.
	State ProvisioningConfig_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.baremetalsolution.v2.ProvisioningConfig_State" json:"state,omitempty"`
	// Optional. Location name of this ProvisioningConfig.
	// It is optional only for Intake UI transition period.
	Location string `protobuf:"bytes,9,opt,name=location,proto3" json:"location,omitempty"`
	// Output only. Last update timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. URI to Cloud Console UI view of this provisioning config.
	CloudConsoleUri string `protobuf:"bytes,11,opt,name=cloud_console_uri,json=cloudConsoleUri,proto3" json:"cloud_console_uri,omitempty"`
	// If true, VPC SC is enabled for the cluster.
	VpcScEnabled bool `protobuf:"varint,12,opt,name=vpc_sc_enabled,json=vpcScEnabled,proto3" json:"vpc_sc_enabled,omitempty"`
	// Optional status messages associated with the FAILED state.
	StatusMessage string `protobuf:"bytes,13,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Optional. The user-defined identifier of the provisioning config.
	CustomId string `protobuf:"bytes,14,opt,name=custom_id,json=customId,proto3" json:"custom_id,omitempty"`
}

func (x *ProvisioningConfig) Reset() {
	*x = ProvisioningConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisioningConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisioningConfig) ProtoMessage() {}

func (x *ProvisioningConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisioningConfig.ProtoReflect.Descriptor instead.
func (*ProvisioningConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{0}
}

func (x *ProvisioningConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProvisioningConfig) GetInstances() []*InstanceConfig {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *ProvisioningConfig) GetNetworks() []*NetworkConfig {
	if x != nil {
		return x.Networks
	}
	return nil
}

func (x *ProvisioningConfig) GetVolumes() []*VolumeConfig {
	if x != nil {
		return x.Volumes
	}
	return nil
}

func (x *ProvisioningConfig) GetTicketId() string {
	if x != nil {
		return x.TicketId
	}
	return ""
}

func (x *ProvisioningConfig) GetHandoverServiceAccount() string {
	if x != nil {
		return x.HandoverServiceAccount
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/baremetalsolution/v2/provisioning.proto.
func (x *ProvisioningConfig) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *ProvisioningConfig) GetState() ProvisioningConfig_State {
	if x != nil {
		return x.State
	}
	return ProvisioningConfig_STATE_UNSPECIFIED
}

func (x *ProvisioningConfig) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *ProvisioningConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ProvisioningConfig) GetCloudConsoleUri() string {
	if x != nil {
		return x.CloudConsoleUri
	}
	return ""
}

func (x *ProvisioningConfig) GetVpcScEnabled() bool {
	if x != nil {
		return x.VpcScEnabled
	}
	return false
}

func (x *ProvisioningConfig) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *ProvisioningConfig) GetCustomId() string {
	if x != nil {
		return x.CustomId
	}
	return ""
}

// Request for SubmitProvisioningConfig.
type SubmitProvisioningConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent project and location containing the
	// ProvisioningConfig.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ProvisioningConfig to create.
	ProvisioningConfig *ProvisioningConfig `protobuf:"bytes,2,opt,name=provisioning_config,json=provisioningConfig,proto3" json:"provisioning_config,omitempty"`
	// Optional. Email provided to send a confirmation with provisioning config
	// to.
	Email string `protobuf:"bytes,3,opt,name=email,proto3" json:"email,omitempty"`
}

func (x *SubmitProvisioningConfigRequest) Reset() {
	*x = SubmitProvisioningConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubmitProvisioningConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubmitProvisioningConfigRequest) ProtoMessage() {}

func (x *SubmitProvisioningConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubmitProvisioningConfigRequest.ProtoReflect.Descriptor instead.
func (*SubmitProvisioningConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{1}
}

func (x *SubmitProvisioningConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SubmitProvisioningConfigRequest) GetProvisioningConfig() *ProvisioningConfig {
	if x != nil {
		return x.ProvisioningConfig
	}
	return nil
}

func (x *SubmitProvisioningConfigRequest) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

// Response for SubmitProvisioningConfig.
type SubmitProvisioningConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The submitted provisioning config.
	ProvisioningConfig *ProvisioningConfig `protobuf:"bytes,1,opt,name=provisioning_config,json=provisioningConfig,proto3" json:"provisioning_config,omitempty"`
}

func (x *SubmitProvisioningConfigResponse) Reset() {
	*x = SubmitProvisioningConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubmitProvisioningConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubmitProvisioningConfigResponse) ProtoMessage() {}

func (x *SubmitProvisioningConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubmitProvisioningConfigResponse.ProtoReflect.Descriptor instead.
func (*SubmitProvisioningConfigResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{2}
}

func (x *SubmitProvisioningConfigResponse) GetProvisioningConfig() *ProvisioningConfig {
	if x != nil {
		return x.ProvisioningConfig
	}
	return nil
}

// A provisioning quota for a given project.
type ProvisioningQuota struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the provisioning quota.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The asset type of this provisioning quota.
	AssetType ProvisioningQuota_AssetType `protobuf:"varint,2,opt,name=asset_type,json=assetType,proto3,enum=google.cloud.baremetalsolution.v2.ProvisioningQuota_AssetType" json:"asset_type,omitempty"`
	// The gcp service of the provisioning quota.
	GcpService string `protobuf:"bytes,3,opt,name=gcp_service,json=gcpService,proto3" json:"gcp_service,omitempty"`
	// The specific location of the provisioining quota.
	Location string `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
	// The available count of the provisioning quota.
	AvailableCount int32 `protobuf:"varint,5,opt,name=available_count,json=availableCount,proto3" json:"available_count,omitempty"`
	// The quota of one asset type.
	//
	// Types that are assignable to Quota:
	//
	//	*ProvisioningQuota_InstanceQuota
	Quota isProvisioningQuota_Quota `protobuf_oneof:"quota"`
	// Available quantity based on asset type.
	//
	// Types that are assignable to Availability:
	//
	//	*ProvisioningQuota_ServerCount
	//	*ProvisioningQuota_NetworkBandwidth
	//	*ProvisioningQuota_StorageGib
	Availability isProvisioningQuota_Availability `protobuf_oneof:"availability"`
}

func (x *ProvisioningQuota) Reset() {
	*x = ProvisioningQuota{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisioningQuota) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisioningQuota) ProtoMessage() {}

func (x *ProvisioningQuota) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisioningQuota.ProtoReflect.Descriptor instead.
func (*ProvisioningQuota) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{3}
}

func (x *ProvisioningQuota) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProvisioningQuota) GetAssetType() ProvisioningQuota_AssetType {
	if x != nil {
		return x.AssetType
	}
	return ProvisioningQuota_ASSET_TYPE_UNSPECIFIED
}

func (x *ProvisioningQuota) GetGcpService() string {
	if x != nil {
		return x.GcpService
	}
	return ""
}

func (x *ProvisioningQuota) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *ProvisioningQuota) GetAvailableCount() int32 {
	if x != nil {
		return x.AvailableCount
	}
	return 0
}

func (m *ProvisioningQuota) GetQuota() isProvisioningQuota_Quota {
	if m != nil {
		return m.Quota
	}
	return nil
}

func (x *ProvisioningQuota) GetInstanceQuota() *InstanceQuota {
	if x, ok := x.GetQuota().(*ProvisioningQuota_InstanceQuota); ok {
		return x.InstanceQuota
	}
	return nil
}

func (m *ProvisioningQuota) GetAvailability() isProvisioningQuota_Availability {
	if m != nil {
		return m.Availability
	}
	return nil
}

func (x *ProvisioningQuota) GetServerCount() int64 {
	if x, ok := x.GetAvailability().(*ProvisioningQuota_ServerCount); ok {
		return x.ServerCount
	}
	return 0
}

func (x *ProvisioningQuota) GetNetworkBandwidth() int64 {
	if x, ok := x.GetAvailability().(*ProvisioningQuota_NetworkBandwidth); ok {
		return x.NetworkBandwidth
	}
	return 0
}

func (x *ProvisioningQuota) GetStorageGib() int64 {
	if x, ok := x.GetAvailability().(*ProvisioningQuota_StorageGib); ok {
		return x.StorageGib
	}
	return 0
}

type isProvisioningQuota_Quota interface {
	isProvisioningQuota_Quota()
}

type ProvisioningQuota_InstanceQuota struct {
	// Instance quota.
	InstanceQuota *InstanceQuota `protobuf:"bytes,6,opt,name=instance_quota,json=instanceQuota,proto3,oneof"`
}

func (*ProvisioningQuota_InstanceQuota) isProvisioningQuota_Quota() {}

type isProvisioningQuota_Availability interface {
	isProvisioningQuota_Availability()
}

type ProvisioningQuota_ServerCount struct {
	// Server count.
	ServerCount int64 `protobuf:"varint,7,opt,name=server_count,json=serverCount,proto3,oneof"`
}

type ProvisioningQuota_NetworkBandwidth struct {
	// Network bandwidth, Gbps
	NetworkBandwidth int64 `protobuf:"varint,8,opt,name=network_bandwidth,json=networkBandwidth,proto3,oneof"`
}

type ProvisioningQuota_StorageGib struct {
	// Storage size (GB).
	StorageGib int64 `protobuf:"varint,9,opt,name=storage_gib,json=storageGib,proto3,oneof"`
}

func (*ProvisioningQuota_ServerCount) isProvisioningQuota_Availability() {}

func (*ProvisioningQuota_NetworkBandwidth) isProvisioningQuota_Availability() {}

func (*ProvisioningQuota_StorageGib) isProvisioningQuota_Availability() {}

// Message for requesting the list of provisioning quotas.
type ListProvisioningQuotasRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListProvisioningQuotasRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. The server might return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	// Notice that page_size field is not supported and won't be respected in
	// the API request for now, will be updated when pagination is supported.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results from the server.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProvisioningQuotasRequest) Reset() {
	*x = ListProvisioningQuotasRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProvisioningQuotasRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProvisioningQuotasRequest) ProtoMessage() {}

func (x *ListProvisioningQuotasRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProvisioningQuotasRequest.ProtoReflect.Descriptor instead.
func (*ListProvisioningQuotasRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{4}
}

func (x *ListProvisioningQuotasRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProvisioningQuotasRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProvisioningQuotasRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the list of provisioning quotas.
type ListProvisioningQuotasResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The provisioning quotas registered in this project.
	ProvisioningQuotas []*ProvisioningQuota `protobuf:"bytes,1,rep,name=provisioning_quotas,json=provisioningQuotas,proto3" json:"provisioning_quotas,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProvisioningQuotasResponse) Reset() {
	*x = ListProvisioningQuotasResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProvisioningQuotasResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProvisioningQuotasResponse) ProtoMessage() {}

func (x *ListProvisioningQuotasResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProvisioningQuotasResponse.ProtoReflect.Descriptor instead.
func (*ListProvisioningQuotasResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{5}
}

func (x *ListProvisioningQuotasResponse) GetProvisioningQuotas() []*ProvisioningQuota {
	if x != nil {
		return x.ProvisioningQuotas
	}
	return nil
}

func (x *ListProvisioningQuotasResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Configuration parameters for a new instance.
type InstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the instance config.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A transient unique identifier to idenfity an instance within an
	// ProvisioningConfig request.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Instance type.
	// [Available
	// types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
	InstanceType string `protobuf:"bytes,3,opt,name=instance_type,json=instanceType,proto3" json:"instance_type,omitempty"`
	// Whether the instance should be provisioned with Hyperthreading enabled.
	Hyperthreading bool `protobuf:"varint,4,opt,name=hyperthreading,proto3" json:"hyperthreading,omitempty"`
	// OS image to initialize the instance.
	// [Available
	// images](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
	OsImage string `protobuf:"bytes,5,opt,name=os_image,json=osImage,proto3" json:"os_image,omitempty"`
	// Client network address. Filled if InstanceConfig.multivlan_config is false.
	//
	// Deprecated: Marked as deprecated in google/cloud/baremetalsolution/v2/provisioning.proto.
	ClientNetwork *InstanceConfig_NetworkAddress `protobuf:"bytes,6,opt,name=client_network,json=clientNetwork,proto3" json:"client_network,omitempty"`
	// Private network address, if any. Filled if InstanceConfig.multivlan_config
	// is false.
	//
	// Deprecated: Marked as deprecated in google/cloud/baremetalsolution/v2/provisioning.proto.
	PrivateNetwork *InstanceConfig_NetworkAddress `protobuf:"bytes,7,opt,name=private_network,json=privateNetwork,proto3" json:"private_network,omitempty"`
	// User note field, it can be used by customers to add additional information
	// for the BMS Ops team .
	UserNote string `protobuf:"bytes,8,opt,name=user_note,json=userNote,proto3" json:"user_note,omitempty"`
	// If true networks can be from different projects of the same vendor account.
	AccountNetworksEnabled bool `protobuf:"varint,9,opt,name=account_networks_enabled,json=accountNetworksEnabled,proto3" json:"account_networks_enabled,omitempty"`
	// The type of network configuration on the instance.
	NetworkConfig InstanceConfig_NetworkConfig `protobuf:"varint,10,opt,name=network_config,json=networkConfig,proto3,enum=google.cloud.baremetalsolution.v2.InstanceConfig_NetworkConfig" json:"network_config,omitempty"`
	// Server network template name. Filled if InstanceConfig.multivlan_config is
	// true.
	NetworkTemplate string `protobuf:"bytes,11,opt,name=network_template,json=networkTemplate,proto3" json:"network_template,omitempty"`
	// List of logical interfaces for the instance. The number of logical
	// interfaces will be the same as number of hardware bond/nic on the chosen
	// network template. Filled if InstanceConfig.multivlan_config is true.
	LogicalInterfaces []*LogicalInterface `protobuf:"bytes,12,rep,name=logical_interfaces,json=logicalInterfaces,proto3" json:"logical_interfaces,omitempty"`
	// List of names of ssh keys used to provision the instance.
	SshKeyNames []string `protobuf:"bytes,13,rep,name=ssh_key_names,json=sshKeyNames,proto3" json:"ssh_key_names,omitempty"`
}

func (x *InstanceConfig) Reset() {
	*x = InstanceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceConfig) ProtoMessage() {}

func (x *InstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceConfig.ProtoReflect.Descriptor instead.
func (*InstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{6}
}

func (x *InstanceConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InstanceConfig) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *InstanceConfig) GetInstanceType() string {
	if x != nil {
		return x.InstanceType
	}
	return ""
}

func (x *InstanceConfig) GetHyperthreading() bool {
	if x != nil {
		return x.Hyperthreading
	}
	return false
}

func (x *InstanceConfig) GetOsImage() string {
	if x != nil {
		return x.OsImage
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/baremetalsolution/v2/provisioning.proto.
func (x *InstanceConfig) GetClientNetwork() *InstanceConfig_NetworkAddress {
	if x != nil {
		return x.ClientNetwork
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/baremetalsolution/v2/provisioning.proto.
func (x *InstanceConfig) GetPrivateNetwork() *InstanceConfig_NetworkAddress {
	if x != nil {
		return x.PrivateNetwork
	}
	return nil
}

func (x *InstanceConfig) GetUserNote() string {
	if x != nil {
		return x.UserNote
	}
	return ""
}

func (x *InstanceConfig) GetAccountNetworksEnabled() bool {
	if x != nil {
		return x.AccountNetworksEnabled
	}
	return false
}

func (x *InstanceConfig) GetNetworkConfig() InstanceConfig_NetworkConfig {
	if x != nil {
		return x.NetworkConfig
	}
	return InstanceConfig_NETWORKCONFIG_UNSPECIFIED
}

func (x *InstanceConfig) GetNetworkTemplate() string {
	if x != nil {
		return x.NetworkTemplate
	}
	return ""
}

func (x *InstanceConfig) GetLogicalInterfaces() []*LogicalInterface {
	if x != nil {
		return x.LogicalInterfaces
	}
	return nil
}

func (x *InstanceConfig) GetSshKeyNames() []string {
	if x != nil {
		return x.SshKeyNames
	}
	return nil
}

// Configuration parameters for a new volume.
type VolumeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the volume config.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A transient unique identifier to identify a volume within an
	// ProvisioningConfig request.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Whether snapshots should be enabled.
	SnapshotsEnabled bool `protobuf:"varint,3,opt,name=snapshots_enabled,json=snapshotsEnabled,proto3" json:"snapshots_enabled,omitempty"`
	// The type of this Volume.
	Type VolumeConfig_Type `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.baremetalsolution.v2.VolumeConfig_Type" json:"type,omitempty"`
	// Volume protocol.
	Protocol VolumeConfig_Protocol `protobuf:"varint,5,opt,name=protocol,proto3,enum=google.cloud.baremetalsolution.v2.VolumeConfig_Protocol" json:"protocol,omitempty"`
	// The requested size of this volume, in GB.
	SizeGb int32 `protobuf:"varint,6,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
	// LUN ranges to be configured. Set only when protocol is PROTOCOL_FC.
	LunRanges []*VolumeConfig_LunRange `protobuf:"bytes,7,rep,name=lun_ranges,json=lunRanges,proto3" json:"lun_ranges,omitempty"`
	// Machine ids connected to this volume. Set only when protocol is
	// PROTOCOL_FC.
	MachineIds []string `protobuf:"bytes,8,rep,name=machine_ids,json=machineIds,proto3" json:"machine_ids,omitempty"`
	// NFS exports. Set only when protocol is PROTOCOL_NFS.
	NfsExports []*VolumeConfig_NfsExport `protobuf:"bytes,9,rep,name=nfs_exports,json=nfsExports,proto3" json:"nfs_exports,omitempty"`
	// User note field, it can be used by customers to add additional information
	// for the BMS Ops team .
	UserNote string `protobuf:"bytes,10,opt,name=user_note,json=userNote,proto3" json:"user_note,omitempty"`
	// The GCP service of the storage volume. Available gcp_service are in
	// https://cloud.google.com/bare-metal/docs/bms-planning.
	GcpService string `protobuf:"bytes,11,opt,name=gcp_service,json=gcpService,proto3" json:"gcp_service,omitempty"`
	// Performance tier of the Volume.
	// Default is SHARED.
	PerformanceTier VolumePerformanceTier `protobuf:"varint,12,opt,name=performance_tier,json=performanceTier,proto3,enum=google.cloud.baremetalsolution.v2.VolumePerformanceTier" json:"performance_tier,omitempty"`
}

func (x *VolumeConfig) Reset() {
	*x = VolumeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VolumeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VolumeConfig) ProtoMessage() {}

func (x *VolumeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VolumeConfig.ProtoReflect.Descriptor instead.
func (*VolumeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{7}
}

func (x *VolumeConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VolumeConfig) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *VolumeConfig) GetSnapshotsEnabled() bool {
	if x != nil {
		return x.SnapshotsEnabled
	}
	return false
}

func (x *VolumeConfig) GetType() VolumeConfig_Type {
	if x != nil {
		return x.Type
	}
	return VolumeConfig_TYPE_UNSPECIFIED
}

func (x *VolumeConfig) GetProtocol() VolumeConfig_Protocol {
	if x != nil {
		return x.Protocol
	}
	return VolumeConfig_PROTOCOL_UNSPECIFIED
}

func (x *VolumeConfig) GetSizeGb() int32 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

func (x *VolumeConfig) GetLunRanges() []*VolumeConfig_LunRange {
	if x != nil {
		return x.LunRanges
	}
	return nil
}

func (x *VolumeConfig) GetMachineIds() []string {
	if x != nil {
		return x.MachineIds
	}
	return nil
}

func (x *VolumeConfig) GetNfsExports() []*VolumeConfig_NfsExport {
	if x != nil {
		return x.NfsExports
	}
	return nil
}

func (x *VolumeConfig) GetUserNote() string {
	if x != nil {
		return x.UserNote
	}
	return ""
}

func (x *VolumeConfig) GetGcpService() string {
	if x != nil {
		return x.GcpService
	}
	return ""
}

func (x *VolumeConfig) GetPerformanceTier() VolumePerformanceTier {
	if x != nil {
		return x.PerformanceTier
	}
	return VolumePerformanceTier_VOLUME_PERFORMANCE_TIER_UNSPECIFIED
}

// Configuration parameters for a new network.
type NetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the network config.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A transient unique identifier to identify a volume within an
	// ProvisioningConfig request.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The type of this network, either Client or Private.
	Type NetworkConfig_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.baremetalsolution.v2.NetworkConfig_Type" json:"type,omitempty"`
	// Interconnect bandwidth. Set only when type is CLIENT.
	Bandwidth NetworkConfig_Bandwidth `protobuf:"varint,4,opt,name=bandwidth,proto3,enum=google.cloud.baremetalsolution.v2.NetworkConfig_Bandwidth" json:"bandwidth,omitempty"`
	// List of VLAN attachments. As of now there are always 2 attachments, but it
	// is going to change in  the future (multi vlan).
	VlanAttachments []*NetworkConfig_IntakeVlanAttachment `protobuf:"bytes,5,rep,name=vlan_attachments,json=vlanAttachments,proto3" json:"vlan_attachments,omitempty"`
	// CIDR range of the network.
	Cidr string `protobuf:"bytes,6,opt,name=cidr,proto3" json:"cidr,omitempty"`
	// Service CIDR, if any.
	ServiceCidr NetworkConfig_ServiceCidr `protobuf:"varint,7,opt,name=service_cidr,json=serviceCidr,proto3,enum=google.cloud.baremetalsolution.v2.NetworkConfig_ServiceCidr" json:"service_cidr,omitempty"`
	// User note field, it can be used by customers to add additional information
	// for the BMS Ops team .
	UserNote string `protobuf:"bytes,8,opt,name=user_note,json=userNote,proto3" json:"user_note,omitempty"`
	// The GCP service of the network. Available gcp_service are in
	// https://cloud.google.com/bare-metal/docs/bms-planning.
	GcpService string `protobuf:"bytes,9,opt,name=gcp_service,json=gcpService,proto3" json:"gcp_service,omitempty"`
	// Whether the VLAN attachment pair is located in the same project.
	VlanSameProject bool `protobuf:"varint,10,opt,name=vlan_same_project,json=vlanSameProject,proto3" json:"vlan_same_project,omitempty"`
	// The JumboFramesEnabled option for customer to set.
	JumboFramesEnabled bool `protobuf:"varint,11,opt,name=jumbo_frames_enabled,json=jumboFramesEnabled,proto3" json:"jumbo_frames_enabled,omitempty"`
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{8}
}

func (x *NetworkConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NetworkConfig) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *NetworkConfig) GetType() NetworkConfig_Type {
	if x != nil {
		return x.Type
	}
	return NetworkConfig_TYPE_UNSPECIFIED
}

func (x *NetworkConfig) GetBandwidth() NetworkConfig_Bandwidth {
	if x != nil {
		return x.Bandwidth
	}
	return NetworkConfig_BANDWIDTH_UNSPECIFIED
}

func (x *NetworkConfig) GetVlanAttachments() []*NetworkConfig_IntakeVlanAttachment {
	if x != nil {
		return x.VlanAttachments
	}
	return nil
}

func (x *NetworkConfig) GetCidr() string {
	if x != nil {
		return x.Cidr
	}
	return ""
}

func (x *NetworkConfig) GetServiceCidr() NetworkConfig_ServiceCidr {
	if x != nil {
		return x.ServiceCidr
	}
	return NetworkConfig_SERVICE_CIDR_UNSPECIFIED
}

func (x *NetworkConfig) GetUserNote() string {
	if x != nil {
		return x.UserNote
	}
	return ""
}

func (x *NetworkConfig) GetGcpService() string {
	if x != nil {
		return x.GcpService
	}
	return ""
}

func (x *NetworkConfig) GetVlanSameProject() bool {
	if x != nil {
		return x.VlanSameProject
	}
	return false
}

func (x *NetworkConfig) GetJumboFramesEnabled() bool {
	if x != nil {
		return x.JumboFramesEnabled
	}
	return false
}

// A resource budget.
type InstanceQuota struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the instance quota.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Instance type.
	// Deprecated: use gcp_service.
	//
	// Deprecated: Marked as deprecated in google/cloud/baremetalsolution/v2/provisioning.proto.
	InstanceType string `protobuf:"bytes,2,opt,name=instance_type,json=instanceType,proto3" json:"instance_type,omitempty"`
	// The gcp service of the provisioning quota.
	GcpService string `protobuf:"bytes,5,opt,name=gcp_service,json=gcpService,proto3" json:"gcp_service,omitempty"`
	// Location where the quota applies.
	Location string `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty"`
	// Number of machines than can be created for the given location and
	// instance_type.
	AvailableMachineCount int32 `protobuf:"varint,4,opt,name=available_machine_count,json=availableMachineCount,proto3" json:"available_machine_count,omitempty"`
}

func (x *InstanceQuota) Reset() {
	*x = InstanceQuota{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceQuota) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceQuota) ProtoMessage() {}

func (x *InstanceQuota) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceQuota.ProtoReflect.Descriptor instead.
func (*InstanceQuota) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{9}
}

func (x *InstanceQuota) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/baremetalsolution/v2/provisioning.proto.
func (x *InstanceQuota) GetInstanceType() string {
	if x != nil {
		return x.InstanceType
	}
	return ""
}

func (x *InstanceQuota) GetGcpService() string {
	if x != nil {
		return x.GcpService
	}
	return ""
}

func (x *InstanceQuota) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *InstanceQuota) GetAvailableMachineCount() int32 {
	if x != nil {
		return x.AvailableMachineCount
	}
	return 0
}

// Request for GetProvisioningConfig.
type GetProvisioningConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the ProvisioningConfig.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProvisioningConfigRequest) Reset() {
	*x = GetProvisioningConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProvisioningConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProvisioningConfigRequest) ProtoMessage() {}

func (x *GetProvisioningConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProvisioningConfigRequest.ProtoReflect.Descriptor instead.
func (*GetProvisioningConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{10}
}

func (x *GetProvisioningConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for CreateProvisioningConfig.
type CreateProvisioningConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent project and location containing the
	// ProvisioningConfig.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ProvisioningConfig to create.
	ProvisioningConfig *ProvisioningConfig `protobuf:"bytes,2,opt,name=provisioning_config,json=provisioningConfig,proto3" json:"provisioning_config,omitempty"`
	// Optional. Email provided to send a confirmation with provisioning config
	// to.
	Email string `protobuf:"bytes,3,opt,name=email,proto3" json:"email,omitempty"`
}

func (x *CreateProvisioningConfigRequest) Reset() {
	*x = CreateProvisioningConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateProvisioningConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateProvisioningConfigRequest) ProtoMessage() {}

func (x *CreateProvisioningConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateProvisioningConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateProvisioningConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{11}
}

func (x *CreateProvisioningConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateProvisioningConfigRequest) GetProvisioningConfig() *ProvisioningConfig {
	if x != nil {
		return x.ProvisioningConfig
	}
	return nil
}

func (x *CreateProvisioningConfigRequest) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

// Message for updating a ProvisioningConfig.
type UpdateProvisioningConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ProvisioningConfig to update.
	ProvisioningConfig *ProvisioningConfig `protobuf:"bytes,1,opt,name=provisioning_config,json=provisioningConfig,proto3" json:"provisioning_config,omitempty"`
	// Required. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. Email provided to send a confirmation with provisioning config
	// to.
	Email string `protobuf:"bytes,3,opt,name=email,proto3" json:"email,omitempty"`
}

func (x *UpdateProvisioningConfigRequest) Reset() {
	*x = UpdateProvisioningConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateProvisioningConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateProvisioningConfigRequest) ProtoMessage() {}

func (x *UpdateProvisioningConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateProvisioningConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateProvisioningConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{12}
}

func (x *UpdateProvisioningConfigRequest) GetProvisioningConfig() *ProvisioningConfig {
	if x != nil {
		return x.ProvisioningConfig
	}
	return nil
}

func (x *UpdateProvisioningConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateProvisioningConfigRequest) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

// A network.
type InstanceConfig_NetworkAddress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Id of the network to use, within the same ProvisioningConfig request.
	NetworkId string `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// IPv4 address to be assigned to the server.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Name of the existing network to use.
	ExistingNetworkId string `protobuf:"bytes,3,opt,name=existing_network_id,json=existingNetworkId,proto3" json:"existing_network_id,omitempty"`
}

func (x *InstanceConfig_NetworkAddress) Reset() {
	*x = InstanceConfig_NetworkAddress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceConfig_NetworkAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceConfig_NetworkAddress) ProtoMessage() {}

func (x *InstanceConfig_NetworkAddress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceConfig_NetworkAddress.ProtoReflect.Descriptor instead.
func (*InstanceConfig_NetworkAddress) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{6, 0}
}

func (x *InstanceConfig_NetworkAddress) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *InstanceConfig_NetworkAddress) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *InstanceConfig_NetworkAddress) GetExistingNetworkId() string {
	if x != nil {
		return x.ExistingNetworkId
	}
	return ""
}

// A LUN(Logical Unit Number) range.
type VolumeConfig_LunRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of LUNs to create.
	Quantity int32 `protobuf:"varint,1,opt,name=quantity,proto3" json:"quantity,omitempty"`
	// The requested size of each LUN, in GB.
	SizeGb int32 `protobuf:"varint,2,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
}

func (x *VolumeConfig_LunRange) Reset() {
	*x = VolumeConfig_LunRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VolumeConfig_LunRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VolumeConfig_LunRange) ProtoMessage() {}

func (x *VolumeConfig_LunRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VolumeConfig_LunRange.ProtoReflect.Descriptor instead.
func (*VolumeConfig_LunRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{7, 0}
}

func (x *VolumeConfig_LunRange) GetQuantity() int32 {
	if x != nil {
		return x.Quantity
	}
	return 0
}

func (x *VolumeConfig_LunRange) GetSizeGb() int32 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

// A NFS export entry.
type VolumeConfig_NfsExport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Network to use to publish the export.
	NetworkId string `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// A client object.
	//
	// Types that are assignable to Client:
	//
	//	*VolumeConfig_NfsExport_MachineId
	//	*VolumeConfig_NfsExport_Cidr
	Client isVolumeConfig_NfsExport_Client `protobuf_oneof:"client"`
	// Export permissions.
	Permissions VolumeConfig_NfsExport_Permissions `protobuf:"varint,4,opt,name=permissions,proto3,enum=google.cloud.baremetalsolution.v2.VolumeConfig_NfsExport_Permissions" json:"permissions,omitempty"`
	// Disable root squashing, which is a feature of NFS.
	// Root squash is a special mapping of the remote superuser (root) identity
	// when using identity authentication.
	NoRootSquash bool `protobuf:"varint,5,opt,name=no_root_squash,json=noRootSquash,proto3" json:"no_root_squash,omitempty"`
	// Allow the setuid flag.
	AllowSuid bool `protobuf:"varint,6,opt,name=allow_suid,json=allowSuid,proto3" json:"allow_suid,omitempty"`
	// Allow dev flag in NfsShare AllowedClientsRequest.
	AllowDev bool `protobuf:"varint,7,opt,name=allow_dev,json=allowDev,proto3" json:"allow_dev,omitempty"`
}

func (x *VolumeConfig_NfsExport) Reset() {
	*x = VolumeConfig_NfsExport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VolumeConfig_NfsExport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VolumeConfig_NfsExport) ProtoMessage() {}

func (x *VolumeConfig_NfsExport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VolumeConfig_NfsExport.ProtoReflect.Descriptor instead.
func (*VolumeConfig_NfsExport) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{7, 1}
}

func (x *VolumeConfig_NfsExport) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (m *VolumeConfig_NfsExport) GetClient() isVolumeConfig_NfsExport_Client {
	if m != nil {
		return m.Client
	}
	return nil
}

func (x *VolumeConfig_NfsExport) GetMachineId() string {
	if x, ok := x.GetClient().(*VolumeConfig_NfsExport_MachineId); ok {
		return x.MachineId
	}
	return ""
}

func (x *VolumeConfig_NfsExport) GetCidr() string {
	if x, ok := x.GetClient().(*VolumeConfig_NfsExport_Cidr); ok {
		return x.Cidr
	}
	return ""
}

func (x *VolumeConfig_NfsExport) GetPermissions() VolumeConfig_NfsExport_Permissions {
	if x != nil {
		return x.Permissions
	}
	return VolumeConfig_NfsExport_PERMISSIONS_UNSPECIFIED
}

func (x *VolumeConfig_NfsExport) GetNoRootSquash() bool {
	if x != nil {
		return x.NoRootSquash
	}
	return false
}

func (x *VolumeConfig_NfsExport) GetAllowSuid() bool {
	if x != nil {
		return x.AllowSuid
	}
	return false
}

func (x *VolumeConfig_NfsExport) GetAllowDev() bool {
	if x != nil {
		return x.AllowDev
	}
	return false
}

type isVolumeConfig_NfsExport_Client interface {
	isVolumeConfig_NfsExport_Client()
}

type VolumeConfig_NfsExport_MachineId struct {
	// Either a single machine, identified by an ID, or a comma-separated
	// list of machine IDs.
	MachineId string `protobuf:"bytes,2,opt,name=machine_id,json=machineId,proto3,oneof"`
}

type VolumeConfig_NfsExport_Cidr struct {
	// A CIDR range.
	Cidr string `protobuf:"bytes,3,opt,name=cidr,proto3,oneof"`
}

func (*VolumeConfig_NfsExport_MachineId) isVolumeConfig_NfsExport_Client() {}

func (*VolumeConfig_NfsExport_Cidr) isVolumeConfig_NfsExport_Client() {}

// A GCP vlan attachment.
type NetworkConfig_IntakeVlanAttachment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier of the VLAN attachment.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Attachment pairing key.
	PairingKey string `protobuf:"bytes,2,opt,name=pairing_key,json=pairingKey,proto3" json:"pairing_key,omitempty"`
}

func (x *NetworkConfig_IntakeVlanAttachment) Reset() {
	*x = NetworkConfig_IntakeVlanAttachment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkConfig_IntakeVlanAttachment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig_IntakeVlanAttachment) ProtoMessage() {}

func (x *NetworkConfig_IntakeVlanAttachment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig_IntakeVlanAttachment.ProtoReflect.Descriptor instead.
func (*NetworkConfig_IntakeVlanAttachment) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP(), []int{8, 0}
}

func (x *NetworkConfig_IntakeVlanAttachment) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *NetworkConfig_IntakeVlanAttachment) GetPairingKey() string {
	if x != nil {
		return x.PairingKey
	}
	return ""
}

var File_google_cloud_baremetalsolution_v2_provisioning_proto protoreflect.FileDescriptor

var file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2f, 0x76, 0x32, 0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfa, 0x07, 0x0a, 0x12, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x09, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65,
	0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x08, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65,
	0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x08,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x49, 0x0a, 0x07, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74,
	0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x07, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x64,
	0x12, 0x38, 0x0a, 0x18, 0x68, 0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x16, 0x68, 0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x05, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x05, 0x65,
	0x6d, 0x61, 0x69, 0x6c, 0x12, 0x56, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x2f, 0x0a, 0x11, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x55, 0x72, 0x69,
	0x12, 0x24, 0x0a, 0x0e, 0x76, 0x70, 0x63, 0x5f, 0x73, 0x63, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x70, 0x63, 0x53, 0x63, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x20, 0x0a,
	0x09, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x49, 0x64, 0x22,
	0x85, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x09, 0x0a, 0x05, 0x44, 0x52, 0x41, 0x46, 0x54, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53,
	0x55, 0x42, 0x4d, 0x49, 0x54, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52,
	0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b,
	0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a,
	0x09, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09,
	0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x3a, 0x8c, 0x01, 0xea, 0x41, 0x88, 0x01, 0x0a, 0x33,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22, 0xec, 0x01, 0x0a, 0x1f, 0x53, 0x75, 0x62, 0x6d, 0x69,
	0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x6b, 0x0a,
	0x13, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65,
	0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x19, 0x0a, 0x05, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x22, 0x8a, 0x01, 0x0a, 0x20, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x13, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0xd8, 0x05, 0x0a, 0x11, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x5d, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x61, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x63, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x67, 0x63, 0x70, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a,
	0x0f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x59, 0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x11, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x01, 0x52, 0x10, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x42, 0x61, 0x6e, 0x64,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x21, 0x0a, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x67, 0x69, 0x62, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x0a, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x47, 0x69, 0x62, 0x22, 0x6e, 0x0a, 0x09, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x53, 0x53, 0x45, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x53, 0x53, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x53, 0x53, 0x45,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x10, 0x02,
	0x12, 0x16, 0x0a, 0x12, 0x41, 0x53, 0x53, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4e,
	0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x03, 0x3a, 0x89, 0x01, 0xea, 0x41, 0x85, 0x01, 0x0a,
	0x32, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x7d, 0x42, 0x07, 0x0a, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x42, 0x0e, 0x0a,
	0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x22, 0x9e, 0x01,
	0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xaf,
	0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x65, 0x0a, 0x13, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xbc, 0x08, 0x0a, 0x0e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x23, 0x0a, 0x0d,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x26, 0x0a, 0x0e, 0x68, 0x79, 0x70, 0x65, 0x72, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64,
	0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x68, 0x79, 0x70, 0x65, 0x72,
	0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x73, 0x5f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x73, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x12, 0x6b, 0x0a, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65,
	0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x6d, 0x0a, 0x0f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65,
	0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x0e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x1b, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x74, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x38, 0x0a,
	0x18, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x16, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x66, 0x0a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x29, 0x0a, 0x10, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x62, 0x0a, 0x12, 0x6c, 0x6f,
	0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73,
	0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x63,
	0x61, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x11, 0x6c, 0x6f, 0x67,
	0x69, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x12, 0x22,
	0x0a, 0x0d, 0x73, 0x73, 0x68, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18,
	0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x73, 0x68, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x1a, 0x79, 0x0a, 0x0e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2e, 0x0a,
	0x13, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x65, 0x78, 0x69, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x22, 0x4f, 0x0a,
	0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d,
	0x0a, 0x19, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a,
	0x0b, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x5f, 0x56, 0x4c, 0x41, 0x4e, 0x10, 0x01, 0x12, 0x0e,
	0x0a, 0x0a, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x5f, 0x56, 0x4c, 0x41, 0x4e, 0x10, 0x02, 0x3a, 0x7f,
	0xea, 0x41, 0x7c, 0x0a, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x49, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22,
	0xd2, 0x0a, 0x0a, 0x0c, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x48, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x54, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x52, 0x08, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67,
	0x62, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12,
	0x57, 0x0a, 0x0a, 0x6c, 0x75, 0x6e, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x75, 0x6e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x09, 0x6c,
	0x75, 0x6e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x49, 0x64, 0x73, 0x12, 0x5a, 0x0a, 0x0b, 0x6e, 0x66, 0x73,
	0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4e, 0x66, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x0a, 0x6e, 0x66, 0x73, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6e, 0x6f,
	0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4e, 0x6f,
	0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x63, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x67, 0x63, 0x70, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x63, 0x0a, 0x10, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72,
	0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x6e, 0x63, 0x65, 0x54, 0x69, 0x65, 0x72, 0x52, 0x0f, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x6e, 0x63, 0x65, 0x54, 0x69, 0x65, 0x72, 0x1a, 0x3f, 0x0a, 0x08, 0x4c, 0x75, 0x6e, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x17, 0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x1a, 0x81, 0x03, 0x0a, 0x09, 0x4e, 0x66,
	0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0a, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x04, 0x63, 0x69, 0x64, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x63, 0x69, 0x64, 0x72, 0x12, 0x67, 0x0a,
	0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x4e, 0x66, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x6e, 0x6f, 0x5f, 0x72, 0x6f, 0x6f,
	0x74, 0x5f, 0x73, 0x71, 0x75, 0x61, 0x73, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x6e, 0x6f, 0x52, 0x6f, 0x6f, 0x74, 0x53, 0x71, 0x75, 0x61, 0x73, 0x68, 0x12, 0x1d, 0x0a, 0x0a,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x75, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x09, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x75, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x76, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x44, 0x65, 0x76, 0x22, 0x49, 0x0a, 0x0b, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x45, 0x52, 0x4d, 0x49,
	0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e, 0x4c,
	0x59, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54,
	0x45, 0x10, 0x02, 0x42, 0x08, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x22, 0x31, 0x0a,
	0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x46,
	0x4c, 0x41, 0x53, 0x48, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x49, 0x53, 0x4b, 0x10, 0x02,
	0x22, 0x47, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x18, 0x0a, 0x14,
	0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43,
	0x4f, 0x4c, 0x5f, 0x46, 0x43, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x54, 0x4f,
	0x43, 0x4f, 0x4c, 0x5f, 0x4e, 0x46, 0x53, 0x10, 0x02, 0x3a, 0x79, 0xea, 0x41, 0x76, 0x0a, 0x2d,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x45, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x7d, 0x22, 0xa5, 0x08, 0x0a, 0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x49, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72,
	0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x58, 0x0a, 0x09, 0x62, 0x61,
	0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72,
	0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x42, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x52, 0x09, 0x62, 0x61, 0x6e, 0x64, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x12, 0x70, 0x0a, 0x10, 0x76, 0x6c, 0x61, 0x6e, 0x5f, 0x61, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x49, 0x6e, 0x74, 0x61, 0x6b, 0x65, 0x56, 0x6c, 0x61, 0x6e, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0f, 0x76, 0x6c, 0x61, 0x6e, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x69, 0x64, 0x72, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x69, 0x64, 0x72, 0x12, 0x5f, 0x0a, 0x0c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x69, 0x64, 0x72, 0x52, 0x0b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x69, 0x64, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x75, 0x73, 0x65, 0x72, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x63, 0x70, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x67,
	0x63, 0x70, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x76, 0x6c, 0x61,
	0x6e, 0x5f, 0x73, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x76, 0x6c, 0x61, 0x6e, 0x53, 0x61, 0x6d, 0x65, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x6a, 0x75, 0x6d, 0x62, 0x6f, 0x5f, 0x66,
	0x72, 0x61, 0x6d, 0x65, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x12, 0x6a, 0x75, 0x6d, 0x62, 0x6f, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x1a, 0x47, 0x0a, 0x14, 0x49, 0x6e, 0x74, 0x61, 0x6b,
	0x65, 0x56, 0x6c, 0x61, 0x6e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x61, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79,
	0x22, 0x35, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52,
	0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x02, 0x22, 0x63, 0x0a, 0x09, 0x42, 0x61, 0x6e, 0x64, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x12, 0x19, 0x0a, 0x15, 0x42, 0x41, 0x4e, 0x44, 0x57, 0x49, 0x44, 0x54,
	0x48, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0d, 0x0a, 0x09, 0x42, 0x57, 0x5f, 0x31, 0x5f, 0x47, 0x42, 0x50, 0x53, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x42, 0x57, 0x5f, 0x32, 0x5f, 0x47, 0x42, 0x50, 0x53, 0x10, 0x02, 0x12, 0x0d, 0x0a,
	0x09, 0x42, 0x57, 0x5f, 0x35, 0x5f, 0x47, 0x42, 0x50, 0x53, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a,
	0x42, 0x57, 0x5f, 0x31, 0x30, 0x5f, 0x47, 0x42, 0x50, 0x53, 0x10, 0x04, 0x22, 0x60, 0x0a, 0x0b,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x69, 0x64, 0x72, 0x12, 0x1c, 0x0a, 0x18, 0x53,
	0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x43, 0x49, 0x44, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x49, 0x47, 0x48, 0x5f,
	0x32, 0x36, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x49, 0x47, 0x48, 0x5f, 0x32, 0x37, 0x10,
	0x03, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x49, 0x47, 0x48, 0x5f, 0x32, 0x38, 0x10, 0x04, 0x3a, 0x7c,
	0xea, 0x41, 0x79, 0x0a, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22, 0xc4, 0x02, 0x0a,
	0x0d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x63, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x67, 0x63, 0x70, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a,
	0x17, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15,
	0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x3a, 0x7c, 0xea, 0x41, 0x79, 0x0a, 0x2e, 0x62, 0x61, 0x72, 0x65,
	0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x71, 0x75, 0x6f,
	0x74, 0x61, 0x7d, 0x22, 0x6f, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33, 0x62, 0x61, 0x72, 0x65, 0x6d,
	0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xec, 0x01, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x6b, 0x0a, 0x13, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61,
	0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x19, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69,
	0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x22, 0xeb, 0x01, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6b, 0x0a, 0x13, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x19, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69,
	0x6c, 0x42, 0x80, 0x02, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x42, 0x11, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x62, 0x61,
	0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x70,
	0x62, 0x3b, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x70, 0x62, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x61, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x6c, 0x53, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x61, 0x72, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x6c, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x24,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42,
	0x61, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x6c, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescOnce sync.Once
	file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescData = file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDesc
)

func file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescGZIP() []byte {
	file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescOnce.Do(func() {
		file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescData)
	})
	return file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDescData
}

var file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_baremetalsolution_v2_provisioning_proto_goTypes = []interface{}{
	(ProvisioningConfig_State)(0),              // 0: google.cloud.baremetalsolution.v2.ProvisioningConfig.State
	(ProvisioningQuota_AssetType)(0),           // 1: google.cloud.baremetalsolution.v2.ProvisioningQuota.AssetType
	(InstanceConfig_NetworkConfig)(0),          // 2: google.cloud.baremetalsolution.v2.InstanceConfig.NetworkConfig
	(VolumeConfig_Type)(0),                     // 3: google.cloud.baremetalsolution.v2.VolumeConfig.Type
	(VolumeConfig_Protocol)(0),                 // 4: google.cloud.baremetalsolution.v2.VolumeConfig.Protocol
	(VolumeConfig_NfsExport_Permissions)(0),    // 5: google.cloud.baremetalsolution.v2.VolumeConfig.NfsExport.Permissions
	(NetworkConfig_Type)(0),                    // 6: google.cloud.baremetalsolution.v2.NetworkConfig.Type
	(NetworkConfig_Bandwidth)(0),               // 7: google.cloud.baremetalsolution.v2.NetworkConfig.Bandwidth
	(NetworkConfig_ServiceCidr)(0),             // 8: google.cloud.baremetalsolution.v2.NetworkConfig.ServiceCidr
	(*ProvisioningConfig)(nil),                 // 9: google.cloud.baremetalsolution.v2.ProvisioningConfig
	(*SubmitProvisioningConfigRequest)(nil),    // 10: google.cloud.baremetalsolution.v2.SubmitProvisioningConfigRequest
	(*SubmitProvisioningConfigResponse)(nil),   // 11: google.cloud.baremetalsolution.v2.SubmitProvisioningConfigResponse
	(*ProvisioningQuota)(nil),                  // 12: google.cloud.baremetalsolution.v2.ProvisioningQuota
	(*ListProvisioningQuotasRequest)(nil),      // 13: google.cloud.baremetalsolution.v2.ListProvisioningQuotasRequest
	(*ListProvisioningQuotasResponse)(nil),     // 14: google.cloud.baremetalsolution.v2.ListProvisioningQuotasResponse
	(*InstanceConfig)(nil),                     // 15: google.cloud.baremetalsolution.v2.InstanceConfig
	(*VolumeConfig)(nil),                       // 16: google.cloud.baremetalsolution.v2.VolumeConfig
	(*NetworkConfig)(nil),                      // 17: google.cloud.baremetalsolution.v2.NetworkConfig
	(*InstanceQuota)(nil),                      // 18: google.cloud.baremetalsolution.v2.InstanceQuota
	(*GetProvisioningConfigRequest)(nil),       // 19: google.cloud.baremetalsolution.v2.GetProvisioningConfigRequest
	(*CreateProvisioningConfigRequest)(nil),    // 20: google.cloud.baremetalsolution.v2.CreateProvisioningConfigRequest
	(*UpdateProvisioningConfigRequest)(nil),    // 21: google.cloud.baremetalsolution.v2.UpdateProvisioningConfigRequest
	(*InstanceConfig_NetworkAddress)(nil),      // 22: google.cloud.baremetalsolution.v2.InstanceConfig.NetworkAddress
	(*VolumeConfig_LunRange)(nil),              // 23: google.cloud.baremetalsolution.v2.VolumeConfig.LunRange
	(*VolumeConfig_NfsExport)(nil),             // 24: google.cloud.baremetalsolution.v2.VolumeConfig.NfsExport
	(*NetworkConfig_IntakeVlanAttachment)(nil), // 25: google.cloud.baremetalsolution.v2.NetworkConfig.IntakeVlanAttachment
	(*timestamppb.Timestamp)(nil),              // 26: google.protobuf.Timestamp
	(*LogicalInterface)(nil),                   // 27: google.cloud.baremetalsolution.v2.LogicalInterface
	(VolumePerformanceTier)(0),                 // 28: google.cloud.baremetalsolution.v2.VolumePerformanceTier
	(*fieldmaskpb.FieldMask)(nil),              // 29: google.protobuf.FieldMask
}
var file_google_cloud_baremetalsolution_v2_provisioning_proto_depIdxs = []int32{
	15, // 0: google.cloud.baremetalsolution.v2.ProvisioningConfig.instances:type_name -> google.cloud.baremetalsolution.v2.InstanceConfig
	17, // 1: google.cloud.baremetalsolution.v2.ProvisioningConfig.networks:type_name -> google.cloud.baremetalsolution.v2.NetworkConfig
	16, // 2: google.cloud.baremetalsolution.v2.ProvisioningConfig.volumes:type_name -> google.cloud.baremetalsolution.v2.VolumeConfig
	0,  // 3: google.cloud.baremetalsolution.v2.ProvisioningConfig.state:type_name -> google.cloud.baremetalsolution.v2.ProvisioningConfig.State
	26, // 4: google.cloud.baremetalsolution.v2.ProvisioningConfig.update_time:type_name -> google.protobuf.Timestamp
	9,  // 5: google.cloud.baremetalsolution.v2.SubmitProvisioningConfigRequest.provisioning_config:type_name -> google.cloud.baremetalsolution.v2.ProvisioningConfig
	9,  // 6: google.cloud.baremetalsolution.v2.SubmitProvisioningConfigResponse.provisioning_config:type_name -> google.cloud.baremetalsolution.v2.ProvisioningConfig
	1,  // 7: google.cloud.baremetalsolution.v2.ProvisioningQuota.asset_type:type_name -> google.cloud.baremetalsolution.v2.ProvisioningQuota.AssetType
	18, // 8: google.cloud.baremetalsolution.v2.ProvisioningQuota.instance_quota:type_name -> google.cloud.baremetalsolution.v2.InstanceQuota
	12, // 9: google.cloud.baremetalsolution.v2.ListProvisioningQuotasResponse.provisioning_quotas:type_name -> google.cloud.baremetalsolution.v2.ProvisioningQuota
	22, // 10: google.cloud.baremetalsolution.v2.InstanceConfig.client_network:type_name -> google.cloud.baremetalsolution.v2.InstanceConfig.NetworkAddress
	22, // 11: google.cloud.baremetalsolution.v2.InstanceConfig.private_network:type_name -> google.cloud.baremetalsolution.v2.InstanceConfig.NetworkAddress
	2,  // 12: google.cloud.baremetalsolution.v2.InstanceConfig.network_config:type_name -> google.cloud.baremetalsolution.v2.InstanceConfig.NetworkConfig
	27, // 13: google.cloud.baremetalsolution.v2.InstanceConfig.logical_interfaces:type_name -> google.cloud.baremetalsolution.v2.LogicalInterface
	3,  // 14: google.cloud.baremetalsolution.v2.VolumeConfig.type:type_name -> google.cloud.baremetalsolution.v2.VolumeConfig.Type
	4,  // 15: google.cloud.baremetalsolution.v2.VolumeConfig.protocol:type_name -> google.cloud.baremetalsolution.v2.VolumeConfig.Protocol
	23, // 16: google.cloud.baremetalsolution.v2.VolumeConfig.lun_ranges:type_name -> google.cloud.baremetalsolution.v2.VolumeConfig.LunRange
	24, // 17: google.cloud.baremetalsolution.v2.VolumeConfig.nfs_exports:type_name -> google.cloud.baremetalsolution.v2.VolumeConfig.NfsExport
	28, // 18: google.cloud.baremetalsolution.v2.VolumeConfig.performance_tier:type_name -> google.cloud.baremetalsolution.v2.VolumePerformanceTier
	6,  // 19: google.cloud.baremetalsolution.v2.NetworkConfig.type:type_name -> google.cloud.baremetalsolution.v2.NetworkConfig.Type
	7,  // 20: google.cloud.baremetalsolution.v2.NetworkConfig.bandwidth:type_name -> google.cloud.baremetalsolution.v2.NetworkConfig.Bandwidth
	25, // 21: google.cloud.baremetalsolution.v2.NetworkConfig.vlan_attachments:type_name -> google.cloud.baremetalsolution.v2.NetworkConfig.IntakeVlanAttachment
	8,  // 22: google.cloud.baremetalsolution.v2.NetworkConfig.service_cidr:type_name -> google.cloud.baremetalsolution.v2.NetworkConfig.ServiceCidr
	9,  // 23: google.cloud.baremetalsolution.v2.CreateProvisioningConfigRequest.provisioning_config:type_name -> google.cloud.baremetalsolution.v2.ProvisioningConfig
	9,  // 24: google.cloud.baremetalsolution.v2.UpdateProvisioningConfigRequest.provisioning_config:type_name -> google.cloud.baremetalsolution.v2.ProvisioningConfig
	29, // 25: google.cloud.baremetalsolution.v2.UpdateProvisioningConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	5,  // 26: google.cloud.baremetalsolution.v2.VolumeConfig.NfsExport.permissions:type_name -> google.cloud.baremetalsolution.v2.VolumeConfig.NfsExport.Permissions
	27, // [27:27] is the sub-list for method output_type
	27, // [27:27] is the sub-list for method input_type
	27, // [27:27] is the sub-list for extension type_name
	27, // [27:27] is the sub-list for extension extendee
	0,  // [0:27] is the sub-list for field type_name
}

func init() { file_google_cloud_baremetalsolution_v2_provisioning_proto_init() }
func file_google_cloud_baremetalsolution_v2_provisioning_proto_init() {
	if File_google_cloud_baremetalsolution_v2_provisioning_proto != nil {
		return
	}
	file_google_cloud_baremetalsolution_v2_common_proto_init()
	file_google_cloud_baremetalsolution_v2_network_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisioningConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubmitProvisioningConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubmitProvisioningConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisioningQuota); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProvisioningQuotasRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProvisioningQuotasResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VolumeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceQuota); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProvisioningConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateProvisioningConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateProvisioningConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceConfig_NetworkAddress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VolumeConfig_LunRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VolumeConfig_NfsExport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkConfig_IntakeVlanAttachment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*ProvisioningQuota_InstanceQuota)(nil),
		(*ProvisioningQuota_ServerCount)(nil),
		(*ProvisioningQuota_NetworkBandwidth)(nil),
		(*ProvisioningQuota_StorageGib)(nil),
	}
	file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*VolumeConfig_NfsExport_MachineId)(nil),
		(*VolumeConfig_NfsExport_Cidr)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDesc,
			NumEnums:      9,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_baremetalsolution_v2_provisioning_proto_goTypes,
		DependencyIndexes: file_google_cloud_baremetalsolution_v2_provisioning_proto_depIdxs,
		EnumInfos:         file_google_cloud_baremetalsolution_v2_provisioning_proto_enumTypes,
		MessageInfos:      file_google_cloud_baremetalsolution_v2_provisioning_proto_msgTypes,
	}.Build()
	File_google_cloud_baremetalsolution_v2_provisioning_proto = out.File
	file_google_cloud_baremetalsolution_v2_provisioning_proto_rawDesc = nil
	file_google_cloud_baremetalsolution_v2_provisioning_proto_goTypes = nil
	file_google_cloud_baremetalsolution_v2_provisioning_proto_depIdxs = nil
}
