// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package client

import (
	flatbuffers "github.com/google/flatbuffers/go"
)

type SessionConfigurationT struct {
	UserToken *UserIdentityTokenT
	MessageSecurityMode *MessageSecurityModeT
	SecurityPolicy *SecurityPolicyT
	LocaleIds []string
}

func (t *SessionConfigurationT) Pack(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	if t == nil { return 0 }
	userTokenOffset := t.UserToken.Pack(builder)
	messageSecurityModeOffset := t.MessageSecurityMode.Pack(builder)
	securityPolicyOffset := t.SecurityPolicy.Pack(builder)
	localeIdsOffset := flatbuffers.UOffsetT(0)
	if t.LocaleIds != nil {
		localeIdsLength := len(t.LocaleIds)
		localeIdsOffsets := make([]flatbuffers.UOffsetT, localeIdsLength)
		for j := 0; j < localeIdsLength; j++ {
			localeIdsOffsets[j] = builder.CreateString(t.LocaleIds[j])
		}
		SessionConfigurationStartLocaleIdsVector(builder, localeIdsLength)
		for j := localeIdsLength - 1; j >= 0; j-- {
			builder.PrependUOffsetT(localeIdsOffsets[j])
		}
		localeIdsOffset = builder.EndVector(localeIdsLength)
	}
	SessionConfigurationStart(builder)
	SessionConfigurationAddUserToken(builder, userTokenOffset)
	SessionConfigurationAddMessageSecurityMode(builder, messageSecurityModeOffset)
	SessionConfigurationAddSecurityPolicy(builder, securityPolicyOffset)
	SessionConfigurationAddLocaleIds(builder, localeIdsOffset)
	return SessionConfigurationEnd(builder)
}

func (rcv *SessionConfiguration) UnPackTo(t *SessionConfigurationT) {
	t.UserToken = rcv.UserToken(nil).UnPack()
	t.MessageSecurityMode = rcv.MessageSecurityMode(nil).UnPack()
	t.SecurityPolicy = rcv.SecurityPolicy(nil).UnPack()
	localeIdsLength := rcv.LocaleIdsLength()
	t.LocaleIds = make([]string, localeIdsLength)
	for j := 0; j < localeIdsLength; j++ {
		t.LocaleIds[j] = string(rcv.LocaleIds(j))
	}
}

func (rcv *SessionConfiguration) UnPack() *SessionConfigurationT {
	if rcv == nil { return nil }
	t := &SessionConfigurationT{}
	rcv.UnPackTo(t)
	return t
}

type SessionConfiguration struct {
	_tab flatbuffers.Table
}

func GetRootAsSessionConfiguration(buf []byte, offset flatbuffers.UOffsetT) *SessionConfiguration {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &SessionConfiguration{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsSessionConfiguration(buf []byte, offset flatbuffers.UOffsetT) *SessionConfiguration {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &SessionConfiguration{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *SessionConfiguration) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *SessionConfiguration) Table() flatbuffers.Table {
	return rcv._tab
}

/// UserToken to be used, e.g. for Anonymous or Username, Password
func (rcv *SessionConfiguration) UserToken(obj *UserIdentityToken) *UserIdentityToken {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(UserIdentityToken)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// UserToken to be used, e.g. for Anonymous or Username, Password
/// The OPC UA Server to connect has to support the selected MessageSecurityMode
func (rcv *SessionConfiguration) MessageSecurityMode(obj *MessageSecurityMode) *MessageSecurityMode {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(MessageSecurityMode)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// The OPC UA Server to connect has to support the selected MessageSecurityMode
/// The OPC UA Server to connect has to support the selected SecurityPolicy
func (rcv *SessionConfiguration) SecurityPolicy(obj *SecurityPolicy) *SecurityPolicy {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SecurityPolicy)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// The OPC UA Server to connect has to support the selected SecurityPolicy
/// Define the LocalId establish a connection to the OPC UA Server (ActivateSession service)
func (rcv *SessionConfiguration) LocaleIds(j int) []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.ByteVector(a + flatbuffers.UOffsetT(j*4))
	}
	return nil
}

func (rcv *SessionConfiguration) LocaleIdsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

/// Define the LocalId establish a connection to the OPC UA Server (ActivateSession service)
func SessionConfigurationStart(builder *flatbuffers.Builder) {
	builder.StartObject(4)
}
func SessionConfigurationAddUserToken(builder *flatbuffers.Builder, userToken flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(userToken), 0)
}
func SessionConfigurationAddMessageSecurityMode(builder *flatbuffers.Builder, messageSecurityMode flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(messageSecurityMode), 0)
}
func SessionConfigurationAddSecurityPolicy(builder *flatbuffers.Builder, securityPolicy flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(securityPolicy), 0)
}
func SessionConfigurationAddLocaleIds(builder *flatbuffers.Builder, localeIds flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(localeIds), 0)
}
func SessionConfigurationStartLocaleIdsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func SessionConfigurationEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
