// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package server

import (
	flatbuffers "github.com/google/flatbuffers/go"
)

type ServerStatusTypeT struct {
	BuildInfo *BuildInfoTypeT
	CurrentTime uint32
	SecondsTillShutdown uint32
	ShutdownReason string
	StartTime uint32
	State EnumServerState
}

func (t *ServerStatusTypeT) Pack(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	if t == nil { return 0 }
	buildInfoOffset := t.BuildInfo.Pack(builder)
	shutdownReasonOffset := builder.CreateString(t.ShutdownReason)
	ServerStatusTypeStart(builder)
	ServerStatusTypeAddBuildInfo(builder, buildInfoOffset)
	ServerStatusTypeAddCurrentTime(builder, t.CurrentTime)
	ServerStatusTypeAddSecondsTillShutdown(builder, t.SecondsTillShutdown)
	ServerStatusTypeAddShutdownReason(builder, shutdownReasonOffset)
	ServerStatusTypeAddStartTime(builder, t.StartTime)
	ServerStatusTypeAddState(builder, t.State)
	return ServerStatusTypeEnd(builder)
}

func (rcv *ServerStatusType) UnPackTo(t *ServerStatusTypeT) {
	t.BuildInfo = rcv.BuildInfo(nil).UnPack()
	t.CurrentTime = rcv.CurrentTime()
	t.SecondsTillShutdown = rcv.SecondsTillShutdown()
	t.ShutdownReason = string(rcv.ShutdownReason())
	t.StartTime = rcv.StartTime()
	t.State = rcv.State()
}

func (rcv *ServerStatusType) UnPack() *ServerStatusTypeT {
	if rcv == nil { return nil }
	t := &ServerStatusTypeT{}
	rcv.UnPackTo(t)
	return t
}

type ServerStatusType struct {
	_tab flatbuffers.Table
}

func GetRootAsServerStatusType(buf []byte, offset flatbuffers.UOffsetT) *ServerStatusType {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &ServerStatusType{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsServerStatusType(buf []byte, offset flatbuffers.UOffsetT) *ServerStatusType {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &ServerStatusType{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *ServerStatusType) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *ServerStatusType) Table() flatbuffers.Table {
	return rcv._tab
}

/// Build info of the OPC UA Server
func (rcv *ServerStatusType) BuildInfo(obj *BuildInfoType) *BuildInfoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(BuildInfoType)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// Build info of the OPC UA Server
/// The current time of the OPC UA Server
func (rcv *ServerStatusType) CurrentTime() uint32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.GetUint32(o + rcv._tab.Pos)
	}
	return 0
}

/// The current time of the OPC UA Server
func (rcv *ServerStatusType) MutateCurrentTime(n uint32) bool {
	return rcv._tab.MutateUint32Slot(6, n)
}

/// The time until server shutdown if an OPC UA Server shutdown was requested
/// Otherwise, the value is 0
func (rcv *ServerStatusType) SecondsTillShutdown() uint32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.GetUint32(o + rcv._tab.Pos)
	}
	return 0
}

/// The time until server shutdown if an OPC UA Server shutdown was requested
/// Otherwise, the value is 0
func (rcv *ServerStatusType) MutateSecondsTillShutdown(n uint32) bool {
	return rcv._tab.MutateUint32Slot(8, n)
}

/// The reason for the server shutdown if an OPC UA Server shutdown was requested
/// Otherwise, an empty string is displayed
func (rcv *ServerStatusType) ShutdownReason() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// The reason for the server shutdown if an OPC UA Server shutdown was requested
/// Otherwise, an empty string is displayed
/// The starting point in time of the OPC UA Server
func (rcv *ServerStatusType) StartTime() uint32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return rcv._tab.GetUint32(o + rcv._tab.Pos)
	}
	return 0
}

/// The starting point in time of the OPC UA Server
func (rcv *ServerStatusType) MutateStartTime(n uint32) bool {
	return rcv._tab.MutateUint32Slot(12, n)
}

/// The current state of the OPC UA Server
func (rcv *ServerStatusType) State() EnumServerState {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		return EnumServerState(rcv._tab.GetInt32(o + rcv._tab.Pos))
	}
	return 0
}

/// The current state of the OPC UA Server
func (rcv *ServerStatusType) MutateState(n EnumServerState) bool {
	return rcv._tab.MutateInt32Slot(14, int32(n))
}

func ServerStatusTypeStart(builder *flatbuffers.Builder) {
	builder.StartObject(6)
}
func ServerStatusTypeAddBuildInfo(builder *flatbuffers.Builder, buildInfo flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(buildInfo), 0)
}
func ServerStatusTypeAddCurrentTime(builder *flatbuffers.Builder, currentTime uint32) {
	builder.PrependUint32Slot(1, currentTime, 0)
}
func ServerStatusTypeAddSecondsTillShutdown(builder *flatbuffers.Builder, secondsTillShutdown uint32) {
	builder.PrependUint32Slot(2, secondsTillShutdown, 0)
}
func ServerStatusTypeAddShutdownReason(builder *flatbuffers.Builder, shutdownReason flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(shutdownReason), 0)
}
func ServerStatusTypeAddStartTime(builder *flatbuffers.Builder, startTime uint32) {
	builder.PrependUint32Slot(4, startTime, 0)
}
func ServerStatusTypeAddState(builder *flatbuffers.Builder, state EnumServerState) {
	builder.PrependInt32Slot(5, int32(state), 0)
}
func ServerStatusTypeEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
