// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package fbtypes

import (
	flatbuffers "github.com/google/flatbuffers/go"
)

/// complete configuration of a single kinematics
type KinCfgT struct {
	ObjectType string
	Limits *KinCfgLimitsT
	AxsCfg []*KinCfgAxsT
	Mcs *KinCfgJntTrafoAllSetsT
	Units *UnitCfgKinT
	PrepLimits *KinCfgPrepLimitsT
	RtInputs *RTInputsCfgT
	Dynamics *KinCfgDynamicsT
	Geometry *KinGeoCfgT
}

func (t *KinCfgT) Pack(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	if t == nil { return 0 }
	objectTypeOffset := builder.CreateString(t.ObjectType)
	limitsOffset := t.Limits.Pack(builder)
	axsCfgOffset := flatbuffers.UOffsetT(0)
	if t.AxsCfg != nil {
		axsCfgLength := len(t.AxsCfg)
		axsCfgOffsets := make([]flatbuffers.UOffsetT, axsCfgLength)
		for j := 0; j < axsCfgLength; j++ {
			axsCfgOffsets[j] = t.AxsCfg[j].Pack(builder)
		}
		KinCfgStartAxsCfgVector(builder, axsCfgLength)
		for j := axsCfgLength - 1; j >= 0; j-- {
			builder.PrependUOffsetT(axsCfgOffsets[j])
		}
		axsCfgOffset = builder.EndVector(axsCfgLength)
	}
	mcsOffset := t.Mcs.Pack(builder)
	unitsOffset := t.Units.Pack(builder)
	prepLimitsOffset := t.PrepLimits.Pack(builder)
	rtInputsOffset := t.RtInputs.Pack(builder)
	dynamicsOffset := t.Dynamics.Pack(builder)
	geometryOffset := t.Geometry.Pack(builder)
	KinCfgStart(builder)
	KinCfgAddObjectType(builder, objectTypeOffset)
	KinCfgAddLimits(builder, limitsOffset)
	KinCfgAddAxsCfg(builder, axsCfgOffset)
	KinCfgAddMcs(builder, mcsOffset)
	KinCfgAddUnits(builder, unitsOffset)
	KinCfgAddPrepLimits(builder, prepLimitsOffset)
	KinCfgAddRtInputs(builder, rtInputsOffset)
	KinCfgAddDynamics(builder, dynamicsOffset)
	KinCfgAddGeometry(builder, geometryOffset)
	return KinCfgEnd(builder)
}

func (rcv *KinCfg) UnPackTo(t *KinCfgT) {
	t.ObjectType = string(rcv.ObjectType())
	t.Limits = rcv.Limits(nil).UnPack()
	axsCfgLength := rcv.AxsCfgLength()
	t.AxsCfg = make([]*KinCfgAxsT, axsCfgLength)
	for j := 0; j < axsCfgLength; j++ {
		x := KinCfgAxs{}
		rcv.AxsCfg(&x, j)
		t.AxsCfg[j] = x.UnPack()
	}
	t.Mcs = rcv.Mcs(nil).UnPack()
	t.Units = rcv.Units(nil).UnPack()
	t.PrepLimits = rcv.PrepLimits(nil).UnPack()
	t.RtInputs = rcv.RtInputs(nil).UnPack()
	t.Dynamics = rcv.Dynamics(nil).UnPack()
	t.Geometry = rcv.Geometry(nil).UnPack()
}

func (rcv *KinCfg) UnPack() *KinCfgT {
	if rcv == nil { return nil }
	t := &KinCfgT{}
	rcv.UnPackTo(t)
	return t
}

type KinCfg struct {
	_tab flatbuffers.Table
}

func GetRootAsKinCfg(buf []byte, offset flatbuffers.UOffsetT) *KinCfg {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &KinCfg{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsKinCfg(buf []byte, offset flatbuffers.UOffsetT) *KinCfg {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &KinCfg{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *KinCfg) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *KinCfg) Table() flatbuffers.Table {
	return rcv._tab
}

/// object type (must be "Kinematics"), required for save/load
func (rcv *KinCfg) ObjectType() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// object type (must be "Kinematics"), required for save/load
/// all configured limits of this kinematics
func (rcv *KinCfg) Limits(obj *KinCfgLimits) *KinCfgLimits {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(KinCfgLimits)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// all configured limits of this kinematics
/// data of all axes, that can be added to this kinematics
func (rcv *KinCfg) AxsCfg(obj *KinCfgAxs, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *KinCfg) AxsCfgLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

/// data of all axes, that can be added to this kinematics
/// configuration of all joint transformations (ACS <--> MCS)
func (rcv *KinCfg) Mcs(obj *KinCfgJntTrafoAllSets) *KinCfgJntTrafoAllSets {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(KinCfgJntTrafoAllSets)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// configuration of all joint transformations (ACS <--> MCS)
/// general unit configuration of this kinematics
func (rcv *KinCfg) Units(obj *UnitCfgKin) *UnitCfgKin {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(UnitCfgKin)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// general unit configuration of this kinematics
/// preparation limits of a kinematics
func (rcv *KinCfg) PrepLimits(obj *KinCfgPrepLimits) *KinCfgPrepLimits {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(KinCfgPrepLimits)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// preparation limits of a kinematics
/// configuration of the real-time inputs of the kinematics
func (rcv *KinCfg) RtInputs(obj *RTInputsCfg) *RTInputsCfg {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(RTInputsCfg)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// configuration of the real-time inputs of the kinematics
/// configuration of the dynamics of the kinematics
func (rcv *KinCfg) Dynamics(obj *KinCfgDynamics) *KinCfgDynamics {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(18))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(KinCfgDynamics)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// configuration of the dynamics of the kinematics
/// configuration of the geometry functions of the kinematics
func (rcv *KinCfg) Geometry(obj *KinGeoCfg) *KinGeoCfg {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(20))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(KinGeoCfg)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// configuration of the geometry functions of the kinematics
func KinCfgStart(builder *flatbuffers.Builder) {
	builder.StartObject(9)
}
func KinCfgAddObjectType(builder *flatbuffers.Builder, objectType flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(objectType), 0)
}
func KinCfgAddLimits(builder *flatbuffers.Builder, limits flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(limits), 0)
}
func KinCfgAddAxsCfg(builder *flatbuffers.Builder, axsCfg flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(axsCfg), 0)
}
func KinCfgStartAxsCfgVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func KinCfgAddMcs(builder *flatbuffers.Builder, mcs flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(mcs), 0)
}
func KinCfgAddUnits(builder *flatbuffers.Builder, units flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(units), 0)
}
func KinCfgAddPrepLimits(builder *flatbuffers.Builder, prepLimits flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(5, flatbuffers.UOffsetT(prepLimits), 0)
}
func KinCfgAddRtInputs(builder *flatbuffers.Builder, rtInputs flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(6, flatbuffers.UOffsetT(rtInputs), 0)
}
func KinCfgAddDynamics(builder *flatbuffers.Builder, dynamics flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(7, flatbuffers.UOffsetT(dynamics), 0)
}
func KinCfgAddGeometry(builder *flatbuffers.Builder, geometry flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(8, flatbuffers.UOffsetT(geometry), 0)
}
func KinCfgEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
