// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/datacatalog/lineage/v1/lineage.proto

package lineagepb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Lineage_ProcessOpenLineageRunEvent_FullMethodName = "/google.cloud.datacatalog.lineage.v1.Lineage/ProcessOpenLineageRunEvent"
	Lineage_CreateProcess_FullMethodName              = "/google.cloud.datacatalog.lineage.v1.Lineage/CreateProcess"
	Lineage_UpdateProcess_FullMethodName              = "/google.cloud.datacatalog.lineage.v1.Lineage/UpdateProcess"
	Lineage_GetProcess_FullMethodName                 = "/google.cloud.datacatalog.lineage.v1.Lineage/GetProcess"
	Lineage_ListProcesses_FullMethodName              = "/google.cloud.datacatalog.lineage.v1.Lineage/ListProcesses"
	Lineage_DeleteProcess_FullMethodName              = "/google.cloud.datacatalog.lineage.v1.Lineage/DeleteProcess"
	Lineage_CreateRun_FullMethodName                  = "/google.cloud.datacatalog.lineage.v1.Lineage/CreateRun"
	Lineage_UpdateRun_FullMethodName                  = "/google.cloud.datacatalog.lineage.v1.Lineage/UpdateRun"
	Lineage_GetRun_FullMethodName                     = "/google.cloud.datacatalog.lineage.v1.Lineage/GetRun"
	Lineage_ListRuns_FullMethodName                   = "/google.cloud.datacatalog.lineage.v1.Lineage/ListRuns"
	Lineage_DeleteRun_FullMethodName                  = "/google.cloud.datacatalog.lineage.v1.Lineage/DeleteRun"
	Lineage_CreateLineageEvent_FullMethodName         = "/google.cloud.datacatalog.lineage.v1.Lineage/CreateLineageEvent"
	Lineage_GetLineageEvent_FullMethodName            = "/google.cloud.datacatalog.lineage.v1.Lineage/GetLineageEvent"
	Lineage_ListLineageEvents_FullMethodName          = "/google.cloud.datacatalog.lineage.v1.Lineage/ListLineageEvents"
	Lineage_DeleteLineageEvent_FullMethodName         = "/google.cloud.datacatalog.lineage.v1.Lineage/DeleteLineageEvent"
	Lineage_SearchLinks_FullMethodName                = "/google.cloud.datacatalog.lineage.v1.Lineage/SearchLinks"
	Lineage_BatchSearchLinkProcesses_FullMethodName   = "/google.cloud.datacatalog.lineage.v1.Lineage/BatchSearchLinkProcesses"
)

// LineageClient is the client API for Lineage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LineageClient interface {
	// Creates new lineage events together with their parents: process and run.
	// Updates the process and run if they already exist.
	// Mapped from Open Lineage specification:
	// https://github.com/OpenLineage/OpenLineage/blob/main/spec/OpenLineage.json.
	ProcessOpenLineageRunEvent(ctx context.Context, in *ProcessOpenLineageRunEventRequest, opts ...grpc.CallOption) (*ProcessOpenLineageRunEventResponse, error)
	// Creates a new process.
	CreateProcess(ctx context.Context, in *CreateProcessRequest, opts ...grpc.CallOption) (*Process, error)
	// Updates a process.
	UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*Process, error)
	// Gets the details of the specified process.
	GetProcess(ctx context.Context, in *GetProcessRequest, opts ...grpc.CallOption) (*Process, error)
	// List processes in the given project and location. List order is descending
	// by insertion time.
	ListProcesses(ctx context.Context, in *ListProcessesRequest, opts ...grpc.CallOption) (*ListProcessesResponse, error)
	// Deletes the process with the specified name.
	DeleteProcess(ctx context.Context, in *DeleteProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new run.
	CreateRun(ctx context.Context, in *CreateRunRequest, opts ...grpc.CallOption) (*Run, error)
	// Updates a run.
	UpdateRun(ctx context.Context, in *UpdateRunRequest, opts ...grpc.CallOption) (*Run, error)
	// Gets the details of the specified run.
	GetRun(ctx context.Context, in *GetRunRequest, opts ...grpc.CallOption) (*Run, error)
	// Lists runs in the given project and location. List order is descending by
	// `start_time`.
	ListRuns(ctx context.Context, in *ListRunsRequest, opts ...grpc.CallOption) (*ListRunsResponse, error)
	// Deletes the run with the specified name.
	DeleteRun(ctx context.Context, in *DeleteRunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new lineage event.
	CreateLineageEvent(ctx context.Context, in *CreateLineageEventRequest, opts ...grpc.CallOption) (*LineageEvent, error)
	// Gets details of a specified lineage event.
	GetLineageEvent(ctx context.Context, in *GetLineageEventRequest, opts ...grpc.CallOption) (*LineageEvent, error)
	// Lists lineage events in the given project and location. The list order is
	// not defined.
	ListLineageEvents(ctx context.Context, in *ListLineageEventsRequest, opts ...grpc.CallOption) (*ListLineageEventsResponse, error)
	// Deletes the lineage event with the specified name.
	DeleteLineageEvent(ctx context.Context, in *DeleteLineageEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Retrieve a list of links connected to a specific asset.
	// Links represent the data flow between **source** (upstream)
	// and **target** (downstream) assets in transformation pipelines.
	// Links are stored in the same project as the Lineage Events that create
	// them.
	//
	// You can retrieve links in every project where you have the
	// `datalineage.events.get` permission. The project provided in the URL
	// is used for Billing and Quota.
	SearchLinks(ctx context.Context, in *SearchLinksRequest, opts ...grpc.CallOption) (*SearchLinksResponse, error)
	// Retrieve information about LineageProcesses associated with specific
	// links. LineageProcesses are transformation pipelines that result in data
	// flowing from **source** to **target** assets. Links between assets
	// represent this operation.
	//
	// If you have specific link names, you can use this method to
	// verify which LineageProcesses contribute to creating those links.
	// See the
	// [SearchLinks][google.cloud.datacatalog.lineage.v1.Lineage.SearchLinks]
	// method for more information on how to retrieve link name.
	//
	// You can retrieve the LineageProcess information in every project where you
	// have the `datalineage.events.get` permission. The project provided in the
	// URL is used for Billing and Quota.
	BatchSearchLinkProcesses(ctx context.Context, in *BatchSearchLinkProcessesRequest, opts ...grpc.CallOption) (*BatchSearchLinkProcessesResponse, error)
}

type lineageClient struct {
	cc grpc.ClientConnInterface
}

func NewLineageClient(cc grpc.ClientConnInterface) LineageClient {
	return &lineageClient{cc}
}

func (c *lineageClient) ProcessOpenLineageRunEvent(ctx context.Context, in *ProcessOpenLineageRunEventRequest, opts ...grpc.CallOption) (*ProcessOpenLineageRunEventResponse, error) {
	out := new(ProcessOpenLineageRunEventResponse)
	err := c.cc.Invoke(ctx, Lineage_ProcessOpenLineageRunEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) CreateProcess(ctx context.Context, in *CreateProcessRequest, opts ...grpc.CallOption) (*Process, error) {
	out := new(Process)
	err := c.cc.Invoke(ctx, Lineage_CreateProcess_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*Process, error) {
	out := new(Process)
	err := c.cc.Invoke(ctx, Lineage_UpdateProcess_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) GetProcess(ctx context.Context, in *GetProcessRequest, opts ...grpc.CallOption) (*Process, error) {
	out := new(Process)
	err := c.cc.Invoke(ctx, Lineage_GetProcess_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) ListProcesses(ctx context.Context, in *ListProcessesRequest, opts ...grpc.CallOption) (*ListProcessesResponse, error) {
	out := new(ListProcessesResponse)
	err := c.cc.Invoke(ctx, Lineage_ListProcesses_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) DeleteProcess(ctx context.Context, in *DeleteProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Lineage_DeleteProcess_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) CreateRun(ctx context.Context, in *CreateRunRequest, opts ...grpc.CallOption) (*Run, error) {
	out := new(Run)
	err := c.cc.Invoke(ctx, Lineage_CreateRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) UpdateRun(ctx context.Context, in *UpdateRunRequest, opts ...grpc.CallOption) (*Run, error) {
	out := new(Run)
	err := c.cc.Invoke(ctx, Lineage_UpdateRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) GetRun(ctx context.Context, in *GetRunRequest, opts ...grpc.CallOption) (*Run, error) {
	out := new(Run)
	err := c.cc.Invoke(ctx, Lineage_GetRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) ListRuns(ctx context.Context, in *ListRunsRequest, opts ...grpc.CallOption) (*ListRunsResponse, error) {
	out := new(ListRunsResponse)
	err := c.cc.Invoke(ctx, Lineage_ListRuns_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) DeleteRun(ctx context.Context, in *DeleteRunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Lineage_DeleteRun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) CreateLineageEvent(ctx context.Context, in *CreateLineageEventRequest, opts ...grpc.CallOption) (*LineageEvent, error) {
	out := new(LineageEvent)
	err := c.cc.Invoke(ctx, Lineage_CreateLineageEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) GetLineageEvent(ctx context.Context, in *GetLineageEventRequest, opts ...grpc.CallOption) (*LineageEvent, error) {
	out := new(LineageEvent)
	err := c.cc.Invoke(ctx, Lineage_GetLineageEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) ListLineageEvents(ctx context.Context, in *ListLineageEventsRequest, opts ...grpc.CallOption) (*ListLineageEventsResponse, error) {
	out := new(ListLineageEventsResponse)
	err := c.cc.Invoke(ctx, Lineage_ListLineageEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) DeleteLineageEvent(ctx context.Context, in *DeleteLineageEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Lineage_DeleteLineageEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) SearchLinks(ctx context.Context, in *SearchLinksRequest, opts ...grpc.CallOption) (*SearchLinksResponse, error) {
	out := new(SearchLinksResponse)
	err := c.cc.Invoke(ctx, Lineage_SearchLinks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *lineageClient) BatchSearchLinkProcesses(ctx context.Context, in *BatchSearchLinkProcessesRequest, opts ...grpc.CallOption) (*BatchSearchLinkProcessesResponse, error) {
	out := new(BatchSearchLinkProcessesResponse)
	err := c.cc.Invoke(ctx, Lineage_BatchSearchLinkProcesses_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LineageServer is the server API for Lineage service.
// All implementations should embed UnimplementedLineageServer
// for forward compatibility
type LineageServer interface {
	// Creates new lineage events together with their parents: process and run.
	// Updates the process and run if they already exist.
	// Mapped from Open Lineage specification:
	// https://github.com/OpenLineage/OpenLineage/blob/main/spec/OpenLineage.json.
	ProcessOpenLineageRunEvent(context.Context, *ProcessOpenLineageRunEventRequest) (*ProcessOpenLineageRunEventResponse, error)
	// Creates a new process.
	CreateProcess(context.Context, *CreateProcessRequest) (*Process, error)
	// Updates a process.
	UpdateProcess(context.Context, *UpdateProcessRequest) (*Process, error)
	// Gets the details of the specified process.
	GetProcess(context.Context, *GetProcessRequest) (*Process, error)
	// List processes in the given project and location. List order is descending
	// by insertion time.
	ListProcesses(context.Context, *ListProcessesRequest) (*ListProcessesResponse, error)
	// Deletes the process with the specified name.
	DeleteProcess(context.Context, *DeleteProcessRequest) (*longrunningpb.Operation, error)
	// Creates a new run.
	CreateRun(context.Context, *CreateRunRequest) (*Run, error)
	// Updates a run.
	UpdateRun(context.Context, *UpdateRunRequest) (*Run, error)
	// Gets the details of the specified run.
	GetRun(context.Context, *GetRunRequest) (*Run, error)
	// Lists runs in the given project and location. List order is descending by
	// `start_time`.
	ListRuns(context.Context, *ListRunsRequest) (*ListRunsResponse, error)
	// Deletes the run with the specified name.
	DeleteRun(context.Context, *DeleteRunRequest) (*longrunningpb.Operation, error)
	// Creates a new lineage event.
	CreateLineageEvent(context.Context, *CreateLineageEventRequest) (*LineageEvent, error)
	// Gets details of a specified lineage event.
	GetLineageEvent(context.Context, *GetLineageEventRequest) (*LineageEvent, error)
	// Lists lineage events in the given project and location. The list order is
	// not defined.
	ListLineageEvents(context.Context, *ListLineageEventsRequest) (*ListLineageEventsResponse, error)
	// Deletes the lineage event with the specified name.
	DeleteLineageEvent(context.Context, *DeleteLineageEventRequest) (*emptypb.Empty, error)
	// Retrieve a list of links connected to a specific asset.
	// Links represent the data flow between **source** (upstream)
	// and **target** (downstream) assets in transformation pipelines.
	// Links are stored in the same project as the Lineage Events that create
	// them.
	//
	// You can retrieve links in every project where you have the
	// `datalineage.events.get` permission. The project provided in the URL
	// is used for Billing and Quota.
	SearchLinks(context.Context, *SearchLinksRequest) (*SearchLinksResponse, error)
	// Retrieve information about LineageProcesses associated with specific
	// links. LineageProcesses are transformation pipelines that result in data
	// flowing from **source** to **target** assets. Links between assets
	// represent this operation.
	//
	// If you have specific link names, you can use this method to
	// verify which LineageProcesses contribute to creating those links.
	// See the
	// [SearchLinks][google.cloud.datacatalog.lineage.v1.Lineage.SearchLinks]
	// method for more information on how to retrieve link name.
	//
	// You can retrieve the LineageProcess information in every project where you
	// have the `datalineage.events.get` permission. The project provided in the
	// URL is used for Billing and Quota.
	BatchSearchLinkProcesses(context.Context, *BatchSearchLinkProcessesRequest) (*BatchSearchLinkProcessesResponse, error)
}

// UnimplementedLineageServer should be embedded to have forward compatible implementations.
type UnimplementedLineageServer struct {
}

func (UnimplementedLineageServer) ProcessOpenLineageRunEvent(context.Context, *ProcessOpenLineageRunEventRequest) (*ProcessOpenLineageRunEventResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProcessOpenLineageRunEvent not implemented")
}
func (UnimplementedLineageServer) CreateProcess(context.Context, *CreateProcessRequest) (*Process, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProcess not implemented")
}
func (UnimplementedLineageServer) UpdateProcess(context.Context, *UpdateProcessRequest) (*Process, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProcess not implemented")
}
func (UnimplementedLineageServer) GetProcess(context.Context, *GetProcessRequest) (*Process, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProcess not implemented")
}
func (UnimplementedLineageServer) ListProcesses(context.Context, *ListProcessesRequest) (*ListProcessesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProcesses not implemented")
}
func (UnimplementedLineageServer) DeleteProcess(context.Context, *DeleteProcessRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProcess not implemented")
}
func (UnimplementedLineageServer) CreateRun(context.Context, *CreateRunRequest) (*Run, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRun not implemented")
}
func (UnimplementedLineageServer) UpdateRun(context.Context, *UpdateRunRequest) (*Run, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRun not implemented")
}
func (UnimplementedLineageServer) GetRun(context.Context, *GetRunRequest) (*Run, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRun not implemented")
}
func (UnimplementedLineageServer) ListRuns(context.Context, *ListRunsRequest) (*ListRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRuns not implemented")
}
func (UnimplementedLineageServer) DeleteRun(context.Context, *DeleteRunRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRun not implemented")
}
func (UnimplementedLineageServer) CreateLineageEvent(context.Context, *CreateLineageEventRequest) (*LineageEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLineageEvent not implemented")
}
func (UnimplementedLineageServer) GetLineageEvent(context.Context, *GetLineageEventRequest) (*LineageEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLineageEvent not implemented")
}
func (UnimplementedLineageServer) ListLineageEvents(context.Context, *ListLineageEventsRequest) (*ListLineageEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLineageEvents not implemented")
}
func (UnimplementedLineageServer) DeleteLineageEvent(context.Context, *DeleteLineageEventRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLineageEvent not implemented")
}
func (UnimplementedLineageServer) SearchLinks(context.Context, *SearchLinksRequest) (*SearchLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchLinks not implemented")
}
func (UnimplementedLineageServer) BatchSearchLinkProcesses(context.Context, *BatchSearchLinkProcessesRequest) (*BatchSearchLinkProcessesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchSearchLinkProcesses not implemented")
}

// UnsafeLineageServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LineageServer will
// result in compilation errors.
type UnsafeLineageServer interface {
	mustEmbedUnimplementedLineageServer()
}

func RegisterLineageServer(s grpc.ServiceRegistrar, srv LineageServer) {
	s.RegisterService(&Lineage_ServiceDesc, srv)
}

func _Lineage_ProcessOpenLineageRunEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessOpenLineageRunEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).ProcessOpenLineageRunEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_ProcessOpenLineageRunEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).ProcessOpenLineageRunEvent(ctx, req.(*ProcessOpenLineageRunEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_CreateProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).CreateProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_CreateProcess_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).CreateProcess(ctx, req.(*CreateProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_UpdateProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).UpdateProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_UpdateProcess_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).UpdateProcess(ctx, req.(*UpdateProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_GetProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).GetProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_GetProcess_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).GetProcess(ctx, req.(*GetProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_ListProcesses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProcessesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).ListProcesses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_ListProcesses_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).ListProcesses(ctx, req.(*ListProcessesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_DeleteProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).DeleteProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_DeleteProcess_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).DeleteProcess(ctx, req.(*DeleteProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_CreateRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).CreateRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_CreateRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).CreateRun(ctx, req.(*CreateRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_UpdateRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).UpdateRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_UpdateRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).UpdateRun(ctx, req.(*UpdateRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_GetRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).GetRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_GetRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).GetRun(ctx, req.(*GetRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_ListRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).ListRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_ListRuns_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).ListRuns(ctx, req.(*ListRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_DeleteRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).DeleteRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_DeleteRun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).DeleteRun(ctx, req.(*DeleteRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_CreateLineageEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLineageEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).CreateLineageEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_CreateLineageEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).CreateLineageEvent(ctx, req.(*CreateLineageEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_GetLineageEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLineageEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).GetLineageEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_GetLineageEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).GetLineageEvent(ctx, req.(*GetLineageEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_ListLineageEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLineageEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).ListLineageEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_ListLineageEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).ListLineageEvents(ctx, req.(*ListLineageEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_DeleteLineageEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLineageEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).DeleteLineageEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_DeleteLineageEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).DeleteLineageEvent(ctx, req.(*DeleteLineageEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_SearchLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).SearchLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_SearchLinks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).SearchLinks(ctx, req.(*SearchLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Lineage_BatchSearchLinkProcesses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchSearchLinkProcessesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LineageServer).BatchSearchLinkProcesses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Lineage_BatchSearchLinkProcesses_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LineageServer).BatchSearchLinkProcesses(ctx, req.(*BatchSearchLinkProcessesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Lineage_ServiceDesc is the grpc.ServiceDesc for Lineage service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Lineage_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.lineage.v1.Lineage",
	HandlerType: (*LineageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ProcessOpenLineageRunEvent",
			Handler:    _Lineage_ProcessOpenLineageRunEvent_Handler,
		},
		{
			MethodName: "CreateProcess",
			Handler:    _Lineage_CreateProcess_Handler,
		},
		{
			MethodName: "UpdateProcess",
			Handler:    _Lineage_UpdateProcess_Handler,
		},
		{
			MethodName: "GetProcess",
			Handler:    _Lineage_GetProcess_Handler,
		},
		{
			MethodName: "ListProcesses",
			Handler:    _Lineage_ListProcesses_Handler,
		},
		{
			MethodName: "DeleteProcess",
			Handler:    _Lineage_DeleteProcess_Handler,
		},
		{
			MethodName: "CreateRun",
			Handler:    _Lineage_CreateRun_Handler,
		},
		{
			MethodName: "UpdateRun",
			Handler:    _Lineage_UpdateRun_Handler,
		},
		{
			MethodName: "GetRun",
			Handler:    _Lineage_GetRun_Handler,
		},
		{
			MethodName: "ListRuns",
			Handler:    _Lineage_ListRuns_Handler,
		},
		{
			MethodName: "DeleteRun",
			Handler:    _Lineage_DeleteRun_Handler,
		},
		{
			MethodName: "CreateLineageEvent",
			Handler:    _Lineage_CreateLineageEvent_Handler,
		},
		{
			MethodName: "GetLineageEvent",
			Handler:    _Lineage_GetLineageEvent_Handler,
		},
		{
			MethodName: "ListLineageEvents",
			Handler:    _Lineage_ListLineageEvents_Handler,
		},
		{
			MethodName: "DeleteLineageEvent",
			Handler:    _Lineage_DeleteLineageEvent_Handler,
		},
		{
			MethodName: "SearchLinks",
			Handler:    _Lineage_SearchLinks_Handler,
		},
		{
			MethodName: "BatchSearchLinkProcesses",
			Handler:    _Lineage_BatchSearchLinkProcesses_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/lineage/v1/lineage.proto",
}
