// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pcommon

import (
	"go.opentelemetry.io/collector/pdata/internal"
)

// IntSlice represents a []int slice.
// The instance of IntSlice can be assigned to multiple objects since it's immutable.
//
// Must use NewIntSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntSlice internal.IntSlice

func (ms IntSlice) getOrig() *[]int {
	return internal.GetOrigIntSlice(internal.IntSlice(ms))
}

func (ms IntSlice) getState() *internal.State {
	return internal.GetIntSliceState(internal.IntSlice(ms))
}

// NewIntSlice creates a new empty IntSlice.
func NewIntSlice() IntSlice {
	orig := []int(nil)
	state := internal.StateMutable
	return IntSlice(internal.NewIntSlice(&orig, &state))
}

// AsRaw returns a copy of the []int slice.
func (ms IntSlice) AsRaw() []int {
	return copyIntSlice(nil, *ms.getOrig())
}

// FromRaw copies raw []int into the slice IntSlice.
func (ms IntSlice) FromRaw(val []int) {
	ms.getState().AssertMutable()
	*ms.getOrig() = copyIntSlice(*ms.getOrig(), val)
}

// Len returns length of the []int slice value.
// Equivalent of len(intSlice).
func (ms IntSlice) Len() int {
	return len(*ms.getOrig())
}

// At returns an item from particular index.
// Equivalent of intSlice[i].
func (ms IntSlice) At(i int) int {
	return (*ms.getOrig())[i]
}

// SetAt sets int item at particular index.
// Equivalent of intSlice[i] = val
func (ms IntSlice) SetAt(i int, val int) {
	ms.getState().AssertMutable()
	(*ms.getOrig())[i] = val
}

// EnsureCapacity ensures IntSlice has at least the specified capacity.
//  1. If the newCap <= cap, then is no change in capacity.
//  2. If the newCap > cap, then the slice capacity will be expanded to the provided value which will be equivalent of:
//     buf := make([]int, len(intSlice), newCap)
//     copy(buf, intSlice)
//     intSlice = buf
func (ms IntSlice) EnsureCapacity(newCap int) {
	ms.getState().AssertMutable()
	oldCap := cap(*ms.getOrig())
	if newCap <= oldCap {
		return
	}

	newOrig := make([]int, len(*ms.getOrig()), newCap)
	copy(newOrig, *ms.getOrig())
	*ms.getOrig() = newOrig
}

// Append appends extra elements to IntSlice.
// Equivalent of intSlice = append(intSlice, elms...)
func (ms IntSlice) Append(elms ...int) {
	ms.getState().AssertMutable()
	*ms.getOrig() = append(*ms.getOrig(), elms...)
}

// MoveTo moves all elements from the current slice overriding the destination and
// resetting the current instance to its zero value.
func (ms IntSlice) MoveTo(dest IntSlice) {
	ms.getState().AssertMutable()
	dest.getState().AssertMutable()
	*dest.getOrig() = *ms.getOrig()
	*ms.getOrig() = nil
}

// CopyTo copies all elements from the current slice overriding the destination.
func (ms IntSlice) CopyTo(dest IntSlice) {
	dest.getState().AssertMutable()
	*dest.getOrig() = copyIntSlice(*dest.getOrig(), *ms.getOrig())
}

func copyIntSlice(dst, src []int) []int {
	dst = dst[:0]
	return append(dst, src...)
}
