/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.util.Utils;

public class StanceTradeItem
extends TradeItem {
    public static final String TAG = "stanceTradeItem";
    private Stance stance;
    private static final String STANCE_TAG = "stance";

    public StanceTradeItem(Game game, Player source, Player destination, Stance stance) {
        super(game, Messages.nameKey("model.tradeItem.stance"), source, destination);
        this.stance = stance;
    }

    public StanceTradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    @Override
    public boolean isValid() {
        return this.stance != null;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public StringTemplate getLabel() {
        return StringTemplate.key(this.stance);
    }

    @Override
    public Stance getStance() {
        return this.stance;
    }

    @Override
    public void setStance(Stance stance) {
        this.stance = stance;
    }

    @Override
    public int evaluateFor(Player player) {
        Stance stance = this.getStance();
        double ratio = player.getStrengthRatio(this.getOther(player), false);
        int value = (int)Math.round(100.0 * ratio);
        switch (stance) {
            case WAR: {
                if (ratio < 0.33) {
                    value = Integer.MIN_VALUE;
                    break;
                }
                if (!(ratio < 0.5)) break;
                value = -value;
                break;
            }
            case PEACE: 
            case CEASE_FIRE: 
            case ALLIANCE: {
                if (ratio > 0.66) {
                    value = Integer.MIN_VALUE;
                    break;
                }
                if (ratio > 0.5) {
                    value = -value;
                    break;
                }
                if (!(ratio < 0.33)) break;
                value = 1000;
                break;
            }
            default: {
                value = Integer.MIN_VALUE;
            }
        }
        return value;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        StanceTradeItem o = this.copyInCast(other, StanceTradeItem.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.stance = o.getStance();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(STANCE_TAG, this.stance);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.stance = xr.getAttribute(STANCE_TAG, Stance.class, null);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof StanceTradeItem) {
            StanceTradeItem other = (StanceTradeItem)o;
            return this.stance == other.stance && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 37 * hash + Utils.hashCode(this.stance);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append('[').append(this.getId()).append(' ').append(this.stance).append(']');
        return sb.toString();
    }
}

