/*
Slurm Rest API RO

API to access Slurm. Only GET requests are implemented.

API version: 0.0.38
Contact: sales@schedmd.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package v0038

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the V0038JobProperties type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &V0038JobProperties{}

// V0038JobProperties struct for V0038JobProperties
type V0038JobProperties struct {
	// Charge resources used by this job to specified account.
	Account *string `json:"account,omitempty"`
	// Define the job accounting and profiling sampling intervals.
	AccountGatherFrequency *string `json:"account_gather_frequency,omitempty"`
	// Arguments to the script.
	Argv []string `json:"argv,omitempty"`
	// Submit a job array, multiple jobs to be executed with identical parameters. The indexes specification identifies what array index values should be used.
	Array *string `json:"array,omitempty"`
	// features required for batch script's node
	BatchFeatures *string `json:"batch_features,omitempty"`
	// Submit the batch script to the Slurm controller immediately, like normal, but tell the controller to defer the allocation of the job until the specified time.
	BeginTime *int64 `json:"begin_time,omitempty"`
	// Burst buffer specification.
	BurstBuffer *string `json:"burst_buffer,omitempty"`
	// Specifies features that a federated cluster must have to have a sibling job submitted to it.
	ClusterConstraint *string `json:"cluster_constraint,omitempty"`
	// An arbitrary comment.
	Comment *string `json:"comment,omitempty"`
	// node features required by job.
	Constraints *string `json:"constraints,omitempty"`
	// absolute path to OCI container bundle
	Container *string `json:"container,omitempty"`
	// Count of specialized threads per node reserved by the job for system operations and not used by the application.
	CoreSpecification *int32 `json:"core_specification,omitempty"`
	// Restrict node selection to nodes with at least the specified number of cores per socket.
	CoresPerSocket *int32 `json:"cores_per_socket,omitempty"`
	// Cpu binding
	CpuBinding *string `json:"cpu_binding,omitempty"`
	// Cpu binding hint
	CpuBindingHint *string `json:"cpu_binding_hint,omitempty"`
	// Request that job steps initiated by srun commands inside this sbatch script be run at some requested frequency if possible, on the CPUs selected for the step on the compute node(s).
	CpuFrequency *string `json:"cpu_frequency,omitempty"`
	// Number of CPUs requested per allocated GPU.
	CpusPerGpu *string `json:"cpus_per_gpu,omitempty"`
	// Advise the Slurm controller that ensuing job steps will require ncpus number of processors per task.
	CpusPerTask *int32 `json:"cpus_per_task,omitempty"`
	// Instruct Slurm to connect the batch script's standard output directly to the file name.
	CurrentWorkingDirectory *string `json:"current_working_directory,omitempty"`
	// Remove the job if no ending is possible before this deadline (start > (deadline - time[-min])).
	Deadline *string `json:"deadline,omitempty"`
	// Do not reboot nodes in order to satisfied this job's feature specification if the job has been eligible to run for less than this time period.
	DelayBoot *int32 `json:"delay_boot,omitempty"`
	// Defer the start of this job until the specified dependencies have been satisfied completed.
	Dependency *string `json:"dependency,omitempty"`
	// Specify alternate distribution methods for remote processes.
	Distribution *string `json:"distribution,omitempty"`
	// Dictionary of environment entries.
	Environment map[string]interface{} `json:"environment"`
	// The job allocation can share nodes just other users with the \"user\" option or with the \"mcs\" option).
	Exclusive *string `json:"exclusive,omitempty"`
	// Load new login environment for user on job node.
	GetUserEnvironment *bool `json:"get_user_environment,omitempty"`
	// Specifies a comma delimited list of generic consumable resources.
	Gres *string `json:"gres,omitempty"`
	// Specify generic resource task binding options.
	GresFlags *string `json:"gres_flags,omitempty"`
	// Requested binding of tasks to GPU.
	GpuBinding *string `json:"gpu_binding,omitempty"`
	// Requested GPU frequency.
	GpuFrequency *string `json:"gpu_frequency,omitempty"`
	// GPUs per job.
	Gpus *string `json:"gpus,omitempty"`
	// GPUs per node.
	GpusPerNode *string `json:"gpus_per_node,omitempty"`
	// GPUs per socket.
	GpusPerSocket *string `json:"gpus_per_socket,omitempty"`
	// GPUs per task.
	GpusPerTask *string `json:"gpus_per_task,omitempty"`
	// Specify the job is to be submitted in a held state (priority of zero).
	Hold *bool `json:"hold,omitempty"`
	// If a job has an invalid dependency, then Slurm is to terminate it.
	KillOnInvalidDependency *bool `json:"kill_on_invalid_dependency,omitempty"`
	// Specification of licenses (or other resources available on all nodes of the cluster) which must be allocated to this job.
	Licenses *string `json:"licenses,omitempty"`
	// Notify user by email when certain event types occur.
	MailType *string `json:"mail_type,omitempty"`
	// User to receive email notification of state changes as defined by mail_type.
	MailUser *string `json:"mail_user,omitempty"`
	// This parameter is a group among the groups of the user.
	McsLabel *string `json:"mcs_label,omitempty"`
	// Bind tasks to memory.
	MemoryBinding *string `json:"memory_binding,omitempty"`
	// Minimum real memory per cpu (MB).
	MemoryPerCpu *int32 `json:"memory_per_cpu,omitempty"`
	// Minimum memory required per allocated GPU.
	MemoryPerGpu *int32 `json:"memory_per_gpu,omitempty"`
	// Minimum real memory per node (MB).
	MemoryPerNode *int32 `json:"memory_per_node,omitempty"`
	// Minimum number of CPUs per node.
	MinimumCpusPerNode *int32 `json:"minimum_cpus_per_node,omitempty"`
	// If a range of node counts is given, prefer the smaller count.
	MinimumNodes *bool `json:"minimum_nodes,omitempty"`
	// Specify a name for the job allocation.
	Name *string `json:"name,omitempty"`
	// Run the job with an adjusted scheduling priority within Slurm.
	Nice *int32 `json:"nice,omitempty"`
	// Do not automatically terminate a job if one of the nodes it has been allocated fails.
	NoKill *bool `json:"no_kill,omitempty"`
	// Request that a minimum of minnodes nodes and a maximum node count.
	Nodes []int32 `json:"nodes,omitempty"`
	// Open the output and error files using append or truncate mode as specified.
	OpenMode *string `json:"open_mode,omitempty"`
	// The job allocation can over-subscribe resources with other running jobs.
	Oversubscribe *bool `json:"oversubscribe,omitempty"`
	// Request a specific partition for the resource allocation.
	Partition *string `json:"partition,omitempty"`
	// Comma delimited list of features for scheduler to prefer but not a strict requirement like a constraint. Value can be used for job submission but is only displayed for PENDING jobs.
	Prefer *string `json:"prefer,omitempty"`
	// Request a specific job priority.
	Priority *string `json:"priority,omitempty"`
	// Request a quality of service for the job.
	Qos *string `json:"qos,omitempty"`
	// Specifies that the batch job should eligible to being requeue.
	Requeue *bool `json:"requeue,omitempty"`
	// Allocate resources for the job from the named reservation.
	Reservation *string `json:"reservation,omitempty"`
	// When a job is within sig_time seconds of its end time, send it the signal sig_num.
	Signal *string `json:"signal,omitempty" validate:"regexp=(B:|)sig_num(@sig_time|)"`
	// Restrict node selection to nodes with at least the specified number of sockets.
	SocketsPerNode *int32 `json:"sockets_per_node,omitempty"`
	// Spread the job allocation over as many nodes as possible and attempt to evenly distribute tasks across the allocated nodes.
	SpreadJob *bool `json:"spread_job,omitempty"`
	// Instruct Slurm to connect the batch script's standard error directly to the file name.
	StandardError *string `json:"standard_error,omitempty"`
	// Instruct Slurm to connect the batch script's standard input directly to the file name specified.
	StandardInput *string `json:"standard_input,omitempty"`
	// Instruct Slurm to connect the batch script's standard output directly to the file name.
	StandardOutput *string `json:"standard_output,omitempty"`
	// Advises the Slurm controller that job steps run within the allocation will launch a maximum of number tasks and to provide for sufficient resources.
	Tasks *int32 `json:"tasks,omitempty"`
	// Request the maximum ntasks be invoked on each core.
	TasksPerCore *int32 `json:"tasks_per_core,omitempty"`
	// Request the maximum ntasks be invoked on each node.
	TasksPerNode *int32 `json:"tasks_per_node,omitempty"`
	// Request the maximum ntasks be invoked on each socket.
	TasksPerSocket *int32 `json:"tasks_per_socket,omitempty"`
	// Count of specialized threads per node reserved by the job for system operations and not used by the application.
	ThreadSpecification *int32 `json:"thread_specification,omitempty"`
	// Restrict node selection to nodes with at least the specified number of threads per core.
	ThreadsPerCore *int32 `json:"threads_per_core,omitempty"`
	// Step time limit in minutes.
	TimeLimit *int32 `json:"time_limit,omitempty"`
	// Minimum run time in minutes.
	TimeMinimum *int32 `json:"time_minimum,omitempty"`
	// Do not begin execution until all nodes are ready for use.
	WaitAllNodes *bool `json:"wait_all_nodes,omitempty"`
	// Specify wckey to be used with job.
	Wckey *string `json:"wckey,omitempty"`
}

type _V0038JobProperties V0038JobProperties

// NewV0038JobProperties instantiates a new V0038JobProperties object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewV0038JobProperties(environment map[string]interface{}) *V0038JobProperties {
	this := V0038JobProperties{}
	this.Environment = environment
	var openMode string = "append"
	this.OpenMode = &openMode
	var oversubscribe bool = false
	this.Oversubscribe = &oversubscribe
	return &this
}

// NewV0038JobPropertiesWithDefaults instantiates a new V0038JobProperties object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewV0038JobPropertiesWithDefaults() *V0038JobProperties {
	this := V0038JobProperties{}
	var openMode string = "append"
	this.OpenMode = &openMode
	var oversubscribe bool = false
	this.Oversubscribe = &oversubscribe
	return &this
}

// GetAccount returns the Account field value if set, zero value otherwise.
func (o *V0038JobProperties) GetAccount() string {
	if o == nil || IsNil(o.Account) {
		var ret string
		return ret
	}
	return *o.Account
}

// GetAccountOk returns a tuple with the Account field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetAccountOk() (*string, bool) {
	if o == nil || IsNil(o.Account) {
		return nil, false
	}
	return o.Account, true
}

// HasAccount returns a boolean if a field has been set.
func (o *V0038JobProperties) HasAccount() bool {
	if o != nil && !IsNil(o.Account) {
		return true
	}

	return false
}

// SetAccount gets a reference to the given string and assigns it to the Account field.
func (o *V0038JobProperties) SetAccount(v string) {
	o.Account = &v
}

// GetAccountGatherFrequency returns the AccountGatherFrequency field value if set, zero value otherwise.
func (o *V0038JobProperties) GetAccountGatherFrequency() string {
	if o == nil || IsNil(o.AccountGatherFrequency) {
		var ret string
		return ret
	}
	return *o.AccountGatherFrequency
}

// GetAccountGatherFrequencyOk returns a tuple with the AccountGatherFrequency field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetAccountGatherFrequencyOk() (*string, bool) {
	if o == nil || IsNil(o.AccountGatherFrequency) {
		return nil, false
	}
	return o.AccountGatherFrequency, true
}

// HasAccountGatherFrequency returns a boolean if a field has been set.
func (o *V0038JobProperties) HasAccountGatherFrequency() bool {
	if o != nil && !IsNil(o.AccountGatherFrequency) {
		return true
	}

	return false
}

// SetAccountGatherFrequency gets a reference to the given string and assigns it to the AccountGatherFrequency field.
func (o *V0038JobProperties) SetAccountGatherFrequency(v string) {
	o.AccountGatherFrequency = &v
}

// GetArgv returns the Argv field value if set, zero value otherwise.
func (o *V0038JobProperties) GetArgv() []string {
	if o == nil || IsNil(o.Argv) {
		var ret []string
		return ret
	}
	return o.Argv
}

// GetArgvOk returns a tuple with the Argv field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetArgvOk() ([]string, bool) {
	if o == nil || IsNil(o.Argv) {
		return nil, false
	}
	return o.Argv, true
}

// HasArgv returns a boolean if a field has been set.
func (o *V0038JobProperties) HasArgv() bool {
	if o != nil && !IsNil(o.Argv) {
		return true
	}

	return false
}

// SetArgv gets a reference to the given []string and assigns it to the Argv field.
func (o *V0038JobProperties) SetArgv(v []string) {
	o.Argv = v
}

// GetArray returns the Array field value if set, zero value otherwise.
func (o *V0038JobProperties) GetArray() string {
	if o == nil || IsNil(o.Array) {
		var ret string
		return ret
	}
	return *o.Array
}

// GetArrayOk returns a tuple with the Array field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetArrayOk() (*string, bool) {
	if o == nil || IsNil(o.Array) {
		return nil, false
	}
	return o.Array, true
}

// HasArray returns a boolean if a field has been set.
func (o *V0038JobProperties) HasArray() bool {
	if o != nil && !IsNil(o.Array) {
		return true
	}

	return false
}

// SetArray gets a reference to the given string and assigns it to the Array field.
func (o *V0038JobProperties) SetArray(v string) {
	o.Array = &v
}

// GetBatchFeatures returns the BatchFeatures field value if set, zero value otherwise.
func (o *V0038JobProperties) GetBatchFeatures() string {
	if o == nil || IsNil(o.BatchFeatures) {
		var ret string
		return ret
	}
	return *o.BatchFeatures
}

// GetBatchFeaturesOk returns a tuple with the BatchFeatures field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetBatchFeaturesOk() (*string, bool) {
	if o == nil || IsNil(o.BatchFeatures) {
		return nil, false
	}
	return o.BatchFeatures, true
}

// HasBatchFeatures returns a boolean if a field has been set.
func (o *V0038JobProperties) HasBatchFeatures() bool {
	if o != nil && !IsNil(o.BatchFeatures) {
		return true
	}

	return false
}

// SetBatchFeatures gets a reference to the given string and assigns it to the BatchFeatures field.
func (o *V0038JobProperties) SetBatchFeatures(v string) {
	o.BatchFeatures = &v
}

// GetBeginTime returns the BeginTime field value if set, zero value otherwise.
func (o *V0038JobProperties) GetBeginTime() int64 {
	if o == nil || IsNil(o.BeginTime) {
		var ret int64
		return ret
	}
	return *o.BeginTime
}

// GetBeginTimeOk returns a tuple with the BeginTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetBeginTimeOk() (*int64, bool) {
	if o == nil || IsNil(o.BeginTime) {
		return nil, false
	}
	return o.BeginTime, true
}

// HasBeginTime returns a boolean if a field has been set.
func (o *V0038JobProperties) HasBeginTime() bool {
	if o != nil && !IsNil(o.BeginTime) {
		return true
	}

	return false
}

// SetBeginTime gets a reference to the given int64 and assigns it to the BeginTime field.
func (o *V0038JobProperties) SetBeginTime(v int64) {
	o.BeginTime = &v
}

// GetBurstBuffer returns the BurstBuffer field value if set, zero value otherwise.
func (o *V0038JobProperties) GetBurstBuffer() string {
	if o == nil || IsNil(o.BurstBuffer) {
		var ret string
		return ret
	}
	return *o.BurstBuffer
}

// GetBurstBufferOk returns a tuple with the BurstBuffer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetBurstBufferOk() (*string, bool) {
	if o == nil || IsNil(o.BurstBuffer) {
		return nil, false
	}
	return o.BurstBuffer, true
}

// HasBurstBuffer returns a boolean if a field has been set.
func (o *V0038JobProperties) HasBurstBuffer() bool {
	if o != nil && !IsNil(o.BurstBuffer) {
		return true
	}

	return false
}

// SetBurstBuffer gets a reference to the given string and assigns it to the BurstBuffer field.
func (o *V0038JobProperties) SetBurstBuffer(v string) {
	o.BurstBuffer = &v
}

// GetClusterConstraint returns the ClusterConstraint field value if set, zero value otherwise.
func (o *V0038JobProperties) GetClusterConstraint() string {
	if o == nil || IsNil(o.ClusterConstraint) {
		var ret string
		return ret
	}
	return *o.ClusterConstraint
}

// GetClusterConstraintOk returns a tuple with the ClusterConstraint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetClusterConstraintOk() (*string, bool) {
	if o == nil || IsNil(o.ClusterConstraint) {
		return nil, false
	}
	return o.ClusterConstraint, true
}

// HasClusterConstraint returns a boolean if a field has been set.
func (o *V0038JobProperties) HasClusterConstraint() bool {
	if o != nil && !IsNil(o.ClusterConstraint) {
		return true
	}

	return false
}

// SetClusterConstraint gets a reference to the given string and assigns it to the ClusterConstraint field.
func (o *V0038JobProperties) SetClusterConstraint(v string) {
	o.ClusterConstraint = &v
}

// GetComment returns the Comment field value if set, zero value otherwise.
func (o *V0038JobProperties) GetComment() string {
	if o == nil || IsNil(o.Comment) {
		var ret string
		return ret
	}
	return *o.Comment
}

// GetCommentOk returns a tuple with the Comment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetCommentOk() (*string, bool) {
	if o == nil || IsNil(o.Comment) {
		return nil, false
	}
	return o.Comment, true
}

// HasComment returns a boolean if a field has been set.
func (o *V0038JobProperties) HasComment() bool {
	if o != nil && !IsNil(o.Comment) {
		return true
	}

	return false
}

// SetComment gets a reference to the given string and assigns it to the Comment field.
func (o *V0038JobProperties) SetComment(v string) {
	o.Comment = &v
}

// GetConstraints returns the Constraints field value if set, zero value otherwise.
func (o *V0038JobProperties) GetConstraints() string {
	if o == nil || IsNil(o.Constraints) {
		var ret string
		return ret
	}
	return *o.Constraints
}

// GetConstraintsOk returns a tuple with the Constraints field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetConstraintsOk() (*string, bool) {
	if o == nil || IsNil(o.Constraints) {
		return nil, false
	}
	return o.Constraints, true
}

// HasConstraints returns a boolean if a field has been set.
func (o *V0038JobProperties) HasConstraints() bool {
	if o != nil && !IsNil(o.Constraints) {
		return true
	}

	return false
}

// SetConstraints gets a reference to the given string and assigns it to the Constraints field.
func (o *V0038JobProperties) SetConstraints(v string) {
	o.Constraints = &v
}

// GetContainer returns the Container field value if set, zero value otherwise.
func (o *V0038JobProperties) GetContainer() string {
	if o == nil || IsNil(o.Container) {
		var ret string
		return ret
	}
	return *o.Container
}

// GetContainerOk returns a tuple with the Container field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetContainerOk() (*string, bool) {
	if o == nil || IsNil(o.Container) {
		return nil, false
	}
	return o.Container, true
}

// HasContainer returns a boolean if a field has been set.
func (o *V0038JobProperties) HasContainer() bool {
	if o != nil && !IsNil(o.Container) {
		return true
	}

	return false
}

// SetContainer gets a reference to the given string and assigns it to the Container field.
func (o *V0038JobProperties) SetContainer(v string) {
	o.Container = &v
}

// GetCoreSpecification returns the CoreSpecification field value if set, zero value otherwise.
func (o *V0038JobProperties) GetCoreSpecification() int32 {
	if o == nil || IsNil(o.CoreSpecification) {
		var ret int32
		return ret
	}
	return *o.CoreSpecification
}

// GetCoreSpecificationOk returns a tuple with the CoreSpecification field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetCoreSpecificationOk() (*int32, bool) {
	if o == nil || IsNil(o.CoreSpecification) {
		return nil, false
	}
	return o.CoreSpecification, true
}

// HasCoreSpecification returns a boolean if a field has been set.
func (o *V0038JobProperties) HasCoreSpecification() bool {
	if o != nil && !IsNil(o.CoreSpecification) {
		return true
	}

	return false
}

// SetCoreSpecification gets a reference to the given int32 and assigns it to the CoreSpecification field.
func (o *V0038JobProperties) SetCoreSpecification(v int32) {
	o.CoreSpecification = &v
}

// GetCoresPerSocket returns the CoresPerSocket field value if set, zero value otherwise.
func (o *V0038JobProperties) GetCoresPerSocket() int32 {
	if o == nil || IsNil(o.CoresPerSocket) {
		var ret int32
		return ret
	}
	return *o.CoresPerSocket
}

// GetCoresPerSocketOk returns a tuple with the CoresPerSocket field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetCoresPerSocketOk() (*int32, bool) {
	if o == nil || IsNil(o.CoresPerSocket) {
		return nil, false
	}
	return o.CoresPerSocket, true
}

// HasCoresPerSocket returns a boolean if a field has been set.
func (o *V0038JobProperties) HasCoresPerSocket() bool {
	if o != nil && !IsNil(o.CoresPerSocket) {
		return true
	}

	return false
}

// SetCoresPerSocket gets a reference to the given int32 and assigns it to the CoresPerSocket field.
func (o *V0038JobProperties) SetCoresPerSocket(v int32) {
	o.CoresPerSocket = &v
}

// GetCpuBinding returns the CpuBinding field value if set, zero value otherwise.
func (o *V0038JobProperties) GetCpuBinding() string {
	if o == nil || IsNil(o.CpuBinding) {
		var ret string
		return ret
	}
	return *o.CpuBinding
}

// GetCpuBindingOk returns a tuple with the CpuBinding field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetCpuBindingOk() (*string, bool) {
	if o == nil || IsNil(o.CpuBinding) {
		return nil, false
	}
	return o.CpuBinding, true
}

// HasCpuBinding returns a boolean if a field has been set.
func (o *V0038JobProperties) HasCpuBinding() bool {
	if o != nil && !IsNil(o.CpuBinding) {
		return true
	}

	return false
}

// SetCpuBinding gets a reference to the given string and assigns it to the CpuBinding field.
func (o *V0038JobProperties) SetCpuBinding(v string) {
	o.CpuBinding = &v
}

// GetCpuBindingHint returns the CpuBindingHint field value if set, zero value otherwise.
func (o *V0038JobProperties) GetCpuBindingHint() string {
	if o == nil || IsNil(o.CpuBindingHint) {
		var ret string
		return ret
	}
	return *o.CpuBindingHint
}

// GetCpuBindingHintOk returns a tuple with the CpuBindingHint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetCpuBindingHintOk() (*string, bool) {
	if o == nil || IsNil(o.CpuBindingHint) {
		return nil, false
	}
	return o.CpuBindingHint, true
}

// HasCpuBindingHint returns a boolean if a field has been set.
func (o *V0038JobProperties) HasCpuBindingHint() bool {
	if o != nil && !IsNil(o.CpuBindingHint) {
		return true
	}

	return false
}

// SetCpuBindingHint gets a reference to the given string and assigns it to the CpuBindingHint field.
func (o *V0038JobProperties) SetCpuBindingHint(v string) {
	o.CpuBindingHint = &v
}

// GetCpuFrequency returns the CpuFrequency field value if set, zero value otherwise.
func (o *V0038JobProperties) GetCpuFrequency() string {
	if o == nil || IsNil(o.CpuFrequency) {
		var ret string
		return ret
	}
	return *o.CpuFrequency
}

// GetCpuFrequencyOk returns a tuple with the CpuFrequency field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetCpuFrequencyOk() (*string, bool) {
	if o == nil || IsNil(o.CpuFrequency) {
		return nil, false
	}
	return o.CpuFrequency, true
}

// HasCpuFrequency returns a boolean if a field has been set.
func (o *V0038JobProperties) HasCpuFrequency() bool {
	if o != nil && !IsNil(o.CpuFrequency) {
		return true
	}

	return false
}

// SetCpuFrequency gets a reference to the given string and assigns it to the CpuFrequency field.
func (o *V0038JobProperties) SetCpuFrequency(v string) {
	o.CpuFrequency = &v
}

// GetCpusPerGpu returns the CpusPerGpu field value if set, zero value otherwise.
func (o *V0038JobProperties) GetCpusPerGpu() string {
	if o == nil || IsNil(o.CpusPerGpu) {
		var ret string
		return ret
	}
	return *o.CpusPerGpu
}

// GetCpusPerGpuOk returns a tuple with the CpusPerGpu field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetCpusPerGpuOk() (*string, bool) {
	if o == nil || IsNil(o.CpusPerGpu) {
		return nil, false
	}
	return o.CpusPerGpu, true
}

// HasCpusPerGpu returns a boolean if a field has been set.
func (o *V0038JobProperties) HasCpusPerGpu() bool {
	if o != nil && !IsNil(o.CpusPerGpu) {
		return true
	}

	return false
}

// SetCpusPerGpu gets a reference to the given string and assigns it to the CpusPerGpu field.
func (o *V0038JobProperties) SetCpusPerGpu(v string) {
	o.CpusPerGpu = &v
}

// GetCpusPerTask returns the CpusPerTask field value if set, zero value otherwise.
func (o *V0038JobProperties) GetCpusPerTask() int32 {
	if o == nil || IsNil(o.CpusPerTask) {
		var ret int32
		return ret
	}
	return *o.CpusPerTask
}

// GetCpusPerTaskOk returns a tuple with the CpusPerTask field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetCpusPerTaskOk() (*int32, bool) {
	if o == nil || IsNil(o.CpusPerTask) {
		return nil, false
	}
	return o.CpusPerTask, true
}

// HasCpusPerTask returns a boolean if a field has been set.
func (o *V0038JobProperties) HasCpusPerTask() bool {
	if o != nil && !IsNil(o.CpusPerTask) {
		return true
	}

	return false
}

// SetCpusPerTask gets a reference to the given int32 and assigns it to the CpusPerTask field.
func (o *V0038JobProperties) SetCpusPerTask(v int32) {
	o.CpusPerTask = &v
}

// GetCurrentWorkingDirectory returns the CurrentWorkingDirectory field value if set, zero value otherwise.
func (o *V0038JobProperties) GetCurrentWorkingDirectory() string {
	if o == nil || IsNil(o.CurrentWorkingDirectory) {
		var ret string
		return ret
	}
	return *o.CurrentWorkingDirectory
}

// GetCurrentWorkingDirectoryOk returns a tuple with the CurrentWorkingDirectory field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetCurrentWorkingDirectoryOk() (*string, bool) {
	if o == nil || IsNil(o.CurrentWorkingDirectory) {
		return nil, false
	}
	return o.CurrentWorkingDirectory, true
}

// HasCurrentWorkingDirectory returns a boolean if a field has been set.
func (o *V0038JobProperties) HasCurrentWorkingDirectory() bool {
	if o != nil && !IsNil(o.CurrentWorkingDirectory) {
		return true
	}

	return false
}

// SetCurrentWorkingDirectory gets a reference to the given string and assigns it to the CurrentWorkingDirectory field.
func (o *V0038JobProperties) SetCurrentWorkingDirectory(v string) {
	o.CurrentWorkingDirectory = &v
}

// GetDeadline returns the Deadline field value if set, zero value otherwise.
func (o *V0038JobProperties) GetDeadline() string {
	if o == nil || IsNil(o.Deadline) {
		var ret string
		return ret
	}
	return *o.Deadline
}

// GetDeadlineOk returns a tuple with the Deadline field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetDeadlineOk() (*string, bool) {
	if o == nil || IsNil(o.Deadline) {
		return nil, false
	}
	return o.Deadline, true
}

// HasDeadline returns a boolean if a field has been set.
func (o *V0038JobProperties) HasDeadline() bool {
	if o != nil && !IsNil(o.Deadline) {
		return true
	}

	return false
}

// SetDeadline gets a reference to the given string and assigns it to the Deadline field.
func (o *V0038JobProperties) SetDeadline(v string) {
	o.Deadline = &v
}

// GetDelayBoot returns the DelayBoot field value if set, zero value otherwise.
func (o *V0038JobProperties) GetDelayBoot() int32 {
	if o == nil || IsNil(o.DelayBoot) {
		var ret int32
		return ret
	}
	return *o.DelayBoot
}

// GetDelayBootOk returns a tuple with the DelayBoot field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetDelayBootOk() (*int32, bool) {
	if o == nil || IsNil(o.DelayBoot) {
		return nil, false
	}
	return o.DelayBoot, true
}

// HasDelayBoot returns a boolean if a field has been set.
func (o *V0038JobProperties) HasDelayBoot() bool {
	if o != nil && !IsNil(o.DelayBoot) {
		return true
	}

	return false
}

// SetDelayBoot gets a reference to the given int32 and assigns it to the DelayBoot field.
func (o *V0038JobProperties) SetDelayBoot(v int32) {
	o.DelayBoot = &v
}

// GetDependency returns the Dependency field value if set, zero value otherwise.
func (o *V0038JobProperties) GetDependency() string {
	if o == nil || IsNil(o.Dependency) {
		var ret string
		return ret
	}
	return *o.Dependency
}

// GetDependencyOk returns a tuple with the Dependency field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetDependencyOk() (*string, bool) {
	if o == nil || IsNil(o.Dependency) {
		return nil, false
	}
	return o.Dependency, true
}

// HasDependency returns a boolean if a field has been set.
func (o *V0038JobProperties) HasDependency() bool {
	if o != nil && !IsNil(o.Dependency) {
		return true
	}

	return false
}

// SetDependency gets a reference to the given string and assigns it to the Dependency field.
func (o *V0038JobProperties) SetDependency(v string) {
	o.Dependency = &v
}

// GetDistribution returns the Distribution field value if set, zero value otherwise.
func (o *V0038JobProperties) GetDistribution() string {
	if o == nil || IsNil(o.Distribution) {
		var ret string
		return ret
	}
	return *o.Distribution
}

// GetDistributionOk returns a tuple with the Distribution field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetDistributionOk() (*string, bool) {
	if o == nil || IsNil(o.Distribution) {
		return nil, false
	}
	return o.Distribution, true
}

// HasDistribution returns a boolean if a field has been set.
func (o *V0038JobProperties) HasDistribution() bool {
	if o != nil && !IsNil(o.Distribution) {
		return true
	}

	return false
}

// SetDistribution gets a reference to the given string and assigns it to the Distribution field.
func (o *V0038JobProperties) SetDistribution(v string) {
	o.Distribution = &v
}

// GetEnvironment returns the Environment field value
func (o *V0038JobProperties) GetEnvironment() map[string]interface{} {
	if o == nil {
		var ret map[string]interface{}
		return ret
	}

	return o.Environment
}

// GetEnvironmentOk returns a tuple with the Environment field value
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetEnvironmentOk() (map[string]interface{}, bool) {
	if o == nil {
		return map[string]interface{}{}, false
	}
	return o.Environment, true
}

// SetEnvironment sets field value
func (o *V0038JobProperties) SetEnvironment(v map[string]interface{}) {
	o.Environment = v
}

// GetExclusive returns the Exclusive field value if set, zero value otherwise.
func (o *V0038JobProperties) GetExclusive() string {
	if o == nil || IsNil(o.Exclusive) {
		var ret string
		return ret
	}
	return *o.Exclusive
}

// GetExclusiveOk returns a tuple with the Exclusive field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetExclusiveOk() (*string, bool) {
	if o == nil || IsNil(o.Exclusive) {
		return nil, false
	}
	return o.Exclusive, true
}

// HasExclusive returns a boolean if a field has been set.
func (o *V0038JobProperties) HasExclusive() bool {
	if o != nil && !IsNil(o.Exclusive) {
		return true
	}

	return false
}

// SetExclusive gets a reference to the given string and assigns it to the Exclusive field.
func (o *V0038JobProperties) SetExclusive(v string) {
	o.Exclusive = &v
}

// GetGetUserEnvironment returns the GetUserEnvironment field value if set, zero value otherwise.
func (o *V0038JobProperties) GetGetUserEnvironment() bool {
	if o == nil || IsNil(o.GetUserEnvironment) {
		var ret bool
		return ret
	}
	return *o.GetUserEnvironment
}

// GetGetUserEnvironmentOk returns a tuple with the GetUserEnvironment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetGetUserEnvironmentOk() (*bool, bool) {
	if o == nil || IsNil(o.GetUserEnvironment) {
		return nil, false
	}
	return o.GetUserEnvironment, true
}

// HasGetUserEnvironment returns a boolean if a field has been set.
func (o *V0038JobProperties) HasGetUserEnvironment() bool {
	if o != nil && !IsNil(o.GetUserEnvironment) {
		return true
	}

	return false
}

// SetGetUserEnvironment gets a reference to the given bool and assigns it to the GetUserEnvironment field.
func (o *V0038JobProperties) SetGetUserEnvironment(v bool) {
	o.GetUserEnvironment = &v
}

// GetGres returns the Gres field value if set, zero value otherwise.
func (o *V0038JobProperties) GetGres() string {
	if o == nil || IsNil(o.Gres) {
		var ret string
		return ret
	}
	return *o.Gres
}

// GetGresOk returns a tuple with the Gres field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetGresOk() (*string, bool) {
	if o == nil || IsNil(o.Gres) {
		return nil, false
	}
	return o.Gres, true
}

// HasGres returns a boolean if a field has been set.
func (o *V0038JobProperties) HasGres() bool {
	if o != nil && !IsNil(o.Gres) {
		return true
	}

	return false
}

// SetGres gets a reference to the given string and assigns it to the Gres field.
func (o *V0038JobProperties) SetGres(v string) {
	o.Gres = &v
}

// GetGresFlags returns the GresFlags field value if set, zero value otherwise.
func (o *V0038JobProperties) GetGresFlags() string {
	if o == nil || IsNil(o.GresFlags) {
		var ret string
		return ret
	}
	return *o.GresFlags
}

// GetGresFlagsOk returns a tuple with the GresFlags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetGresFlagsOk() (*string, bool) {
	if o == nil || IsNil(o.GresFlags) {
		return nil, false
	}
	return o.GresFlags, true
}

// HasGresFlags returns a boolean if a field has been set.
func (o *V0038JobProperties) HasGresFlags() bool {
	if o != nil && !IsNil(o.GresFlags) {
		return true
	}

	return false
}

// SetGresFlags gets a reference to the given string and assigns it to the GresFlags field.
func (o *V0038JobProperties) SetGresFlags(v string) {
	o.GresFlags = &v
}

// GetGpuBinding returns the GpuBinding field value if set, zero value otherwise.
func (o *V0038JobProperties) GetGpuBinding() string {
	if o == nil || IsNil(o.GpuBinding) {
		var ret string
		return ret
	}
	return *o.GpuBinding
}

// GetGpuBindingOk returns a tuple with the GpuBinding field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetGpuBindingOk() (*string, bool) {
	if o == nil || IsNil(o.GpuBinding) {
		return nil, false
	}
	return o.GpuBinding, true
}

// HasGpuBinding returns a boolean if a field has been set.
func (o *V0038JobProperties) HasGpuBinding() bool {
	if o != nil && !IsNil(o.GpuBinding) {
		return true
	}

	return false
}

// SetGpuBinding gets a reference to the given string and assigns it to the GpuBinding field.
func (o *V0038JobProperties) SetGpuBinding(v string) {
	o.GpuBinding = &v
}

// GetGpuFrequency returns the GpuFrequency field value if set, zero value otherwise.
func (o *V0038JobProperties) GetGpuFrequency() string {
	if o == nil || IsNil(o.GpuFrequency) {
		var ret string
		return ret
	}
	return *o.GpuFrequency
}

// GetGpuFrequencyOk returns a tuple with the GpuFrequency field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetGpuFrequencyOk() (*string, bool) {
	if o == nil || IsNil(o.GpuFrequency) {
		return nil, false
	}
	return o.GpuFrequency, true
}

// HasGpuFrequency returns a boolean if a field has been set.
func (o *V0038JobProperties) HasGpuFrequency() bool {
	if o != nil && !IsNil(o.GpuFrequency) {
		return true
	}

	return false
}

// SetGpuFrequency gets a reference to the given string and assigns it to the GpuFrequency field.
func (o *V0038JobProperties) SetGpuFrequency(v string) {
	o.GpuFrequency = &v
}

// GetGpus returns the Gpus field value if set, zero value otherwise.
func (o *V0038JobProperties) GetGpus() string {
	if o == nil || IsNil(o.Gpus) {
		var ret string
		return ret
	}
	return *o.Gpus
}

// GetGpusOk returns a tuple with the Gpus field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetGpusOk() (*string, bool) {
	if o == nil || IsNil(o.Gpus) {
		return nil, false
	}
	return o.Gpus, true
}

// HasGpus returns a boolean if a field has been set.
func (o *V0038JobProperties) HasGpus() bool {
	if o != nil && !IsNil(o.Gpus) {
		return true
	}

	return false
}

// SetGpus gets a reference to the given string and assigns it to the Gpus field.
func (o *V0038JobProperties) SetGpus(v string) {
	o.Gpus = &v
}

// GetGpusPerNode returns the GpusPerNode field value if set, zero value otherwise.
func (o *V0038JobProperties) GetGpusPerNode() string {
	if o == nil || IsNil(o.GpusPerNode) {
		var ret string
		return ret
	}
	return *o.GpusPerNode
}

// GetGpusPerNodeOk returns a tuple with the GpusPerNode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetGpusPerNodeOk() (*string, bool) {
	if o == nil || IsNil(o.GpusPerNode) {
		return nil, false
	}
	return o.GpusPerNode, true
}

// HasGpusPerNode returns a boolean if a field has been set.
func (o *V0038JobProperties) HasGpusPerNode() bool {
	if o != nil && !IsNil(o.GpusPerNode) {
		return true
	}

	return false
}

// SetGpusPerNode gets a reference to the given string and assigns it to the GpusPerNode field.
func (o *V0038JobProperties) SetGpusPerNode(v string) {
	o.GpusPerNode = &v
}

// GetGpusPerSocket returns the GpusPerSocket field value if set, zero value otherwise.
func (o *V0038JobProperties) GetGpusPerSocket() string {
	if o == nil || IsNil(o.GpusPerSocket) {
		var ret string
		return ret
	}
	return *o.GpusPerSocket
}

// GetGpusPerSocketOk returns a tuple with the GpusPerSocket field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetGpusPerSocketOk() (*string, bool) {
	if o == nil || IsNil(o.GpusPerSocket) {
		return nil, false
	}
	return o.GpusPerSocket, true
}

// HasGpusPerSocket returns a boolean if a field has been set.
func (o *V0038JobProperties) HasGpusPerSocket() bool {
	if o != nil && !IsNil(o.GpusPerSocket) {
		return true
	}

	return false
}

// SetGpusPerSocket gets a reference to the given string and assigns it to the GpusPerSocket field.
func (o *V0038JobProperties) SetGpusPerSocket(v string) {
	o.GpusPerSocket = &v
}

// GetGpusPerTask returns the GpusPerTask field value if set, zero value otherwise.
func (o *V0038JobProperties) GetGpusPerTask() string {
	if o == nil || IsNil(o.GpusPerTask) {
		var ret string
		return ret
	}
	return *o.GpusPerTask
}

// GetGpusPerTaskOk returns a tuple with the GpusPerTask field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetGpusPerTaskOk() (*string, bool) {
	if o == nil || IsNil(o.GpusPerTask) {
		return nil, false
	}
	return o.GpusPerTask, true
}

// HasGpusPerTask returns a boolean if a field has been set.
func (o *V0038JobProperties) HasGpusPerTask() bool {
	if o != nil && !IsNil(o.GpusPerTask) {
		return true
	}

	return false
}

// SetGpusPerTask gets a reference to the given string and assigns it to the GpusPerTask field.
func (o *V0038JobProperties) SetGpusPerTask(v string) {
	o.GpusPerTask = &v
}

// GetHold returns the Hold field value if set, zero value otherwise.
func (o *V0038JobProperties) GetHold() bool {
	if o == nil || IsNil(o.Hold) {
		var ret bool
		return ret
	}
	return *o.Hold
}

// GetHoldOk returns a tuple with the Hold field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetHoldOk() (*bool, bool) {
	if o == nil || IsNil(o.Hold) {
		return nil, false
	}
	return o.Hold, true
}

// HasHold returns a boolean if a field has been set.
func (o *V0038JobProperties) HasHold() bool {
	if o != nil && !IsNil(o.Hold) {
		return true
	}

	return false
}

// SetHold gets a reference to the given bool and assigns it to the Hold field.
func (o *V0038JobProperties) SetHold(v bool) {
	o.Hold = &v
}

// GetKillOnInvalidDependency returns the KillOnInvalidDependency field value if set, zero value otherwise.
func (o *V0038JobProperties) GetKillOnInvalidDependency() bool {
	if o == nil || IsNil(o.KillOnInvalidDependency) {
		var ret bool
		return ret
	}
	return *o.KillOnInvalidDependency
}

// GetKillOnInvalidDependencyOk returns a tuple with the KillOnInvalidDependency field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetKillOnInvalidDependencyOk() (*bool, bool) {
	if o == nil || IsNil(o.KillOnInvalidDependency) {
		return nil, false
	}
	return o.KillOnInvalidDependency, true
}

// HasKillOnInvalidDependency returns a boolean if a field has been set.
func (o *V0038JobProperties) HasKillOnInvalidDependency() bool {
	if o != nil && !IsNil(o.KillOnInvalidDependency) {
		return true
	}

	return false
}

// SetKillOnInvalidDependency gets a reference to the given bool and assigns it to the KillOnInvalidDependency field.
func (o *V0038JobProperties) SetKillOnInvalidDependency(v bool) {
	o.KillOnInvalidDependency = &v
}

// GetLicenses returns the Licenses field value if set, zero value otherwise.
func (o *V0038JobProperties) GetLicenses() string {
	if o == nil || IsNil(o.Licenses) {
		var ret string
		return ret
	}
	return *o.Licenses
}

// GetLicensesOk returns a tuple with the Licenses field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetLicensesOk() (*string, bool) {
	if o == nil || IsNil(o.Licenses) {
		return nil, false
	}
	return o.Licenses, true
}

// HasLicenses returns a boolean if a field has been set.
func (o *V0038JobProperties) HasLicenses() bool {
	if o != nil && !IsNil(o.Licenses) {
		return true
	}

	return false
}

// SetLicenses gets a reference to the given string and assigns it to the Licenses field.
func (o *V0038JobProperties) SetLicenses(v string) {
	o.Licenses = &v
}

// GetMailType returns the MailType field value if set, zero value otherwise.
func (o *V0038JobProperties) GetMailType() string {
	if o == nil || IsNil(o.MailType) {
		var ret string
		return ret
	}
	return *o.MailType
}

// GetMailTypeOk returns a tuple with the MailType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetMailTypeOk() (*string, bool) {
	if o == nil || IsNil(o.MailType) {
		return nil, false
	}
	return o.MailType, true
}

// HasMailType returns a boolean if a field has been set.
func (o *V0038JobProperties) HasMailType() bool {
	if o != nil && !IsNil(o.MailType) {
		return true
	}

	return false
}

// SetMailType gets a reference to the given string and assigns it to the MailType field.
func (o *V0038JobProperties) SetMailType(v string) {
	o.MailType = &v
}

// GetMailUser returns the MailUser field value if set, zero value otherwise.
func (o *V0038JobProperties) GetMailUser() string {
	if o == nil || IsNil(o.MailUser) {
		var ret string
		return ret
	}
	return *o.MailUser
}

// GetMailUserOk returns a tuple with the MailUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetMailUserOk() (*string, bool) {
	if o == nil || IsNil(o.MailUser) {
		return nil, false
	}
	return o.MailUser, true
}

// HasMailUser returns a boolean if a field has been set.
func (o *V0038JobProperties) HasMailUser() bool {
	if o != nil && !IsNil(o.MailUser) {
		return true
	}

	return false
}

// SetMailUser gets a reference to the given string and assigns it to the MailUser field.
func (o *V0038JobProperties) SetMailUser(v string) {
	o.MailUser = &v
}

// GetMcsLabel returns the McsLabel field value if set, zero value otherwise.
func (o *V0038JobProperties) GetMcsLabel() string {
	if o == nil || IsNil(o.McsLabel) {
		var ret string
		return ret
	}
	return *o.McsLabel
}

// GetMcsLabelOk returns a tuple with the McsLabel field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetMcsLabelOk() (*string, bool) {
	if o == nil || IsNil(o.McsLabel) {
		return nil, false
	}
	return o.McsLabel, true
}

// HasMcsLabel returns a boolean if a field has been set.
func (o *V0038JobProperties) HasMcsLabel() bool {
	if o != nil && !IsNil(o.McsLabel) {
		return true
	}

	return false
}

// SetMcsLabel gets a reference to the given string and assigns it to the McsLabel field.
func (o *V0038JobProperties) SetMcsLabel(v string) {
	o.McsLabel = &v
}

// GetMemoryBinding returns the MemoryBinding field value if set, zero value otherwise.
func (o *V0038JobProperties) GetMemoryBinding() string {
	if o == nil || IsNil(o.MemoryBinding) {
		var ret string
		return ret
	}
	return *o.MemoryBinding
}

// GetMemoryBindingOk returns a tuple with the MemoryBinding field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetMemoryBindingOk() (*string, bool) {
	if o == nil || IsNil(o.MemoryBinding) {
		return nil, false
	}
	return o.MemoryBinding, true
}

// HasMemoryBinding returns a boolean if a field has been set.
func (o *V0038JobProperties) HasMemoryBinding() bool {
	if o != nil && !IsNil(o.MemoryBinding) {
		return true
	}

	return false
}

// SetMemoryBinding gets a reference to the given string and assigns it to the MemoryBinding field.
func (o *V0038JobProperties) SetMemoryBinding(v string) {
	o.MemoryBinding = &v
}

// GetMemoryPerCpu returns the MemoryPerCpu field value if set, zero value otherwise.
func (o *V0038JobProperties) GetMemoryPerCpu() int32 {
	if o == nil || IsNil(o.MemoryPerCpu) {
		var ret int32
		return ret
	}
	return *o.MemoryPerCpu
}

// GetMemoryPerCpuOk returns a tuple with the MemoryPerCpu field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetMemoryPerCpuOk() (*int32, bool) {
	if o == nil || IsNil(o.MemoryPerCpu) {
		return nil, false
	}
	return o.MemoryPerCpu, true
}

// HasMemoryPerCpu returns a boolean if a field has been set.
func (o *V0038JobProperties) HasMemoryPerCpu() bool {
	if o != nil && !IsNil(o.MemoryPerCpu) {
		return true
	}

	return false
}

// SetMemoryPerCpu gets a reference to the given int32 and assigns it to the MemoryPerCpu field.
func (o *V0038JobProperties) SetMemoryPerCpu(v int32) {
	o.MemoryPerCpu = &v
}

// GetMemoryPerGpu returns the MemoryPerGpu field value if set, zero value otherwise.
func (o *V0038JobProperties) GetMemoryPerGpu() int32 {
	if o == nil || IsNil(o.MemoryPerGpu) {
		var ret int32
		return ret
	}
	return *o.MemoryPerGpu
}

// GetMemoryPerGpuOk returns a tuple with the MemoryPerGpu field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetMemoryPerGpuOk() (*int32, bool) {
	if o == nil || IsNil(o.MemoryPerGpu) {
		return nil, false
	}
	return o.MemoryPerGpu, true
}

// HasMemoryPerGpu returns a boolean if a field has been set.
func (o *V0038JobProperties) HasMemoryPerGpu() bool {
	if o != nil && !IsNil(o.MemoryPerGpu) {
		return true
	}

	return false
}

// SetMemoryPerGpu gets a reference to the given int32 and assigns it to the MemoryPerGpu field.
func (o *V0038JobProperties) SetMemoryPerGpu(v int32) {
	o.MemoryPerGpu = &v
}

// GetMemoryPerNode returns the MemoryPerNode field value if set, zero value otherwise.
func (o *V0038JobProperties) GetMemoryPerNode() int32 {
	if o == nil || IsNil(o.MemoryPerNode) {
		var ret int32
		return ret
	}
	return *o.MemoryPerNode
}

// GetMemoryPerNodeOk returns a tuple with the MemoryPerNode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetMemoryPerNodeOk() (*int32, bool) {
	if o == nil || IsNil(o.MemoryPerNode) {
		return nil, false
	}
	return o.MemoryPerNode, true
}

// HasMemoryPerNode returns a boolean if a field has been set.
func (o *V0038JobProperties) HasMemoryPerNode() bool {
	if o != nil && !IsNil(o.MemoryPerNode) {
		return true
	}

	return false
}

// SetMemoryPerNode gets a reference to the given int32 and assigns it to the MemoryPerNode field.
func (o *V0038JobProperties) SetMemoryPerNode(v int32) {
	o.MemoryPerNode = &v
}

// GetMinimumCpusPerNode returns the MinimumCpusPerNode field value if set, zero value otherwise.
func (o *V0038JobProperties) GetMinimumCpusPerNode() int32 {
	if o == nil || IsNil(o.MinimumCpusPerNode) {
		var ret int32
		return ret
	}
	return *o.MinimumCpusPerNode
}

// GetMinimumCpusPerNodeOk returns a tuple with the MinimumCpusPerNode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetMinimumCpusPerNodeOk() (*int32, bool) {
	if o == nil || IsNil(o.MinimumCpusPerNode) {
		return nil, false
	}
	return o.MinimumCpusPerNode, true
}

// HasMinimumCpusPerNode returns a boolean if a field has been set.
func (o *V0038JobProperties) HasMinimumCpusPerNode() bool {
	if o != nil && !IsNil(o.MinimumCpusPerNode) {
		return true
	}

	return false
}

// SetMinimumCpusPerNode gets a reference to the given int32 and assigns it to the MinimumCpusPerNode field.
func (o *V0038JobProperties) SetMinimumCpusPerNode(v int32) {
	o.MinimumCpusPerNode = &v
}

// GetMinimumNodes returns the MinimumNodes field value if set, zero value otherwise.
func (o *V0038JobProperties) GetMinimumNodes() bool {
	if o == nil || IsNil(o.MinimumNodes) {
		var ret bool
		return ret
	}
	return *o.MinimumNodes
}

// GetMinimumNodesOk returns a tuple with the MinimumNodes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetMinimumNodesOk() (*bool, bool) {
	if o == nil || IsNil(o.MinimumNodes) {
		return nil, false
	}
	return o.MinimumNodes, true
}

// HasMinimumNodes returns a boolean if a field has been set.
func (o *V0038JobProperties) HasMinimumNodes() bool {
	if o != nil && !IsNil(o.MinimumNodes) {
		return true
	}

	return false
}

// SetMinimumNodes gets a reference to the given bool and assigns it to the MinimumNodes field.
func (o *V0038JobProperties) SetMinimumNodes(v bool) {
	o.MinimumNodes = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *V0038JobProperties) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *V0038JobProperties) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *V0038JobProperties) SetName(v string) {
	o.Name = &v
}

// GetNice returns the Nice field value if set, zero value otherwise.
func (o *V0038JobProperties) GetNice() int32 {
	if o == nil || IsNil(o.Nice) {
		var ret int32
		return ret
	}
	return *o.Nice
}

// GetNiceOk returns a tuple with the Nice field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetNiceOk() (*int32, bool) {
	if o == nil || IsNil(o.Nice) {
		return nil, false
	}
	return o.Nice, true
}

// HasNice returns a boolean if a field has been set.
func (o *V0038JobProperties) HasNice() bool {
	if o != nil && !IsNil(o.Nice) {
		return true
	}

	return false
}

// SetNice gets a reference to the given int32 and assigns it to the Nice field.
func (o *V0038JobProperties) SetNice(v int32) {
	o.Nice = &v
}

// GetNoKill returns the NoKill field value if set, zero value otherwise.
func (o *V0038JobProperties) GetNoKill() bool {
	if o == nil || IsNil(o.NoKill) {
		var ret bool
		return ret
	}
	return *o.NoKill
}

// GetNoKillOk returns a tuple with the NoKill field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetNoKillOk() (*bool, bool) {
	if o == nil || IsNil(o.NoKill) {
		return nil, false
	}
	return o.NoKill, true
}

// HasNoKill returns a boolean if a field has been set.
func (o *V0038JobProperties) HasNoKill() bool {
	if o != nil && !IsNil(o.NoKill) {
		return true
	}

	return false
}

// SetNoKill gets a reference to the given bool and assigns it to the NoKill field.
func (o *V0038JobProperties) SetNoKill(v bool) {
	o.NoKill = &v
}

// GetNodes returns the Nodes field value if set, zero value otherwise.
func (o *V0038JobProperties) GetNodes() []int32 {
	if o == nil || IsNil(o.Nodes) {
		var ret []int32
		return ret
	}
	return o.Nodes
}

// GetNodesOk returns a tuple with the Nodes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetNodesOk() ([]int32, bool) {
	if o == nil || IsNil(o.Nodes) {
		return nil, false
	}
	return o.Nodes, true
}

// HasNodes returns a boolean if a field has been set.
func (o *V0038JobProperties) HasNodes() bool {
	if o != nil && !IsNil(o.Nodes) {
		return true
	}

	return false
}

// SetNodes gets a reference to the given []int32 and assigns it to the Nodes field.
func (o *V0038JobProperties) SetNodes(v []int32) {
	o.Nodes = v
}

// GetOpenMode returns the OpenMode field value if set, zero value otherwise.
func (o *V0038JobProperties) GetOpenMode() string {
	if o == nil || IsNil(o.OpenMode) {
		var ret string
		return ret
	}
	return *o.OpenMode
}

// GetOpenModeOk returns a tuple with the OpenMode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetOpenModeOk() (*string, bool) {
	if o == nil || IsNil(o.OpenMode) {
		return nil, false
	}
	return o.OpenMode, true
}

// HasOpenMode returns a boolean if a field has been set.
func (o *V0038JobProperties) HasOpenMode() bool {
	if o != nil && !IsNil(o.OpenMode) {
		return true
	}

	return false
}

// SetOpenMode gets a reference to the given string and assigns it to the OpenMode field.
func (o *V0038JobProperties) SetOpenMode(v string) {
	o.OpenMode = &v
}

// GetOversubscribe returns the Oversubscribe field value if set, zero value otherwise.
func (o *V0038JobProperties) GetOversubscribe() bool {
	if o == nil || IsNil(o.Oversubscribe) {
		var ret bool
		return ret
	}
	return *o.Oversubscribe
}

// GetOversubscribeOk returns a tuple with the Oversubscribe field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetOversubscribeOk() (*bool, bool) {
	if o == nil || IsNil(o.Oversubscribe) {
		return nil, false
	}
	return o.Oversubscribe, true
}

// HasOversubscribe returns a boolean if a field has been set.
func (o *V0038JobProperties) HasOversubscribe() bool {
	if o != nil && !IsNil(o.Oversubscribe) {
		return true
	}

	return false
}

// SetOversubscribe gets a reference to the given bool and assigns it to the Oversubscribe field.
func (o *V0038JobProperties) SetOversubscribe(v bool) {
	o.Oversubscribe = &v
}

// GetPartition returns the Partition field value if set, zero value otherwise.
func (o *V0038JobProperties) GetPartition() string {
	if o == nil || IsNil(o.Partition) {
		var ret string
		return ret
	}
	return *o.Partition
}

// GetPartitionOk returns a tuple with the Partition field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetPartitionOk() (*string, bool) {
	if o == nil || IsNil(o.Partition) {
		return nil, false
	}
	return o.Partition, true
}

// HasPartition returns a boolean if a field has been set.
func (o *V0038JobProperties) HasPartition() bool {
	if o != nil && !IsNil(o.Partition) {
		return true
	}

	return false
}

// SetPartition gets a reference to the given string and assigns it to the Partition field.
func (o *V0038JobProperties) SetPartition(v string) {
	o.Partition = &v
}

// GetPrefer returns the Prefer field value if set, zero value otherwise.
func (o *V0038JobProperties) GetPrefer() string {
	if o == nil || IsNil(o.Prefer) {
		var ret string
		return ret
	}
	return *o.Prefer
}

// GetPreferOk returns a tuple with the Prefer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetPreferOk() (*string, bool) {
	if o == nil || IsNil(o.Prefer) {
		return nil, false
	}
	return o.Prefer, true
}

// HasPrefer returns a boolean if a field has been set.
func (o *V0038JobProperties) HasPrefer() bool {
	if o != nil && !IsNil(o.Prefer) {
		return true
	}

	return false
}

// SetPrefer gets a reference to the given string and assigns it to the Prefer field.
func (o *V0038JobProperties) SetPrefer(v string) {
	o.Prefer = &v
}

// GetPriority returns the Priority field value if set, zero value otherwise.
func (o *V0038JobProperties) GetPriority() string {
	if o == nil || IsNil(o.Priority) {
		var ret string
		return ret
	}
	return *o.Priority
}

// GetPriorityOk returns a tuple with the Priority field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetPriorityOk() (*string, bool) {
	if o == nil || IsNil(o.Priority) {
		return nil, false
	}
	return o.Priority, true
}

// HasPriority returns a boolean if a field has been set.
func (o *V0038JobProperties) HasPriority() bool {
	if o != nil && !IsNil(o.Priority) {
		return true
	}

	return false
}

// SetPriority gets a reference to the given string and assigns it to the Priority field.
func (o *V0038JobProperties) SetPriority(v string) {
	o.Priority = &v
}

// GetQos returns the Qos field value if set, zero value otherwise.
func (o *V0038JobProperties) GetQos() string {
	if o == nil || IsNil(o.Qos) {
		var ret string
		return ret
	}
	return *o.Qos
}

// GetQosOk returns a tuple with the Qos field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetQosOk() (*string, bool) {
	if o == nil || IsNil(o.Qos) {
		return nil, false
	}
	return o.Qos, true
}

// HasQos returns a boolean if a field has been set.
func (o *V0038JobProperties) HasQos() bool {
	if o != nil && !IsNil(o.Qos) {
		return true
	}

	return false
}

// SetQos gets a reference to the given string and assigns it to the Qos field.
func (o *V0038JobProperties) SetQos(v string) {
	o.Qos = &v
}

// GetRequeue returns the Requeue field value if set, zero value otherwise.
func (o *V0038JobProperties) GetRequeue() bool {
	if o == nil || IsNil(o.Requeue) {
		var ret bool
		return ret
	}
	return *o.Requeue
}

// GetRequeueOk returns a tuple with the Requeue field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetRequeueOk() (*bool, bool) {
	if o == nil || IsNil(o.Requeue) {
		return nil, false
	}
	return o.Requeue, true
}

// HasRequeue returns a boolean if a field has been set.
func (o *V0038JobProperties) HasRequeue() bool {
	if o != nil && !IsNil(o.Requeue) {
		return true
	}

	return false
}

// SetRequeue gets a reference to the given bool and assigns it to the Requeue field.
func (o *V0038JobProperties) SetRequeue(v bool) {
	o.Requeue = &v
}

// GetReservation returns the Reservation field value if set, zero value otherwise.
func (o *V0038JobProperties) GetReservation() string {
	if o == nil || IsNil(o.Reservation) {
		var ret string
		return ret
	}
	return *o.Reservation
}

// GetReservationOk returns a tuple with the Reservation field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetReservationOk() (*string, bool) {
	if o == nil || IsNil(o.Reservation) {
		return nil, false
	}
	return o.Reservation, true
}

// HasReservation returns a boolean if a field has been set.
func (o *V0038JobProperties) HasReservation() bool {
	if o != nil && !IsNil(o.Reservation) {
		return true
	}

	return false
}

// SetReservation gets a reference to the given string and assigns it to the Reservation field.
func (o *V0038JobProperties) SetReservation(v string) {
	o.Reservation = &v
}

// GetSignal returns the Signal field value if set, zero value otherwise.
func (o *V0038JobProperties) GetSignal() string {
	if o == nil || IsNil(o.Signal) {
		var ret string
		return ret
	}
	return *o.Signal
}

// GetSignalOk returns a tuple with the Signal field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetSignalOk() (*string, bool) {
	if o == nil || IsNil(o.Signal) {
		return nil, false
	}
	return o.Signal, true
}

// HasSignal returns a boolean if a field has been set.
func (o *V0038JobProperties) HasSignal() bool {
	if o != nil && !IsNil(o.Signal) {
		return true
	}

	return false
}

// SetSignal gets a reference to the given string and assigns it to the Signal field.
func (o *V0038JobProperties) SetSignal(v string) {
	o.Signal = &v
}

// GetSocketsPerNode returns the SocketsPerNode field value if set, zero value otherwise.
func (o *V0038JobProperties) GetSocketsPerNode() int32 {
	if o == nil || IsNil(o.SocketsPerNode) {
		var ret int32
		return ret
	}
	return *o.SocketsPerNode
}

// GetSocketsPerNodeOk returns a tuple with the SocketsPerNode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetSocketsPerNodeOk() (*int32, bool) {
	if o == nil || IsNil(o.SocketsPerNode) {
		return nil, false
	}
	return o.SocketsPerNode, true
}

// HasSocketsPerNode returns a boolean if a field has been set.
func (o *V0038JobProperties) HasSocketsPerNode() bool {
	if o != nil && !IsNil(o.SocketsPerNode) {
		return true
	}

	return false
}

// SetSocketsPerNode gets a reference to the given int32 and assigns it to the SocketsPerNode field.
func (o *V0038JobProperties) SetSocketsPerNode(v int32) {
	o.SocketsPerNode = &v
}

// GetSpreadJob returns the SpreadJob field value if set, zero value otherwise.
func (o *V0038JobProperties) GetSpreadJob() bool {
	if o == nil || IsNil(o.SpreadJob) {
		var ret bool
		return ret
	}
	return *o.SpreadJob
}

// GetSpreadJobOk returns a tuple with the SpreadJob field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetSpreadJobOk() (*bool, bool) {
	if o == nil || IsNil(o.SpreadJob) {
		return nil, false
	}
	return o.SpreadJob, true
}

// HasSpreadJob returns a boolean if a field has been set.
func (o *V0038JobProperties) HasSpreadJob() bool {
	if o != nil && !IsNil(o.SpreadJob) {
		return true
	}

	return false
}

// SetSpreadJob gets a reference to the given bool and assigns it to the SpreadJob field.
func (o *V0038JobProperties) SetSpreadJob(v bool) {
	o.SpreadJob = &v
}

// GetStandardError returns the StandardError field value if set, zero value otherwise.
func (o *V0038JobProperties) GetStandardError() string {
	if o == nil || IsNil(o.StandardError) {
		var ret string
		return ret
	}
	return *o.StandardError
}

// GetStandardErrorOk returns a tuple with the StandardError field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetStandardErrorOk() (*string, bool) {
	if o == nil || IsNil(o.StandardError) {
		return nil, false
	}
	return o.StandardError, true
}

// HasStandardError returns a boolean if a field has been set.
func (o *V0038JobProperties) HasStandardError() bool {
	if o != nil && !IsNil(o.StandardError) {
		return true
	}

	return false
}

// SetStandardError gets a reference to the given string and assigns it to the StandardError field.
func (o *V0038JobProperties) SetStandardError(v string) {
	o.StandardError = &v
}

// GetStandardInput returns the StandardInput field value if set, zero value otherwise.
func (o *V0038JobProperties) GetStandardInput() string {
	if o == nil || IsNil(o.StandardInput) {
		var ret string
		return ret
	}
	return *o.StandardInput
}

// GetStandardInputOk returns a tuple with the StandardInput field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetStandardInputOk() (*string, bool) {
	if o == nil || IsNil(o.StandardInput) {
		return nil, false
	}
	return o.StandardInput, true
}

// HasStandardInput returns a boolean if a field has been set.
func (o *V0038JobProperties) HasStandardInput() bool {
	if o != nil && !IsNil(o.StandardInput) {
		return true
	}

	return false
}

// SetStandardInput gets a reference to the given string and assigns it to the StandardInput field.
func (o *V0038JobProperties) SetStandardInput(v string) {
	o.StandardInput = &v
}

// GetStandardOutput returns the StandardOutput field value if set, zero value otherwise.
func (o *V0038JobProperties) GetStandardOutput() string {
	if o == nil || IsNil(o.StandardOutput) {
		var ret string
		return ret
	}
	return *o.StandardOutput
}

// GetStandardOutputOk returns a tuple with the StandardOutput field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetStandardOutputOk() (*string, bool) {
	if o == nil || IsNil(o.StandardOutput) {
		return nil, false
	}
	return o.StandardOutput, true
}

// HasStandardOutput returns a boolean if a field has been set.
func (o *V0038JobProperties) HasStandardOutput() bool {
	if o != nil && !IsNil(o.StandardOutput) {
		return true
	}

	return false
}

// SetStandardOutput gets a reference to the given string and assigns it to the StandardOutput field.
func (o *V0038JobProperties) SetStandardOutput(v string) {
	o.StandardOutput = &v
}

// GetTasks returns the Tasks field value if set, zero value otherwise.
func (o *V0038JobProperties) GetTasks() int32 {
	if o == nil || IsNil(o.Tasks) {
		var ret int32
		return ret
	}
	return *o.Tasks
}

// GetTasksOk returns a tuple with the Tasks field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetTasksOk() (*int32, bool) {
	if o == nil || IsNil(o.Tasks) {
		return nil, false
	}
	return o.Tasks, true
}

// HasTasks returns a boolean if a field has been set.
func (o *V0038JobProperties) HasTasks() bool {
	if o != nil && !IsNil(o.Tasks) {
		return true
	}

	return false
}

// SetTasks gets a reference to the given int32 and assigns it to the Tasks field.
func (o *V0038JobProperties) SetTasks(v int32) {
	o.Tasks = &v
}

// GetTasksPerCore returns the TasksPerCore field value if set, zero value otherwise.
func (o *V0038JobProperties) GetTasksPerCore() int32 {
	if o == nil || IsNil(o.TasksPerCore) {
		var ret int32
		return ret
	}
	return *o.TasksPerCore
}

// GetTasksPerCoreOk returns a tuple with the TasksPerCore field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetTasksPerCoreOk() (*int32, bool) {
	if o == nil || IsNil(o.TasksPerCore) {
		return nil, false
	}
	return o.TasksPerCore, true
}

// HasTasksPerCore returns a boolean if a field has been set.
func (o *V0038JobProperties) HasTasksPerCore() bool {
	if o != nil && !IsNil(o.TasksPerCore) {
		return true
	}

	return false
}

// SetTasksPerCore gets a reference to the given int32 and assigns it to the TasksPerCore field.
func (o *V0038JobProperties) SetTasksPerCore(v int32) {
	o.TasksPerCore = &v
}

// GetTasksPerNode returns the TasksPerNode field value if set, zero value otherwise.
func (o *V0038JobProperties) GetTasksPerNode() int32 {
	if o == nil || IsNil(o.TasksPerNode) {
		var ret int32
		return ret
	}
	return *o.TasksPerNode
}

// GetTasksPerNodeOk returns a tuple with the TasksPerNode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetTasksPerNodeOk() (*int32, bool) {
	if o == nil || IsNil(o.TasksPerNode) {
		return nil, false
	}
	return o.TasksPerNode, true
}

// HasTasksPerNode returns a boolean if a field has been set.
func (o *V0038JobProperties) HasTasksPerNode() bool {
	if o != nil && !IsNil(o.TasksPerNode) {
		return true
	}

	return false
}

// SetTasksPerNode gets a reference to the given int32 and assigns it to the TasksPerNode field.
func (o *V0038JobProperties) SetTasksPerNode(v int32) {
	o.TasksPerNode = &v
}

// GetTasksPerSocket returns the TasksPerSocket field value if set, zero value otherwise.
func (o *V0038JobProperties) GetTasksPerSocket() int32 {
	if o == nil || IsNil(o.TasksPerSocket) {
		var ret int32
		return ret
	}
	return *o.TasksPerSocket
}

// GetTasksPerSocketOk returns a tuple with the TasksPerSocket field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetTasksPerSocketOk() (*int32, bool) {
	if o == nil || IsNil(o.TasksPerSocket) {
		return nil, false
	}
	return o.TasksPerSocket, true
}

// HasTasksPerSocket returns a boolean if a field has been set.
func (o *V0038JobProperties) HasTasksPerSocket() bool {
	if o != nil && !IsNil(o.TasksPerSocket) {
		return true
	}

	return false
}

// SetTasksPerSocket gets a reference to the given int32 and assigns it to the TasksPerSocket field.
func (o *V0038JobProperties) SetTasksPerSocket(v int32) {
	o.TasksPerSocket = &v
}

// GetThreadSpecification returns the ThreadSpecification field value if set, zero value otherwise.
func (o *V0038JobProperties) GetThreadSpecification() int32 {
	if o == nil || IsNil(o.ThreadSpecification) {
		var ret int32
		return ret
	}
	return *o.ThreadSpecification
}

// GetThreadSpecificationOk returns a tuple with the ThreadSpecification field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetThreadSpecificationOk() (*int32, bool) {
	if o == nil || IsNil(o.ThreadSpecification) {
		return nil, false
	}
	return o.ThreadSpecification, true
}

// HasThreadSpecification returns a boolean if a field has been set.
func (o *V0038JobProperties) HasThreadSpecification() bool {
	if o != nil && !IsNil(o.ThreadSpecification) {
		return true
	}

	return false
}

// SetThreadSpecification gets a reference to the given int32 and assigns it to the ThreadSpecification field.
func (o *V0038JobProperties) SetThreadSpecification(v int32) {
	o.ThreadSpecification = &v
}

// GetThreadsPerCore returns the ThreadsPerCore field value if set, zero value otherwise.
func (o *V0038JobProperties) GetThreadsPerCore() int32 {
	if o == nil || IsNil(o.ThreadsPerCore) {
		var ret int32
		return ret
	}
	return *o.ThreadsPerCore
}

// GetThreadsPerCoreOk returns a tuple with the ThreadsPerCore field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetThreadsPerCoreOk() (*int32, bool) {
	if o == nil || IsNil(o.ThreadsPerCore) {
		return nil, false
	}
	return o.ThreadsPerCore, true
}

// HasThreadsPerCore returns a boolean if a field has been set.
func (o *V0038JobProperties) HasThreadsPerCore() bool {
	if o != nil && !IsNil(o.ThreadsPerCore) {
		return true
	}

	return false
}

// SetThreadsPerCore gets a reference to the given int32 and assigns it to the ThreadsPerCore field.
func (o *V0038JobProperties) SetThreadsPerCore(v int32) {
	o.ThreadsPerCore = &v
}

// GetTimeLimit returns the TimeLimit field value if set, zero value otherwise.
func (o *V0038JobProperties) GetTimeLimit() int32 {
	if o == nil || IsNil(o.TimeLimit) {
		var ret int32
		return ret
	}
	return *o.TimeLimit
}

// GetTimeLimitOk returns a tuple with the TimeLimit field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetTimeLimitOk() (*int32, bool) {
	if o == nil || IsNil(o.TimeLimit) {
		return nil, false
	}
	return o.TimeLimit, true
}

// HasTimeLimit returns a boolean if a field has been set.
func (o *V0038JobProperties) HasTimeLimit() bool {
	if o != nil && !IsNil(o.TimeLimit) {
		return true
	}

	return false
}

// SetTimeLimit gets a reference to the given int32 and assigns it to the TimeLimit field.
func (o *V0038JobProperties) SetTimeLimit(v int32) {
	o.TimeLimit = &v
}

// GetTimeMinimum returns the TimeMinimum field value if set, zero value otherwise.
func (o *V0038JobProperties) GetTimeMinimum() int32 {
	if o == nil || IsNil(o.TimeMinimum) {
		var ret int32
		return ret
	}
	return *o.TimeMinimum
}

// GetTimeMinimumOk returns a tuple with the TimeMinimum field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetTimeMinimumOk() (*int32, bool) {
	if o == nil || IsNil(o.TimeMinimum) {
		return nil, false
	}
	return o.TimeMinimum, true
}

// HasTimeMinimum returns a boolean if a field has been set.
func (o *V0038JobProperties) HasTimeMinimum() bool {
	if o != nil && !IsNil(o.TimeMinimum) {
		return true
	}

	return false
}

// SetTimeMinimum gets a reference to the given int32 and assigns it to the TimeMinimum field.
func (o *V0038JobProperties) SetTimeMinimum(v int32) {
	o.TimeMinimum = &v
}

// GetWaitAllNodes returns the WaitAllNodes field value if set, zero value otherwise.
func (o *V0038JobProperties) GetWaitAllNodes() bool {
	if o == nil || IsNil(o.WaitAllNodes) {
		var ret bool
		return ret
	}
	return *o.WaitAllNodes
}

// GetWaitAllNodesOk returns a tuple with the WaitAllNodes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetWaitAllNodesOk() (*bool, bool) {
	if o == nil || IsNil(o.WaitAllNodes) {
		return nil, false
	}
	return o.WaitAllNodes, true
}

// HasWaitAllNodes returns a boolean if a field has been set.
func (o *V0038JobProperties) HasWaitAllNodes() bool {
	if o != nil && !IsNil(o.WaitAllNodes) {
		return true
	}

	return false
}

// SetWaitAllNodes gets a reference to the given bool and assigns it to the WaitAllNodes field.
func (o *V0038JobProperties) SetWaitAllNodes(v bool) {
	o.WaitAllNodes = &v
}

// GetWckey returns the Wckey field value if set, zero value otherwise.
func (o *V0038JobProperties) GetWckey() string {
	if o == nil || IsNil(o.Wckey) {
		var ret string
		return ret
	}
	return *o.Wckey
}

// GetWckeyOk returns a tuple with the Wckey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038JobProperties) GetWckeyOk() (*string, bool) {
	if o == nil || IsNil(o.Wckey) {
		return nil, false
	}
	return o.Wckey, true
}

// HasWckey returns a boolean if a field has been set.
func (o *V0038JobProperties) HasWckey() bool {
	if o != nil && !IsNil(o.Wckey) {
		return true
	}

	return false
}

// SetWckey gets a reference to the given string and assigns it to the Wckey field.
func (o *V0038JobProperties) SetWckey(v string) {
	o.Wckey = &v
}

func (o V0038JobProperties) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o V0038JobProperties) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Account) {
		toSerialize["account"] = o.Account
	}
	if !IsNil(o.AccountGatherFrequency) {
		toSerialize["account_gather_frequency"] = o.AccountGatherFrequency
	}
	if !IsNil(o.Argv) {
		toSerialize["argv"] = o.Argv
	}
	if !IsNil(o.Array) {
		toSerialize["array"] = o.Array
	}
	if !IsNil(o.BatchFeatures) {
		toSerialize["batch_features"] = o.BatchFeatures
	}
	if !IsNil(o.BeginTime) {
		toSerialize["begin_time"] = o.BeginTime
	}
	if !IsNil(o.BurstBuffer) {
		toSerialize["burst_buffer"] = o.BurstBuffer
	}
	if !IsNil(o.ClusterConstraint) {
		toSerialize["cluster_constraint"] = o.ClusterConstraint
	}
	if !IsNil(o.Comment) {
		toSerialize["comment"] = o.Comment
	}
	if !IsNil(o.Constraints) {
		toSerialize["constraints"] = o.Constraints
	}
	if !IsNil(o.Container) {
		toSerialize["container"] = o.Container
	}
	if !IsNil(o.CoreSpecification) {
		toSerialize["core_specification"] = o.CoreSpecification
	}
	if !IsNil(o.CoresPerSocket) {
		toSerialize["cores_per_socket"] = o.CoresPerSocket
	}
	if !IsNil(o.CpuBinding) {
		toSerialize["cpu_binding"] = o.CpuBinding
	}
	if !IsNil(o.CpuBindingHint) {
		toSerialize["cpu_binding_hint"] = o.CpuBindingHint
	}
	if !IsNil(o.CpuFrequency) {
		toSerialize["cpu_frequency"] = o.CpuFrequency
	}
	if !IsNil(o.CpusPerGpu) {
		toSerialize["cpus_per_gpu"] = o.CpusPerGpu
	}
	if !IsNil(o.CpusPerTask) {
		toSerialize["cpus_per_task"] = o.CpusPerTask
	}
	if !IsNil(o.CurrentWorkingDirectory) {
		toSerialize["current_working_directory"] = o.CurrentWorkingDirectory
	}
	if !IsNil(o.Deadline) {
		toSerialize["deadline"] = o.Deadline
	}
	if !IsNil(o.DelayBoot) {
		toSerialize["delay_boot"] = o.DelayBoot
	}
	if !IsNil(o.Dependency) {
		toSerialize["dependency"] = o.Dependency
	}
	if !IsNil(o.Distribution) {
		toSerialize["distribution"] = o.Distribution
	}
	toSerialize["environment"] = o.Environment
	if !IsNil(o.Exclusive) {
		toSerialize["exclusive"] = o.Exclusive
	}
	if !IsNil(o.GetUserEnvironment) {
		toSerialize["get_user_environment"] = o.GetUserEnvironment
	}
	if !IsNil(o.Gres) {
		toSerialize["gres"] = o.Gres
	}
	if !IsNil(o.GresFlags) {
		toSerialize["gres_flags"] = o.GresFlags
	}
	if !IsNil(o.GpuBinding) {
		toSerialize["gpu_binding"] = o.GpuBinding
	}
	if !IsNil(o.GpuFrequency) {
		toSerialize["gpu_frequency"] = o.GpuFrequency
	}
	if !IsNil(o.Gpus) {
		toSerialize["gpus"] = o.Gpus
	}
	if !IsNil(o.GpusPerNode) {
		toSerialize["gpus_per_node"] = o.GpusPerNode
	}
	if !IsNil(o.GpusPerSocket) {
		toSerialize["gpus_per_socket"] = o.GpusPerSocket
	}
	if !IsNil(o.GpusPerTask) {
		toSerialize["gpus_per_task"] = o.GpusPerTask
	}
	if !IsNil(o.Hold) {
		toSerialize["hold"] = o.Hold
	}
	if !IsNil(o.KillOnInvalidDependency) {
		toSerialize["kill_on_invalid_dependency"] = o.KillOnInvalidDependency
	}
	if !IsNil(o.Licenses) {
		toSerialize["licenses"] = o.Licenses
	}
	if !IsNil(o.MailType) {
		toSerialize["mail_type"] = o.MailType
	}
	if !IsNil(o.MailUser) {
		toSerialize["mail_user"] = o.MailUser
	}
	if !IsNil(o.McsLabel) {
		toSerialize["mcs_label"] = o.McsLabel
	}
	if !IsNil(o.MemoryBinding) {
		toSerialize["memory_binding"] = o.MemoryBinding
	}
	if !IsNil(o.MemoryPerCpu) {
		toSerialize["memory_per_cpu"] = o.MemoryPerCpu
	}
	if !IsNil(o.MemoryPerGpu) {
		toSerialize["memory_per_gpu"] = o.MemoryPerGpu
	}
	if !IsNil(o.MemoryPerNode) {
		toSerialize["memory_per_node"] = o.MemoryPerNode
	}
	if !IsNil(o.MinimumCpusPerNode) {
		toSerialize["minimum_cpus_per_node"] = o.MinimumCpusPerNode
	}
	if !IsNil(o.MinimumNodes) {
		toSerialize["minimum_nodes"] = o.MinimumNodes
	}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !IsNil(o.Nice) {
		toSerialize["nice"] = o.Nice
	}
	if !IsNil(o.NoKill) {
		toSerialize["no_kill"] = o.NoKill
	}
	if !IsNil(o.Nodes) {
		toSerialize["nodes"] = o.Nodes
	}
	if !IsNil(o.OpenMode) {
		toSerialize["open_mode"] = o.OpenMode
	}
	if !IsNil(o.Oversubscribe) {
		toSerialize["oversubscribe"] = o.Oversubscribe
	}
	if !IsNil(o.Partition) {
		toSerialize["partition"] = o.Partition
	}
	if !IsNil(o.Prefer) {
		toSerialize["prefer"] = o.Prefer
	}
	if !IsNil(o.Priority) {
		toSerialize["priority"] = o.Priority
	}
	if !IsNil(o.Qos) {
		toSerialize["qos"] = o.Qos
	}
	if !IsNil(o.Requeue) {
		toSerialize["requeue"] = o.Requeue
	}
	if !IsNil(o.Reservation) {
		toSerialize["reservation"] = o.Reservation
	}
	if !IsNil(o.Signal) {
		toSerialize["signal"] = o.Signal
	}
	if !IsNil(o.SocketsPerNode) {
		toSerialize["sockets_per_node"] = o.SocketsPerNode
	}
	if !IsNil(o.SpreadJob) {
		toSerialize["spread_job"] = o.SpreadJob
	}
	if !IsNil(o.StandardError) {
		toSerialize["standard_error"] = o.StandardError
	}
	if !IsNil(o.StandardInput) {
		toSerialize["standard_input"] = o.StandardInput
	}
	if !IsNil(o.StandardOutput) {
		toSerialize["standard_output"] = o.StandardOutput
	}
	if !IsNil(o.Tasks) {
		toSerialize["tasks"] = o.Tasks
	}
	if !IsNil(o.TasksPerCore) {
		toSerialize["tasks_per_core"] = o.TasksPerCore
	}
	if !IsNil(o.TasksPerNode) {
		toSerialize["tasks_per_node"] = o.TasksPerNode
	}
	if !IsNil(o.TasksPerSocket) {
		toSerialize["tasks_per_socket"] = o.TasksPerSocket
	}
	if !IsNil(o.ThreadSpecification) {
		toSerialize["thread_specification"] = o.ThreadSpecification
	}
	if !IsNil(o.ThreadsPerCore) {
		toSerialize["threads_per_core"] = o.ThreadsPerCore
	}
	if !IsNil(o.TimeLimit) {
		toSerialize["time_limit"] = o.TimeLimit
	}
	if !IsNil(o.TimeMinimum) {
		toSerialize["time_minimum"] = o.TimeMinimum
	}
	if !IsNil(o.WaitAllNodes) {
		toSerialize["wait_all_nodes"] = o.WaitAllNodes
	}
	if !IsNil(o.Wckey) {
		toSerialize["wckey"] = o.Wckey
	}
	return toSerialize, nil
}

func (o *V0038JobProperties) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"environment",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varV0038JobProperties := _V0038JobProperties{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varV0038JobProperties)

	if err != nil {
		return err
	}

	*o = V0038JobProperties(varV0038JobProperties)

	return err
}

type NullableV0038JobProperties struct {
	value *V0038JobProperties
	isSet bool
}

func (v NullableV0038JobProperties) Get() *V0038JobProperties {
	return v.value
}

func (v *NullableV0038JobProperties) Set(val *V0038JobProperties) {
	v.value = val
	v.isSet = true
}

func (v NullableV0038JobProperties) IsSet() bool {
	return v.isSet
}

func (v *NullableV0038JobProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableV0038JobProperties(val *V0038JobProperties) *NullableV0038JobProperties {
	return &NullableV0038JobProperties{value: val, isSet: true}
}

func (v NullableV0038JobProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableV0038JobProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


