//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package internal

// QueryOptions contains a group of parameters for the TableClient.Query method.
type QueryOptions struct {
	// OData filter expression.
	Filter *string

	// Specifies the media type for the response.
	Format *ODataMetadataFormat

	// Select expression using OData notation. Limits the columns on each record to just those requested, e.g. "$select=PolicyAssignmentId,
	// ResourceId".
	Select *string

	// Maximum number of records to return.
	Top *int32
}

// ServiceClientGetPropertiesOptions contains the optional parameters for the ServiceClient.GetProperties method.
type ServiceClientGetPropertiesOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds.
	Timeout *int32
}

// ServiceClientGetStatisticsOptions contains the optional parameters for the ServiceClient.GetStatistics method.
type ServiceClientGetStatisticsOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds.
	Timeout *int32
}

// ServiceClientSetPropertiesOptions contains the optional parameters for the ServiceClient.SetProperties method.
type ServiceClientSetPropertiesOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds.
	Timeout *int32
}

// TableClientCreateOptions contains the optional parameters for the TableClient.Create method.
type TableClientCreateOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string

	// Specifies whether the response should include the inserted entity in the payload. Possible values are return-no-content
	// and return-content.
	ResponsePreference *ResponseFormat
}

// TableClientDeleteEntityOptions contains the optional parameters for the TableClient.DeleteEntity method.
type TableClientDeleteEntityOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds.
	Timeout *int32
}

// TableClientDeleteOptions contains the optional parameters for the TableClient.Delete method.
type TableClientDeleteOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string
}

// TableClientGetAccessPolicyOptions contains the optional parameters for the TableClient.GetAccessPolicy method.
type TableClientGetAccessPolicyOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds.
	Timeout *int32
}

// TableClientInsertEntityOptions contains the optional parameters for the TableClient.InsertEntity method.
type TableClientInsertEntityOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string

	// Specifies whether the response should include the inserted entity in the payload. Possible values are return-no-content
	// and return-content.
	ResponsePreference *ResponseFormat

	// The properties for the table entity.
	TableEntityProperties map[string]any

	// The timeout parameter is expressed in seconds.
	Timeout *int32
}

// TableClientMergeEntityOptions contains the optional parameters for the TableClient.MergeEntity method.
type TableClientMergeEntityOptions struct {
	// Match condition for an entity to be updated. If specified and a matching entity is not found, an error will be raised.
	// To force an unconditional update, set to the wildcard character (*). If not
	// specified, an insert will be performed when no existing entity is found to update and a merge will be performed if an existing
	// entity is found.
	IfMatch *string

	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string

	// The properties for the table entity.
	TableEntityProperties map[string]any

	// The timeout parameter is expressed in seconds.
	Timeout *int32
}

// TableClientQueryEntitiesOptions contains the optional parameters for the TableClient.QueryEntities method.
type TableClientQueryEntitiesOptions struct {
	// An entity query continuation token from a previous call.
	NextPartitionKey *string

	// An entity query continuation token from a previous call.
	NextRowKey *string

	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds.
	Timeout *int32
}

// TableClientQueryEntityWithPartitionAndRowKeyOptions contains the optional parameters for the TableClient.QueryEntityWithPartitionAndRowKey
// method.
type TableClientQueryEntityWithPartitionAndRowKeyOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string

	// The timeout parameter is expressed in seconds.
	Timeout *int32
}

// TableClientQueryOptions contains the optional parameters for the TableClient.Query method.
type TableClientQueryOptions struct {
	// A table query continuation token from a previous call.
	NextTableName *string

	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string
}

// TableClientSetAccessPolicyOptions contains the optional parameters for the TableClient.SetAccessPolicy method.
type TableClientSetAccessPolicyOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string

	// The acls for the table.
	TableACL []*SignedIdentifier

	// The timeout parameter is expressed in seconds.
	Timeout *int32
}

// TableClientUpdateEntityOptions contains the optional parameters for the TableClient.UpdateEntity method.
type TableClientUpdateEntityOptions struct {
	// Match condition for an entity to be updated. If specified and a matching entity is not found, an error will be raised.
	// To force an unconditional update, set to the wildcard character (*). If not
	// specified, an insert will be performed when no existing entity is found to update and a replace will be performed if an
	// existing entity is found.
	IfMatch *string

	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when analytics
	// logging is enabled.
	RequestID *string

	// The properties for the table entity.
	TableEntityProperties map[string]any

	// The timeout parameter is expressed in seconds.
	Timeout *int32
}
