/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.integration.api.network.dto.details;

import com.ubnt.net.Dto;
import com.ubnt.net.integration.api.network.dto.details.IntegrationIpv6AddressSuffixRangeSelectorDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import lombok.Generated;

@Schema(name="DHCP Configuration for IPv6 Network")
public final class IntegrationNetworkIpv6DhcpConfigurationDto
implements Dto {
    @NotNull
    @Valid
    private final IntegrationIpv6AddressSuffixRangeSelectorDto ipAddressSuffixRange;
    @NotNull
    @Min(value=0L)
    @Max(value=31536000L)
    @Schema(description="The lease time in seconds for IP addresses in this range.")
    private final @NotNull @Min(value=0L) @Max(value=31536000L) Integer leaseTimeSeconds;

    @ConstructorProperties(value={"ipAddressSuffixRange", "leaseTimeSeconds"})
    @Generated
    public IntegrationNetworkIpv6DhcpConfigurationDto(IntegrationIpv6AddressSuffixRangeSelectorDto integrationIpv6AddressSuffixRangeSelectorDto, Integer n2) {
        this.ipAddressSuffixRange = integrationIpv6AddressSuffixRangeSelectorDto;
        this.leaseTimeSeconds = n2;
    }

    @Generated
    public IntegrationIpv6AddressSuffixRangeSelectorDto getIpAddressSuffixRange() {
        return this.ipAddressSuffixRange;
    }

    @Generated
    public Integer getLeaseTimeSeconds() {
        return this.leaseTimeSeconds;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntegrationNetworkIpv6DhcpConfigurationDto)) {
            return false;
        }
        IntegrationNetworkIpv6DhcpConfigurationDto integrationNetworkIpv6DhcpConfigurationDto = (IntegrationNetworkIpv6DhcpConfigurationDto)object;
        Integer n2 = this.getLeaseTimeSeconds();
        Integer n3 = integrationNetworkIpv6DhcpConfigurationDto.getLeaseTimeSeconds();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        IntegrationIpv6AddressSuffixRangeSelectorDto integrationIpv6AddressSuffixRangeSelectorDto = this.getIpAddressSuffixRange();
        IntegrationIpv6AddressSuffixRangeSelectorDto integrationIpv6AddressSuffixRangeSelectorDto2 = integrationNetworkIpv6DhcpConfigurationDto.getIpAddressSuffixRange();
        return !(integrationIpv6AddressSuffixRangeSelectorDto == null ? integrationIpv6AddressSuffixRangeSelectorDto2 != null : !((Object)integrationIpv6AddressSuffixRangeSelectorDto).equals(integrationIpv6AddressSuffixRangeSelectorDto2));
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        Integer n3 = this.getLeaseTimeSeconds();
        n2 = n2 * 59 + (n3 == null ? 43 : ((Object)n3).hashCode());
        IntegrationIpv6AddressSuffixRangeSelectorDto integrationIpv6AddressSuffixRangeSelectorDto = this.getIpAddressSuffixRange();
        n2 = n2 * 59 + (integrationIpv6AddressSuffixRangeSelectorDto == null ? 43 : ((Object)integrationIpv6AddressSuffixRangeSelectorDto).hashCode());
        return n2;
    }

    @Generated
    public String toString() {
        return "IntegrationNetworkIpv6DhcpConfigurationDto(ipAddressSuffixRange=" + String.valueOf(this.getIpAddressSuffixRange()) + ", leaseTimeSeconds=" + this.getLeaseTimeSeconds() + ")";
    }
}

