/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ubnt.data.Device;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class TraceDevice {
    private String model;
    private String version;
    private Integer manufacturerId;
    private Integer boardRev;
    private String anonymousDeviceId;
    @JsonIgnore
    private String siteId;

    public TraceDevice(Device device) {
        this.model = device.getModel().toString();
        this.version = device.getString("version", "unknown");
        this.manufacturerId = device.getInt("manufacturer_id", -1);
        this.boardRev = device.getInt("board_rev", -1);
        this.anonymousDeviceId = device.getAnonymousDeviceId();
        this.siteId = device.getSiteId();
    }

    public String getModel() {
        return this.model;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getManufacturerId() {
        return this.manufacturerId;
    }

    public Integer getBoardRev() {
        return this.boardRev;
    }

    public String getAnonymousDeviceId() {
        return this.anonymousDeviceId;
    }

    public String getSiteId() {
        return this.siteId;
    }
}

