/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Crossover;
import io.jenetics.EnumGene;
import io.jenetics.internal.math.comb;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import java.util.Random;

public final class PartiallyMatchedCrossover<T, C extends Comparable<? super C>>
extends Crossover<EnumGene<T>, C> {
    public PartiallyMatchedCrossover(double probability2) {
        super(probability2);
    }

    @Override
    protected int crossover(MSeq<EnumGene<T>> that, MSeq<EnumGene<T>> other) {
        if (that.length() != other.length()) {
            throw new IllegalArgumentException(String.format("Required chromosomes with same length: %s != %s", that.length(), other.length()));
        }
        if (that.length() >= 2) {
            Random random2 = RandomRegistry.getRandom();
            int[] points = comb.subset(that.length(), 2, random2);
            that.swap(points[0], points[1], other, points[0]);
            PartiallyMatchedCrossover.repair(that, other, points[0], points[1]);
            PartiallyMatchedCrossover.repair(other, that, points[0], points[1]);
        }
        return 1;
    }

    private static <T> void repair(MSeq<T> that, MSeq<T> other, int begin, int end) {
        int i;
        for (i = 0; i < begin; ++i) {
            int index = that.indexOf(that.get(i), begin, end);
            while (index != -1) {
                that.set(i, other.get(index));
                index = that.indexOf(that.get(i), begin, end);
            }
        }
        int n = that.length();
        for (i = end; i < n; ++i) {
            int index = that.indexOf(that.get(i), begin, end);
            while (index != -1) {
                that.set(i, other.get(index));
                index = that.indexOf(that.get(i), begin, end);
            }
        }
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).value();
    }

    @Override
    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(x$0 -> super.equals(x$0));
    }

    public String toString() {
        return String.format("%s[p=%f]", this.getClass().getSimpleName(), this._probability);
    }
}

