/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Alterer;
import io.jenetics.AltererResult;
import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.Mutator;
import io.jenetics.Optimize;
import io.jenetics.Phenotype;
import io.jenetics.Selector;
import io.jenetics.SinglePointCrossover;
import io.jenetics.TournamentSelector;
import io.jenetics.engine.Codec;
import io.jenetics.engine.ConcurrentEvaluator;
import io.jenetics.engine.EvolutionDurations;
import io.jenetics.engine.EvolutionInit;
import io.jenetics.engine.EvolutionIterable;
import io.jenetics.engine.EvolutionIterator;
import io.jenetics.engine.EvolutionResult;
import io.jenetics.engine.EvolutionStart;
import io.jenetics.engine.EvolutionStream;
import io.jenetics.engine.EvolutionStreamable;
import io.jenetics.engine.FilterResult;
import io.jenetics.engine.Problem;
import io.jenetics.engine.TimedExecutor;
import io.jenetics.engine.TimedResult;
import io.jenetics.engine.Timer;
import io.jenetics.internal.util.require;
import io.jenetics.util.Copyable;
import io.jenetics.util.Factory;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.NanoClock;
import io.jenetics.util.Seq;
import java.time.Clock;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public final class Engine<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Function<EvolutionStart<G, C>, EvolutionResult<G, C>>,
EvolutionStreamable<G, C>,
EvolutionIterable<G, C> {
    private final Function<? super Genotype<G>, ? extends C> _fitnessFunction;
    private final Factory<Genotype<G>> _genotypeFactory;
    private final Function<? super C, ? extends C> _fitnessScaler;
    private final Selector<G, C> _survivorsSelector;
    private final Selector<G, C> _offspringSelector;
    private final Alterer<G, C> _alterer;
    private final Predicate<? super Phenotype<G, C>> _validator;
    private final Optimize _optimize;
    private final int _offspringCount;
    private final int _survivorsCount;
    private final long _maximalPhenotypeAge;
    private final TimedExecutor _executor;
    private final Evaluator<G, C> _evaluator;
    private final Clock _clock;
    private final int _individualCreationRetries;
    private final UnaryOperator<EvolutionResult<G, C>> _mapper;

    Engine(Function<? super Genotype<G>, ? extends C> fitnessFunction, Factory<Genotype<G>> genotypeFactory, Function<? super C, ? extends C> fitnessScaler, Selector<G, C> survivorsSelector, Selector<G, C> offspringSelector, Alterer<G, C> alterer, Predicate<? super Phenotype<G, C>> validator, Optimize optimize, int offspringCount, int survivorsCount, long maximalPhenotypeAge, Executor executor, Evaluator<G, C> evaluator, Clock clock, int individualCreationRetries, UnaryOperator<EvolutionResult<G, C>> mapper) {
        this._fitnessFunction = Objects.requireNonNull(fitnessFunction);
        this._fitnessScaler = Objects.requireNonNull(fitnessScaler);
        this._genotypeFactory = Objects.requireNonNull(genotypeFactory);
        this._survivorsSelector = Objects.requireNonNull(survivorsSelector);
        this._offspringSelector = Objects.requireNonNull(offspringSelector);
        this._alterer = Objects.requireNonNull(alterer);
        this._validator = Objects.requireNonNull(validator);
        this._optimize = Objects.requireNonNull(optimize);
        this._offspringCount = require.nonNegative(offspringCount);
        this._survivorsCount = require.nonNegative(survivorsCount);
        this._maximalPhenotypeAge = require.positive(maximalPhenotypeAge);
        this._executor = new TimedExecutor(Objects.requireNonNull(executor));
        this._evaluator = Objects.requireNonNull(evaluator);
        this._clock = Objects.requireNonNull(clock);
        if (individualCreationRetries < 0) {
            throw new IllegalArgumentException(String.format("Retry count must not be negative: %d", individualCreationRetries));
        }
        this._individualCreationRetries = individualCreationRetries;
        this._mapper = Objects.requireNonNull(mapper);
    }

    public EvolutionResult<G, C> evolve(ISeq<Phenotype<G, C>> population, long generation) {
        return this.evolve(EvolutionStart.of(population, generation));
    }

    public EvolutionResult<G, C> evolve(EvolutionStart<G, C> start) {
        Timer timer = Timer.of(this._clock).start();
        Timer evaluateTimer = Timer.of(this._clock).start();
        ISeq<Phenotype<G, C>> evalPop = this._evaluator.evaluate(start.getPopulation());
        if (start.getPopulation().size() != evalPop.size()) {
            throw new IllegalStateException(String.format("Expected %d individuals, but got %d. Check your evaluator function.", start.getPopulation().size(), evalPop.size()));
        }
        evaluateTimer.stop();
        CompletableFuture<TimedResult<ISeq>> offspring = this._executor.async(() -> this.selectOffspring(evalPop), this._clock);
        CompletableFuture<TimedResult<ISeq>> survivors = this._executor.async(() -> this.selectSurvivors(evalPop), this._clock);
        CompletableFuture<TimedResult<AltererResult>> alteredOffspring = this._executor.thenApply(offspring, p -> this._alterer.alter((Seq)p.result, start.getGeneration()), this._clock);
        CompletableFuture<TimedResult<FilterResult>> filteredSurvivors = this._executor.thenApply(survivors, pop -> this.filter((Seq)pop.result, start.getGeneration()), this._clock);
        CompletableFuture<TimedResult<FilterResult>> filteredOffspring = this._executor.thenApply(alteredOffspring, pop -> this.filter(((AltererResult)pop.result).getPopulation(), start.getGeneration()), this._clock);
        CompletionStage population = filteredSurvivors.thenCombineAsync(filteredOffspring, (s, o) -> ISeq.of(((FilterResult)s.result).population.append((Iterable)((FilterResult)o.result).population)), this._executor.get());
        ISeq pop2 = (ISeq)((CompletableFuture)population).join();
        TimedResult<ISeq> result = TimedResult.of(() -> this._evaluator.evaluate(pop2), this._clock).get();
        EvolutionDurations durations = EvolutionDurations.of(offspring.join().duration, survivors.join().duration, alteredOffspring.join().duration, filteredOffspring.join().duration, filteredSurvivors.join().duration, result.duration.plus(evaluateTimer.getTime()), timer.stop().getTime());
        int killCount = ((FilterResult)filteredOffspring.join().result).killCount + ((FilterResult)filteredSurvivors.join().result).killCount;
        int invalidCount = ((FilterResult)filteredOffspring.join().result).invalidCount + ((FilterResult)filteredSurvivors.join().result).invalidCount;
        return (EvolutionResult)this._mapper.apply(EvolutionResult.of(this._optimize, (ISeq)result.result, start.getGeneration(), durations, killCount, invalidCount, ((AltererResult)alteredOffspring.join().result).getAlterations()));
    }

    @Override
    public EvolutionResult<G, C> apply(EvolutionStart<G, C> start) {
        return this.evolve(start);
    }

    private ISeq<Phenotype<G, C>> selectSurvivors(ISeq<Phenotype<G, C>> population) {
        return this._survivorsCount > 0 ? this._survivorsSelector.select(population, this._survivorsCount, this._optimize) : ISeq.empty();
    }

    private ISeq<Phenotype<G, C>> selectOffspring(ISeq<Phenotype<G, C>> population) {
        return this._offspringCount > 0 ? this._offspringSelector.select(population, this._offspringCount, this._optimize) : ISeq.empty();
    }

    private FilterResult<G, C> filter(Seq<Phenotype<G, C>> population, long generation) {
        int killCount = 0;
        int invalidCount = 0;
        MSeq<Phenotype<G, C>> pop = MSeq.of(population);
        int n = pop.size();
        for (int i = 0; i < n; ++i) {
            Phenotype individual = (Phenotype)pop.get(i);
            if (!this._validator.test(individual)) {
                pop.set(i, this.newPhenotype(generation));
                ++invalidCount;
                continue;
            }
            if (individual.getAge(generation) <= this._maximalPhenotypeAge) continue;
            pop.set(i, this.newPhenotype(generation));
            ++killCount;
        }
        return new FilterResult<G, C>(pop.toISeq(), killCount, invalidCount);
    }

    private Phenotype<G, C> newPhenotype(long generation) {
        Phenotype<G, ? extends C> phenotype;
        int count = 0;
        do {
            phenotype = Phenotype.of(this._genotypeFactory.newInstance(), generation, this._fitnessFunction, this._fitnessScaler);
        } while (++count < this._individualCreationRetries && !this._validator.test(phenotype));
        return phenotype;
    }

    @Override
    @Deprecated
    public Iterator<EvolutionResult<G, C>> iterator(Supplier<EvolutionStart<G, C>> start) {
        return new EvolutionIterator<G, C>(this.evolutionStart(start), this::evolve);
    }

    @Override
    @Deprecated
    public Iterator<EvolutionResult<G, C>> iterator(EvolutionInit<G> init) {
        return this.iterator(this.evolutionStart(init));
    }

    @Override
    public EvolutionStream<G, C> stream(Supplier<EvolutionStart<G, C>> start) {
        return EvolutionStream.of(this.evolutionStart(start), this::evolve);
    }

    @Override
    public EvolutionStream<G, C> stream(EvolutionInit<G> init) {
        return this.stream(this.evolutionStart(init));
    }

    private Supplier<EvolutionStart<G, C>> evolutionStart(Supplier<EvolutionStart<G, C>> start) {
        return () -> {
            EvolutionStart es = (EvolutionStart)start.get();
            ISeq population = es.getPopulation();
            long generation = es.getGeneration();
            Stream<Phenotype> stream = Stream.concat(population.stream().map(this::toFixedPhenotype), Stream.generate(() -> this.newPhenotype(generation)));
            ISeq pop = stream.limit(this.getPopulationSize()).collect(ISeq.toISeq());
            return EvolutionStart.of(pop, generation);
        };
    }

    private Phenotype<G, C> toFixedPhenotype(Phenotype<G, C> pt) {
        return pt.getFitnessFunction() == this._fitnessFunction && pt.getFitnessScaler() == this._fitnessScaler ? pt : pt.newInstance(pt.getGeneration(), this._fitnessFunction, this._fitnessScaler);
    }

    private Supplier<EvolutionStart<G, C>> evolutionStart(EvolutionInit<G> init) {
        return this.evolutionStart(() -> EvolutionStart.of(init.getPopulation().map(gt -> Phenotype.of(gt, init.getGeneration(), this._fitnessFunction, this._fitnessScaler)), init.getGeneration()));
    }

    public Function<? super Genotype<G>, ? extends C> getFitnessFunction() {
        return this._fitnessFunction;
    }

    public Function<? super C, ? extends C> getFitnessScaler() {
        return this._fitnessScaler;
    }

    public Factory<Genotype<G>> getGenotypeFactory() {
        return this._genotypeFactory;
    }

    public Selector<G, C> getSurvivorsSelector() {
        return this._survivorsSelector;
    }

    public Selector<G, C> getOffspringSelector() {
        return this._offspringSelector;
    }

    public Alterer<G, C> getAlterer() {
        return this._alterer;
    }

    public int getOffspringCount() {
        return this._offspringCount;
    }

    public int getSurvivorsCount() {
        return this._survivorsCount;
    }

    public int getPopulationSize() {
        return this._offspringCount + this._survivorsCount;
    }

    public long getMaximalPhenotypeAge() {
        return this._maximalPhenotypeAge;
    }

    public Optimize getOptimize() {
        return this._optimize;
    }

    public Clock getClock() {
        return this._clock;
    }

    public Executor getExecutor() {
        return this._executor.get();
    }

    public int getIndividualCreationRetries() {
        return this._individualCreationRetries;
    }

    public UnaryOperator<EvolutionResult<G, C>> getMapper() {
        return this._mapper;
    }

    public Builder<G, C> builder() {
        return new Builder<G, C>(this._genotypeFactory, this._fitnessFunction).alterers(this._alterer, new Alterer[0]).clock(this._clock).evaluator(this._evaluator).executor(this._executor.get()).fitnessScaler(this._fitnessScaler).maximalPhenotypeAge(this._maximalPhenotypeAge).offspringFraction((double)this._offspringCount / (double)this.getPopulationSize()).offspringSelector(this._offspringSelector).optimize(this._optimize).phenotypeValidator(this._validator).populationSize(this.getPopulationSize()).survivorsSelector(this._survivorsSelector).individualCreationRetries(this._individualCreationRetries).mapping(this._mapper);
    }

    public static <T, G extends Gene<?, G>, C extends Comparable<? super C>> Builder<G, C> builder(Problem<T, G, C> problem) {
        return Engine.builder(problem.fitness(), problem.codec());
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> Builder<G, C> builder(Function<? super Genotype<G>, ? extends C> ff, Factory<Genotype<G>> genotypeFactory) {
        return new Builder(genotypeFactory, ff);
    }

    @SafeVarargs
    public static <G extends Gene<?, G>, C extends Comparable<? super C>> Builder<G, C> builder(Function<? super Genotype<G>, ? extends C> ff, Chromosome<G> chromosome, Chromosome<G> ... chromosomes) {
        return new Builder(Genotype.of(chromosome, chromosomes), ff);
    }

    public static <T, G extends Gene<?, G>, C extends Comparable<? super C>> Builder<G, C> builder(Function<? super T, ? extends C> ff, Codec<T, G> codec) {
        return Engine.builder(ff.compose(codec.decoder()), codec.encoding());
    }

    public static final class Builder<G extends Gene<?, G>, C extends Comparable<? super C>>
    implements Copyable<Builder<G, C>> {
        private Function<? super Genotype<G>, ? extends C> _fitnessFunction;
        private Factory<Genotype<G>> _genotypeFactory;
        private Function<? super C, ? extends C> _fitnessScaler = a -> a;
        private Selector<G, C> _survivorsSelector = new TournamentSelector(3);
        private Selector<G, C> _offspringSelector = new TournamentSelector(3);
        private Alterer<G, C> _alterer = Alterer.of(new SinglePointCrossover(0.2), new Mutator(0.15));
        private Predicate<? super Phenotype<G, C>> _validator = Phenotype::isValid;
        private Optimize _optimize = Optimize.MAXIMUM;
        private double _offspringFraction = 0.6;
        private int _populationSize = 50;
        private long _maximalPhenotypeAge = 70L;
        private Executor _executor = ForkJoinPool.commonPool();
        private Clock _clock = NanoClock.systemUTC();
        private Evaluator<G, C> _evaluator;
        private int _individualCreationRetries = 10;
        private UnaryOperator<EvolutionResult<G, C>> _mapper = r -> r;

        private Builder(Factory<Genotype<G>> genotypeFactory, Function<? super Genotype<G>, ? extends C> fitnessFunction) {
            this._genotypeFactory = Objects.requireNonNull(genotypeFactory);
            this._fitnessFunction = Objects.requireNonNull(fitnessFunction);
        }

        public Builder<G, C> fitnessFunction(Function<? super Genotype<G>, ? extends C> function) {
            this._fitnessFunction = Objects.requireNonNull(function);
            return this;
        }

        public Builder<G, C> fitnessScaler(Function<? super C, ? extends C> scaler) {
            this._fitnessScaler = Objects.requireNonNull(scaler);
            return this;
        }

        public Builder<G, C> genotypeFactory(Factory<Genotype<G>> genotypeFactory) {
            this._genotypeFactory = Objects.requireNonNull(genotypeFactory);
            return this;
        }

        public Builder<G, C> offspringSelector(Selector<G, C> selector) {
            this._offspringSelector = Objects.requireNonNull(selector);
            return this;
        }

        public Builder<G, C> survivorsSelector(Selector<G, C> selector) {
            this._survivorsSelector = Objects.requireNonNull(selector);
            return this;
        }

        public Builder<G, C> selector(Selector<G, C> selector) {
            this._offspringSelector = Objects.requireNonNull(selector);
            this._survivorsSelector = Objects.requireNonNull(selector);
            return this;
        }

        @SafeVarargs
        public final Builder<G, C> alterers(Alterer<G, C> first, Alterer<G, C> ... rest) {
            Objects.requireNonNull(first);
            Stream.of(rest).forEach(Objects::requireNonNull);
            this._alterer = rest.length == 0 ? first : Alterer.of(rest).compose(first);
            return this;
        }

        public Builder<G, C> phenotypeValidator(Predicate<? super Phenotype<G, C>> validator) {
            this._validator = Objects.requireNonNull(validator);
            return this;
        }

        public Builder<G, C> genotypeValidator(Predicate<? super Genotype<G>> validator) {
            Objects.requireNonNull(validator);
            this._validator = pt -> validator.test(pt.getGenotype());
            return this;
        }

        public Builder<G, C> optimize(Optimize optimize) {
            this._optimize = Objects.requireNonNull(optimize);
            return this;
        }

        public Builder<G, C> maximizing() {
            return this.optimize(Optimize.MAXIMUM);
        }

        public Builder<G, C> minimizing() {
            return this.optimize(Optimize.MINIMUM);
        }

        public Builder<G, C> offspringFraction(double fraction) {
            this._offspringFraction = require.probability(fraction);
            return this;
        }

        public Builder<G, C> survivorsFraction(double fraction) {
            this._offspringFraction = 1.0 - require.probability(fraction);
            return this;
        }

        public Builder<G, C> offspringSize(int size) {
            if (size < 0) {
                throw new IllegalArgumentException(String.format("Offspring size must be greater or equal zero, but was %s.", size));
            }
            return this.offspringFraction((double)size / (double)this._populationSize);
        }

        public Builder<G, C> survivorsSize(int size) {
            if (size < 0) {
                throw new IllegalArgumentException(String.format("Survivors must be greater or equal zero, but was %s.", size));
            }
            return this.survivorsFraction((double)size / (double)this._populationSize);
        }

        public Builder<G, C> populationSize(int size) {
            if (size < 1) {
                throw new IllegalArgumentException(String.format("Population size must be greater than zero, but was %s.", size));
            }
            this._populationSize = size;
            return this;
        }

        public Builder<G, C> maximalPhenotypeAge(long age) {
            if (age < 1L) {
                throw new IllegalArgumentException(String.format("Phenotype age must be greater than one, but was %s.", age));
            }
            this._maximalPhenotypeAge = age;
            return this;
        }

        public Builder<G, C> executor(Executor executor) {
            this._executor = Objects.requireNonNull(executor);
            return this;
        }

        public Builder<G, C> clock(Clock clock) {
            this._clock = Objects.requireNonNull(clock);
            return this;
        }

        public Builder<G, C> evaluator(Evaluator<G, C> evaluator) {
            this._evaluator = Objects.requireNonNull(evaluator);
            return this;
        }

        public Builder<G, C> evaluator(GenotypeEvaluator<G, C> evaluator) {
            this._evaluator = Evaluator.of(evaluator);
            return this;
        }

        public Builder<G, C> individualCreationRetries(int retries) {
            if (retries < 0) {
                throw new IllegalArgumentException(String.format("Retry count must not be negative: %d", retries));
            }
            this._individualCreationRetries = retries;
            return this;
        }

        public Builder<G, C> mapping(Function<? super EvolutionResult<G, C>, EvolutionResult<G, C>> mapper) {
            this._mapper = Objects.requireNonNull(mapper::apply);
            return this;
        }

        public Engine<G, C> build() {
            return new Engine<G, C>(this._fitnessFunction, this._genotypeFactory, this._fitnessScaler, this._survivorsSelector, this._offspringSelector, this._alterer, this._validator, this._optimize, this.getOffspringCount(), this.getSurvivorsCount(), this._maximalPhenotypeAge, this._executor, this._evaluator != null ? this._evaluator : new ConcurrentEvaluator(this._executor), this._clock, this._individualCreationRetries, this._mapper);
        }

        private int getSurvivorsCount() {
            return this._populationSize - this.getOffspringCount();
        }

        private int getOffspringCount() {
            return (int)Math.round(this._offspringFraction * (double)this._populationSize);
        }

        public Alterer<G, C> getAlterers() {
            return this._alterer;
        }

        public Clock getClock() {
            return this._clock;
        }

        public Executor getExecutor() {
            return this._executor;
        }

        public Function<? super Genotype<G>, ? extends C> getFitnessFunction() {
            return this._fitnessFunction;
        }

        public Function<? super C, ? extends C> getFitnessScaler() {
            return this._fitnessScaler;
        }

        public Factory<Genotype<G>> getGenotypeFactory() {
            return this._genotypeFactory;
        }

        public long getMaximalPhenotypeAge() {
            return this._maximalPhenotypeAge;
        }

        public double getOffspringFraction() {
            return this._offspringFraction;
        }

        public Selector<G, C> getOffspringSelector() {
            return this._offspringSelector;
        }

        public Selector<G, C> getSurvivorsSelector() {
            return this._survivorsSelector;
        }

        public Optimize getOptimize() {
            return this._optimize;
        }

        public int getPopulationSize() {
            return this._populationSize;
        }

        public int getIndividualCreationRetries() {
            return this._individualCreationRetries;
        }

        public UnaryOperator<EvolutionResult<G, C>> getMapper() {
            return this._mapper;
        }

        @Override
        public Builder<G, C> copy() {
            return new Builder<G, C>(this._genotypeFactory, this._fitnessFunction).alterers(this._alterer, new Alterer[0]).clock(this._clock).executor(this._executor).evaluator(this._evaluator).fitnessScaler(this._fitnessScaler).maximalPhenotypeAge(this._maximalPhenotypeAge).offspringFraction(this._offspringFraction).offspringSelector(this._offspringSelector).phenotypeValidator(this._validator).optimize(this._optimize).populationSize(this._populationSize).survivorsSelector(this._survivorsSelector).individualCreationRetries(this._individualCreationRetries).mapping(this._mapper);
        }
    }

    @FunctionalInterface
    public static interface GenotypeEvaluator<G extends Gene<?, G>, C extends Comparable<? super C>> {
        public ISeq<C> evaluate(Seq<Genotype<G>> var1, Function<? super Genotype<G>, ? extends C> var2);
    }

    @FunctionalInterface
    public static interface Evaluator<G extends Gene<?, G>, C extends Comparable<? super C>> {
        public ISeq<Phenotype<G, C>> evaluate(Seq<Phenotype<G, C>> var1);

        public static <G extends Gene<?, G>, C extends Comparable<? super C>> Evaluator<G, C> of(GenotypeEvaluator<G, C> evaluator) {
            Objects.requireNonNull(evaluator);
            return population -> {
                ISeq genotypes = population.stream().filter(pt -> !pt.isEvaluated()).map(Phenotype::getGenotype).collect(ISeq.toISeq());
                if (genotypes.nonEmpty()) {
                    ISeq results = evaluator.evaluate(genotypes, ((Phenotype)population.get(0)).getFitnessFunction());
                    if (genotypes.size() != results.size()) {
                        throw new IllegalStateException(String.format("Expected %d results, but got %d. Check your evaluator function.", genotypes.size(), results.size()));
                    }
                    MSeq evaluated = population.asMSeq();
                    int j = 0;
                    for (int i = 0; i < evaluated.length(); ++i) {
                        if (((Phenotype)population.get(i)).isEvaluated()) continue;
                        evaluated.set(i, ((Phenotype)population.get(i)).withFitness((Comparable)results.get(j++)));
                    }
                    return evaluated.toISeq();
                }
                return population.asISeq();
            };
        }
    }
}

