// SPDX-License-Identifier: Apache-2.0 OR MIT OR Unlicense

// Code auto-generated by piet-gpu-derive

struct AnnoImageRef {
    uint offset;
};

struct AnnoColorRef {
    uint offset;
};

struct AnnoBeginClipRef {
    uint offset;
};

struct AnnoEndClipRef {
    uint offset;
};

struct AnnotatedRef {
    uint offset;
};

struct AnnoImage {
    vec4 bbox;
    float linewidth;
    uint index;
    ivec2 offset;
};

#define AnnoImage_size 28

AnnoImageRef AnnoImage_index(AnnoImageRef ref, uint index) {
    return AnnoImageRef(ref.offset + index * AnnoImage_size);
}

struct AnnoColor {
    vec4 bbox;
    float linewidth;
    uint rgba_color;
};

#define AnnoColor_size 24

AnnoColorRef AnnoColor_index(AnnoColorRef ref, uint index) {
    return AnnoColorRef(ref.offset + index * AnnoColor_size);
}

struct AnnoBeginClip {
    vec4 bbox;
    float linewidth;
};

#define AnnoBeginClip_size 20

AnnoBeginClipRef AnnoBeginClip_index(AnnoBeginClipRef ref, uint index) {
    return AnnoBeginClipRef(ref.offset + index * AnnoBeginClip_size);
}

struct AnnoEndClip {
    vec4 bbox;
};

#define AnnoEndClip_size 16

AnnoEndClipRef AnnoEndClip_index(AnnoEndClipRef ref, uint index) {
    return AnnoEndClipRef(ref.offset + index * AnnoEndClip_size);
}

#define Annotated_Nop 0
#define Annotated_Color 1
#define Annotated_Image 2
#define Annotated_BeginClip 3
#define Annotated_EndClip 4
#define Annotated_size 32

AnnotatedRef Annotated_index(AnnotatedRef ref, uint index) {
    return AnnotatedRef(ref.offset + index * Annotated_size);
}

struct AnnotatedTag {
   uint tag;
   uint flags;
};

AnnoImage AnnoImage_read(Alloc a, AnnoImageRef ref) {
    uint ix = ref.offset >> 2;
    uint raw0 = read_mem(a, ix + 0);
    uint raw1 = read_mem(a, ix + 1);
    uint raw2 = read_mem(a, ix + 2);
    uint raw3 = read_mem(a, ix + 3);
    uint raw4 = read_mem(a, ix + 4);
    uint raw5 = read_mem(a, ix + 5);
    uint raw6 = read_mem(a, ix + 6);
    AnnoImage s;
    s.bbox = vec4(uintBitsToFloat(raw0), uintBitsToFloat(raw1), uintBitsToFloat(raw2), uintBitsToFloat(raw3));
    s.linewidth = uintBitsToFloat(raw4);
    s.index = raw5;
    s.offset = ivec2(int(raw6 << 16) >> 16, int(raw6) >> 16);
    return s;
}

void AnnoImage_write(Alloc a, AnnoImageRef ref, AnnoImage s) {
    uint ix = ref.offset >> 2;
    write_mem(a, ix + 0, floatBitsToUint(s.bbox.x));
    write_mem(a, ix + 1, floatBitsToUint(s.bbox.y));
    write_mem(a, ix + 2, floatBitsToUint(s.bbox.z));
    write_mem(a, ix + 3, floatBitsToUint(s.bbox.w));
    write_mem(a, ix + 4, floatBitsToUint(s.linewidth));
    write_mem(a, ix + 5, s.index);
    write_mem(a, ix + 6, (uint(s.offset.x) & 0xffff) | (uint(s.offset.y) << 16));
}

AnnoColor AnnoColor_read(Alloc a, AnnoColorRef ref) {
    uint ix = ref.offset >> 2;
    uint raw0 = read_mem(a, ix + 0);
    uint raw1 = read_mem(a, ix + 1);
    uint raw2 = read_mem(a, ix + 2);
    uint raw3 = read_mem(a, ix + 3);
    uint raw4 = read_mem(a, ix + 4);
    uint raw5 = read_mem(a, ix + 5);
    AnnoColor s;
    s.bbox = vec4(uintBitsToFloat(raw0), uintBitsToFloat(raw1), uintBitsToFloat(raw2), uintBitsToFloat(raw3));
    s.linewidth = uintBitsToFloat(raw4);
    s.rgba_color = raw5;
    return s;
}

void AnnoColor_write(Alloc a, AnnoColorRef ref, AnnoColor s) {
    uint ix = ref.offset >> 2;
    write_mem(a, ix + 0, floatBitsToUint(s.bbox.x));
    write_mem(a, ix + 1, floatBitsToUint(s.bbox.y));
    write_mem(a, ix + 2, floatBitsToUint(s.bbox.z));
    write_mem(a, ix + 3, floatBitsToUint(s.bbox.w));
    write_mem(a, ix + 4, floatBitsToUint(s.linewidth));
    write_mem(a, ix + 5, s.rgba_color);
}

AnnoBeginClip AnnoBeginClip_read(Alloc a, AnnoBeginClipRef ref) {
    uint ix = ref.offset >> 2;
    uint raw0 = read_mem(a, ix + 0);
    uint raw1 = read_mem(a, ix + 1);
    uint raw2 = read_mem(a, ix + 2);
    uint raw3 = read_mem(a, ix + 3);
    uint raw4 = read_mem(a, ix + 4);
    AnnoBeginClip s;
    s.bbox = vec4(uintBitsToFloat(raw0), uintBitsToFloat(raw1), uintBitsToFloat(raw2), uintBitsToFloat(raw3));
    s.linewidth = uintBitsToFloat(raw4);
    return s;
}

void AnnoBeginClip_write(Alloc a, AnnoBeginClipRef ref, AnnoBeginClip s) {
    uint ix = ref.offset >> 2;
    write_mem(a, ix + 0, floatBitsToUint(s.bbox.x));
    write_mem(a, ix + 1, floatBitsToUint(s.bbox.y));
    write_mem(a, ix + 2, floatBitsToUint(s.bbox.z));
    write_mem(a, ix + 3, floatBitsToUint(s.bbox.w));
    write_mem(a, ix + 4, floatBitsToUint(s.linewidth));
}

AnnoEndClip AnnoEndClip_read(Alloc a, AnnoEndClipRef ref) {
    uint ix = ref.offset >> 2;
    uint raw0 = read_mem(a, ix + 0);
    uint raw1 = read_mem(a, ix + 1);
    uint raw2 = read_mem(a, ix + 2);
    uint raw3 = read_mem(a, ix + 3);
    AnnoEndClip s;
    s.bbox = vec4(uintBitsToFloat(raw0), uintBitsToFloat(raw1), uintBitsToFloat(raw2), uintBitsToFloat(raw3));
    return s;
}

void AnnoEndClip_write(Alloc a, AnnoEndClipRef ref, AnnoEndClip s) {
    uint ix = ref.offset >> 2;
    write_mem(a, ix + 0, floatBitsToUint(s.bbox.x));
    write_mem(a, ix + 1, floatBitsToUint(s.bbox.y));
    write_mem(a, ix + 2, floatBitsToUint(s.bbox.z));
    write_mem(a, ix + 3, floatBitsToUint(s.bbox.w));
}

AnnotatedTag Annotated_tag(Alloc a, AnnotatedRef ref) {
    uint tag_and_flags = read_mem(a, ref.offset >> 2);
    return AnnotatedTag(tag_and_flags & 0xffff, tag_and_flags >> 16);
}

AnnoColor Annotated_Color_read(Alloc a, AnnotatedRef ref) {
    return AnnoColor_read(a, AnnoColorRef(ref.offset + 4));
}

AnnoImage Annotated_Image_read(Alloc a, AnnotatedRef ref) {
    return AnnoImage_read(a, AnnoImageRef(ref.offset + 4));
}

AnnoBeginClip Annotated_BeginClip_read(Alloc a, AnnotatedRef ref) {
    return AnnoBeginClip_read(a, AnnoBeginClipRef(ref.offset + 4));
}

AnnoEndClip Annotated_EndClip_read(Alloc a, AnnotatedRef ref) {
    return AnnoEndClip_read(a, AnnoEndClipRef(ref.offset + 4));
}

void Annotated_Nop_write(Alloc a, AnnotatedRef ref) {
    write_mem(a, ref.offset >> 2, Annotated_Nop);
}

void Annotated_Color_write(Alloc a, AnnotatedRef ref, uint flags, AnnoColor s) {
    write_mem(a, ref.offset >> 2, (flags << 16) | Annotated_Color);
    AnnoColor_write(a, AnnoColorRef(ref.offset + 4), s);
}

void Annotated_Image_write(Alloc a, AnnotatedRef ref, uint flags, AnnoImage s) {
    write_mem(a, ref.offset >> 2, (flags << 16) | Annotated_Image);
    AnnoImage_write(a, AnnoImageRef(ref.offset + 4), s);
}

void Annotated_BeginClip_write(Alloc a, AnnotatedRef ref, uint flags, AnnoBeginClip s) {
    write_mem(a, ref.offset >> 2, (flags << 16) | Annotated_BeginClip);
    AnnoBeginClip_write(a, AnnoBeginClipRef(ref.offset + 4), s);
}

void Annotated_EndClip_write(Alloc a, AnnotatedRef ref, AnnoEndClip s) {
    write_mem(a, ref.offset >> 2, Annotated_EndClip);
    AnnoEndClip_write(a, AnnoEndClipRef(ref.offset + 4), s);
}

