/* engine.c generated by valac 0.38.1.30-90885, the Vala compiler
 * generated from engine.vala, do not modify */

/* 
 * Copyright (C) 2011-2017 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2017 Red Hat, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <libskk/libskk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libutil.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <locale.h>
#include <stdio.h>


#define TYPE_SKK_ENGINE (skk_engine_get_type ())
#define SKK_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SKK_ENGINE, SkkEngine))
#define SKK_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SKK_ENGINE, SkkEngineClass))
#define IS_SKK_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SKK_ENGINE))
#define IS_SKK_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SKK_ENGINE))
#define SKK_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SKK_ENGINE, SkkEngineClass))

typedef struct _SkkEngine SkkEngine;
typedef struct _SkkEngineClass SkkEngineClass;
typedef struct _SkkEnginePrivate SkkEnginePrivate;
enum  {
	SKK_ENGINE_0_PROPERTY,
	SKK_ENGINE_NUM_PROPERTIES
};
static GParamSpec* skk_engine_properties[SKK_ENGINE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SkkEngine {
	IBusEngine parent_instance;
	SkkEnginePrivate * priv;
};

struct _SkkEngineClass {
	IBusEngineClass parent_class;
};

struct _SkkEnginePrivate {
	SkkContext* context;
	IBusLookupTable* lookup_table;
	guint page_start;
	gboolean lookup_table_visible;
	gboolean show_annotation;
	IBusProperty* input_mode_prop;
	IBusPropList* prop_list;
	gboolean properties_registered;
	GeeMap* input_mode_props;
	GeeMap* input_mode_symbols;
	GeeMap* name_input_modes;
	gchar** LOOKUP_TABLE_LABELS;
	gint LOOKUP_TABLE_LABELS_length1;
	gint _LOOKUP_TABLE_LABELS_size_;
};


static gpointer skk_engine_parent_class = NULL;
static Preferences* skk_engine_preferences;
static Preferences* skk_engine_preferences = NULL;
static GeeArrayList* skk_engine_dictionaries;
static GeeArrayList* skk_engine_dictionaries = NULL;
static gboolean skk_engine_ibus;
static gboolean skk_engine_ibus = FALSE;

GType skk_engine_get_type (void) G_GNUC_CONST;
#define SKK_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SKK_ENGINE, SkkEnginePrivate))
static gboolean _skk_engine_retrieve_surrounding_text (SkkEngine* self, gchar* * text, guint* cursor_pos);
static gboolean _skk_engine_delete_surrounding_text (SkkEngine* self, gint offset, guint nchars);
static void skk_engine_populate_lookup_table (SkkEngine* self);
static void skk_engine_set_lookup_table_cursor_pos (SkkEngine* self);
static void skk_engine_update_preedit (SkkEngine* self);
static void skk_engine_update_candidates (SkkEngine* self);
static void skk_engine_update_input_mode (SkkEngine* self);
static SkkDict* skk_engine_parse_dict_from_plist (PList* plist, GError** error);
static void skk_engine_reload_dictionaries (void);
static void skk_engine_apply_preferences (SkkEngine* self);
static IBusProperty* skk_engine_register_input_mode_property (SkkEngine* self, SkkInputMode mode, const gchar* name, const gchar* label, const gchar* symbol);
static gboolean skk_engine_process_lookup_table_key_event (SkkEngine* self, guint keyval, guint keycode, guint state);
static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle);
static gboolean skk_engine_real_process_key_event (IBusEngine* base, guint keyval, guint keycode, guint state);
static void skk_engine_real_enable (IBusEngine* base);
static void skk_engine_real_disable (IBusEngine* base);
static void skk_engine_real_reset (IBusEngine* base);
static void skk_engine_real_focus_in (IBusEngine* base);
static void skk_engine_real_focus_out (IBusEngine* base);
static void skk_engine_real_property_activate (IBusEngine* base, const gchar* prop_name, guint prop_state);
static void skk_engine_real_candidate_clicked (IBusEngine* base, guint index, guint button, guint state);
static void skk_engine_real_cursor_up (IBusEngine* base);
static void skk_engine_real_cursor_down (IBusEngine* base);
static void skk_engine_real_page_up (IBusEngine* base);
static void skk_engine_real_page_down (IBusEngine* base);
gint skk_engine_main (gchar** args, int args_length1);
static void __lambda4_ (void);
static void ___lambda4__ibus_bus_disconnected (IBusBus* _sender, gpointer self);
static void __lambda5_ (const gchar* name, GVariant* value);
static void ___lambda5__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self);
SkkEngine* skk_engine_new (void);
SkkEngine* skk_engine_construct (GType object_type);
static GObject * skk_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _skk_engine___lambda6_ (SkkEngine* self, const gchar* name, GVariant* value);
static void __skk_engine___lambda6__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self);
static void _skk_engine___lambda7_ (SkkEngine* self);
static void __skk_engine___lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _skk_engine___lambda8_ (SkkEngine* self, GObject* s, GParamSpec* p);
static void __skk_engine___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _skk_engine___lambda9_ (SkkEngine* self);
static void __skk_engine___lambda9__skk_candidate_list_populated (SkkCandidateList* _sender, gpointer self);
static void _skk_engine___lambda10_ (SkkEngine* self);
static void __skk_engine___lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _skk_engine___lambda11_ (SkkEngine* self);
static void __skk_engine___lambda11__skk_candidate_list_selected (SkkCandidateList* _sender, SkkCandidate* candidate, gpointer self);
static gboolean __skk_engine_retrieve_surrounding_text_skk_context_retrieve_surrounding_text (SkkContext* _sender, gchar* * text, guint* cursor_pos, gpointer self);
static gboolean __skk_engine_delete_surrounding_text_skk_context_delete_surrounding_text (SkkContext* _sender, gint offset, guint nchars, gpointer self);
static void skk_engine_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry SKK_ENGINE_options[2] = {{"ibus", 'i', 0, G_OPTION_ARG_NONE, &skk_engine_ibus, N_ ("Component is executed by IBus"), NULL}, {NULL}};

static gboolean _skk_engine_retrieve_surrounding_text (SkkEngine* self, gchar* * text, guint* cursor_pos) {
	gchar* _vala_text = NULL;
	guint _vala_cursor_pos = 0U;
	gboolean result = FALSE;
	IBusText* _text = NULL;
	guint _cursor_pos = 0U;
	guint anchor_pos = 0U;
	IBusText* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	ibus_engine_get_surrounding_text ((IBusEngine*) self, &_tmp0_, &_tmp1_, &_tmp2_);
	_text = _tmp0_;
	_cursor_pos = _tmp1_;
	anchor_pos = _tmp2_;
	_tmp3_ = _text->text;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_vala_text);
	_vala_text = _tmp4_;
	_vala_cursor_pos = _cursor_pos;
	result = TRUE;
	if (text) {
		*text = _vala_text;
	} else {
		_g_free0 (_vala_text);
	}
	if (cursor_pos) {
		*cursor_pos = _vala_cursor_pos;
	}
	return result;
}


static gboolean _skk_engine_delete_surrounding_text (SkkEngine* self, gint offset, guint nchars) {
	gboolean result = FALSE;
	gint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = offset;
	_tmp1_ = nchars;
	ibus_engine_delete_surrounding_text ((IBusEngine*) self, _tmp0_, _tmp1_);
	result = TRUE;
	return result;
}


static void skk_engine_populate_lookup_table (SkkEngine* self) {
	IBusLookupTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->lookup_table;
	ibus_lookup_table_clear (_tmp0_);
	{
		gint i = 0;
		guint _tmp1_;
		_tmp1_ = self->priv->page_start;
		i = (gint) _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				SkkContext* _tmp5_;
				SkkCandidateList* _tmp6_;
				SkkCandidateList* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				IBusText* text = NULL;
				SkkContext* _tmp10_;
				SkkCandidateList* _tmp11_;
				SkkCandidateList* _tmp12_;
				gint _tmp13_;
				SkkCandidate* _tmp14_;
				SkkCandidate* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				IBusText* _tmp18_;
				IBusText* _tmp19_;
				IBusLookupTable* _tmp20_;
				IBusText* _tmp21_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->priv->context;
				_tmp6_ = skk_context_get_candidates (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = skk_candidate_list_get_size (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!(_tmp4_ < _tmp9_)) {
					break;
				}
				_tmp10_ = self->priv->context;
				_tmp11_ = skk_context_get_candidates (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = i;
				_tmp14_ = skk_candidate_list_get (_tmp12_, _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = skk_candidate_get_output (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = ibus_text_new_from_string (_tmp17_);
				g_object_ref_sink (_tmp18_);
				_tmp19_ = _tmp18_;
				_g_object_unref0 (_tmp15_);
				text = _tmp19_;
				_tmp20_ = self->priv->lookup_table;
				_tmp21_ = text;
				ibus_lookup_table_append_candidate (_tmp20_, _tmp21_);
				_g_object_unref0 (text);
			}
		}
	}
}


static void skk_engine_set_lookup_table_cursor_pos (SkkEngine* self) {
	IBusText* empty_text = NULL;
	IBusText* _tmp0_;
	gint cursor_pos = 0;
	SkkContext* _tmp1_;
	SkkCandidateList* _tmp2_;
	SkkCandidateList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	SkkContext* _tmp6_;
	SkkCandidateList* _tmp7_;
	SkkCandidateList* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ibus_text_new_from_static_string ("");
	g_object_ref_sink (_tmp0_);
	empty_text = _tmp0_;
	_tmp1_ = self->priv->context;
	_tmp2_ = skk_context_get_candidates (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = skk_candidate_list_get_cursor_pos (_tmp3_);
	_tmp5_ = _tmp4_;
	cursor_pos = _tmp5_;
	_tmp6_ = self->priv->context;
	_tmp7_ = skk_context_get_candidates (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = skk_candidate_list_get_page_visible (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		IBusLookupTable* _tmp11_;
		gint _tmp12_;
		SkkContext* _tmp13_;
		SkkCandidateList* _tmp14_;
		SkkCandidateList* _tmp15_;
		guint _tmp16_;
		guint _tmp17_;
		IBusLookupTable* _tmp18_;
		SkkCandidate* candidate = NULL;
		SkkContext* _tmp19_;
		SkkCandidateList* _tmp20_;
		SkkCandidateList* _tmp21_;
		SkkCandidate* _tmp22_;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_;
		_tmp11_ = self->priv->lookup_table;
		_tmp12_ = cursor_pos;
		_tmp13_ = self->priv->context;
		_tmp14_ = skk_context_get_candidates (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = skk_candidate_list_get_page_start (_tmp15_);
		_tmp17_ = _tmp16_;
		ibus_lookup_table_set_cursor_pos (_tmp11_, _tmp12_ - _tmp17_);
		_tmp18_ = self->priv->lookup_table;
		ibus_engine_update_lookup_table_fast ((IBusEngine*) self, _tmp18_, TRUE);
		_tmp19_ = self->priv->context;
		_tmp20_ = skk_context_get_candidates (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = skk_candidate_list_get (_tmp21_, -1);
		candidate = _tmp22_;
		_tmp24_ = self->priv->show_annotation;
		if (_tmp24_) {
			SkkCandidate* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			_tmp25_ = candidate;
			_tmp26_ = skk_candidate_get_annotation (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp23_ = _tmp27_ != NULL;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			IBusText* text = NULL;
			SkkCandidate* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			IBusText* _tmp31_;
			IBusText* _tmp32_;
			_tmp28_ = candidate;
			_tmp29_ = skk_candidate_get_annotation (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = ibus_text_new_from_string (_tmp30_);
			g_object_ref_sink (_tmp31_);
			text = _tmp31_;
			_tmp32_ = text;
			ibus_engine_update_auxiliary_text ((IBusEngine*) self, _tmp32_, TRUE);
			_g_object_unref0 (text);
		} else {
			IBusText* _tmp33_;
			_tmp33_ = empty_text;
			ibus_engine_update_auxiliary_text ((IBusEngine*) self, _tmp33_, FALSE);
		}
		self->priv->lookup_table_visible = TRUE;
		_g_object_unref0 (candidate);
	} else {
		gboolean _tmp34_;
		_tmp34_ = self->priv->lookup_table_visible;
		if (_tmp34_) {
			ibus_engine_hide_lookup_table ((IBusEngine*) self);
			ibus_engine_hide_auxiliary_text ((IBusEngine*) self);
			self->priv->lookup_table_visible = FALSE;
		}
	}
	_g_object_unref0 (empty_text);
}


static void skk_engine_update_preedit (SkkEngine* self) {
	IBusText* text = NULL;
	SkkContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	IBusText* _tmp3_;
	guint underline_offset = 0U;
	guint underline_nchars = 0U;
	SkkContext* _tmp4_;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_;
	IBusText* _tmp12_;
	IBusText* _tmp13_;
	guint _tmp14_;
	IBusText* _tmp15_;
	guint _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_preedit (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ibus_text_new_from_string (_tmp2_);
	g_object_ref_sink (_tmp3_);
	text = _tmp3_;
	_tmp4_ = self->priv->context;
	skk_context_get_preedit_underline (_tmp4_, &_tmp5_, &_tmp6_);
	underline_offset = _tmp5_;
	underline_nchars = _tmp6_;
	_tmp7_ = underline_nchars;
	if (((guint) 0) < _tmp7_) {
		IBusText* _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		guint _tmp11_;
		_tmp8_ = text;
		_tmp9_ = underline_offset;
		_tmp10_ = underline_offset;
		_tmp11_ = underline_nchars;
		ibus_text_append_attribute (_tmp8_, (guint) IBUS_ATTR_TYPE_UNDERLINE, (guint) IBUS_ATTR_UNDERLINE_SINGLE, (guint) ((gint) _tmp9_), (gint) (_tmp10_ + _tmp11_));
	}
	_tmp12_ = text;
	_tmp13_ = text;
	_tmp14_ = ibus_text_get_length (_tmp13_);
	_tmp15_ = text;
	_tmp16_ = ibus_text_get_length (_tmp15_);
	ibus_engine_update_preedit_text ((IBusEngine*) self, _tmp12_, _tmp14_, _tmp16_ > ((guint) 0));
	_g_object_unref0 (text);
}


static void skk_engine_update_candidates (SkkEngine* self) {
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	guint _tmp3_;
	SkkContext* _tmp4_;
	SkkCandidateList* _tmp5_;
	SkkCandidateList* _tmp6_;
	IBusLookupTable* _tmp7_;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->page_start;
	skk_candidate_list_set_page_start (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->context;
	_tmp5_ = skk_context_get_candidates (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->lookup_table;
	_tmp8_ = ibus_lookup_table_get_page_size (_tmp7_);
	skk_candidate_list_set_page_size (_tmp6_, _tmp8_);
	skk_engine_populate_lookup_table (self);
	skk_engine_set_lookup_table_cursor_pos (self);
}


static void skk_engine_update_input_mode (SkkEngine* self) {
	GeeMapIterator* iter = NULL;
	GeeMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	IBusText* symbol = NULL;
	GeeMap* _tmp16_;
	SkkContext* _tmp17_;
	SkkInputMode _tmp18_;
	SkkInputMode _tmp19_;
	gpointer _tmp20_;
	gchar* _tmp21_;
	IBusText* _tmp22_;
	IBusText* _tmp23_;
	IBusText* label = NULL;
	IBusText* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	IBusText* _tmp28_;
	IBusText* _tmp29_;
	IBusProperty* _tmp30_;
	IBusText* _tmp31_;
	IBusProperty* _tmp32_;
	IBusText* _tmp33_;
	gboolean _tmp34_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input_mode_props;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		gboolean _tmp3_;
		SkkInputMode input_mode = 0;
		GeeMapIterator* _tmp4_;
		gpointer _tmp5_;
		IBusProperty* prop = NULL;
		GeeMapIterator* _tmp6_;
		gpointer _tmp7_;
		SkkInputMode _tmp8_;
		SkkContext* _tmp9_;
		SkkInputMode _tmp10_;
		SkkInputMode _tmp11_;
		gboolean _tmp14_;
		_tmp2_ = iter;
		_tmp3_ = gee_map_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_map_iterator_get_key (_tmp4_);
		input_mode = (SkkInputMode) ((gintptr) _tmp5_);
		_tmp6_ = iter;
		_tmp7_ = gee_map_iterator_get_value (_tmp6_);
		prop = (IBusProperty*) _tmp7_;
		_tmp8_ = input_mode;
		_tmp9_ = self->priv->context;
		_tmp10_ = skk_context_get_input_mode (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp8_ == _tmp11_) {
			IBusProperty* _tmp12_;
			_tmp12_ = prop;
			ibus_property_set_state (_tmp12_, PROP_STATE_CHECKED);
		} else {
			IBusProperty* _tmp13_;
			_tmp13_ = prop;
			ibus_property_set_state (_tmp13_, PROP_STATE_UNCHECKED);
		}
		_tmp14_ = self->priv->properties_registered;
		if (_tmp14_) {
			IBusProperty* _tmp15_;
			_tmp15_ = prop;
			ibus_engine_update_property ((IBusEngine*) self, _tmp15_);
		}
		_g_object_unref0 (prop);
	}
	_tmp16_ = self->priv->input_mode_symbols;
	_tmp17_ = self->priv->context;
	_tmp18_ = skk_context_get_input_mode (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = gee_map_get (_tmp16_, (gpointer) ((gintptr) _tmp19_));
	_tmp21_ = (gchar*) _tmp20_;
	_tmp22_ = ibus_text_new_from_string (_tmp21_);
	g_object_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	symbol = _tmp23_;
	_tmp24_ = symbol;
	_tmp25_ = _tmp24_->text;
	_tmp26_ = g_strdup_printf (_ ("Input Mode (%s)"), _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = ibus_text_new_from_string (_tmp27_);
	g_object_ref_sink (_tmp28_);
	_tmp29_ = _tmp28_;
	_g_free0 (_tmp27_);
	label = _tmp29_;
	_tmp30_ = self->priv->input_mode_prop;
	_tmp31_ = label;
	ibus_property_set_label (_tmp30_, _tmp31_);
	_tmp32_ = self->priv->input_mode_prop;
	_tmp33_ = symbol;
	ibus_property_set_symbol (_tmp32_, _tmp33_);
	_tmp34_ = self->priv->properties_registered;
	if (_tmp34_) {
		IBusProperty* _tmp35_;
		_tmp35_ = self->priv->input_mode_prop;
		ibus_engine_update_property ((IBusEngine*) self, _tmp35_);
	}
	_g_object_unref0 (label);
	_g_object_unref0 (symbol);
	_g_object_unref0 (iter);
}


static SkkDict* skk_engine_parse_dict_from_plist (PList* plist, GError** error) {
	SkkDict* result = NULL;
	gchar* _tmp0_ = NULL;
	PList* _tmp1_;
	gchar* _tmp2_;
	gchar* encoding = NULL;
	gchar* _tmp4_;
	gchar* type = NULL;
	PList* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (plist != NULL, NULL);
	_tmp1_ = plist;
	_tmp2_ = plist_get (_tmp1_, "encoding");
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("EUC-JP");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = g_strdup (_tmp0_);
	encoding = _tmp4_;
	_tmp5_ = plist;
	_tmp6_ = plist_get (_tmp5_, "type");
	type = _tmp6_;
	_tmp7_ = type;
	if (g_strcmp0 (_tmp7_, "file") == 0) {
		gchar* file = NULL;
		PList* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		PList* _tmp12_;
		gchar* _tmp13_;
		gchar* mode = NULL;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp8_ = plist;
		_tmp9_ = plist_get (_tmp8_, "file");
		file = _tmp9_;
		_tmp10_ = file;
		if (_tmp10_ == NULL) {
			result = NULL;
			_g_free0 (file);
			_g_free0 (type);
			_g_free0 (encoding);
			_g_free0 (_tmp0_);
			return result;
		}
		_tmp12_ = plist;
		_tmp13_ = plist_get (_tmp12_, "mode");
		_tmp11_ = _tmp13_;
		if (_tmp11_ == NULL) {
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("readonly");
			_g_free0 (_tmp11_);
			_tmp11_ = _tmp14_;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		mode = _tmp15_;
		_tmp16_ = mode;
		if (g_strcmp0 (_tmp16_, "readonly") == 0) {
			const gchar* _tmp17_;
			gboolean _tmp18_;
			_tmp17_ = file;
			_tmp18_ = g_str_has_suffix (_tmp17_, ".cdb");
			if (_tmp18_) {
				SkkCdbDict* _tmp19_ = NULL;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				SkkCdbDict* _tmp22_;
				SkkCdbDict* _tmp23_;
				_tmp20_ = file;
				_tmp21_ = encoding;
				_tmp22_ = skk_cdb_dict_new (_tmp20_, _tmp21_, &_inner_error_);
				_tmp19_ = _tmp22_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (mode);
					_g_free0 (_tmp11_);
					_g_free0 (file);
					_g_free0 (type);
					_g_free0 (encoding);
					_g_free0 (_tmp0_);
					return NULL;
				}
				_tmp23_ = _tmp19_;
				_tmp19_ = NULL;
				result = (SkkDict*) _tmp23_;
				_g_object_unref0 (_tmp19_);
				_g_free0 (mode);
				_g_free0 (_tmp11_);
				_g_free0 (file);
				_g_free0 (type);
				_g_free0 (encoding);
				_g_free0 (_tmp0_);
				return result;
			} else {
				SkkFileDict* _tmp24_ = NULL;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				SkkFileDict* _tmp27_;
				SkkFileDict* _tmp28_;
				_tmp25_ = file;
				_tmp26_ = encoding;
				_tmp27_ = skk_file_dict_new (_tmp25_, _tmp26_, &_inner_error_);
				_tmp24_ = _tmp27_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (mode);
					_g_free0 (_tmp11_);
					_g_free0 (file);
					_g_free0 (type);
					_g_free0 (encoding);
					_g_free0 (_tmp0_);
					return NULL;
				}
				_tmp28_ = _tmp24_;
				_tmp24_ = NULL;
				result = (SkkDict*) _tmp28_;
				_g_object_unref0 (_tmp24_);
				_g_free0 (mode);
				_g_free0 (_tmp11_);
				_g_free0 (file);
				_g_free0 (type);
				_g_free0 (encoding);
				_g_free0 (_tmp0_);
				return result;
			}
		} else {
			const gchar* _tmp29_;
			_tmp29_ = mode;
			if (g_strcmp0 (_tmp29_, "readwrite") == 0) {
				SkkUserDict* _tmp30_ = NULL;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				SkkUserDict* _tmp33_;
				SkkUserDict* _tmp34_;
				_tmp31_ = file;
				_tmp32_ = encoding;
				_tmp33_ = skk_user_dict_new (_tmp31_, _tmp32_, &_inner_error_);
				_tmp30_ = _tmp33_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (mode);
					_g_free0 (_tmp11_);
					_g_free0 (file);
					_g_free0 (type);
					_g_free0 (encoding);
					_g_free0 (_tmp0_);
					return NULL;
				}
				_tmp34_ = _tmp30_;
				_tmp30_ = NULL;
				result = (SkkDict*) _tmp34_;
				_g_object_unref0 (_tmp30_);
				_g_free0 (mode);
				_g_free0 (_tmp11_);
				_g_free0 (file);
				_g_free0 (type);
				_g_free0 (encoding);
				_g_free0 (_tmp0_);
				return result;
			}
		}
		_g_free0 (mode);
		_g_free0 (_tmp11_);
		_g_free0 (file);
	} else {
		const gchar* _tmp35_;
		_tmp35_ = type;
		if (g_strcmp0 (_tmp35_, "server") == 0) {
			gchar* _tmp36_ = NULL;
			PList* _tmp37_;
			gchar* _tmp38_;
			gchar* host = NULL;
			gchar* _tmp40_;
			gchar* _tmp41_ = NULL;
			PList* _tmp42_;
			gchar* _tmp43_;
			gchar* port = NULL;
			gchar* _tmp45_;
			SkkSkkServ* _tmp46_ = NULL;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			gint _tmp49_;
			const gchar* _tmp50_;
			SkkSkkServ* _tmp51_;
			SkkSkkServ* _tmp52_;
			_tmp37_ = plist;
			_tmp38_ = plist_get (_tmp37_, "host");
			_tmp36_ = _tmp38_;
			if (_tmp36_ == NULL) {
				gchar* _tmp39_;
				_tmp39_ = g_strdup ("localhost");
				_g_free0 (_tmp36_);
				_tmp36_ = _tmp39_;
			}
			_tmp40_ = g_strdup (_tmp36_);
			host = _tmp40_;
			_tmp42_ = plist;
			_tmp43_ = plist_get (_tmp42_, "port");
			_tmp41_ = _tmp43_;
			if (_tmp41_ == NULL) {
				gchar* _tmp44_;
				_tmp44_ = g_strdup ("1178");
				_g_free0 (_tmp41_);
				_tmp41_ = _tmp44_;
			}
			_tmp45_ = g_strdup (_tmp41_);
			port = _tmp45_;
			_tmp47_ = host;
			_tmp48_ = port;
			_tmp49_ = atoi (_tmp48_);
			_tmp50_ = encoding;
			_tmp51_ = skk_skk_serv_new (_tmp47_, (guint16) _tmp49_, _tmp50_, &_inner_error_);
			_tmp46_ = _tmp51_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (port);
				_g_free0 (_tmp41_);
				_g_free0 (host);
				_g_free0 (_tmp36_);
				_g_free0 (type);
				_g_free0 (encoding);
				_g_free0 (_tmp0_);
				return NULL;
			}
			_tmp52_ = _tmp46_;
			_tmp46_ = NULL;
			result = (SkkDict*) _tmp52_;
			_g_object_unref0 (_tmp46_);
			_g_free0 (port);
			_g_free0 (_tmp41_);
			_g_free0 (host);
			_g_free0 (_tmp36_);
			_g_free0 (type);
			_g_free0 (encoding);
			_g_free0 (_tmp0_);
			return result;
		}
	}
	result = NULL;
	_g_free0 (type);
	_g_free0 (encoding);
	_g_free0 (_tmp0_);
	return result;
}


static void skk_engine_reload_dictionaries (void) {
	GeeArrayList* _tmp0_;
	GVariant* variant = NULL;
	Preferences* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gchar** strv = NULL;
	GVariant* _tmp4_;
	size_t _tmp5_;
	gchar** _tmp6_;
	gint strv_length1;
	gint _strv_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = skk_engine_dictionaries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = skk_engine_preferences;
	_tmp2_ = preferences_get (_tmp1_, "dictionaries");
	variant = _tmp2_;
	_tmp3_ = variant;
	_vala_assert (_tmp3_ != NULL, "variant != null");
	_tmp4_ = variant;
	_tmp6_ = g_variant_dup_strv (_tmp4_, &_tmp5_);
	strv = _tmp6_;
	strv_length1 = _tmp5_;
	_strv_size_ = strv_length1;
	_tmp7_ = strv;
	_tmp7__length1 = strv_length1;
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
		str_collection = _tmp7_;
		str_collection_length1 = _tmp7__length1;
		for (str_it = 0; str_it < _tmp7__length1; str_it = str_it + 1) {
			gchar* _tmp8_;
			gchar* str = NULL;
			_tmp8_ = g_strdup (str_collection[str_it]);
			str = _tmp8_;
			{
				{
					PList* plist = NULL;
					const gchar* _tmp9_;
					PList* _tmp10_;
					SkkDict* dict = NULL;
					PList* _tmp11_;
					SkkDict* _tmp12_;
					SkkDict* _tmp13_;
					_tmp9_ = str;
					_tmp10_ = plist_new (_tmp9_, &_inner_error_);
					plist = _tmp10_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == PLIST_PARSE_ERROR) {
							goto __catch0_plist_parse_error;
						}
						goto __catch0_g_error;
					}
					_tmp11_ = plist;
					_tmp12_ = skk_engine_parse_dict_from_plist (_tmp11_, &_inner_error_);
					dict = _tmp12_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (plist);
						if (_inner_error_->domain == PLIST_PARSE_ERROR) {
							goto __catch0_plist_parse_error;
						}
						goto __catch0_g_error;
					}
					_tmp13_ = dict;
					if (_tmp13_ != NULL) {
						GeeArrayList* _tmp14_;
						SkkDict* _tmp15_;
						_tmp14_ = skk_engine_dictionaries;
						_tmp15_ = dict;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
					}
					_g_object_unref0 (dict);
					_g_object_unref0 (plist);
				}
				goto __finally0;
				__catch0_plist_parse_error:
				{
					GError* e = NULL;
					const gchar* _tmp16_;
					GError* _tmp17_;
					const gchar* _tmp18_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp16_ = str;
					_tmp17_ = e;
					_tmp18_ = _tmp17_->message;
					g_warning ("engine.vala:293: can't parse plist \"%s\": %s", _tmp16_, _tmp18_);
					_g_error_free0 (e);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp19_;
					GError* _tmp20_;
					const gchar* _tmp21_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp19_ = str;
					_tmp20_ = e;
					_tmp21_ = _tmp20_->message;
					g_warning ("engine.vala:296: can't open dictionary \"%s\": %s", _tmp19_, _tmp21_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (str);
					strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
					_g_variant_unref0 (variant);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (str);
			}
		}
	}
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (variant);
}


static void skk_engine_apply_preferences (SkkEngine* self) {
	GVariant* variant = NULL;
	Preferences* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	SkkContext* _tmp3_;
	GVariant* _tmp4_;
	size_t _tmp5_;
	const gchar** _tmp6_;
	const gchar** _tmp7_;
	gint _tmp7__length1;
	Preferences* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	SkkContext* _tmp11_;
	GVariant* _tmp12_;
	gint32 _tmp13_;
	Preferences* _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	IBusLookupTable* _tmp17_;
	GVariant* _tmp18_;
	gint32 _tmp19_;
	Preferences* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	gint32 _tmp24_;
	Preferences* _tmp25_;
	GVariant* _tmp26_;
	GVariant* _tmp27_;
	SkkContext* _tmp28_;
	GVariant* _tmp29_;
	gint32 _tmp30_;
	Preferences* _tmp31_;
	GVariant* _tmp32_;
	GVariant* _tmp33_;
	GVariant* _tmp34_;
	gboolean _tmp35_;
	Preferences* _tmp36_;
	GVariant* _tmp37_;
	GVariant* _tmp38_;
	SkkContext* _tmp39_;
	GVariant* _tmp40_;
	gboolean _tmp41_;
	Preferences* _tmp42_;
	GVariant* _tmp43_;
	GVariant* _tmp44_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = skk_engine_preferences;
	_tmp1_ = preferences_get (_tmp0_, "auto_start_henkan_keywords");
	_g_variant_unref0 (variant);
	variant = _tmp1_;
	_tmp2_ = variant;
	_vala_assert (_tmp2_ != NULL, "variant != null");
	_tmp3_ = self->priv->context;
	_tmp4_ = variant;
	_tmp6_ = g_variant_get_strv (_tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	skk_context_set_auto_start_henkan_keywords (_tmp3_, _tmp7_, _tmp5_);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp8_ = skk_engine_preferences;
	_tmp9_ = preferences_get (_tmp8_, "period_style");
	_g_variant_unref0 (variant);
	variant = _tmp9_;
	_tmp10_ = variant;
	_vala_assert (_tmp10_ != NULL, "variant != null");
	_tmp11_ = self->priv->context;
	_tmp12_ = variant;
	_tmp13_ = g_variant_get_int32 (_tmp12_);
	skk_context_set_period_style (_tmp11_, (SkkPeriodStyle) _tmp13_);
	_tmp14_ = skk_engine_preferences;
	_tmp15_ = preferences_get (_tmp14_, "page_size");
	_g_variant_unref0 (variant);
	variant = _tmp15_;
	_tmp16_ = variant;
	_vala_assert (_tmp16_ != NULL, "variant != null");
	_tmp17_ = self->priv->lookup_table;
	_tmp18_ = variant;
	_tmp19_ = g_variant_get_int32 (_tmp18_);
	ibus_lookup_table_set_page_size (_tmp17_, (guint) _tmp19_);
	_tmp20_ = skk_engine_preferences;
	_tmp21_ = preferences_get (_tmp20_, "pagination_start");
	_g_variant_unref0 (variant);
	variant = _tmp21_;
	_tmp22_ = variant;
	_vala_assert (_tmp22_ != NULL, "variant != null");
	_tmp23_ = variant;
	_tmp24_ = g_variant_get_int32 (_tmp23_);
	self->priv->page_start = (guint) _tmp24_;
	_tmp25_ = skk_engine_preferences;
	_tmp26_ = preferences_get (_tmp25_, "initial_input_mode");
	_g_variant_unref0 (variant);
	variant = _tmp26_;
	_tmp27_ = variant;
	_vala_assert (_tmp27_ != NULL, "variant != null");
	_tmp28_ = self->priv->context;
	_tmp29_ = variant;
	_tmp30_ = g_variant_get_int32 (_tmp29_);
	skk_context_set_input_mode (_tmp28_, (SkkInputMode) _tmp30_);
	_tmp31_ = skk_engine_preferences;
	_tmp32_ = preferences_get (_tmp31_, "show_annotation");
	_g_variant_unref0 (variant);
	variant = _tmp32_;
	_tmp33_ = variant;
	_vala_assert (_tmp33_ != NULL, "variant != null");
	_tmp34_ = variant;
	_tmp35_ = g_variant_get_boolean (_tmp34_);
	self->priv->show_annotation = _tmp35_;
	_tmp36_ = skk_engine_preferences;
	_tmp37_ = preferences_get (_tmp36_, "egg_like_newline");
	_g_variant_unref0 (variant);
	variant = _tmp37_;
	_tmp38_ = variant;
	_vala_assert (_tmp38_ != NULL, "variant != null");
	_tmp39_ = self->priv->context;
	_tmp40_ = variant;
	_tmp41_ = g_variant_get_boolean (_tmp40_);
	skk_context_set_egg_like_newline (_tmp39_, _tmp41_);
	_tmp42_ = skk_engine_preferences;
	_tmp43_ = preferences_get (_tmp42_, "typing_rule");
	_g_variant_unref0 (variant);
	variant = _tmp43_;
	_tmp44_ = variant;
	_vala_assert (_tmp44_ != NULL, "variant != null");
	{
		SkkRule* _tmp45_ = NULL;
		GVariant* _tmp46_;
		const gchar* _tmp47_;
		SkkRule* _tmp48_;
		SkkContext* _tmp49_;
		_tmp46_ = variant;
		_tmp47_ = g_variant_get_string (_tmp46_, NULL);
		_tmp48_ = skk_rule_new (_tmp47_, &_inner_error_);
		_tmp45_ = _tmp48_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
				goto __catch1_skk_rule_parse_error;
			}
			_g_variant_unref0 (variant);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp49_ = self->priv->context;
		skk_context_set_typing_rule (_tmp49_, _tmp45_);
		_g_object_unref0 (_tmp45_);
	}
	goto __finally1;
	__catch1_skk_rule_parse_error:
	{
		GError* e = NULL;
		GVariant* _tmp50_;
		const gchar* _tmp51_;
		GError* _tmp52_;
		const gchar* _tmp53_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp50_ = variant;
		_tmp51_ = g_variant_get_string (_tmp50_, NULL);
		_tmp52_ = e;
		_tmp53_ = _tmp52_->message;
		g_warning ("engine.vala:338: can't load typing rule %s: %s", _tmp51_, _tmp53_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_variant_unref0 (variant);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_variant_unref0 (variant);
}


static IBusProperty* skk_engine_register_input_mode_property (SkkEngine* self, SkkInputMode mode, const gchar* name, const gchar* label, const gchar* symbol) {
	IBusProperty* result = NULL;
	IBusProperty* prop = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	IBusText* _tmp2_;
	IBusText* _tmp3_;
	IBusProperty* _tmp4_;
	IBusProperty* _tmp5_;
	GeeMap* _tmp6_;
	SkkInputMode _tmp7_;
	GeeMap* _tmp8_;
	SkkInputMode _tmp9_;
	const gchar* _tmp10_;
	GeeMap* _tmp11_;
	const gchar* _tmp12_;
	SkkInputMode _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = label;
	_tmp2_ = ibus_text_new_from_string (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = ibus_property_new (_tmp0_, PROP_TYPE_RADIO, _tmp3_, NULL, NULL, TRUE, TRUE, PROP_STATE_UNCHECKED, NULL);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	prop = _tmp5_;
	_tmp6_ = self->priv->input_mode_props;
	_tmp7_ = mode;
	gee_map_set (_tmp6_, (gpointer) ((gintptr) _tmp7_), prop);
	_tmp8_ = self->priv->input_mode_symbols;
	_tmp9_ = mode;
	_tmp10_ = symbol;
	gee_map_set (_tmp8_, (gpointer) ((gintptr) _tmp9_), _tmp10_);
	_tmp11_ = self->priv->name_input_modes;
	_tmp12_ = name;
	_tmp13_ = mode;
	gee_map_set (_tmp11_, _tmp12_, (gpointer) ((gintptr) _tmp13_));
	result = prop;
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean skk_engine_process_lookup_table_key_event (SkkEngine* self, guint keyval, guint keycode, guint state) {
	gboolean result = FALSE;
	guint page_size = 0U;
	IBusLookupTable* _tmp0_;
	guint _tmp1_;
	gboolean _tmp2_ = FALSE;
	guint _tmp3_;
	guint _tmp26_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lookup_table;
	_tmp1_ = ibus_lookup_table_get_page_size (_tmp0_);
	page_size = _tmp1_;
	_tmp3_ = state;
	if (_tmp3_ == ((guint) 0)) {
		guint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp4_ = keyval;
		_tmp5_ = g_unichar_to_string ((gunichar) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->LOOKUP_TABLE_LABELS;
		_tmp7__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
		_tmp2_ = _vala_string_array_contains (_tmp7_, _tmp7__length1, _tmp6_);
		_g_free0 (_tmp6_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* label = NULL;
		guint _tmp8_;
		gunichar _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = keyval;
		_tmp9_ = g_unichar_tolower ((gunichar) _tmp8_);
		_tmp10_ = g_unichar_to_string (_tmp9_);
		label = _tmp10_;
		{
			gint index = 0;
			index = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gint _tmp13_;
					guint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					gchar** _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = index;
						index = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = index;
					_tmp14_ = page_size;
					_tmp15_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp15__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp16_ = MIN ((gint) _tmp14_, _tmp15__length1);
					if (!(_tmp13_ < _tmp16_)) {
						break;
					}
					_tmp17_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp17__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp18_ = index;
					_tmp19_ = _tmp17_[_tmp18_];
					_tmp20_ = label;
					if (g_strcmp0 (_tmp19_, _tmp20_) == 0) {
						SkkContext* _tmp21_;
						SkkCandidateList* _tmp22_;
						SkkCandidateList* _tmp23_;
						gint _tmp24_;
						gboolean _tmp25_;
						_tmp21_ = self->priv->context;
						_tmp22_ = skk_context_get_candidates (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = index;
						_tmp25_ = skk_candidate_list_select_at (_tmp23_, (guint) _tmp24_);
						result = _tmp25_;
						_g_free0 (label);
						return result;
					}
				}
			}
		}
		result = FALSE;
		_g_free0 (label);
		return result;
	}
	_tmp26_ = state;
	if (_tmp26_ == ((guint) 0)) {
		gboolean retval = FALSE;
		guint _tmp27_;
		gboolean _tmp44_;
		retval = FALSE;
		_tmp27_ = keyval;
		switch (_tmp27_) {
			case IBUS_Page_Up:
			case IBUS_KP_Page_Up:
			{
				SkkContext* _tmp28_;
				SkkCandidateList* _tmp29_;
				SkkCandidateList* _tmp30_;
				gboolean _tmp31_;
				_tmp28_ = self->priv->context;
				_tmp29_ = skk_context_get_candidates (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = skk_candidate_list_page_up (_tmp30_);
				retval = _tmp31_;
				break;
			}
			case IBUS_Page_Down:
			case IBUS_KP_Page_Down:
			{
				SkkContext* _tmp32_;
				SkkCandidateList* _tmp33_;
				SkkCandidateList* _tmp34_;
				gboolean _tmp35_;
				_tmp32_ = self->priv->context;
				_tmp33_ = skk_context_get_candidates (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = skk_candidate_list_page_down (_tmp34_);
				retval = _tmp35_;
				break;
			}
			case IBUS_Up:
			case IBUS_Left:
			{
				SkkContext* _tmp36_;
				SkkCandidateList* _tmp37_;
				SkkCandidateList* _tmp38_;
				gboolean _tmp39_;
				_tmp36_ = self->priv->context;
				_tmp37_ = skk_context_get_candidates (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = skk_candidate_list_cursor_up (_tmp38_);
				retval = _tmp39_;
				break;
			}
			case IBUS_Down:
			case IBUS_Right:
			{
				SkkContext* _tmp40_;
				SkkCandidateList* _tmp41_;
				SkkCandidateList* _tmp42_;
				gboolean _tmp43_;
				_tmp40_ = self->priv->context;
				_tmp41_ = skk_context_get_candidates (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = skk_candidate_list_cursor_down (_tmp42_);
				retval = _tmp43_;
				break;
			}
			default:
			{
				break;
			}
		}
		_tmp44_ = retval;
		if (_tmp44_) {
			skk_engine_set_lookup_table_cursor_pos (self);
			skk_engine_update_preedit (self);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean skk_engine_real_process_key_event (IBusEngine* base, guint keyval, guint keycode, guint state) {
	SkkEngine * self;
	gboolean result = FALSE;
	guint _state = 0U;
	guint _tmp0_;
	gboolean _tmp1_ = FALSE;
	SkkContext* _tmp2_;
	SkkCandidateList* _tmp3_;
	SkkCandidateList* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	SkkModifierType modifiers = 0;
	guint _tmp11_;
	SkkKeyEvent* key = NULL;
	gboolean retval = FALSE;
	SkkContext* _tmp19_;
	SkkKeyEvent* _tmp20_;
	gboolean _tmp21_;
	gchar* output = NULL;
	SkkContext* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GError * _inner_error_ = NULL;
	self = (SkkEngine*) base;
	_tmp0_ = state;
	_state = _tmp0_ & (((IBUS_CONTROL_MASK | IBUS_MOD1_MASK) | IBUS_MOD5_MASK) | IBUS_RELEASE_MASK);
	_tmp2_ = self->priv->context;
	_tmp3_ = skk_context_get_candidates (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = skk_candidate_list_get_page_visible (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		guint _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = keyval;
		_tmp8_ = keycode;
		_tmp9_ = _state;
		_tmp10_ = skk_engine_process_lookup_table_key_event (self, _tmp7_, _tmp8_, _tmp9_);
		_tmp1_ = _tmp10_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp11_ = _state;
	modifiers = (SkkModifierType) _tmp11_;
	{
		SkkKeyEvent* _tmp12_ = NULL;
		guint _tmp13_;
		SkkModifierType _tmp14_;
		SkkKeyEvent* _tmp15_;
		SkkKeyEvent* _tmp17_;
		_tmp13_ = keyval;
		_tmp14_ = modifiers;
		_tmp15_ = skk_key_event_new_from_x_keysym (_tmp13_, _tmp14_, &_inner_error_);
		_tmp12_ = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp16_ = FALSE;
			if (_inner_error_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
				goto __catch2_skk_key_event_format_error;
			}
			_g_object_unref0 (key);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp16_;
		}
		_tmp17_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (key);
		key = _tmp17_;
		_g_object_unref0 (_tmp12_);
	}
	goto __finally2;
	__catch2_skk_key_event_format_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (key);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp18_ = FALSE;
		_g_object_unref0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp18_;
	}
	_tmp19_ = self->priv->context;
	_tmp20_ = key;
	_tmp21_ = skk_context_process_key_event (_tmp19_, _tmp20_);
	retval = _tmp21_;
	_tmp22_ = self->priv->context;
	_tmp23_ = skk_context_poll_output (_tmp22_);
	output = _tmp23_;
	_tmp24_ = output;
	_tmp25_ = strlen (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ > 0) {
		IBusText* text = NULL;
		const gchar* _tmp27_;
		IBusText* _tmp28_;
		IBusText* _tmp29_;
		_tmp27_ = output;
		_tmp28_ = ibus_text_new_from_string (_tmp27_);
		g_object_ref_sink (_tmp28_);
		text = _tmp28_;
		_tmp29_ = text;
		ibus_engine_commit_text ((IBusEngine*) self, _tmp29_);
		_g_object_unref0 (text);
	}
	result = retval;
	_g_free0 (output);
	_g_object_unref0 (key);
	return result;
}


static void skk_engine_real_enable (IBusEngine* base) {
	SkkEngine * self;
	SkkContext* _tmp0_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	skk_context_reset (_tmp0_);
	ibus_engine_get_surrounding_text ((IBusEngine*) self, NULL, NULL, NULL);
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->enable (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}


static void skk_engine_real_disable (IBusEngine* base) {
	SkkEngine * self;
	self = (SkkEngine*) base;
	g_signal_emit_by_name ((IBusEngine*) self, "focus-out");
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->disable (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}


static void skk_engine_real_reset (IBusEngine* base) {
	SkkEngine * self;
	SkkContext* _tmp0_;
	IBusText* empty_text = NULL;
	IBusText* _tmp1_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	skk_context_reset (_tmp0_);
	_tmp1_ = ibus_text_new_from_static_string ("");
	g_object_ref_sink (_tmp1_);
	empty_text = _tmp1_;
	ibus_engine_update_preedit_text ((IBusEngine*) self, empty_text, (guint) 0, FALSE);
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->reset (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
	_g_object_unref0 (empty_text);
}


static void skk_engine_real_focus_in (IBusEngine* base) {
	SkkEngine * self;
	IBusPropList* _tmp0_;
	self = (SkkEngine*) base;
	skk_engine_update_input_mode (self);
	_tmp0_ = self->priv->prop_list;
	ibus_engine_register_properties ((IBusEngine*) self, _tmp0_);
	self->priv->properties_registered = TRUE;
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->focus_in (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}


static void skk_engine_real_focus_out (IBusEngine* base) {
	SkkEngine * self;
	SkkContext* _tmp0_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	skk_context_reset (_tmp0_);
	ibus_engine_hide_preedit_text ((IBusEngine*) self);
	ibus_engine_hide_lookup_table ((IBusEngine*) self);
	self->priv->properties_registered = FALSE;
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->focus_out (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}


static void skk_engine_real_property_activate (IBusEngine* base, const gchar* prop_name, guint prop_state) {
	SkkEngine * self;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (SkkEngine*) base;
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	if (g_strcmp0 (_tmp0_, "setup") == 0) {
		gchar* filename = NULL;
		gchar* _tmp1_;
		_tmp1_ = g_build_filename (LIBEXECDIR, "ibus-setup-skk", NULL);
		filename = _tmp1_;
		{
			const gchar* _tmp2_;
			_tmp2_ = filename;
			g_spawn_command_line_async (_tmp2_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch3_g_spawn_error;
				}
				_g_free0 (filename);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally3;
		__catch3_g_spawn_error:
		{
			GError* e = NULL;
			const gchar* _tmp3_;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = filename;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("engine.vala:495: can't spawn %s: %s", _tmp3_, _tmp5_);
			_g_error_free0 (e);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (filename);
	} else {
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = prop_name;
		_tmp8_ = g_str_has_prefix (_tmp7_, "InputMode.");
		if (_tmp8_) {
			guint _tmp9_;
			_tmp9_ = prop_state;
			_tmp6_ = _tmp9_ == ((guint) PROP_STATE_CHECKED);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			SkkContext* _tmp10_;
			GeeMap* _tmp11_;
			const gchar* _tmp12_;
			gpointer _tmp13_;
			_tmp10_ = self->priv->context;
			_tmp11_ = self->priv->name_input_modes;
			_tmp12_ = prop_name;
			_tmp13_ = gee_map_get (_tmp11_, _tmp12_);
			skk_context_set_input_mode (_tmp10_, (SkkInputMode) ((gintptr) _tmp13_));
		}
	}
}


static void skk_engine_real_candidate_clicked (IBusEngine* base, guint index, guint button, guint state) {
	SkkEngine * self;
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	guint _tmp3_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	skk_candidate_list_select_at (_tmp2_, _tmp3_);
}


static void skk_engine_real_cursor_up (IBusEngine* base) {
	SkkEngine * self;
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	skk_candidate_list_cursor_up (_tmp2_);
}


static void skk_engine_real_cursor_down (IBusEngine* base) {
	SkkEngine * self;
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	skk_candidate_list_cursor_down (_tmp2_);
}


static void skk_engine_real_page_up (IBusEngine* base) {
	SkkEngine * self;
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	skk_candidate_list_page_up (_tmp2_);
}


static void skk_engine_real_page_down (IBusEngine* base) {
	SkkEngine * self;
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	skk_candidate_list_page_down (_tmp2_);
}


static void __lambda4_ (void) {
	ibus_quit ();
}


static void ___lambda4__ibus_bus_disconnected (IBusBus* _sender, gpointer self) {
	__lambda4_ ();
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda5_ (const gchar* name, GVariant* value) {
	const gchar* _tmp0_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "dictionaries") == 0) {
		skk_engine_reload_dictionaries ();
	}
}


static void ___lambda5__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self) {
	__lambda5_ (name, value);
}


gint skk_engine_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	IBusBus* bus = NULL;
	IBusBus* _tmp8_;
	IBusBus* _tmp9_;
	gboolean _tmp10_;
	IBusBus* _tmp12_;
	IBusConfig* config = NULL;
	IBusBus* _tmp13_;
	IBusConfig* _tmp14_;
	IBusConfig* _tmp15_;
	IBusConfig* _tmp16_;
	Preferences* _tmp17_;
	GeeArrayList* _tmp18_;
	Preferences* _tmp19_;
	IBusFactory* factory = NULL;
	IBusBus* _tmp20_;
	GDBusConnection* _tmp21_;
	IBusFactory* _tmp22_;
	IBusFactory* _tmp23_;
	gboolean _tmp24_;
	GError * _inner_error_ = NULL;
	ibus_init ();
	skk_init ();
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = g_option_context_new ("- ibus skk");
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_add_main_entries (_tmp1_, SKK_ENGINE_options, "ibus-skk");
	{
		GOptionContext* _tmp2_;
		_tmp2_ = context;
		g_option_context_parse (_tmp2_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp3_ = 0;
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch4_g_option_error;
			}
			_g_option_context_free0 (context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	goto __finally4;
	__catch4_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp7_ = 0;
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp7_;
	}
	_tmp8_ = ibus_bus_new ();
	g_object_ref_sink (_tmp8_);
	bus = _tmp8_;
	_tmp9_ = bus;
	_tmp10_ = ibus_bus_is_connected (_tmp9_);
	if (!_tmp10_) {
		FILE* _tmp11_;
		_tmp11_ = stderr;
		fprintf (_tmp11_, "Can not connect to ibus-daemon!\n");
		result = 1;
		_g_object_unref0 (bus);
		_g_option_context_free0 (context);
		return result;
	}
	_tmp12_ = bus;
	g_signal_connect (_tmp12_, "disconnected", (GCallback) ___lambda4__ibus_bus_disconnected, NULL);
	_tmp13_ = bus;
	_tmp14_ = ibus_bus_get_config (_tmp13_);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	config = _tmp15_;
	_tmp16_ = config;
	_tmp17_ = preferences_new (_tmp16_);
	_g_object_unref0 (skk_engine_preferences);
	skk_engine_preferences = _tmp17_;
	_tmp18_ = gee_array_list_new (SKK_TYPE_DICT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (skk_engine_dictionaries);
	skk_engine_dictionaries = _tmp18_;
	skk_engine_reload_dictionaries ();
	_tmp19_ = skk_engine_preferences;
	g_signal_connect (_tmp19_, "value-changed", (GCallback) ___lambda5__preferences_value_changed, NULL);
	_tmp20_ = bus;
	_tmp21_ = ibus_bus_get_connection (_tmp20_);
	_tmp22_ = ibus_factory_new (_tmp21_);
	g_object_ref_sink (_tmp22_);
	factory = _tmp22_;
	_tmp23_ = factory;
	ibus_factory_add_engine (_tmp23_, "skk", TYPE_SKK_ENGINE);
	_tmp24_ = skk_engine_ibus;
	if (_tmp24_) {
		IBusBus* _tmp25_;
		_tmp25_ = bus;
		ibus_bus_request_name (_tmp25_, "org.freedesktop.IBus.SKK", (guint32) 0);
	} else {
		IBusComponent* component = NULL;
		IBusComponent* _tmp26_;
		IBusEngineDesc* engine = NULL;
		gchar* _tmp27_;
		gchar* _tmp28_;
		IBusEngineDesc* _tmp29_;
		IBusEngineDesc* _tmp30_;
		IBusComponent* _tmp31_;
		IBusEngineDesc* _tmp32_;
		IBusBus* _tmp33_;
		IBusComponent* _tmp34_;
		_tmp26_ = ibus_component_new ("org.freedesktop.IBus.SKK", N_ ("SKK"), PACKAGE_VERSION, "GPL", "Daiki Ueno <ueno@unixuser.org>", "http://code.google.com/p/ibus/", "", "ibus-skk");
		g_object_ref_sink (_tmp26_);
		component = _tmp26_;
		_tmp27_ = g_strdup_printf ("%s/icons/ibus-skk.svg", PACKAGE_DATADIR);
		_tmp28_ = _tmp27_;
		_tmp29_ = ibus_engine_desc_new ("skk", "SKK", "SKK Input Method", "ja", "GPL", "Daiki Ueno <ueno@unixuser.org>", _tmp28_, "us");
		g_object_ref_sink (_tmp29_);
		_tmp30_ = _tmp29_;
		_g_free0 (_tmp28_);
		engine = _tmp30_;
		_tmp31_ = component;
		_tmp32_ = engine;
		ibus_component_add_engine (_tmp31_, _tmp32_);
		_tmp33_ = bus;
		_tmp34_ = component;
		ibus_bus_register_component (_tmp33_, _tmp34_);
		_g_object_unref0 (engine);
		_g_object_unref0 (component);
	}
	ibus_main ();
	result = 0;
	_g_object_unref0 (factory);
	_g_object_unref0 (config);
	_g_object_unref0 (bus);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	return skk_engine_main (argv, argc);
}


SkkEngine* skk_engine_construct (GType object_type) {
	SkkEngine * self = NULL;
	self = (SkkEngine*) g_object_new (object_type, NULL);
	return self;
}


SkkEngine* skk_engine_new (void) {
	return skk_engine_construct (TYPE_SKK_ENGINE);
}


static void _skk_engine___lambda6_ (SkkEngine* self, const gchar* name, GVariant* value) {
	const gchar* _tmp0_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	skk_engine_apply_preferences (self);
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "dictionaries") == 0) {
		SkkContext* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gpointer* _tmp4_;
		SkkDict** _tmp5_;
		gint _tmp5__length1;
		_tmp1_ = self->priv->context;
		_tmp2_ = skk_engine_dictionaries;
		_tmp4_ = gee_collection_to_array ((GeeCollection*) _tmp2_, &_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _tmp3_;
		skk_context_set_dictionaries (_tmp1_, _tmp5_, _tmp3_);
		_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_object_unref), NULL);
	}
}


static void __skk_engine___lambda6__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self) {
	_skk_engine___lambda6_ ((SkkEngine*) self, name, value);
}


static void _skk_engine___lambda7_ (SkkEngine* self) {
	skk_engine_update_preedit (self);
}


static void __skk_engine___lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_skk_engine___lambda7_ ((SkkEngine*) self);
}


static void _skk_engine___lambda8_ (SkkEngine* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	skk_engine_update_input_mode (self);
}


static void __skk_engine___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_skk_engine___lambda8_ ((SkkEngine*) self, _sender, pspec);
}


static void _skk_engine___lambda9_ (SkkEngine* self) {
	skk_engine_populate_lookup_table (self);
}


static void __skk_engine___lambda9__skk_candidate_list_populated (SkkCandidateList* _sender, gpointer self) {
	_skk_engine___lambda9_ ((SkkEngine*) self);
}


static void _skk_engine___lambda10_ (SkkEngine* self) {
	skk_engine_set_lookup_table_cursor_pos (self);
}


static void __skk_engine___lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_skk_engine___lambda10_ ((SkkEngine*) self);
}


static void _skk_engine___lambda11_ (SkkEngine* self) {
	gchar* output = NULL;
	SkkContext* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp8_;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_poll_output (_tmp0_);
	output = _tmp1_;
	_tmp2_ = output;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		IBusText* text = NULL;
		const gchar* _tmp5_;
		IBusText* _tmp6_;
		IBusText* _tmp7_;
		_tmp5_ = output;
		_tmp6_ = ibus_text_new_from_string (_tmp5_);
		g_object_ref_sink (_tmp6_);
		text = _tmp6_;
		_tmp7_ = text;
		ibus_engine_commit_text ((IBusEngine*) self, _tmp7_);
		_g_object_unref0 (text);
	}
	_tmp8_ = self->priv->lookup_table_visible;
	if (_tmp8_) {
		ibus_engine_hide_lookup_table ((IBusEngine*) self);
		ibus_engine_hide_auxiliary_text ((IBusEngine*) self);
		self->priv->lookup_table_visible = FALSE;
	}
	_g_free0 (output);
}


static void __skk_engine___lambda11__skk_candidate_list_selected (SkkCandidateList* _sender, SkkCandidate* candidate, gpointer self) {
	_skk_engine___lambda11_ ((SkkEngine*) self);
}


static gboolean __skk_engine_retrieve_surrounding_text_skk_context_retrieve_surrounding_text (SkkContext* _sender, gchar* * text, guint* cursor_pos, gpointer self) {
	gboolean result;
	result = _skk_engine_retrieve_surrounding_text ((SkkEngine*) self, text, cursor_pos);
	return result;
}


static gboolean __skk_engine_delete_surrounding_text_skk_context_delete_surrounding_text (SkkContext* _sender, gint offset, guint nchars, gpointer self) {
	gboolean result;
	result = _skk_engine_delete_surrounding_text ((SkkEngine*) self, offset, nchars);
	return result;
}


static GObject * skk_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SkkEngine * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	IBusLookupTable* _tmp1_;
	IBusLookupTable* _tmp13_;
	IBusPropList* _tmp14_;
	IBusPropList* props = NULL;
	IBusPropList* _tmp15_;
	IBusProperty* prop = NULL;
	IBusProperty* _tmp16_;
	IBusPropList* _tmp17_;
	IBusProperty* _tmp18_;
	IBusProperty* _tmp19_;
	IBusPropList* _tmp20_;
	IBusProperty* _tmp21_;
	IBusProperty* _tmp22_;
	IBusPropList* _tmp23_;
	IBusProperty* _tmp24_;
	IBusProperty* _tmp25_;
	IBusPropList* _tmp26_;
	IBusProperty* _tmp27_;
	IBusProperty* _tmp28_;
	IBusPropList* _tmp29_;
	IBusProperty* _tmp30_;
	IBusText* _tmp31_;
	IBusText* _tmp32_;
	IBusText* _tmp33_;
	IBusText* _tmp34_;
	IBusPropList* _tmp35_;
	IBusProperty* _tmp36_;
	IBusPropList* _tmp37_;
	IBusProperty* _tmp38_;
	IBusProperty* _tmp39_;
	IBusProperty* _tmp40_;
	IBusText* _tmp41_;
	IBusText* _tmp42_;
	IBusText* _tmp43_;
	IBusText* _tmp44_;
	IBusProperty* _tmp45_;
	IBusPropList* _tmp46_;
	IBusProperty* _tmp47_;
	GeeArrayList* _tmp48_;
	gint _tmp49_;
	gpointer* _tmp50_;
	SkkDict** _tmp51_;
	gint _tmp51__length1;
	SkkContext* _tmp52_;
	Preferences* _tmp53_;
	SkkContext* _tmp54_;
	SkkContext* _tmp55_;
	SkkContext* _tmp56_;
	SkkCandidateList* _tmp57_;
	SkkCandidateList* _tmp58_;
	SkkContext* _tmp59_;
	SkkCandidateList* _tmp60_;
	SkkCandidateList* _tmp61_;
	SkkContext* _tmp62_;
	SkkCandidateList* _tmp63_;
	SkkCandidateList* _tmp64_;
	SkkContext* _tmp65_;
	SkkContext* _tmp66_;
	parent_class = G_OBJECT_CLASS (skk_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SKK_ENGINE, SkkEngine);
	_tmp0_ = self->priv->LOOKUP_TABLE_LABELS;
	_tmp0__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
	_tmp1_ = ibus_lookup_table_new ((guint) _tmp0__length1, (guint) 0, TRUE, FALSE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->lookup_table);
	self->priv->lookup_table = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				gchar** _tmp5_;
				gint _tmp5__length1;
				IBusText* text = NULL;
				gchar** _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				const gchar* _tmp8_;
				IBusText* _tmp9_;
				IBusLookupTable* _tmp10_;
				gint _tmp11_;
				IBusText* _tmp12_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->priv->LOOKUP_TABLE_LABELS;
				_tmp5__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
				if (!(_tmp4_ < _tmp5__length1)) {
					break;
				}
				_tmp6_ = self->priv->LOOKUP_TABLE_LABELS;
				_tmp6__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				_tmp9_ = ibus_text_new_from_string (_tmp8_);
				g_object_ref_sink (_tmp9_);
				text = _tmp9_;
				_tmp10_ = self->priv->lookup_table;
				_tmp11_ = i;
				_tmp12_ = text;
				ibus_lookup_table_set_label (_tmp10_, (guint) _tmp11_, _tmp12_);
				_g_object_unref0 (text);
			}
		}
	}
	_tmp13_ = self->priv->lookup_table;
	ibus_lookup_table_set_orientation (_tmp13_, (gint) IBUS_ORIENTATION_HORIZONTAL);
	_tmp14_ = ibus_prop_list_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->prop_list);
	self->priv->prop_list = _tmp14_;
	_tmp15_ = ibus_prop_list_new ();
	g_object_ref_sink (_tmp15_);
	props = _tmp15_;
	_tmp16_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_HIRAGANA, "InputMode.Hiragana", _ ("Hiragana"), "あ");
	_g_object_unref0 (prop);
	prop = _tmp16_;
	_tmp17_ = props;
	_tmp18_ = prop;
	ibus_prop_list_append (_tmp17_, _tmp18_);
	_tmp19_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_KATAKANA, "InputMode.Katakana", _ ("Katakana"), "ア");
	_g_object_unref0 (prop);
	prop = _tmp19_;
	_tmp20_ = props;
	_tmp21_ = prop;
	ibus_prop_list_append (_tmp20_, _tmp21_);
	_tmp22_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_HANKAKU_KATAKANA, "InputMode.HankakuKatakana", _ ("Halfwidth Katakana"), "_ｱ");
	_g_object_unref0 (prop);
	prop = _tmp22_;
	_tmp23_ = props;
	_tmp24_ = prop;
	ibus_prop_list_append (_tmp23_, _tmp24_);
	_tmp25_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_LATIN, "InputMode.Latin", _ ("Latin"), "_A");
	_g_object_unref0 (prop);
	prop = _tmp25_;
	_tmp26_ = props;
	_tmp27_ = prop;
	ibus_prop_list_append (_tmp26_, _tmp27_);
	_tmp28_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_WIDE_LATIN, "InputMode.WideLatin", _ ("Wide Latin"), "Ａ");
	_g_object_unref0 (prop);
	prop = _tmp28_;
	_tmp29_ = props;
	_tmp30_ = prop;
	ibus_prop_list_append (_tmp29_, _tmp30_);
	_tmp31_ = ibus_text_new_from_string ("あ");
	g_object_ref_sink (_tmp31_);
	_tmp32_ = _tmp31_;
	_tmp33_ = ibus_text_new_from_string (_ ("Switch input mode"));
	g_object_ref_sink (_tmp33_);
	_tmp34_ = _tmp33_;
	_tmp35_ = props;
	_tmp36_ = ibus_property_new ("InputMode", PROP_TYPE_MENU, _tmp32_, NULL, _tmp34_, TRUE, TRUE, PROP_STATE_UNCHECKED, _tmp35_);
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (prop);
	prop = _tmp36_;
	_g_object_unref0 (_tmp34_);
	_g_object_unref0 (_tmp32_);
	_tmp37_ = self->priv->prop_list;
	_tmp38_ = prop;
	ibus_prop_list_append (_tmp37_, _tmp38_);
	_tmp39_ = prop;
	_tmp40_ = _g_object_ref0 (_tmp39_);
	_g_object_unref0 (self->priv->input_mode_prop);
	self->priv->input_mode_prop = _tmp40_;
	_tmp41_ = ibus_text_new_from_string (_ ("Setup"));
	g_object_ref_sink (_tmp41_);
	_tmp42_ = _tmp41_;
	_tmp43_ = ibus_text_new_from_string (_ ("Configure SKK"));
	g_object_ref_sink (_tmp43_);
	_tmp44_ = _tmp43_;
	_tmp45_ = ibus_property_new ("setup", PROP_TYPE_NORMAL, _tmp42_, "gtk-preferences", _tmp44_, TRUE, TRUE, PROP_STATE_UNCHECKED, NULL);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (prop);
	prop = _tmp45_;
	_g_object_unref0 (_tmp44_);
	_g_object_unref0 (_tmp42_);
	_tmp46_ = self->priv->prop_list;
	_tmp47_ = prop;
	ibus_prop_list_append (_tmp46_, _tmp47_);
	_tmp48_ = skk_engine_dictionaries;
	_tmp50_ = gee_collection_to_array ((GeeCollection*) _tmp48_, &_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp51__length1 = _tmp49_;
	_tmp52_ = skk_context_new (_tmp51_, _tmp49_);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp52_;
	_tmp51_ = (_vala_array_free (_tmp51_, _tmp51__length1, (GDestroyNotify) g_object_unref), NULL);
	skk_engine_apply_preferences (self);
	_tmp53_ = skk_engine_preferences;
	g_signal_connect_object (_tmp53_, "value-changed", (GCallback) __skk_engine___lambda6__preferences_value_changed, self, 0);
	_tmp54_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp54_, "notify::preedit", (GCallback) __skk_engine___lambda7__g_object_notify, self, 0);
	_tmp55_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp55_, "notify::input-mode", (GCallback) __skk_engine___lambda8__g_object_notify, self, 0);
	_tmp56_ = self->priv->context;
	_tmp57_ = skk_context_get_candidates (_tmp56_);
	_tmp58_ = _tmp57_;
	g_signal_connect_object (_tmp58_, "populated", (GCallback) __skk_engine___lambda9__skk_candidate_list_populated, self, 0);
	_tmp59_ = self->priv->context;
	_tmp60_ = skk_context_get_candidates (_tmp59_);
	_tmp61_ = _tmp60_;
	g_signal_connect_object ((GObject*) _tmp61_, "notify::cursor-pos", (GCallback) __skk_engine___lambda10__g_object_notify, self, 0);
	_tmp62_ = self->priv->context;
	_tmp63_ = skk_context_get_candidates (_tmp62_);
	_tmp64_ = _tmp63_;
	g_signal_connect_object (_tmp64_, "selected", (GCallback) __skk_engine___lambda11__skk_candidate_list_selected, self, 0);
	skk_engine_update_candidates (self);
	skk_engine_update_input_mode (self);
	_tmp65_ = self->priv->context;
	g_signal_connect_object (_tmp65_, "retrieve-surrounding-text", (GCallback) __skk_engine_retrieve_surrounding_text_skk_context_retrieve_surrounding_text, self, 0);
	_tmp66_ = self->priv->context;
	g_signal_connect_object (_tmp66_, "delete-surrounding-text", (GCallback) __skk_engine_delete_surrounding_text_skk_context_delete_surrounding_text, self, 0);
	_g_object_unref0 (prop);
	_g_object_unref0 (props);
	return obj;
}


static void skk_engine_class_init (SkkEngineClass * klass) {
	skk_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkEnginePrivate));
	((IBusEngineClass *) klass)->process_key_event = (gboolean (*) (IBusEngine *, guint, guint, guint)) skk_engine_real_process_key_event;
	((IBusEngineClass *) klass)->enable = (void (*) (IBusEngine *)) skk_engine_real_enable;
	((IBusEngineClass *) klass)->disable = (void (*) (IBusEngine *)) skk_engine_real_disable;
	((IBusEngineClass *) klass)->reset = (void (*) (IBusEngine *)) skk_engine_real_reset;
	((IBusEngineClass *) klass)->focus_in = (void (*) (IBusEngine *)) skk_engine_real_focus_in;
	((IBusEngineClass *) klass)->focus_out = (void (*) (IBusEngine *)) skk_engine_real_focus_out;
	((IBusEngineClass *) klass)->property_activate = (void (*) (IBusEngine *, const gchar*, guint)) skk_engine_real_property_activate;
	((IBusEngineClass *) klass)->candidate_clicked = (void (*) (IBusEngine *, guint, guint, guint)) skk_engine_real_candidate_clicked;
	((IBusEngineClass *) klass)->cursor_up = (void (*) (IBusEngine *)) skk_engine_real_cursor_up;
	((IBusEngineClass *) klass)->cursor_down = (void (*) (IBusEngine *)) skk_engine_real_cursor_down;
	((IBusEngineClass *) klass)->page_up = (void (*) (IBusEngine *)) skk_engine_real_page_up;
	((IBusEngineClass *) klass)->page_down = (void (*) (IBusEngine *)) skk_engine_real_page_down;
	G_OBJECT_CLASS (klass)->constructor = skk_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = skk_engine_finalize;
}


static void skk_engine_instance_init (SkkEngine * self) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_;
	self->priv = SKK_ENGINE_GET_PRIVATE (self);
	self->priv->properties_registered = FALSE;
	_tmp0_ = gee_hash_map_new (SKK_TYPE_INPUT_MODE, NULL, NULL, IBUS_TYPE_PROPERTY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->input_mode_props = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (SKK_TYPE_INPUT_MODE, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->input_mode_symbols = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SKK_TYPE_INPUT_MODE, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->name_input_modes = (GeeMap*) _tmp2_;
	_tmp3_ = g_strdup ("a");
	_tmp4_ = g_strdup ("s");
	_tmp5_ = g_strdup ("d");
	_tmp6_ = g_strdup ("f");
	_tmp7_ = g_strdup ("j");
	_tmp8_ = g_strdup ("k");
	_tmp9_ = g_strdup ("l");
	_tmp10_ = g_strdup ("q");
	_tmp11_ = g_strdup ("w");
	_tmp12_ = g_strdup ("e");
	_tmp13_ = g_strdup ("r");
	_tmp14_ = g_strdup ("u");
	_tmp15_ = g_strdup ("i");
	_tmp16_ = g_strdup ("o");
	_tmp17_ = g_new0 (gchar*, 14 + 1);
	_tmp17_[0] = _tmp3_;
	_tmp17_[1] = _tmp4_;
	_tmp17_[2] = _tmp5_;
	_tmp17_[3] = _tmp6_;
	_tmp17_[4] = _tmp7_;
	_tmp17_[5] = _tmp8_;
	_tmp17_[6] = _tmp9_;
	_tmp17_[7] = _tmp10_;
	_tmp17_[8] = _tmp11_;
	_tmp17_[9] = _tmp12_;
	_tmp17_[10] = _tmp13_;
	_tmp17_[11] = _tmp14_;
	_tmp17_[12] = _tmp15_;
	_tmp17_[13] = _tmp16_;
	self->priv->LOOKUP_TABLE_LABELS = _tmp17_;
	self->priv->LOOKUP_TABLE_LABELS_length1 = 14;
	self->priv->_LOOKUP_TABLE_LABELS_size_ = self->priv->LOOKUP_TABLE_LABELS_length1;
}


static void skk_engine_finalize (GObject * obj) {
	SkkEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SKK_ENGINE, SkkEngine);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->lookup_table);
	_g_object_unref0 (self->priv->input_mode_prop);
	_g_object_unref0 (self->priv->prop_list);
	_g_object_unref0 (self->priv->input_mode_props);
	_g_object_unref0 (self->priv->input_mode_symbols);
	_g_object_unref0 (self->priv->name_input_modes);
	self->priv->LOOKUP_TABLE_LABELS = (_vala_array_free (self->priv->LOOKUP_TABLE_LABELS, self->priv->LOOKUP_TABLE_LABELS_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (skk_engine_parent_class)->finalize (obj);
}


GType skk_engine_get_type (void) {
	static volatile gsize skk_engine_type_id__volatile = 0;
	if (g_once_init_enter (&skk_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkEngine), 0, (GInstanceInitFunc) skk_engine_instance_init, NULL };
		GType skk_engine_type_id;
		skk_engine_type_id = g_type_register_static (IBUS_TYPE_ENGINE, "SkkEngine", &g_define_type_info, 0);
		g_once_init_leave (&skk_engine_type_id__volatile, skk_engine_type_id);
	}
	return skk_engine_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



