// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/bigquery/storage/v1beta/metastore_partition.proto

package storagepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	MetastorePartitionService_BatchCreateMetastorePartitions_FullMethodName = "/google.cloud.bigquery.storage.v1beta.MetastorePartitionService/BatchCreateMetastorePartitions"
	MetastorePartitionService_BatchDeleteMetastorePartitions_FullMethodName = "/google.cloud.bigquery.storage.v1beta.MetastorePartitionService/BatchDeleteMetastorePartitions"
	MetastorePartitionService_BatchUpdateMetastorePartitions_FullMethodName = "/google.cloud.bigquery.storage.v1beta.MetastorePartitionService/BatchUpdateMetastorePartitions"
	MetastorePartitionService_ListMetastorePartitions_FullMethodName        = "/google.cloud.bigquery.storage.v1beta.MetastorePartitionService/ListMetastorePartitions"
	MetastorePartitionService_StreamMetastorePartitions_FullMethodName      = "/google.cloud.bigquery.storage.v1beta.MetastorePartitionService/StreamMetastorePartitions"
)

// MetastorePartitionServiceClient is the client API for MetastorePartitionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MetastorePartitionServiceClient interface {
	// Adds metastore partitions to a table.
	BatchCreateMetastorePartitions(ctx context.Context, in *BatchCreateMetastorePartitionsRequest, opts ...grpc.CallOption) (*BatchCreateMetastorePartitionsResponse, error)
	// Deletes metastore partitions from a table.
	BatchDeleteMetastorePartitions(ctx context.Context, in *BatchDeleteMetastorePartitionsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates metastore partitions in a table.
	BatchUpdateMetastorePartitions(ctx context.Context, in *BatchUpdateMetastorePartitionsRequest, opts ...grpc.CallOption) (*BatchUpdateMetastorePartitionsResponse, error)
	// Gets metastore partitions from a table.
	ListMetastorePartitions(ctx context.Context, in *ListMetastorePartitionsRequest, opts ...grpc.CallOption) (*ListMetastorePartitionsResponse, error)
	// This is a bi-di streaming rpc method that allows the client to send
	// a stream of partitions and commit all of them atomically at the end.
	// If the commit is successful, the server will return a
	// response and close the stream. If the commit fails (due to duplicate
	// partitions or other reason), the server will close the stream with an
	// error. This method is only available via the gRPC API (not REST).
	StreamMetastorePartitions(ctx context.Context, opts ...grpc.CallOption) (MetastorePartitionService_StreamMetastorePartitionsClient, error)
}

type metastorePartitionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMetastorePartitionServiceClient(cc grpc.ClientConnInterface) MetastorePartitionServiceClient {
	return &metastorePartitionServiceClient{cc}
}

func (c *metastorePartitionServiceClient) BatchCreateMetastorePartitions(ctx context.Context, in *BatchCreateMetastorePartitionsRequest, opts ...grpc.CallOption) (*BatchCreateMetastorePartitionsResponse, error) {
	out := new(BatchCreateMetastorePartitionsResponse)
	err := c.cc.Invoke(ctx, MetastorePartitionService_BatchCreateMetastorePartitions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastorePartitionServiceClient) BatchDeleteMetastorePartitions(ctx context.Context, in *BatchDeleteMetastorePartitionsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, MetastorePartitionService_BatchDeleteMetastorePartitions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastorePartitionServiceClient) BatchUpdateMetastorePartitions(ctx context.Context, in *BatchUpdateMetastorePartitionsRequest, opts ...grpc.CallOption) (*BatchUpdateMetastorePartitionsResponse, error) {
	out := new(BatchUpdateMetastorePartitionsResponse)
	err := c.cc.Invoke(ctx, MetastorePartitionService_BatchUpdateMetastorePartitions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastorePartitionServiceClient) ListMetastorePartitions(ctx context.Context, in *ListMetastorePartitionsRequest, opts ...grpc.CallOption) (*ListMetastorePartitionsResponse, error) {
	out := new(ListMetastorePartitionsResponse)
	err := c.cc.Invoke(ctx, MetastorePartitionService_ListMetastorePartitions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metastorePartitionServiceClient) StreamMetastorePartitions(ctx context.Context, opts ...grpc.CallOption) (MetastorePartitionService_StreamMetastorePartitionsClient, error) {
	stream, err := c.cc.NewStream(ctx, &MetastorePartitionService_ServiceDesc.Streams[0], MetastorePartitionService_StreamMetastorePartitions_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &metastorePartitionServiceStreamMetastorePartitionsClient{stream}
	return x, nil
}

type MetastorePartitionService_StreamMetastorePartitionsClient interface {
	Send(*StreamMetastorePartitionsRequest) error
	Recv() (*StreamMetastorePartitionsResponse, error)
	grpc.ClientStream
}

type metastorePartitionServiceStreamMetastorePartitionsClient struct {
	grpc.ClientStream
}

func (x *metastorePartitionServiceStreamMetastorePartitionsClient) Send(m *StreamMetastorePartitionsRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *metastorePartitionServiceStreamMetastorePartitionsClient) Recv() (*StreamMetastorePartitionsResponse, error) {
	m := new(StreamMetastorePartitionsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// MetastorePartitionServiceServer is the server API for MetastorePartitionService service.
// All implementations should embed UnimplementedMetastorePartitionServiceServer
// for forward compatibility
type MetastorePartitionServiceServer interface {
	// Adds metastore partitions to a table.
	BatchCreateMetastorePartitions(context.Context, *BatchCreateMetastorePartitionsRequest) (*BatchCreateMetastorePartitionsResponse, error)
	// Deletes metastore partitions from a table.
	BatchDeleteMetastorePartitions(context.Context, *BatchDeleteMetastorePartitionsRequest) (*emptypb.Empty, error)
	// Updates metastore partitions in a table.
	BatchUpdateMetastorePartitions(context.Context, *BatchUpdateMetastorePartitionsRequest) (*BatchUpdateMetastorePartitionsResponse, error)
	// Gets metastore partitions from a table.
	ListMetastorePartitions(context.Context, *ListMetastorePartitionsRequest) (*ListMetastorePartitionsResponse, error)
	// This is a bi-di streaming rpc method that allows the client to send
	// a stream of partitions and commit all of them atomically at the end.
	// If the commit is successful, the server will return a
	// response and close the stream. If the commit fails (due to duplicate
	// partitions or other reason), the server will close the stream with an
	// error. This method is only available via the gRPC API (not REST).
	StreamMetastorePartitions(MetastorePartitionService_StreamMetastorePartitionsServer) error
}

// UnimplementedMetastorePartitionServiceServer should be embedded to have forward compatible implementations.
type UnimplementedMetastorePartitionServiceServer struct {
}

func (UnimplementedMetastorePartitionServiceServer) BatchCreateMetastorePartitions(context.Context, *BatchCreateMetastorePartitionsRequest) (*BatchCreateMetastorePartitionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateMetastorePartitions not implemented")
}
func (UnimplementedMetastorePartitionServiceServer) BatchDeleteMetastorePartitions(context.Context, *BatchDeleteMetastorePartitionsRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteMetastorePartitions not implemented")
}
func (UnimplementedMetastorePartitionServiceServer) BatchUpdateMetastorePartitions(context.Context, *BatchUpdateMetastorePartitionsRequest) (*BatchUpdateMetastorePartitionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateMetastorePartitions not implemented")
}
func (UnimplementedMetastorePartitionServiceServer) ListMetastorePartitions(context.Context, *ListMetastorePartitionsRequest) (*ListMetastorePartitionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMetastorePartitions not implemented")
}
func (UnimplementedMetastorePartitionServiceServer) StreamMetastorePartitions(MetastorePartitionService_StreamMetastorePartitionsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamMetastorePartitions not implemented")
}

// UnsafeMetastorePartitionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MetastorePartitionServiceServer will
// result in compilation errors.
type UnsafeMetastorePartitionServiceServer interface {
	mustEmbedUnimplementedMetastorePartitionServiceServer()
}

func RegisterMetastorePartitionServiceServer(s grpc.ServiceRegistrar, srv MetastorePartitionServiceServer) {
	s.RegisterService(&MetastorePartitionService_ServiceDesc, srv)
}

func _MetastorePartitionService_BatchCreateMetastorePartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateMetastorePartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastorePartitionServiceServer).BatchCreateMetastorePartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastorePartitionService_BatchCreateMetastorePartitions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastorePartitionServiceServer).BatchCreateMetastorePartitions(ctx, req.(*BatchCreateMetastorePartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastorePartitionService_BatchDeleteMetastorePartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteMetastorePartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastorePartitionServiceServer).BatchDeleteMetastorePartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastorePartitionService_BatchDeleteMetastorePartitions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastorePartitionServiceServer).BatchDeleteMetastorePartitions(ctx, req.(*BatchDeleteMetastorePartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastorePartitionService_BatchUpdateMetastorePartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateMetastorePartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastorePartitionServiceServer).BatchUpdateMetastorePartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastorePartitionService_BatchUpdateMetastorePartitions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastorePartitionServiceServer).BatchUpdateMetastorePartitions(ctx, req.(*BatchUpdateMetastorePartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastorePartitionService_ListMetastorePartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMetastorePartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetastorePartitionServiceServer).ListMetastorePartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetastorePartitionService_ListMetastorePartitions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetastorePartitionServiceServer).ListMetastorePartitions(ctx, req.(*ListMetastorePartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetastorePartitionService_StreamMetastorePartitions_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(MetastorePartitionServiceServer).StreamMetastorePartitions(&metastorePartitionServiceStreamMetastorePartitionsServer{stream})
}

type MetastorePartitionService_StreamMetastorePartitionsServer interface {
	Send(*StreamMetastorePartitionsResponse) error
	Recv() (*StreamMetastorePartitionsRequest, error)
	grpc.ServerStream
}

type metastorePartitionServiceStreamMetastorePartitionsServer struct {
	grpc.ServerStream
}

func (x *metastorePartitionServiceStreamMetastorePartitionsServer) Send(m *StreamMetastorePartitionsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *metastorePartitionServiceStreamMetastorePartitionsServer) Recv() (*StreamMetastorePartitionsRequest, error) {
	m := new(StreamMetastorePartitionsRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// MetastorePartitionService_ServiceDesc is the grpc.ServiceDesc for MetastorePartitionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MetastorePartitionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.storage.v1beta.MetastorePartitionService",
	HandlerType: (*MetastorePartitionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchCreateMetastorePartitions",
			Handler:    _MetastorePartitionService_BatchCreateMetastorePartitions_Handler,
		},
		{
			MethodName: "BatchDeleteMetastorePartitions",
			Handler:    _MetastorePartitionService_BatchDeleteMetastorePartitions_Handler,
		},
		{
			MethodName: "BatchUpdateMetastorePartitions",
			Handler:    _MetastorePartitionService_BatchUpdateMetastorePartitions_Handler,
		},
		{
			MethodName: "ListMetastorePartitions",
			Handler:    _MetastorePartitionService_ListMetastorePartitions_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamMetastorePartitions",
			Handler:       _MetastorePartitionService_StreamMetastorePartitions_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/bigquery/storage/v1beta/metastore_partition.proto",
}
