// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Data Catalog API
//
// Use the Data Catalog APIs to collect, organize, find, access, understand, enrich, and activate technical, business, and operational metadata.
// For more information, see Data Catalog (https://docs.oracle.com/iaas/data-catalog/home.htm).
//

package datacatalog

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ImportLineageJobResult Information about lineage import operation.
type ImportLineageJobResult struct {

	// The unique key of the data asset on which import is triggered.
	DataAssetKey *string `mandatory:"true" json:"dataAssetKey"`

	// The unique key of the parent job execution for which the log resource is created.
	ImportJobExecutionKey *string `mandatory:"true" json:"importJobExecutionKey"`

	// The unique key of the job definition resource that is used for the import.
	ImportJobDefinitionKey *string `mandatory:"false" json:"importJobDefinitionKey"`

	// The unique key of the job for the import.
	ImportJobKey *string `mandatory:"false" json:"importJobKey"`

	// The state of the import job execution.
	ImportJobExecutionStatus JobExecutionStateEnum `mandatory:"false" json:"importJobExecutionStatus,omitempty"`
}

func (m ImportLineageJobResult) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ImportLineageJobResult) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if _, ok := GetMappingJobExecutionStateEnum(string(m.ImportJobExecutionStatus)); !ok && m.ImportJobExecutionStatus != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for ImportJobExecutionStatus: %s. Supported values are: %s.", m.ImportJobExecutionStatus, strings.Join(GetJobExecutionStateEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
