// Code generated by go-swagger; DO NOT EDIT.

package invoice_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-billing/preview/2020-11-05/models"
)

// InvoiceServiceGetUsageReader is a Reader for the InvoiceServiceGetUsage structure.
type InvoiceServiceGetUsageReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *InvoiceServiceGetUsageReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewInvoiceServiceGetUsageOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewInvoiceServiceGetUsageDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewInvoiceServiceGetUsageOK creates a InvoiceServiceGetUsageOK with default headers values
func NewInvoiceServiceGetUsageOK() *InvoiceServiceGetUsageOK {
	return &InvoiceServiceGetUsageOK{}
}

/*
InvoiceServiceGetUsageOK describes a response with status code 200, with default header values.

A successful response.
*/
type InvoiceServiceGetUsageOK struct {
	Payload *models.Billing20201105GetUsageResponse
}

// IsSuccess returns true when this invoice service get usage o k response has a 2xx status code
func (o *InvoiceServiceGetUsageOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this invoice service get usage o k response has a 3xx status code
func (o *InvoiceServiceGetUsageOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this invoice service get usage o k response has a 4xx status code
func (o *InvoiceServiceGetUsageOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this invoice service get usage o k response has a 5xx status code
func (o *InvoiceServiceGetUsageOK) IsServerError() bool {
	return false
}

// IsCode returns true when this invoice service get usage o k response a status code equal to that given
func (o *InvoiceServiceGetUsageOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the invoice service get usage o k response
func (o *InvoiceServiceGetUsageOK) Code() int {
	return 200
}

func (o *InvoiceServiceGetUsageOK) Error() string {
	return fmt.Sprintf("[GET /billing/2020-11-05/organizations/{organization_id}/accounts/{billing_account_id}/usage][%d] invoiceServiceGetUsageOK  %+v", 200, o.Payload)
}

func (o *InvoiceServiceGetUsageOK) String() string {
	return fmt.Sprintf("[GET /billing/2020-11-05/organizations/{organization_id}/accounts/{billing_account_id}/usage][%d] invoiceServiceGetUsageOK  %+v", 200, o.Payload)
}

func (o *InvoiceServiceGetUsageOK) GetPayload() *models.Billing20201105GetUsageResponse {
	return o.Payload
}

func (o *InvoiceServiceGetUsageOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Billing20201105GetUsageResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInvoiceServiceGetUsageDefault creates a InvoiceServiceGetUsageDefault with default headers values
func NewInvoiceServiceGetUsageDefault(code int) *InvoiceServiceGetUsageDefault {
	return &InvoiceServiceGetUsageDefault{
		_statusCode: code,
	}
}

/*
InvoiceServiceGetUsageDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type InvoiceServiceGetUsageDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this invoice service get usage default response has a 2xx status code
func (o *InvoiceServiceGetUsageDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this invoice service get usage default response has a 3xx status code
func (o *InvoiceServiceGetUsageDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this invoice service get usage default response has a 4xx status code
func (o *InvoiceServiceGetUsageDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this invoice service get usage default response has a 5xx status code
func (o *InvoiceServiceGetUsageDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this invoice service get usage default response a status code equal to that given
func (o *InvoiceServiceGetUsageDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the invoice service get usage default response
func (o *InvoiceServiceGetUsageDefault) Code() int {
	return o._statusCode
}

func (o *InvoiceServiceGetUsageDefault) Error() string {
	return fmt.Sprintf("[GET /billing/2020-11-05/organizations/{organization_id}/accounts/{billing_account_id}/usage][%d] InvoiceService_GetUsage default  %+v", o._statusCode, o.Payload)
}

func (o *InvoiceServiceGetUsageDefault) String() string {
	return fmt.Sprintf("[GET /billing/2020-11-05/organizations/{organization_id}/accounts/{billing_account_id}/usage][%d] InvoiceService_GetUsage default  %+v", o._statusCode, o.Payload)
}

func (o *InvoiceServiceGetUsageDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *InvoiceServiceGetUsageDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
