// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Billing20201105BillingAccountUsage BillingAccountUsage describes the usage that accrued during a specific
// billing period.
//
// swagger:model billing_20201105BillingAccountUsage
type Billing20201105BillingAccountUsage struct {

	// billing_period_end is the end time of the period that was considered for
	// this usage calculation.
	// Format: date-time
	BillingPeriodEnd strfmt.DateTime `json:"billing_period_end,omitempty"`

	// billing_period_start is the start time of the period that was considered
	// for this usage calculation.
	// Format: date-time
	BillingPeriodStart strfmt.DateTime `json:"billing_period_start,omitempty"`

	// discount is the amount of credits that would be deducted from the subtotal
	// if an invoice would be generated.
	Discount string `json:"discount,omitempty"`

	// remaining_balance is the account balance remaining after deducting the
	// calculated usage's subtotal_cost. This should be considered as an estimate
	// and understood as the potential new account balance if an invoice was
	// generated at the end of the billing period covered by this usage.
	RemainingBalance string `json:"remaining_balance,omitempty"`

	// resource_usages has information about each resource that is part of this calculation.
	ResourceUsages []*Billing20201105ResourceUsage `json:"resource_usages"`

	// subtotal_cost is the cost produced within this billing period. It's the sum
	// of all calculated line items' amounts.
	SubtotalCost string `json:"subtotal_cost,omitempty"`

	// total_cost is the cost produced within this billing period minus any
	// discount that is granted because of a positive account balance. This
	// should be considered an estimate because not all information required to
	// issue an invoice might have been taken into consideration (e.g. billing
	// address country and tax might not be reflected in this value).
	TotalCost string `json:"total_cost,omitempty"`
}

// Validate validates this billing 20201105 billing account usage
func (m *Billing20201105BillingAccountUsage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBillingPeriodEnd(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBillingPeriodStart(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResourceUsages(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105BillingAccountUsage) validateBillingPeriodEnd(formats strfmt.Registry) error {
	if swag.IsZero(m.BillingPeriodEnd) { // not required
		return nil
	}

	if err := validate.FormatOf("billing_period_end", "body", "date-time", m.BillingPeriodEnd.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105BillingAccountUsage) validateBillingPeriodStart(formats strfmt.Registry) error {
	if swag.IsZero(m.BillingPeriodStart) { // not required
		return nil
	}

	if err := validate.FormatOf("billing_period_start", "body", "date-time", m.BillingPeriodStart.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105BillingAccountUsage) validateResourceUsages(formats strfmt.Registry) error {
	if swag.IsZero(m.ResourceUsages) { // not required
		return nil
	}

	for i := 0; i < len(m.ResourceUsages); i++ {
		if swag.IsZero(m.ResourceUsages[i]) { // not required
			continue
		}

		if m.ResourceUsages[i] != nil {
			if err := m.ResourceUsages[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("resource_usages" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("resource_usages" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this billing 20201105 billing account usage based on the context it is used
func (m *Billing20201105BillingAccountUsage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateResourceUsages(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105BillingAccountUsage) contextValidateResourceUsages(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ResourceUsages); i++ {

		if m.ResourceUsages[i] != nil {

			if swag.IsZero(m.ResourceUsages[i]) { // not required
				return nil
			}

			if err := m.ResourceUsages[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("resource_usages" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("resource_usages" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105BillingAccountUsage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105BillingAccountUsage) UnmarshalBinary(b []byte) error {
	var res Billing20201105BillingAccountUsage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
