// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewBoundaryServiceSessionsParams creates a new BoundaryServiceSessionsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBoundaryServiceSessionsParams() *BoundaryServiceSessionsParams {
	return &BoundaryServiceSessionsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBoundaryServiceSessionsParamsWithTimeout creates a new BoundaryServiceSessionsParams object
// with the ability to set a timeout on a request.
func NewBoundaryServiceSessionsParamsWithTimeout(timeout time.Duration) *BoundaryServiceSessionsParams {
	return &BoundaryServiceSessionsParams{
		timeout: timeout,
	}
}

// NewBoundaryServiceSessionsParamsWithContext creates a new BoundaryServiceSessionsParams object
// with the ability to set a context for a request.
func NewBoundaryServiceSessionsParamsWithContext(ctx context.Context) *BoundaryServiceSessionsParams {
	return &BoundaryServiceSessionsParams{
		Context: ctx,
	}
}

// NewBoundaryServiceSessionsParamsWithHTTPClient creates a new BoundaryServiceSessionsParams object
// with the ability to set a custom HTTPClient for a request.
func NewBoundaryServiceSessionsParamsWithHTTPClient(client *http.Client) *BoundaryServiceSessionsParams {
	return &BoundaryServiceSessionsParams{
		HTTPClient: client,
	}
}

/*
BoundaryServiceSessionsParams contains all the parameters to send to the API endpoint

	for the boundary service sessions operation.

	Typically these are written to a http.Request.
*/
type BoundaryServiceSessionsParams struct {

	/* ClusterID.

	   cluster_id is the id of the cluster set by user on creation.
	*/
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the boundary service sessions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BoundaryServiceSessionsParams) WithDefaults() *BoundaryServiceSessionsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the boundary service sessions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BoundaryServiceSessionsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) WithTimeout(timeout time.Duration) *BoundaryServiceSessionsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) WithContext(ctx context.Context) *BoundaryServiceSessionsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) WithHTTPClient(client *http.Client) *BoundaryServiceSessionsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) WithClusterID(clusterID string) *BoundaryServiceSessionsParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) WithLocationOrganizationID(locationOrganizationID string) *BoundaryServiceSessionsParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) WithLocationProjectID(locationProjectID string) *BoundaryServiceSessionsParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) WithLocationRegionProvider(locationRegionProvider *string) *BoundaryServiceSessionsParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) WithLocationRegionRegion(locationRegionRegion *string) *BoundaryServiceSessionsParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the boundary service sessions params
func (o *BoundaryServiceSessionsParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *BoundaryServiceSessionsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
