// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-boundary-service/stable/2021-12-21/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// BoundaryServiceSessionsReader is a Reader for the BoundaryServiceSessions structure.
type BoundaryServiceSessionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BoundaryServiceSessionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBoundaryServiceSessionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBoundaryServiceSessionsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBoundaryServiceSessionsOK creates a BoundaryServiceSessionsOK with default headers values
func NewBoundaryServiceSessionsOK() *BoundaryServiceSessionsOK {
	return &BoundaryServiceSessionsOK{}
}

/*
BoundaryServiceSessionsOK describes a response with status code 200, with default header values.

A successful response.
*/
type BoundaryServiceSessionsOK struct {
	Payload *models.HashicorpCloudBoundary20211221SessionsResponse
}

// IsSuccess returns true when this boundary service sessions o k response has a 2xx status code
func (o *BoundaryServiceSessionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this boundary service sessions o k response has a 3xx status code
func (o *BoundaryServiceSessionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this boundary service sessions o k response has a 4xx status code
func (o *BoundaryServiceSessionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this boundary service sessions o k response has a 5xx status code
func (o *BoundaryServiceSessionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this boundary service sessions o k response a status code equal to that given
func (o *BoundaryServiceSessionsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the boundary service sessions o k response
func (o *BoundaryServiceSessionsOK) Code() int {
	return 200
}

func (o *BoundaryServiceSessionsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/sessions][%d] boundaryServiceSessionsOK %s", 200, payload)
}

func (o *BoundaryServiceSessionsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/sessions][%d] boundaryServiceSessionsOK %s", 200, payload)
}

func (o *BoundaryServiceSessionsOK) GetPayload() *models.HashicorpCloudBoundary20211221SessionsResponse {
	return o.Payload
}

func (o *BoundaryServiceSessionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudBoundary20211221SessionsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBoundaryServiceSessionsDefault creates a BoundaryServiceSessionsDefault with default headers values
func NewBoundaryServiceSessionsDefault(code int) *BoundaryServiceSessionsDefault {
	return &BoundaryServiceSessionsDefault{
		_statusCode: code,
	}
}

/*
BoundaryServiceSessionsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type BoundaryServiceSessionsDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this boundary service sessions default response has a 2xx status code
func (o *BoundaryServiceSessionsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this boundary service sessions default response has a 3xx status code
func (o *BoundaryServiceSessionsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this boundary service sessions default response has a 4xx status code
func (o *BoundaryServiceSessionsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this boundary service sessions default response has a 5xx status code
func (o *BoundaryServiceSessionsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this boundary service sessions default response a status code equal to that given
func (o *BoundaryServiceSessionsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the boundary service sessions default response
func (o *BoundaryServiceSessionsDefault) Code() int {
	return o._statusCode
}

func (o *BoundaryServiceSessionsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/sessions][%d] BoundaryService_Sessions default %s", o._statusCode, payload)
}

func (o *BoundaryServiceSessionsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/sessions][%d] BoundaryService_Sessions default %s", o._statusCode, payload)
}

func (o *BoundaryServiceSessionsDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *BoundaryServiceSessionsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
