// Code generated by go-swagger; DO NOT EDIT.

package nodes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListClusterNodesParams creates a new ListClusterNodesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListClusterNodesParams() *ListClusterNodesParams {
	return &ListClusterNodesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListClusterNodesParamsWithTimeout creates a new ListClusterNodesParams object
// with the ability to set a timeout on a request.
func NewListClusterNodesParamsWithTimeout(timeout time.Duration) *ListClusterNodesParams {
	return &ListClusterNodesParams{
		timeout: timeout,
	}
}

// NewListClusterNodesParamsWithContext creates a new ListClusterNodesParams object
// with the ability to set a context for a request.
func NewListClusterNodesParamsWithContext(ctx context.Context) *ListClusterNodesParams {
	return &ListClusterNodesParams{
		Context: ctx,
	}
}

// NewListClusterNodesParamsWithHTTPClient creates a new ListClusterNodesParams object
// with the ability to set a custom HTTPClient for a request.
func NewListClusterNodesParamsWithHTTPClient(client *http.Client) *ListClusterNodesParams {
	return &ListClusterNodesParams{
		HTTPClient: client,
	}
}

/*
ListClusterNodesParams contains all the parameters to send to the API endpoint

	for the list cluster nodes operation.

	Typically these are written to a http.Request.
*/
type ListClusterNodesParams struct {

	/* Address.

	   Filters nodes based on the lists of addresses.
	*/
	Address []string

	/* ClusterName.

	   Filters nodes based on the lists of cluster names.
	*/
	ClusterName []string

	/* IncludeSyntheticNodes.

	   Include synthetic nodes in response
	*/
	IncludeSyntheticNodes *bool

	/* Name.

	   Filters nodes based on the list of names.
	*/
	Name []string

	/* OrderBy.

	   Sorts the nodes based on a field. Allowed fields: `name`, `partition`, `created_at`, `updated_at`. The value needs to be of the format `<{name/partition/created_at/updated_at} {asc/desc}>` For example: `partition asc`, `name desc`.
	*/
	OrderBy []string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this parameter to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The maximum number of results per page to return. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned, which you can use to get the next page of results in subsequent
	requests. A value of zero causes `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this parameter to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* ParentResourceName.

	   Cluster resource name will be of the form `consul/project/<project_id>/cluster/<cluster_id>`
	*/
	ParentResourceName string

	/* Partition.

	   Filters nodes based on the lists of partitions.
	*/
	Partition []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list cluster nodes params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListClusterNodesParams) WithDefaults() *ListClusterNodesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list cluster nodes params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListClusterNodesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list cluster nodes params
func (o *ListClusterNodesParams) WithTimeout(timeout time.Duration) *ListClusterNodesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list cluster nodes params
func (o *ListClusterNodesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list cluster nodes params
func (o *ListClusterNodesParams) WithContext(ctx context.Context) *ListClusterNodesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list cluster nodes params
func (o *ListClusterNodesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list cluster nodes params
func (o *ListClusterNodesParams) WithHTTPClient(client *http.Client) *ListClusterNodesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list cluster nodes params
func (o *ListClusterNodesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAddress adds the address to the list cluster nodes params
func (o *ListClusterNodesParams) WithAddress(address []string) *ListClusterNodesParams {
	o.SetAddress(address)
	return o
}

// SetAddress adds the address to the list cluster nodes params
func (o *ListClusterNodesParams) SetAddress(address []string) {
	o.Address = address
}

// WithClusterName adds the clusterName to the list cluster nodes params
func (o *ListClusterNodesParams) WithClusterName(clusterName []string) *ListClusterNodesParams {
	o.SetClusterName(clusterName)
	return o
}

// SetClusterName adds the clusterName to the list cluster nodes params
func (o *ListClusterNodesParams) SetClusterName(clusterName []string) {
	o.ClusterName = clusterName
}

// WithIncludeSyntheticNodes adds the includeSyntheticNodes to the list cluster nodes params
func (o *ListClusterNodesParams) WithIncludeSyntheticNodes(includeSyntheticNodes *bool) *ListClusterNodesParams {
	o.SetIncludeSyntheticNodes(includeSyntheticNodes)
	return o
}

// SetIncludeSyntheticNodes adds the includeSyntheticNodes to the list cluster nodes params
func (o *ListClusterNodesParams) SetIncludeSyntheticNodes(includeSyntheticNodes *bool) {
	o.IncludeSyntheticNodes = includeSyntheticNodes
}

// WithName adds the name to the list cluster nodes params
func (o *ListClusterNodesParams) WithName(name []string) *ListClusterNodesParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the list cluster nodes params
func (o *ListClusterNodesParams) SetName(name []string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the list cluster nodes params
func (o *ListClusterNodesParams) WithOrderBy(orderBy []string) *ListClusterNodesParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the list cluster nodes params
func (o *ListClusterNodesParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the list cluster nodes params
func (o *ListClusterNodesParams) WithPaginationNextPageToken(paginationNextPageToken *string) *ListClusterNodesParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the list cluster nodes params
func (o *ListClusterNodesParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the list cluster nodes params
func (o *ListClusterNodesParams) WithPaginationPageSize(paginationPageSize *int64) *ListClusterNodesParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the list cluster nodes params
func (o *ListClusterNodesParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the list cluster nodes params
func (o *ListClusterNodesParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *ListClusterNodesParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the list cluster nodes params
func (o *ListClusterNodesParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithParentResourceName adds the parentResourceName to the list cluster nodes params
func (o *ListClusterNodesParams) WithParentResourceName(parentResourceName string) *ListClusterNodesParams {
	o.SetParentResourceName(parentResourceName)
	return o
}

// SetParentResourceName adds the parentResourceName to the list cluster nodes params
func (o *ListClusterNodesParams) SetParentResourceName(parentResourceName string) {
	o.ParentResourceName = parentResourceName
}

// WithPartition adds the partition to the list cluster nodes params
func (o *ListClusterNodesParams) WithPartition(partition []string) *ListClusterNodesParams {
	o.SetPartition(partition)
	return o
}

// SetPartition adds the partition to the list cluster nodes params
func (o *ListClusterNodesParams) SetPartition(partition []string) {
	o.Partition = partition
}

// WriteToRequest writes these params to a swagger request
func (o *ListClusterNodesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Address != nil {

		// binding items for address
		joinedAddress := o.bindParamAddress(reg)

		// query array param address
		if err := r.SetQueryParam("address", joinedAddress...); err != nil {
			return err
		}
	}

	if o.ClusterName != nil {

		// binding items for cluster_name
		joinedClusterName := o.bindParamClusterName(reg)

		// query array param cluster_name
		if err := r.SetQueryParam("cluster_name", joinedClusterName...); err != nil {
			return err
		}
	}

	if o.IncludeSyntheticNodes != nil {

		// query param include_synthetic_nodes
		var qrIncludeSyntheticNodes bool

		if o.IncludeSyntheticNodes != nil {
			qrIncludeSyntheticNodes = *o.IncludeSyntheticNodes
		}
		qIncludeSyntheticNodes := swag.FormatBool(qrIncludeSyntheticNodes)
		if qIncludeSyntheticNodes != "" {

			if err := r.SetQueryParam("include_synthetic_nodes", qIncludeSyntheticNodes); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// binding items for name
		joinedName := o.bindParamName(reg)

		// query array param name
		if err := r.SetQueryParam("name", joinedName...); err != nil {
			return err
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	// path param parent_resource_name
	if err := r.SetPathParam("parent_resource_name", o.ParentResourceName); err != nil {
		return err
	}

	if o.Partition != nil {

		// binding items for partition
		joinedPartition := o.bindParamPartition(reg)

		// query array param partition
		if err := r.SetQueryParam("partition", joinedPartition...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamListClusterNodes binds the parameter address
func (o *ListClusterNodesParams) bindParamAddress(formats strfmt.Registry) []string {
	addressIR := o.Address

	var addressIC []string
	for _, addressIIR := range addressIR { // explode []string

		addressIIV := addressIIR // string as string
		addressIC = append(addressIC, addressIIV)
	}

	// items.CollectionFormat: "multi"
	addressIS := swag.JoinByFormat(addressIC, "multi")

	return addressIS
}

// bindParamListClusterNodes binds the parameter cluster_name
func (o *ListClusterNodesParams) bindParamClusterName(formats strfmt.Registry) []string {
	clusterNameIR := o.ClusterName

	var clusterNameIC []string
	for _, clusterNameIIR := range clusterNameIR { // explode []string

		clusterNameIIV := clusterNameIIR // string as string
		clusterNameIC = append(clusterNameIC, clusterNameIIV)
	}

	// items.CollectionFormat: "multi"
	clusterNameIS := swag.JoinByFormat(clusterNameIC, "multi")

	return clusterNameIS
}

// bindParamListClusterNodes binds the parameter name
func (o *ListClusterNodesParams) bindParamName(formats strfmt.Registry) []string {
	nameIR := o.Name

	var nameIC []string
	for _, nameIIR := range nameIR { // explode []string

		nameIIV := nameIIR // string as string
		nameIC = append(nameIC, nameIIV)
	}

	// items.CollectionFormat: "multi"
	nameIS := swag.JoinByFormat(nameIC, "multi")

	return nameIS
}

// bindParamListClusterNodes binds the parameter order_by
func (o *ListClusterNodesParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "multi"
	orderByIS := swag.JoinByFormat(orderByIC, "multi")

	return orderByIS
}

// bindParamListClusterNodes binds the parameter partition
func (o *ListClusterNodesParams) bindParamPartition(formats strfmt.Registry) []string {
	partitionIR := o.Partition

	var partitionIC []string
	for _, partitionIIR := range partitionIR { // explode []string

		partitionIIV := partitionIIR // string as string
		partitionIC = append(partitionIC, partitionIIV)
	}

	// items.CollectionFormat: "multi"
	partitionIS := swag.JoinByFormat(partitionIC, "multi")

	return partitionIS
}
