// Code generated by go-swagger; DO NOT EDIT.

package profile_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ProfileServiceDisableMFAReader is a Reader for the ProfileServiceDisableMFA structure.
type ProfileServiceDisableMFAReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ProfileServiceDisableMFAReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewProfileServiceDisableMFAOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewProfileServiceDisableMFADefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewProfileServiceDisableMFAOK creates a ProfileServiceDisableMFAOK with default headers values
func NewProfileServiceDisableMFAOK() *ProfileServiceDisableMFAOK {
	return &ProfileServiceDisableMFAOK{}
}

/*
ProfileServiceDisableMFAOK describes a response with status code 200, with default header values.

A successful response.
*/
type ProfileServiceDisableMFAOK struct {
	Payload models.HashicorpCloudIamDisableMFAResponse
}

// IsSuccess returns true when this profile service disable m f a o k response has a 2xx status code
func (o *ProfileServiceDisableMFAOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this profile service disable m f a o k response has a 3xx status code
func (o *ProfileServiceDisableMFAOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this profile service disable m f a o k response has a 4xx status code
func (o *ProfileServiceDisableMFAOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this profile service disable m f a o k response has a 5xx status code
func (o *ProfileServiceDisableMFAOK) IsServerError() bool {
	return false
}

// IsCode returns true when this profile service disable m f a o k response a status code equal to that given
func (o *ProfileServiceDisableMFAOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the profile service disable m f a o k response
func (o *ProfileServiceDisableMFAOK) Code() int {
	return 200
}

func (o *ProfileServiceDisableMFAOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/me/disable-mfa][%d] profileServiceDisableMFAOK %s", 200, payload)
}

func (o *ProfileServiceDisableMFAOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/me/disable-mfa][%d] profileServiceDisableMFAOK %s", 200, payload)
}

func (o *ProfileServiceDisableMFAOK) GetPayload() models.HashicorpCloudIamDisableMFAResponse {
	return o.Payload
}

func (o *ProfileServiceDisableMFAOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProfileServiceDisableMFADefault creates a ProfileServiceDisableMFADefault with default headers values
func NewProfileServiceDisableMFADefault(code int) *ProfileServiceDisableMFADefault {
	return &ProfileServiceDisableMFADefault{
		_statusCode: code,
	}
}

/*
ProfileServiceDisableMFADefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ProfileServiceDisableMFADefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this profile service disable m f a default response has a 2xx status code
func (o *ProfileServiceDisableMFADefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this profile service disable m f a default response has a 3xx status code
func (o *ProfileServiceDisableMFADefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this profile service disable m f a default response has a 4xx status code
func (o *ProfileServiceDisableMFADefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this profile service disable m f a default response has a 5xx status code
func (o *ProfileServiceDisableMFADefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this profile service disable m f a default response a status code equal to that given
func (o *ProfileServiceDisableMFADefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the profile service disable m f a default response
func (o *ProfileServiceDisableMFADefault) Code() int {
	return o._statusCode
}

func (o *ProfileServiceDisableMFADefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/me/disable-mfa][%d] ProfileService_DisableMFA default %s", o._statusCode, payload)
}

func (o *ProfileServiceDisableMFADefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/me/disable-mfa][%d] ProfileService_DisableMFA default %s", o._statusCode, payload)
}

func (o *ProfileServiceDisableMFADefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ProfileServiceDisableMFADefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
