// Code generated by go-swagger; DO NOT EDIT.

package log_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// LogServiceGetArchiveReader is a Reader for the LogServiceGetArchive structure.
type LogServiceGetArchiveReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LogServiceGetArchiveReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLogServiceGetArchiveOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLogServiceGetArchiveDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLogServiceGetArchiveOK creates a LogServiceGetArchiveOK with default headers values
func NewLogServiceGetArchiveOK() *LogServiceGetArchiveOK {
	return &LogServiceGetArchiveOK{}
}

/*
LogServiceGetArchiveOK describes a response with status code 200, with default header values.

A successful response.
*/
type LogServiceGetArchiveOK struct {
	Payload *models.LogService20210330GetArchiveResponse
}

// IsSuccess returns true when this log service get archive o k response has a 2xx status code
func (o *LogServiceGetArchiveOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this log service get archive o k response has a 3xx status code
func (o *LogServiceGetArchiveOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this log service get archive o k response has a 4xx status code
func (o *LogServiceGetArchiveOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this log service get archive o k response has a 5xx status code
func (o *LogServiceGetArchiveOK) IsServerError() bool {
	return false
}

// IsCode returns true when this log service get archive o k response a status code equal to that given
func (o *LogServiceGetArchiveOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the log service get archive o k response
func (o *LogServiceGetArchiveOK) Code() int {
	return 200
}

func (o *LogServiceGetArchiveOK) Error() string {
	return fmt.Sprintf("[GET /logs/2021-03-30/organizations/{resource.location.organization_id}/projects/{resource.location.project_id}/resources/{resource.id}/archives/{id}][%d] logServiceGetArchiveOK  %+v", 200, o.Payload)
}

func (o *LogServiceGetArchiveOK) String() string {
	return fmt.Sprintf("[GET /logs/2021-03-30/organizations/{resource.location.organization_id}/projects/{resource.location.project_id}/resources/{resource.id}/archives/{id}][%d] logServiceGetArchiveOK  %+v", 200, o.Payload)
}

func (o *LogServiceGetArchiveOK) GetPayload() *models.LogService20210330GetArchiveResponse {
	return o.Payload
}

func (o *LogServiceGetArchiveOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LogService20210330GetArchiveResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLogServiceGetArchiveDefault creates a LogServiceGetArchiveDefault with default headers values
func NewLogServiceGetArchiveDefault(code int) *LogServiceGetArchiveDefault {
	return &LogServiceGetArchiveDefault{
		_statusCode: code,
	}
}

/*
LogServiceGetArchiveDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type LogServiceGetArchiveDefault struct {
	_statusCode int

	Payload *models.RuntimeError
}

// IsSuccess returns true when this log service get archive default response has a 2xx status code
func (o *LogServiceGetArchiveDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this log service get archive default response has a 3xx status code
func (o *LogServiceGetArchiveDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this log service get archive default response has a 4xx status code
func (o *LogServiceGetArchiveDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this log service get archive default response has a 5xx status code
func (o *LogServiceGetArchiveDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this log service get archive default response a status code equal to that given
func (o *LogServiceGetArchiveDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the log service get archive default response
func (o *LogServiceGetArchiveDefault) Code() int {
	return o._statusCode
}

func (o *LogServiceGetArchiveDefault) Error() string {
	return fmt.Sprintf("[GET /logs/2021-03-30/organizations/{resource.location.organization_id}/projects/{resource.location.project_id}/resources/{resource.id}/archives/{id}][%d] LogService_GetArchive default  %+v", o._statusCode, o.Payload)
}

func (o *LogServiceGetArchiveDefault) String() string {
	return fmt.Sprintf("[GET /logs/2021-03-30/organizations/{resource.location.organization_id}/projects/{resource.location.project_id}/resources/{resource.id}/archives/{id}][%d] LogService_GetArchive default  %+v", o._statusCode, o.Payload)
}

func (o *LogServiceGetArchiveDefault) GetPayload() *models.RuntimeError {
	return o.Payload
}

func (o *LogServiceGetArchiveDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
