// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// LogService20210330TestStreamingDestinationRequest TestStreamingDestinationRequest represents a request to test a streaming destination config record.
//
// swagger:model log_service_20210330TestStreamingDestinationRequest
type LogService20210330TestStreamingDestinationRequest struct {

	// cloudwatchlogs_provider represents a cloudwatch provider.
	CloudwatchlogsProvider *LogService20210330CloudwatchLogsProvider `json:"cloudwatchlogs_provider,omitempty"`

	// datadog_provider represents a datadog provider.
	DatadogProvider *LogService20210330DatadogProvider `json:"datadog_provider,omitempty"`

	// existing_destination_id is the original destination id
	// this should be set only if we need to test config with redacted fields
	ExistingDestinationID string `json:"existing_destination_id,omitempty"`

	// location is the location (orgID - projectID) the streaming destination will belong to.
	Location *CloudlocationLocation `json:"location,omitempty"`

	// mask specifies which fields to use from provider to override fields in existing destination
	Mask *ProtobufFieldMask `json:"mask,omitempty"`
}

// Validate validates this log service 20210330 test streaming destination request
func (m *LogService20210330TestStreamingDestinationRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCloudwatchlogsProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatadogProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330TestStreamingDestinationRequest) validateCloudwatchlogsProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.CloudwatchlogsProvider) { // not required
		return nil
	}

	if m.CloudwatchlogsProvider != nil {
		if err := m.CloudwatchlogsProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloudwatchlogs_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cloudwatchlogs_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330TestStreamingDestinationRequest) validateDatadogProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.DatadogProvider) { // not required
		return nil
	}

	if m.DatadogProvider != nil {
		if err := m.DatadogProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datadog_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("datadog_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330TestStreamingDestinationRequest) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330TestStreamingDestinationRequest) validateMask(formats strfmt.Registry) error {
	if swag.IsZero(m.Mask) { // not required
		return nil
	}

	if m.Mask != nil {
		if err := m.Mask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mask")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("mask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this log service 20210330 test streaming destination request based on the context it is used
func (m *LogService20210330TestStreamingDestinationRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCloudwatchlogsProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatadogProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330TestStreamingDestinationRequest) contextValidateCloudwatchlogsProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.CloudwatchlogsProvider != nil {

		if swag.IsZero(m.CloudwatchlogsProvider) { // not required
			return nil
		}

		if err := m.CloudwatchlogsProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloudwatchlogs_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cloudwatchlogs_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330TestStreamingDestinationRequest) contextValidateDatadogProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.DatadogProvider != nil {

		if swag.IsZero(m.DatadogProvider) { // not required
			return nil
		}

		if err := m.DatadogProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datadog_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("datadog_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330TestStreamingDestinationRequest) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330TestStreamingDestinationRequest) contextValidateMask(ctx context.Context, formats strfmt.Registry) error {

	if m.Mask != nil {

		if swag.IsZero(m.Mask) { // not required
			return nil
		}

		if err := m.Mask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("mask")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("mask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogService20210330TestStreamingDestinationRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogService20210330TestStreamingDestinationRequest) UnmarshalBinary(b []byte) error {
	var res LogService20210330TestStreamingDestinationRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
